/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.video.surface;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.util.Log;
import android.view.TextureView;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.IntRange;
import com.devbrackets.android.exomedia.core.video.scale.MatrixManager;
import com.devbrackets.android.exomedia.core.video.scale.ScaleType;
import com.devbrackets.android.exomedia.core.video.surface.VideoSurface;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.egl.EGL;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000e\b\u0016\u0018\u0000 ]2\u00020\u00012\u00020\u0002:\u0004\\]^_B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\b\u0010E\u001a\u00020FH\u0016J\u0018\u0010G\u001a\u00020F2\u0006\u0010H\u001a\u00020\n2\u0006\u0010I\u001a\u00020\nH\u0004J\u0010\u0010J\u001a\u00020F2\u0006\u0010K\u001a\u00020LH\u0014J\u0018\u0010M\u001a\u00020F2\u0006\u0010N\u001a\u00020\n2\u0006\u0010O\u001a\u00020\nH\u0014J \u0010P\u001a\u00020F2\u0006\u0010H\u001a\u00020\n2\u0006\u0010I\u001a\u00020\n2\u0006\u0010Q\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020F2\u0006\u0010T\u001a\u00020)H\u0016J\u001a\u0010U\u001a\u00020F2\b\b\u0001\u0010V\u001a\u00020\n2\u0006\u0010W\u001a\u00020)H\u0016J\u001a\u0010U\u001a\u00020F2\b\b\u0001\u0010X\u001a\u00020\n2\b\b\u0001\u0010Y\u001a\u00020\nJ\b\u0010Z\u001a\u00020FH\u0004J\u0018\u0010[\u001a\u00020)2\u0006\u0010H\u001a\u00020\n2\u0006\u0010I\u001a\u00020\nH\u0016R\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020)X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001c\u0010.\u001a\u0004\u0018\u00010/X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001e\u00104\u001a\u00020\n8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001e\u00109\u001a\u00020\n8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u00106\"\u0004\b;\u00108R$\u0010<\u001a\u00020=2\u0006\u0010<\u001a\u00020=8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u001a\u0010B\u001a\u00020\u001dX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010\u001f\"\u0004\bD\u0010!\u00a8\u0006`"}, d2={"Lcom/devbrackets/android/exomedia/core/video/surface/ResizingTextureView;", "Landroid/view/TextureView;", "Lcom/devbrackets/android/exomedia/core/video/surface/VideoSurface;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "attachedListener", "Landroid/view/View$OnAttachStateChangeListener;", "getAttachedListener", "()Landroid/view/View$OnAttachStateChangeListener;", "globalLayoutMatrixListener", "Landroid/view/ViewTreeObserver$OnGlobalLayoutListener;", "getGlobalLayoutMatrixListener", "()Landroid/view/ViewTreeObserver$OnGlobalLayoutListener;", "setGlobalLayoutMatrixListener", "(Landroid/view/ViewTreeObserver$OnGlobalLayoutListener;)V", "globalLayoutMatrixListenerLock", "Ljava/util/concurrent/locks/ReentrantLock;", "getGlobalLayoutMatrixListenerLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "lastNotifiedSize", "Landroid/graphics/Point;", "getLastNotifiedSize", "()Landroid/graphics/Point;", "setLastNotifiedSize", "(Landroid/graphics/Point;)V", "matrixManager", "Lcom/devbrackets/android/exomedia/core/video/scale/MatrixManager;", "getMatrixManager", "()Lcom/devbrackets/android/exomedia/core/video/scale/MatrixManager;", "setMatrixManager", "(Lcom/devbrackets/android/exomedia/core/video/scale/MatrixManager;)V", "measureBasedOnAspectRatio", "", "getMeasureBasedOnAspectRatio", "()Z", "setMeasureBasedOnAspectRatio", "(Z)V", "onSizeChangeListener", "Lcom/devbrackets/android/exomedia/core/video/surface/ResizingTextureView$OnSizeChangeListener;", "getOnSizeChangeListener", "()Lcom/devbrackets/android/exomedia/core/video/surface/ResizingTextureView$OnSizeChangeListener;", "setOnSizeChangeListener", "(Lcom/devbrackets/android/exomedia/core/video/surface/ResizingTextureView$OnSizeChangeListener;)V", "requestedConfigurationRotation", "getRequestedConfigurationRotation", "()I", "setRequestedConfigurationRotation", "(I)V", "requestedUserRotation", "getRequestedUserRotation", "setRequestedUserRotation", "scaleType", "Lcom/devbrackets/android/exomedia/core/video/scale/ScaleType;", "getScaleType", "()Lcom/devbrackets/android/exomedia/core/video/scale/ScaleType;", "setScaleType", "(Lcom/devbrackets/android/exomedia/core/video/scale/ScaleType;)V", "videoSize", "getVideoSize", "setVideoSize", "clearSurface", "", "notifyOnSizeChangeListener", "width", "height", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onVideoSizeChanged", "pixelWidthHeightRatio", "", "setMeasureBasedOnAspectRatioEnabled", "enabled", "setVideoRotation", "rotation", "fromUser", "userRotation", "configurationRotation", "updateMatrixOnLayout", "updateVideoSize", "AttachedListener", "Companion", "GlobalLayoutMatrixListener", "OnSizeChangeListener", "library_release"})
public class ResizingTextureView
extends TextureView
implements VideoSurface {
    @Nullable
    private OnSizeChangeListener onSizeChangeListener;
    @NotNull
    private Point lastNotifiedSize;
    @NotNull
    private Point videoSize;
    @NotNull
    private MatrixManager matrixManager;
    @NotNull
    private final View.OnAttachStateChangeListener attachedListener;
    @NotNull
    private ViewTreeObserver.OnGlobalLayoutListener globalLayoutMatrixListener;
    @NotNull
    private final ReentrantLock globalLayoutMatrixListenerLock;
    @IntRange(from=0L, to=359L)
    private int requestedUserRotation;
    @IntRange(from=0L, to=359L)
    private int requestedConfigurationRotation;
    private boolean measureBasedOnAspectRatio;
    private static final String TAG;
    private static final int MAX_DEGREES;
    private static final int EGL_CONTEXT_CLIENT_VERSION;
    private static final int[] GL_CLEAR_CONFIG_ATTRIBUTES;
    private static final int[] GL_CLEAR_CONTEXT_ATTRIBUTES;
    @NotNull
    public static final Companion Companion;

    @Nullable
    protected final OnSizeChangeListener getOnSizeChangeListener() {
        return this.onSizeChangeListener;
    }

    protected final void setOnSizeChangeListener(@Nullable OnSizeChangeListener onSizeChangeListener) {
        this.onSizeChangeListener = onSizeChangeListener;
    }

    @NotNull
    protected final Point getLastNotifiedSize() {
        return this.lastNotifiedSize;
    }

    protected final void setLastNotifiedSize(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"<set-?>");
        this.lastNotifiedSize = point;
    }

    @NotNull
    protected final Point getVideoSize() {
        return this.videoSize;
    }

    protected final void setVideoSize(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"<set-?>");
        this.videoSize = point;
    }

    @NotNull
    protected final MatrixManager getMatrixManager() {
        return this.matrixManager;
    }

    protected final void setMatrixManager(@NotNull MatrixManager matrixManager) {
        Intrinsics.checkNotNullParameter((Object)matrixManager, (String)"<set-?>");
        this.matrixManager = matrixManager;
    }

    @NotNull
    protected final View.OnAttachStateChangeListener getAttachedListener() {
        return this.attachedListener;
    }

    @NotNull
    protected final ViewTreeObserver.OnGlobalLayoutListener getGlobalLayoutMatrixListener() {
        return this.globalLayoutMatrixListener;
    }

    protected final void setGlobalLayoutMatrixListener(@NotNull ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
        Intrinsics.checkNotNullParameter((Object)onGlobalLayoutListener, (String)"<set-?>");
        this.globalLayoutMatrixListener = onGlobalLayoutListener;
    }

    @NotNull
    protected final ReentrantLock getGlobalLayoutMatrixListenerLock() {
        return this.globalLayoutMatrixListenerLock;
    }

    protected final int getRequestedUserRotation() {
        return this.requestedUserRotation;
    }

    protected final void setRequestedUserRotation(int n) {
        this.requestedUserRotation = n;
    }

    protected final int getRequestedConfigurationRotation() {
        return this.requestedConfigurationRotation;
    }

    protected final void setRequestedConfigurationRotation(int n) {
        this.requestedConfigurationRotation = n;
    }

    protected final boolean getMeasureBasedOnAspectRatio() {
        return this.measureBasedOnAspectRatio;
    }

    protected final void setMeasureBasedOnAspectRatio(boolean bl) {
        this.measureBasedOnAspectRatio = bl;
    }

    @Override
    @NotNull
    public ScaleType getScaleType() {
        return this.matrixManager.getCurrentScaleType();
    }

    @Override
    public void setScaleType(@NotNull ScaleType scaleType) {
        Intrinsics.checkNotNullParameter((Object)((Object)scaleType), (String)"scaleType");
        this.matrixManager.scale((View)this, scaleType);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (!this.measureBasedOnAspectRatio) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            this.notifyOnSizeChangeListener(this.getMeasuredWidth(), this.getMeasuredHeight());
            return;
        }
        int width = View.getDefaultSize((int)this.videoSize.x, (int)widthMeasureSpec);
        int height = View.getDefaultSize((int)this.videoSize.y, (int)heightMeasureSpec);
        if (this.videoSize.x <= 0 || this.videoSize.y <= 0) {
            this.setMeasuredDimension(width, height);
            this.notifyOnSizeChangeListener(width, height);
            return;
        }
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
            height = heightSpecSize;
            width = widthSpecSize;
            if (this.videoSize.x * height < width * this.videoSize.y) {
                width = height * this.videoSize.x / this.videoSize.y;
            } else if (this.videoSize.x * height > width * this.videoSize.y) {
                height = width * this.videoSize.y / this.videoSize.x;
            }
        } else if (widthSpecMode == 0x40000000) {
            width = widthSpecSize;
            height = width * this.videoSize.y / this.videoSize.x;
            if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                height = heightSpecSize;
            }
        } else if (heightSpecMode == 0x40000000) {
            height = heightSpecSize;
            width = height * this.videoSize.x / this.videoSize.y;
            if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                width = widthSpecSize;
            }
        } else {
            width = this.videoSize.x;
            height = this.videoSize.y;
            if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                height = heightSpecSize;
                width = height * this.videoSize.x / this.videoSize.y;
            }
            if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                width = widthSpecSize;
                height = width * this.videoSize.y / this.videoSize.x;
            }
        }
        this.setMeasuredDimension(width, height);
        this.notifyOnSizeChangeListener(width, height);
    }

    protected void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
        this.updateMatrixOnLayout();
        super.onConfigurationChanged(newConfig);
    }

    @Override
    public void clearSurface() {
        if (this.getSurfaceTexture() == null) {
            return;
        }
        try {
            EGL eGL = EGLContext.getEGL();
            if (eGL == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.microedition.khronos.egl.EGL10");
            }
            EGL10 gl10 = (EGL10)eGL;
            EGLDisplay display = gl10.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            gl10.eglInitialize(display, null);
            EGLConfig[] configs = new EGLConfig[1];
            gl10.eglChooseConfig(display, GL_CLEAR_CONFIG_ATTRIBUTES, configs, configs.length, new int[1]);
            EGLContext context = gl10.eglCreateContext(display, configs[0], EGL10.EGL_NO_CONTEXT, GL_CLEAR_CONTEXT_ATTRIBUTES);
            EGLSurface eglSurface = gl10.eglCreateWindowSurface(display, configs[0], (Object)this.getSurfaceTexture(), new int[]{12344});
            gl10.eglMakeCurrent(display, eglSurface, eglSurface, context);
            gl10.eglSwapBuffers(display, eglSurface);
            gl10.eglDestroySurface(display, eglSurface);
            gl10.eglMakeCurrent(display, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            gl10.eglDestroyContext(display, context);
            gl10.eglTerminate(display);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error clearing surface", (Throwable)e);
        }
    }

    @Override
    public boolean updateVideoSize(int width, int height) {
        this.matrixManager.setIntrinsicVideoSize(width, height);
        this.updateMatrixOnLayout();
        this.videoSize.x = width;
        this.videoSize.y = height;
        if (width == 0 || height == 0) {
            return false;
        }
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (surfaceTexture == null) {
            return false;
        }
        surfaceTexture.setDefaultBufferSize(width, height);
        return true;
    }

    @Override
    public void setMeasureBasedOnAspectRatioEnabled(boolean enabled) {
        this.measureBasedOnAspectRatio = enabled;
        this.requestLayout();
    }

    @Override
    public void setVideoRotation(@IntRange(from=0L, to=359L) int rotation, boolean fromUser) {
        this.setVideoRotation(fromUser ? rotation : this.requestedUserRotation, !fromUser ? rotation : this.requestedConfigurationRotation);
    }

    @Override
    public void onVideoSizeChanged(int width, int height, float pixelWidthHeightRatio) {
        if (this.updateVideoSize((int)((float)width * pixelWidthHeightRatio), height)) {
            this.requestLayout();
        }
    }

    public final void setVideoRotation(@IntRange(from=0L, to=359L) int userRotation, @IntRange(from=0L, to=359L) int configurationRotation) {
        this.requestedUserRotation = userRotation;
        this.requestedConfigurationRotation = configurationRotation;
        this.matrixManager.rotate((View)this, (userRotation + configurationRotation) % MAX_DEGREES);
    }

    protected final void updateMatrixOnLayout() {
        this.globalLayoutMatrixListenerLock.lock();
        if (this.getWindowToken() == null) {
            this.addOnAttachStateChangeListener(this.attachedListener);
        } else {
            this.getViewTreeObserver().addOnGlobalLayoutListener(this.globalLayoutMatrixListener);
        }
        this.globalLayoutMatrixListenerLock.unlock();
    }

    protected final void notifyOnSizeChangeListener(int width, int height) {
        block1: {
            if (this.lastNotifiedSize.x == width && this.lastNotifiedSize.y == height) {
                return;
            }
            this.lastNotifiedSize.x = width;
            this.lastNotifiedSize.y = height;
            this.updateMatrixOnLayout();
            OnSizeChangeListener onSizeChangeListener = this.onSizeChangeListener;
            if (onSizeChangeListener == null) break block1;
            onSizeChangeListener.onVideoSurfaceSizeChange(width, height);
        }
    }

    public ResizingTextureView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.lastNotifiedSize = new Point(0, 0);
        this.videoSize = new Point(0, 0);
        this.matrixManager = new MatrixManager();
        this.attachedListener = new AttachedListener();
        this.globalLayoutMatrixListener = new GlobalLayoutMatrixListener();
        this.globalLayoutMatrixListenerLock = new ReentrantLock(true);
    }

    public ResizingTextureView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.lastNotifiedSize = new Point(0, 0);
        this.videoSize = new Point(0, 0);
        this.matrixManager = new MatrixManager();
        this.attachedListener = new AttachedListener();
        this.globalLayoutMatrixListener = new GlobalLayoutMatrixListener();
        this.globalLayoutMatrixListenerLock = new ReentrantLock(true);
    }

    public ResizingTextureView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.lastNotifiedSize = new Point(0, 0);
        this.videoSize = new Point(0, 0);
        this.matrixManager = new MatrixManager();
        this.attachedListener = new AttachedListener();
        this.globalLayoutMatrixListener = new GlobalLayoutMatrixListener();
        this.globalLayoutMatrixListenerLock = new ReentrantLock(true);
    }

    public ResizingTextureView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.lastNotifiedSize = new Point(0, 0);
        this.videoSize = new Point(0, 0);
        this.matrixManager = new MatrixManager();
        this.attachedListener = new AttachedListener();
        this.globalLayoutMatrixListener = new GlobalLayoutMatrixListener();
        this.globalLayoutMatrixListenerLock = new ReentrantLock(true);
    }

    static {
        Companion = new Companion(null);
        TAG = "ResizingTextureView";
        MAX_DEGREES = 360;
        EGL_CONTEXT_CLIENT_VERSION = 12440;
        GL_CLEAR_CONFIG_ATTRIBUTES = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, 4, 12344, 0, 12344};
        GL_CLEAR_CONTEXT_ATTRIBUTES = new int[]{EGL_CONTEXT_CLIENT_VERSION, 2, 12344};
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/devbrackets/android/exomedia/core/video/surface/ResizingTextureView$OnSizeChangeListener;", "", "onVideoSurfaceSizeChange", "", "width", "", "height", "library_release"})
    public static interface OnSizeChangeListener {
        public void onVideoSurfaceSizeChange(int var1, int var2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/devbrackets/android/exomedia/core/video/surface/ResizingTextureView$AttachedListener;", "Landroid/view/View$OnAttachStateChangeListener;", "(Lcom/devbrackets/android/exomedia/core/video/surface/ResizingTextureView;)V", "onViewAttachedToWindow", "", "view", "Landroid/view/View;", "onViewDetachedFromWindow", "library_release"})
    private final class AttachedListener
    implements View.OnAttachStateChangeListener {
        public void onViewAttachedToWindow(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            ResizingTextureView.this.getGlobalLayoutMatrixListenerLock().lock();
            ResizingTextureView.this.getViewTreeObserver().addOnGlobalLayoutListener(ResizingTextureView.this.getGlobalLayoutMatrixListener());
            ResizingTextureView.this.removeOnAttachStateChangeListener(this);
            ResizingTextureView.this.getGlobalLayoutMatrixListenerLock().unlock();
        }

        public void onViewDetachedFromWindow(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/devbrackets/android/exomedia/core/video/surface/ResizingTextureView$GlobalLayoutMatrixListener;", "Landroid/view/ViewTreeObserver$OnGlobalLayoutListener;", "(Lcom/devbrackets/android/exomedia/core/video/surface/ResizingTextureView;)V", "onGlobalLayout", "", "library_release"})
    private final class GlobalLayoutMatrixListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        public void onGlobalLayout() {
            ResizingTextureView.this.setScaleType(ResizingTextureView.this.getMatrixManager().getCurrentScaleType());
            ResizingTextureView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/devbrackets/android/exomedia/core/video/surface/ResizingTextureView$Companion;", "", "()V", "EGL_CONTEXT_CLIENT_VERSION", "", "GL_CLEAR_CONFIG_ATTRIBUTES", "", "GL_CLEAR_CONTEXT_ATTRIBUTES", "MAX_DEGREES", "getMAX_DEGREES", "()I", "TAG", "", "library_release"})
    public static final class Companion {
        protected final int getMAX_DEGREES() {
            return MAX_DEGREES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

