/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.source;

import android.net.Uri;
import com.devbrackets.android.exomedia.core.source.builder.DashMediaSourceBuilder;
import com.devbrackets.android.exomedia.core.source.builder.DefaultMediaSourceBuilder;
import com.devbrackets.android.exomedia.core.source.builder.HlsMediaSourceBuilder;
import com.devbrackets.android.exomedia.core.source.builder.MediaSourceBuilder;
import com.devbrackets.android.exomedia.core.source.builder.SsMediaSourceBuilder;
import com.devbrackets.android.exomedia.util.UriExtensionsKt;
import com.google.android.exoplayer2.source.MediaSource;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0004J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0004J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0004J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/devbrackets/android/exomedia/core/source/MediaSourceProvider;", "", "()V", "builders", "", "Lcom/devbrackets/android/exomedia/core/source/MediaSourceProvider$SourceTypeBuilder;", "findByExtension", "uri", "Landroid/net/Uri;", "findByLooseComparison", "findByProviders", "findByScheme", "generate", "Lcom/google/android/exoplayer2/source/MediaSource;", "attributes", "Lcom/devbrackets/android/exomedia/core/source/builder/MediaSourceBuilder$MediaSourceAttributes;", "SourceTypeBuilder", "library_release"})
public class MediaSourceProvider {
    private final List<SourceTypeBuilder> builders = CollectionsKt.listOf((Object[])new SourceTypeBuilder[]{new SourceTypeBuilder(new HlsMediaSourceBuilder(), null, ".m3u8", ".*\\.m3u8.*"), new SourceTypeBuilder(new DashMediaSourceBuilder(), null, ".mpd", ".*\\.mpd.*"), new SourceTypeBuilder(new SsMediaSourceBuilder(), null, ".ism", ".*\\.ism.*")});

    @NotNull
    public List<SourceTypeBuilder> builders() {
        return this.builders;
    }

    @NotNull
    public final MediaSource generate(@NotNull MediaSourceBuilder.MediaSourceAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        SourceTypeBuilder sourceTypeBuilder = this.findByProviders(attributes.getUri());
        Object object = sourceTypeBuilder;
        if (object == null || (object = ((SourceTypeBuilder)object).getBuilder()) == null) {
            object = new DefaultMediaSourceBuilder();
        }
        Object builder = object;
        return ((MediaSourceBuilder)builder).build(attributes);
    }

    @Nullable
    protected final SourceTypeBuilder findByProviders(@NotNull Uri uri) {
        SourceTypeBuilder sourceTypeBuilder;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        SourceTypeBuilder sourceTypeBuilder2 = this.findByScheme(uri);
        if (sourceTypeBuilder2 == null) {
            sourceTypeBuilder2 = sourceTypeBuilder = this.findByExtension(uri);
        }
        if (sourceTypeBuilder2 == null) {
            sourceTypeBuilder = this.findByLooseComparison(uri);
        }
        return sourceTypeBuilder;
    }

    @Nullable
    protected final SourceTypeBuilder findByScheme(@NotNull Uri uri) {
        Object v2;
        block3: {
            String string;
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                    string = uri.getScheme();
                    if (string == null) break block4;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    String string3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it");
                    CharSequence charSequence = string3;
                    boolean bl4 = false;
                    string = charSequence.length() > 0 ? string2 : null;
                    if (string != null) break block5;
                }
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.scheme?.takeIf { it.\u2026tEmpty() } ?: return null");
            String scheme = string;
            Iterable $this$firstOrNull$iv = this.builders();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SourceTypeBuilder it = (SourceTypeBuilder)element$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)it.getUriScheme(), (String)scheme, (boolean)true)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        return v2;
    }

    @Nullable
    protected final SourceTypeBuilder findByExtension(@NotNull Uri uri) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            String string = UriExtensionsKt.getExtension(uri);
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            CharSequence charSequence = it;
            boolean bl4 = false;
            String string2 = charSequence.length() > 0 ? string : null;
            if (string2 == null) {
                return null;
            }
            String extension = string2;
            Iterable $this$firstOrNull$iv = this.builders();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SourceTypeBuilder it2 = (SourceTypeBuilder)element$iv;
                boolean bl5 = false;
                if (!StringsKt.equals((String)it2.getExtension(), (String)extension, (boolean)true)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    protected final SourceTypeBuilder findByLooseComparison(@NotNull Uri uri) {
        Object element$iv;
        Object v1;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.toString()");
        String uriString = string;
        Iterable $this$firstOrNull$iv = this.builders();
        boolean $i$f$firstOrNull = false;
        Iterator iterator = $this$firstOrNull$iv.iterator();
        do {
            if (!iterator.hasNext()) {
                v1 = null;
                return v1;
            }
            element$iv = iterator.next();
            SourceTypeBuilder it = (SourceTypeBuilder)element$iv;
            boolean bl2 = false;
            if (it.getLooseComparisonRegex() != null) {
                String string2;
                boolean bl3 = false;
                if (new Regex(string2).matches((CharSequence)uriString)) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v1 = element$iv;
        return v1;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J7\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/devbrackets/android/exomedia/core/source/MediaSourceProvider$SourceTypeBuilder;", "", "builder", "Lcom/devbrackets/android/exomedia/core/source/builder/MediaSourceBuilder;", "uriScheme", "", "extension", "looseComparisonRegex", "(Lcom/devbrackets/android/exomedia/core/source/builder/MediaSourceBuilder;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBuilder", "()Lcom/devbrackets/android/exomedia/core/source/builder/MediaSourceBuilder;", "getExtension", "()Ljava/lang/String;", "getLooseComparisonRegex", "getUriScheme", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "library_release"})
    public static final class SourceTypeBuilder {
        @NotNull
        private final MediaSourceBuilder builder;
        @Nullable
        private final String uriScheme;
        @Nullable
        private final String extension;
        @Nullable
        private final String looseComparisonRegex;

        @NotNull
        public final MediaSourceBuilder getBuilder() {
            return this.builder;
        }

        @Nullable
        public final String getUriScheme() {
            return this.uriScheme;
        }

        @Nullable
        public final String getExtension() {
            return this.extension;
        }

        @Nullable
        public final String getLooseComparisonRegex() {
            return this.looseComparisonRegex;
        }

        public SourceTypeBuilder(@NotNull MediaSourceBuilder builder, @Nullable String uriScheme, @Nullable String extension, @Nullable String looseComparisonRegex) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            this.builder = builder;
            this.uriScheme = uriScheme;
            this.extension = extension;
            this.looseComparisonRegex = looseComparisonRegex;
        }

        @NotNull
        public final MediaSourceBuilder component1() {
            return this.builder;
        }

        @Nullable
        public final String component2() {
            return this.uriScheme;
        }

        @Nullable
        public final String component3() {
            return this.extension;
        }

        @Nullable
        public final String component4() {
            return this.looseComparisonRegex;
        }

        @NotNull
        public final SourceTypeBuilder copy(@NotNull MediaSourceBuilder builder, @Nullable String uriScheme, @Nullable String extension, @Nullable String looseComparisonRegex) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            return new SourceTypeBuilder(builder, uriScheme, extension, looseComparisonRegex);
        }

        public static /* synthetic */ SourceTypeBuilder copy$default(SourceTypeBuilder sourceTypeBuilder, MediaSourceBuilder mediaSourceBuilder, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                mediaSourceBuilder = sourceTypeBuilder.builder;
            }
            if ((n & 2) != 0) {
                string = sourceTypeBuilder.uriScheme;
            }
            if ((n & 4) != 0) {
                string2 = sourceTypeBuilder.extension;
            }
            if ((n & 8) != 0) {
                string3 = sourceTypeBuilder.looseComparisonRegex;
            }
            return sourceTypeBuilder.copy(mediaSourceBuilder, string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "SourceTypeBuilder(builder=" + this.builder + ", uriScheme=" + this.uriScheme + ", extension=" + this.extension + ", looseComparisonRegex=" + this.looseComparisonRegex + ")";
        }

        public int hashCode() {
            MediaSourceBuilder mediaSourceBuilder = this.builder;
            String string = this.uriScheme;
            String string2 = this.extension;
            String string3 = this.looseComparisonRegex;
            return (((mediaSourceBuilder != null ? mediaSourceBuilder.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SourceTypeBuilder)) break block3;
                    SourceTypeBuilder sourceTypeBuilder = (SourceTypeBuilder)object;
                    if (!Intrinsics.areEqual((Object)this.builder, (Object)sourceTypeBuilder.builder) || !Intrinsics.areEqual((Object)this.uriScheme, (Object)sourceTypeBuilder.uriScheme) || !Intrinsics.areEqual((Object)this.extension, (Object)sourceTypeBuilder.extension) || !Intrinsics.areEqual((Object)this.looseComparisonRegex, (Object)sourceTypeBuilder.looseComparisonRegex)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

