/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import com.devbrackets.android.exomedia.core.ListenerMux;
import com.devbrackets.android.exomedia.core.audio.AudioPlayerApi;
import com.devbrackets.android.exomedia.core.audio.ExoAudioPlayer;
import com.devbrackets.android.exomedia.core.listener.MetadataListener;
import com.devbrackets.android.exomedia.core.renderer.RendererType;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.devbrackets.android.exomedia.listener.OnCompletionListener;
import com.devbrackets.android.exomedia.listener.OnErrorListener;
import com.devbrackets.android.exomedia.listener.OnPreparedListener;
import com.devbrackets.android.exomedia.listener.OnSeekCompletionListener;
import com.devbrackets.android.exomedia.nmp.ExoMediaPlayer;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfig;
import com.devbrackets.android.exomedia.nmp.config.PlayerConfigBuilder;
import com.devbrackets.android.exomedia.nmp.manager.window.WindowInfo;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.drm.DrmSessionManagerProvider;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0016\u0018\u0000 p2\u00020\u0001:\u0002pqB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\r\u0012\u0006\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\tJ\u0011\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u0012H\u0096\u0001J\u0019\u0010@\u001a\u00020\r2\u0006\u0010?\u001a\u00020\u00122\u0006\u0010A\u001a\u00020\rH\u0096\u0001J\u0011\u0010B\u001a\u00020'2\u0006\u0010?\u001a\u00020\u0012H\u0096\u0001J\t\u0010C\u001a\u00020>H\u0096\u0001J\b\u0010D\u001a\u00020>H\u0002J\u000e\u0010E\u001a\u00020>2\u0006\u0010$\u001a\u00020\u001bJ\t\u0010F\u001a\u00020>H\u0096\u0001J\t\u0010G\u001a\u00020>H\u0096\u0001J\b\u0010H\u001a\u00020>H\u0016J\t\u0010I\u001a\u00020'H\u0096\u0001J\u0013\u0010J\u001a\u00020>2\b\b\u0001\u0010K\u001a\u00020\u001bH\u0096\u0001J\u0010\u0010L\u001a\u00020>2\b\u0010M\u001a\u0004\u0018\u00010NJ\u0011\u0010O\u001a\u00020>2\u0006\u0010P\u001a\u00020\rH\u0096\u0001J\u0011\u0010Q\u001a\u00020>2\u0006\u0010)\u001a\u00020*H\u0096\u0001J\u001c\u0010R\u001a\u00020>2\b\u0010S\u001a\u0004\u0018\u00010T2\b\u0010U\u001a\u0004\u0018\u00010VH\u0016J\u0010\u0010W\u001a\u00020>2\b\u0010M\u001a\u0004\u0018\u00010XJ\u0010\u0010Y\u001a\u00020>2\b\u0010M\u001a\u0004\u0018\u00010ZJ\u0010\u0010[\u001a\u00020>2\b\u0010M\u001a\u0004\u0018\u00010\\J\u0010\u0010]\u001a\u00020>2\b\u0010M\u001a\u0004\u0018\u00010^J\u0010\u0010_\u001a\u00020>2\b\u0010M\u001a\u0004\u0018\u00010`J\u0010\u0010a\u001a\u00020>2\b\u0010M\u001a\u0004\u0018\u00010bJ\u0011\u0010c\u001a\u00020'2\u0006\u0010d\u001a\u000202H\u0096\u0001J\u0019\u0010e\u001a\u00020>2\u0006\u0010?\u001a\u00020\u00122\u0006\u0010f\u001a\u00020'H\u0096\u0001J\u0011\u0010g\u001a\u00020>2\u0006\u0010h\u001a\u00020\rH\u0096\u0001J!\u0010i\u001a\u00020>2\u0006\u0010?\u001a\u00020\u00122\u0006\u0010A\u001a\u00020\r2\u0006\u0010j\u001a\u00020\rH\u0096\u0001J\u0011\u0010k\u001a\u00020>2\u0006\u0010l\u001a\u00020\rH\u0096\u0001J\t\u0010m\u001a\u00020>H\u0096\u0001J\t\u0010n\u001a\u00020>H\u0096\u0001J\t\u0010o\u001a\u00020'H\u0096\u0001R\u0014\u0010\b\u001a\u00020\u0001X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0011X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0014\u0010\u0018\u001a\u00020\r8WX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0014\u0010\u001a\u001a\u00020\u001b8WX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001dR\u0012\u0010&\u001a\u00020'X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b&\u0010(R\u0014\u0010)\u001a\u00020*X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u001d\"\u0004\b/\u00100R\u0012\u00101\u001a\u000202X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u001a\u00105\u001a\u0002028WX\u0096\u000f\u00a2\u0006\f\u001a\u0004\b6\u00104\"\u0004\b7\u00108R\u0014\u00109\u001a\u0004\u0018\u00010:X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b;\u0010<\u00a8\u0006r"}, d2={"Lcom/devbrackets/android/exomedia/AudioPlayer;", "Lcom/devbrackets/android/exomedia/core/audio/AudioPlayerApi;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "config", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "(Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;)V", "audioPlayerImpl", "(Lcom/devbrackets/android/exomedia/core/audio/AudioPlayerApi;)V", "getAudioPlayerImpl", "()Lcom/devbrackets/android/exomedia/core/audio/AudioPlayerApi;", "audioSessionId", "", "getAudioSessionId", "()I", "availableTracks", "", "Lcom/devbrackets/android/exomedia/core/renderer/RendererType;", "Lcom/google/android/exoplayer2/source/TrackGroupArray;", "getAvailableTracks", "()Ljava/util/Map;", "bufferPercentage", "getBufferPercentage", "bufferedPercent", "getBufferedPercent", "currentPosition", "", "getCurrentPosition", "()J", "drmSessionManagerProvider", "Lcom/google/android/exoplayer2/drm/DrmSessionManagerProvider;", "getDrmSessionManagerProvider", "()Lcom/google/android/exoplayer2/drm/DrmSessionManagerProvider;", "setDrmSessionManagerProvider", "(Lcom/google/android/exoplayer2/drm/DrmSessionManagerProvider;)V", "duration", "getDuration", "isPlaying", "", "()Z", "listenerMux", "Lcom/devbrackets/android/exomedia/core/ListenerMux;", "getListenerMux", "()Lcom/devbrackets/android/exomedia/core/ListenerMux;", "overriddenDuration", "getOverriddenDuration", "setOverriddenDuration", "(J)V", "playbackSpeed", "", "getPlaybackSpeed", "()F", "volume", "getVolume", "setVolume", "(F)V", "windowInfo", "Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "getWindowInfo", "()Lcom/devbrackets/android/exomedia/nmp/manager/window/WindowInfo;", "clearSelectedTracks", "", "type", "getSelectedTrackIndex", "groupIndex", "isRendererEnabled", "onMediaPrepared", "onPlaybackEnded", "overrideDuration", "pause", "release", "reset", "restart", "seekTo", "milliseconds", "setAnalyticsListener", "listener", "Lcom/google/android/exoplayer2/analytics/AnalyticsListener;", "setAudioStreamType", "streamType", "setListenerMux", "setMedia", "uri", "Landroid/net/Uri;", "mediaSource", "Lcom/google/android/exoplayer2/source/MediaSource;", "setMetadataListener", "Lcom/devbrackets/android/exomedia/core/listener/MetadataListener;", "setOnBufferUpdateListener", "Lcom/devbrackets/android/exomedia/listener/OnBufferUpdateListener;", "setOnCompletionListener", "Lcom/devbrackets/android/exomedia/listener/OnCompletionListener;", "setOnErrorListener", "Lcom/devbrackets/android/exomedia/listener/OnErrorListener;", "setOnPreparedListener", "Lcom/devbrackets/android/exomedia/listener/OnPreparedListener;", "setOnSeekCompletionListener", "Lcom/devbrackets/android/exomedia/listener/OnSeekCompletionListener;", "setPlaybackSpeed", "speed", "setRendererEnabled", "enabled", "setRepeatMode", "repeatMode", "setSelectedTrack", "trackIndex", "setWakeLevel", "levelAndFlags", "start", "stop", "trackSelectionAvailable", "Companion", "MuxNotifier", "library_release"})
public class AudioPlayer
implements AudioPlayerApi {
    @NotNull
    private final ListenerMux listenerMux;
    private long overriddenDuration;
    @NotNull
    private final AudioPlayerApi audioPlayerImpl;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final ListenerMux getListenerMux() {
        return this.listenerMux;
    }

    protected final long getOverriddenDuration() {
        return this.overriddenDuration;
    }

    protected final void setOverriddenDuration(long l) {
        this.overriddenDuration = l;
    }

    @Override
    public long getDuration() {
        return this.overriddenDuration >= 0L ? this.overriddenDuration : this.audioPlayerImpl.getDuration();
    }

    public final int getBufferPercentage() {
        return this.audioPlayerImpl.getBufferedPercent();
    }

    @Override
    public void setMedia(@Nullable Uri uri, @Nullable MediaSource mediaSource) {
        this.audioPlayerImpl.setMedia(uri, mediaSource);
        this.overrideDuration(-1L);
    }

    @Override
    public void reset() {
        this.stop();
        this.setMedia(null, null);
        this.audioPlayerImpl.reset();
    }

    public final void overrideDuration(long duration) {
        this.overriddenDuration = duration;
    }

    public final void setOnPreparedListener(@Nullable OnPreparedListener listener) {
        this.listenerMux.setOnPreparedListener(listener);
    }

    public final void setOnCompletionListener(@Nullable OnCompletionListener listener) {
        this.listenerMux.setOnCompletionListener(listener);
    }

    public final void setOnBufferUpdateListener(@Nullable OnBufferUpdateListener listener) {
        this.listenerMux.setOnBufferUpdateListener(listener);
    }

    public final void setOnSeekCompletionListener(@Nullable OnSeekCompletionListener listener) {
        this.listenerMux.setOnSeekCompletionListener(listener);
    }

    public final void setOnErrorListener(@Nullable OnErrorListener listener) {
        this.listenerMux.setOnErrorListener(listener);
    }

    public final void setMetadataListener(@Nullable MetadataListener listener) {
        this.listenerMux.setMetadataListener(listener);
    }

    public final void setAnalyticsListener(@Nullable AnalyticsListener listener) {
        this.listenerMux.setAnalyticsListener(listener);
    }

    private final void onPlaybackEnded() {
        this.pause();
    }

    @NotNull
    protected final AudioPlayerApi getAudioPlayerImpl() {
        return this.audioPlayerImpl;
    }

    public AudioPlayer(@NotNull AudioPlayerApi audioPlayerImpl) {
        Intrinsics.checkNotNullParameter((Object)audioPlayerImpl, (String)"audioPlayerImpl");
        this.audioPlayerImpl = audioPlayerImpl;
        this.listenerMux = new ListenerMux(new MuxNotifier());
        this.overriddenDuration = -1L;
        this.audioPlayerImpl.setListenerMux(this.listenerMux);
    }

    public AudioPlayer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(new PlayerConfigBuilder(context).build());
    }

    public AudioPlayer(@NotNull PlayerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this(Companion.getPlayerImplementation(config));
    }

    @Override
    public int getAudioSessionId() {
        return this.audioPlayerImpl.getAudioSessionId();
    }

    @Override
    @Nullable
    public Map<RendererType, TrackGroupArray> getAvailableTracks() {
        return this.audioPlayerImpl.getAvailableTracks();
    }

    @Override
    @IntRange(from=0L, to=100L)
    public int getBufferedPercent() {
        return this.audioPlayerImpl.getBufferedPercent();
    }

    @Override
    @IntRange(from=0L)
    public long getCurrentPosition() {
        return this.audioPlayerImpl.getCurrentPosition();
    }

    @Override
    @Nullable
    public DrmSessionManagerProvider getDrmSessionManagerProvider() {
        return this.audioPlayerImpl.getDrmSessionManagerProvider();
    }

    @Override
    public void setDrmSessionManagerProvider(@Nullable DrmSessionManagerProvider drmSessionManagerProvider) {
        this.audioPlayerImpl.setDrmSessionManagerProvider(drmSessionManagerProvider);
    }

    @Override
    public boolean isPlaying() {
        return this.audioPlayerImpl.isPlaying();
    }

    @Override
    public float getPlaybackSpeed() {
        return this.audioPlayerImpl.getPlaybackSpeed();
    }

    @Override
    @FloatRange(from=0.0, to=1.0)
    public float getVolume() {
        return this.audioPlayerImpl.getVolume();
    }

    @Override
    public void setVolume(float f) {
        this.audioPlayerImpl.setVolume(f);
    }

    @Override
    @Nullable
    public WindowInfo getWindowInfo() {
        return this.audioPlayerImpl.getWindowInfo();
    }

    @Override
    public void clearSelectedTracks(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.audioPlayerImpl.clearSelectedTracks(type);
    }

    @Override
    public int getSelectedTrackIndex(@NotNull RendererType type, int groupIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.audioPlayerImpl.getSelectedTrackIndex(type, groupIndex);
    }

    @Override
    public boolean isRendererEnabled(@NotNull RendererType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return this.audioPlayerImpl.isRendererEnabled(type);
    }

    @Override
    public void onMediaPrepared() {
        this.audioPlayerImpl.onMediaPrepared();
    }

    @Override
    public void pause() {
        this.audioPlayerImpl.pause();
    }

    @Override
    public void release() {
        this.audioPlayerImpl.release();
    }

    @Override
    public boolean restart() {
        return this.audioPlayerImpl.restart();
    }

    @Override
    public void seekTo(@IntRange(from=0L) long milliseconds) {
        this.audioPlayerImpl.seekTo(milliseconds);
    }

    @Override
    public void setAudioStreamType(int streamType) {
        this.audioPlayerImpl.setAudioStreamType(streamType);
    }

    @Override
    public void setListenerMux(@NotNull ListenerMux listenerMux2) {
        Intrinsics.checkNotNullParameter((Object)listenerMux2, (String)"listenerMux");
        this.audioPlayerImpl.setListenerMux(listenerMux2);
    }

    @Override
    public boolean setPlaybackSpeed(float speed) {
        return this.audioPlayerImpl.setPlaybackSpeed(speed);
    }

    @Override
    public void setRendererEnabled(@NotNull RendererType type, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.audioPlayerImpl.setRendererEnabled(type, enabled);
    }

    @Override
    public void setRepeatMode(int repeatMode) {
        this.audioPlayerImpl.setRepeatMode(repeatMode);
    }

    @Override
    public void setSelectedTrack(@NotNull RendererType type, int groupIndex, int trackIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.audioPlayerImpl.setSelectedTrack(type, groupIndex, trackIndex);
    }

    @Override
    public void setWakeLevel(int levelAndFlags) {
        this.audioPlayerImpl.setWakeLevel(levelAndFlags);
    }

    @Override
    public void start() {
        this.audioPlayerImpl.start();
    }

    @Override
    public void stop() {
        this.audioPlayerImpl.stop();
    }

    @Override
    public boolean trackSelectionAvailable() {
        return this.audioPlayerImpl.trackSelectionAvailable();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tH\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/devbrackets/android/exomedia/AudioPlayer$MuxNotifier;", "Lcom/devbrackets/android/exomedia/core/ListenerMux$Notifier;", "(Lcom/devbrackets/android/exomedia/AudioPlayer;)V", "onExoPlayerError", "", "exoMediaPlayer", "Lcom/devbrackets/android/exomedia/nmp/ExoMediaPlayer;", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onMediaPlaybackEnded", "onPrepared", "shouldNotifyCompletion", "", "endLeeway", "", "library_release"})
    private final class MuxNotifier
    extends ListenerMux.Notifier {
        @Override
        public boolean shouldNotifyCompletion(long endLeeway) {
            return AudioPlayer.this.getCurrentPosition() > 0L && AudioPlayer.this.getDuration() > 0L && AudioPlayer.this.getCurrentPosition() + endLeeway >= AudioPlayer.this.getDuration();
        }

        @Override
        public void onExoPlayerError(@NotNull ExoMediaPlayer exoMediaPlayer, @Nullable Exception e) {
            Intrinsics.checkNotNullParameter((Object)exoMediaPlayer, (String)"exoMediaPlayer");
            AudioPlayer.this.stop();
            exoMediaPlayer.forcePrepare();
        }

        @Override
        public void onMediaPlaybackEnded() {
            AudioPlayer.this.onPlaybackEnded();
        }

        @Override
        public void onPrepared() {
            AudioPlayer.this.getAudioPlayerImpl().onMediaPrepared();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/devbrackets/android/exomedia/AudioPlayer$Companion;", "", "()V", "getPlayerImplementation", "Lcom/devbrackets/android/exomedia/core/audio/AudioPlayerApi;", "config", "Lcom/devbrackets/android/exomedia/nmp/config/PlayerConfig;", "library_release"})
    public static final class Companion {
        @NotNull
        public final AudioPlayerApi getPlayerImplementation(@NotNull PlayerConfig config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return config.getFallbackManager().useFallback() ? config.getFallbackManager().getFallbackAudioPlayer(config.getContext()) : (AudioPlayerApi)new ExoAudioPlayer(config);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

