/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.net.Uri;
import android.support.annotation.DrawableRes;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.devbrackets.android.exomedia.ExoMedia;
import com.devbrackets.android.exomedia.R;
import com.devbrackets.android.exomedia.core.ListenerMux;
import com.devbrackets.android.exomedia.core.api.VideoViewApi;
import com.devbrackets.android.exomedia.core.exoplayer.ExoMediaPlayer;
import com.devbrackets.android.exomedia.core.exoplayer.WindowInfo;
import com.devbrackets.android.exomedia.core.listener.MetadataListener;
import com.devbrackets.android.exomedia.core.video.scale.ScaleType;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.devbrackets.android.exomedia.listener.OnCompletionListener;
import com.devbrackets.android.exomedia.listener.OnErrorListener;
import com.devbrackets.android.exomedia.listener.OnPreparedListener;
import com.devbrackets.android.exomedia.listener.OnSeekCompletionListener;
import com.devbrackets.android.exomedia.listener.OnVideoSizeChangedListener;
import com.devbrackets.android.exomedia.ui.widget.VideoControls;
import com.devbrackets.android.exomedia.ui.widget.VideoControlsCore;
import com.devbrackets.android.exomedia.ui.widget.VideoControlsLeanback;
import com.devbrackets.android.exomedia.ui.widget.VideoControlsMobile;
import com.devbrackets.android.exomedia.util.DeviceUtil;
import com.devbrackets.android.exomedia.util.StopWatch;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import java.util.Map;

public class VideoView
extends RelativeLayout {
    private static final String TAG = VideoView.class.getSimpleName();
    @Nullable
    protected VideoControlsCore videoControls;
    protected ImageView previewImageView;
    protected Uri videoUri;
    protected VideoViewApi videoViewImpl;
    protected DeviceUtil deviceUtil = new DeviceUtil();
    protected AudioManager audioManager;
    @NonNull
    protected AudioFocusHelper audioFocusHelper = new AudioFocusHelper();
    protected long positionOffset = 0L;
    protected long overriddenDuration = -1L;
    protected boolean overridePosition = false;
    protected boolean matchOverridePositionSpeed = true;
    protected StopWatch overriddenPositionStopWatch = new StopWatch();
    protected MuxNotifier muxNotifier = new MuxNotifier();
    protected ListenerMux listenerMux;
    protected boolean releaseOnDetachFromWindow = true;
    protected boolean handleAudioFocus = true;

    public VideoView(Context context) {
        super(context);
        this.setup(context, null);
    }

    public VideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup(context, attrs);
    }

    @TargetApi(value=11)
    public VideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup(context, attrs);
    }

    @TargetApi(value=21)
    public VideoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setup(context, attrs);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.isInEditMode() && this.releaseOnDetachFromWindow) {
            this.release();
        }
    }

    public void setOnTouchListener(View.OnTouchListener listener) {
        this.videoViewImpl.setOnTouchListener(listener);
        super.setOnTouchListener(listener);
    }

    public void setReleaseOnDetachFromWindow(boolean releaseOnDetach) {
        this.releaseOnDetachFromWindow = releaseOnDetach;
    }

    public void release() {
        if (this.videoControls != null) {
            this.videoControls.onDetachedFromView(this);
            this.videoControls = null;
        }
        this.stopPlayback();
        this.overriddenPositionStopWatch.stop();
        this.videoViewImpl.release();
    }

    public void setPreviewImage(@Nullable Drawable drawable2) {
        if (this.previewImageView != null) {
            this.previewImageView.setImageDrawable(drawable2);
        }
    }

    public void setPreviewImage(@DrawableRes int resourceId) {
        if (this.previewImageView != null) {
            this.previewImageView.setImageResource(resourceId);
        }
    }

    public void setPreviewImage(@Nullable Bitmap bitmap) {
        if (this.previewImageView != null) {
            this.previewImageView.setImageBitmap(bitmap);
        }
    }

    public void setPreviewImage(@Nullable Uri uri) {
        if (this.previewImageView != null) {
            this.previewImageView.setImageURI(uri);
        }
    }

    public ImageView getPreviewImageView() {
        return this.previewImageView;
    }

    @Deprecated
    public void setControls(@Nullable VideoControls controls) {
        this.setControls((VideoControlsCore)controls);
    }

    public void setControls(@Nullable VideoControlsCore controls) {
        if (this.videoControls != null && this.videoControls != controls) {
            this.videoControls.onDetachedFromView(this);
        }
        this.videoControls = controls;
        if (this.videoControls != null) {
            this.videoControls.onAttachedToView(this);
        }
        TouchListener listener = new TouchListener(this.getContext());
        this.setOnTouchListener(this.videoControls != null ? listener : null);
    }

    public void showControls() {
        if (this.videoControls != null) {
            this.videoControls.show();
            if (this.isPlaying()) {
                this.videoControls.hide(true);
            }
        }
    }

    @Deprecated
    @Nullable
    public VideoControls getVideoControls() {
        if (this.videoControls != null && this.videoControls instanceof VideoControls) {
            return (VideoControls)this.videoControls;
        }
        return null;
    }

    @Nullable
    public VideoControlsCore getVideoControlsCore() {
        return this.videoControls;
    }

    public void setVideoURI(@Nullable Uri uri) {
        this.videoUri = uri;
        this.videoViewImpl.setVideoUri(uri);
        if (this.videoControls != null) {
            this.videoControls.showLoading(true);
        }
    }

    public void setVideoURI(@Nullable Uri uri, @Nullable MediaSource mediaSource) {
        this.videoUri = uri;
        this.videoViewImpl.setVideoUri(uri, mediaSource);
        if (this.videoControls != null) {
            this.videoControls.showLoading(true);
        }
    }

    public void setVideoPath(String path) {
        this.setVideoURI(Uri.parse((String)path));
    }

    @Nullable
    public Uri getVideoUri() {
        return this.videoUri;
    }

    public void setDrmCallback(@Nullable MediaDrmCallback drmCallback) {
        this.videoViewImpl.setDrmCallback(drmCallback);
    }

    public float getVolume() {
        return this.videoViewImpl.getVolume();
    }

    public boolean setVolume(@FloatRange(from=0.0, to=1.0) float volume) {
        return this.videoViewImpl.setVolume(volume);
    }

    public void setHandleAudioFocus(boolean handleAudioFocus) {
        this.audioFocusHelper.abandonFocus();
        this.handleAudioFocus = handleAudioFocus;
    }

    public void reset() {
        this.stopPlayback();
        this.setVideoURI(null);
    }

    public void seekTo(long milliSeconds) {
        if (this.videoControls != null) {
            this.videoControls.showLoading(false);
        }
        this.videoViewImpl.seekTo(milliSeconds);
    }

    public boolean isPlaying() {
        return this.videoViewImpl.isPlaying();
    }

    public void start() {
        if (!this.audioFocusHelper.requestFocus()) {
            return;
        }
        this.videoViewImpl.start();
        this.setKeepScreenOn(true);
        if (this.videoControls != null) {
            this.videoControls.updatePlaybackState(true);
        }
    }

    public void pause() {
        this.pause(false);
    }

    public void pause(boolean transientFocusLoss) {
        if (!transientFocusLoss) {
            this.audioFocusHelper.abandonFocus();
        }
        this.videoViewImpl.pause();
        this.setKeepScreenOn(false);
        if (this.videoControls != null) {
            this.videoControls.updatePlaybackState(false);
        }
    }

    public void stopPlayback() {
        this.stopPlayback(true);
    }

    public boolean restart() {
        if (this.videoUri == null) {
            return false;
        }
        if (this.videoViewImpl.restart()) {
            if (this.videoControls != null) {
                this.videoControls.showLoading(true);
            }
            return true;
        }
        return false;
    }

    public void suspend() {
        this.audioFocusHelper.abandonFocus();
        this.videoViewImpl.suspend();
        this.setKeepScreenOn(false);
        if (this.videoControls != null) {
            this.videoControls.updatePlaybackState(false);
        }
    }

    public long getDuration() {
        if (this.overriddenDuration >= 0L) {
            return this.overriddenDuration;
        }
        return this.videoViewImpl.getDuration();
    }

    public void overrideDuration(long duration) {
        this.overriddenDuration = duration;
    }

    public long getCurrentPosition() {
        if (this.overridePosition) {
            return this.positionOffset + this.overriddenPositionStopWatch.getTime();
        }
        return this.positionOffset + this.videoViewImpl.getCurrentPosition();
    }

    public void setPositionOffset(long offset) {
        this.positionOffset = offset;
    }

    public void restartOverridePosition() {
        this.overriddenPositionStopWatch.reset();
    }

    public void overridePosition(boolean override) {
        if (override) {
            this.overriddenPositionStopWatch.start();
        } else {
            this.overriddenPositionStopWatch.stop();
        }
        this.overridePosition = override;
    }

    public void setOverridePositionMatchesPlaybackSpeed(boolean match) {
        if (match != this.matchOverridePositionSpeed) {
            this.matchOverridePositionSpeed = match;
            if (match) {
                this.overriddenPositionStopWatch.setSpeedMultiplier(this.getPlaybackSpeed());
            } else {
                this.overriddenPositionStopWatch.setSpeedMultiplier(1.0f);
            }
        }
    }

    public int getBufferPercentage() {
        return this.videoViewImpl.getBufferedPercent();
    }

    @Nullable
    public WindowInfo getWindowInfo() {
        return this.videoViewImpl.getWindowInfo();
    }

    public void setRepeatMode(int repeatMode) {
        this.videoViewImpl.setRepeatMode(repeatMode);
    }

    public boolean setPlaybackSpeed(float speed) {
        boolean wasSet = this.videoViewImpl.setPlaybackSpeed(speed);
        if (wasSet && this.matchOverridePositionSpeed) {
            this.overriddenPositionStopWatch.setSpeedMultiplier(speed);
        }
        return wasSet;
    }

    public float getPlaybackSpeed() {
        return this.videoViewImpl.getPlaybackSpeed();
    }

    public boolean trackSelectionAvailable() {
        return this.videoViewImpl.trackSelectionAvailable();
    }

    @Deprecated
    public void setTrack(ExoMedia.RendererType trackType, int trackIndex) {
        this.videoViewImpl.setTrack(trackType, trackIndex);
    }

    public void setTrack(ExoMedia.RendererType trackType, int groupIndex, int trackIndex) {
        this.videoViewImpl.setTrack(trackType, groupIndex, trackIndex);
    }

    @Nullable
    public Map<ExoMedia.RendererType, TrackGroupArray> getAvailableTracks() {
        return this.videoViewImpl.getAvailableTracks();
    }

    public void setRendererEnabled(@NonNull ExoMedia.RendererType type, boolean enabled) {
        this.videoViewImpl.setRendererEnabled(type, enabled);
    }

    public void setScaleType(@NonNull ScaleType scaleType) {
        this.videoViewImpl.setScaleType(scaleType);
    }

    public void setMeasureBasedOnAspectRatioEnabled(boolean measureBasedOnAspectRatioEnabled) {
        this.videoViewImpl.setMeasureBasedOnAspectRatioEnabled(measureBasedOnAspectRatioEnabled);
    }

    public void setVideoRotation(@IntRange(from=0L, to=359L) int rotation) {
        this.videoViewImpl.setVideoRotation(rotation, true);
    }

    public void setOnPreparedListener(@Nullable OnPreparedListener listener) {
        this.listenerMux.setOnPreparedListener(listener);
    }

    public void setOnCompletionListener(@Nullable OnCompletionListener listener) {
        this.listenerMux.setOnCompletionListener(listener);
    }

    public void setOnBufferUpdateListener(@Nullable OnBufferUpdateListener listener) {
        this.listenerMux.setOnBufferUpdateListener(listener);
    }

    public void setOnSeekCompletionListener(@Nullable OnSeekCompletionListener listener) {
        this.listenerMux.setOnSeekCompletionListener(listener);
    }

    public void setOnErrorListener(@Nullable OnErrorListener listener) {
        this.listenerMux.setOnErrorListener(listener);
    }

    public void setId3MetadataListener(@Nullable MetadataListener listener) {
        this.listenerMux.setMetadataListener(listener);
    }

    public void setAnalyticsListener(@Nullable AnalyticsListener listener) {
        this.listenerMux.setAnalyticsListener(listener);
    }

    public void setOnVideoSizedChangedListener(@Nullable OnVideoSizeChangedListener listener) {
        this.muxNotifier.videoSizeChangedListener = listener;
    }

    @Nullable
    public Bitmap getBitmap() {
        if (this.videoViewImpl instanceof TextureView) {
            return ((TextureView)this.videoViewImpl).getBitmap();
        }
        return null;
    }

    protected void setup(Context context, @Nullable AttributeSet attrs) {
        if (this.isInEditMode()) {
            return;
        }
        this.audioManager = (AudioManager)context.getApplicationContext().getSystemService("audio");
        AttributeContainer attributeContainer = new AttributeContainer(context, attrs);
        this.initView(context, attributeContainer);
        this.postInit(attributeContainer);
    }

    protected void initView(Context context, @NonNull AttributeContainer attributeContainer) {
        this.inflateVideoView(context, attributeContainer);
        this.previewImageView = (ImageView)this.findViewById(R.id.exomedia_video_preview_image);
        this.videoViewImpl = (VideoViewApi)this.findViewById(R.id.exomedia_video_view);
        this.muxNotifier = new MuxNotifier();
        this.listenerMux = new ListenerMux(this.muxNotifier);
        this.videoViewImpl.setListenerMux(this.listenerMux);
    }

    protected void postInit(@NonNull AttributeContainer attributeContainer) {
        if (attributeContainer.useDefaultControls) {
            this.setControls(this.deviceUtil.isDeviceTV(this.getContext()) ? new VideoControlsLeanback(this.getContext()) : new VideoControlsMobile(this.getContext()));
        }
        if (attributeContainer.scaleType != null) {
            this.setScaleType(attributeContainer.scaleType);
        }
        if (attributeContainer.measureBasedOnAspectRatio != null) {
            this.setMeasureBasedOnAspectRatioEnabled(attributeContainer.measureBasedOnAspectRatio);
        }
    }

    protected void inflateVideoView(@NonNull Context context, @NonNull AttributeContainer attributeContainer) {
        View.inflate((Context)context, (int)R.layout.exomedia_video_view_layout, (ViewGroup)this);
        ViewStub videoViewStub = (ViewStub)this.findViewById(R.id.video_view_api_impl_stub);
        videoViewStub.setLayoutResource(this.getVideoViewApiImplementation(context, attributeContainer));
        videoViewStub.inflate();
    }

    @LayoutRes
    protected int getVideoViewApiImplementation(@NonNull Context context, @NonNull AttributeContainer attributeContainer) {
        boolean useLegacy = !this.deviceUtil.supportsExoPlayer(context);
        return useLegacy ? attributeContainer.apiImplLegacyResourceId : attributeContainer.apiImplResourceId;
    }

    protected void onPlaybackEnded() {
        this.stopPlayback(false);
    }

    protected void stopPlayback(boolean clearSurface) {
        this.audioFocusHelper.abandonFocus();
        this.videoViewImpl.stopPlayback(clearSurface);
        this.setKeepScreenOn(false);
        if (this.videoControls != null) {
            this.videoControls.updatePlaybackState(false);
        }
    }

    protected class AttributeContainer {
        public boolean useDefaultControls = false;
        public boolean useTextureViewBacking = false;
        public int apiImplResourceId = R.layout.exomedia_default_exo_texture_video_view;
        public int apiImplLegacyResourceId = R.layout.exomedia_default_native_texture_video_view;
        @Nullable
        public ScaleType scaleType;
        @Nullable
        public Boolean measureBasedOnAspectRatio;

        public AttributeContainer(@Nullable Context context, AttributeSet attrs) {
            if (attrs == null) {
                return;
            }
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.VideoView);
            if (typedArray == null) {
                return;
            }
            this.useDefaultControls = typedArray.getBoolean(R.styleable.VideoView_useDefaultControls, this.useDefaultControls);
            this.useTextureViewBacking = typedArray.getBoolean(R.styleable.VideoView_useTextureViewBacking, this.useTextureViewBacking);
            if (typedArray.hasValue(R.styleable.VideoView_videoScale)) {
                this.scaleType = ScaleType.fromOrdinal(typedArray.getInt(R.styleable.VideoView_videoScale, -1));
            }
            if (typedArray.hasValue(R.styleable.VideoView_measureBasedOnAspectRatio)) {
                this.measureBasedOnAspectRatio = typedArray.getBoolean(R.styleable.VideoView_measureBasedOnAspectRatio, false);
            }
            this.apiImplResourceId = this.useTextureViewBacking ? R.layout.exomedia_default_exo_texture_video_view : R.layout.exomedia_default_exo_surface_video_view;
            this.apiImplLegacyResourceId = this.useTextureViewBacking ? R.layout.exomedia_default_native_texture_video_view : R.layout.exomedia_default_native_surface_video_view;
            this.apiImplResourceId = typedArray.getResourceId(R.styleable.VideoView_videoViewApiImpl, this.apiImplResourceId);
            this.apiImplLegacyResourceId = typedArray.getResourceId(R.styleable.VideoView_videoViewApiImplLegacy, this.apiImplLegacyResourceId);
            typedArray.recycle();
        }
    }

    protected class TouchListener
    extends GestureDetector.SimpleOnGestureListener
    implements View.OnTouchListener {
        protected GestureDetector gestureDetector;

        public TouchListener(Context context) {
            this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
        }

        public boolean onTouch(View view, MotionEvent event) {
            this.gestureDetector.onTouchEvent(event);
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent event) {
            if (VideoView.this.videoControls != null && VideoView.this.videoControls.isVisible()) {
                VideoView.this.videoControls.hide(false);
            } else {
                VideoView.this.showControls();
            }
            return true;
        }
    }

    protected class MuxNotifier
    extends ListenerMux.Notifier {
        @Nullable
        public OnVideoSizeChangedListener videoSizeChangedListener;

        protected MuxNotifier() {
        }

        @Override
        public boolean shouldNotifyCompletion(long endLeeway) {
            long position = VideoView.this.getCurrentPosition();
            long duration = VideoView.this.getDuration();
            return position > 0L && duration > 0L && position + endLeeway >= duration;
        }

        @Override
        public void onExoPlayerError(ExoMediaPlayer exoMediaPlayer, Exception e) {
            VideoView.this.stopPlayback();
            if (exoMediaPlayer != null) {
                exoMediaPlayer.forcePrepare();
            }
        }

        @Override
        public void onMediaPlaybackEnded() {
            VideoView.this.setKeepScreenOn(false);
            VideoView.this.onPlaybackEnded();
        }

        @Override
        public void onSeekComplete() {
            if (VideoView.this.videoControls != null) {
                VideoView.this.videoControls.finishLoading();
            }
        }

        @Override
        public void onVideoSizeChanged(int width, int height, int unAppliedRotationDegrees, float pixelWidthHeightRatio) {
            VideoView.this.videoViewImpl.setVideoRotation(unAppliedRotationDegrees, false);
            VideoView.this.videoViewImpl.onVideoSizeChanged(width, height, pixelWidthHeightRatio);
            if (this.videoSizeChangedListener != null) {
                this.videoSizeChangedListener.onVideoSizeChanged(width, height, pixelWidthHeightRatio);
            }
        }

        @Override
        public void onPrepared() {
            if (VideoView.this.videoControls != null) {
                VideoView.this.videoControls.setDuration(VideoView.this.getDuration());
                VideoView.this.videoControls.finishLoading();
            }
        }

        @Override
        public void onPreviewImageStateChanged(boolean toVisible) {
            if (VideoView.this.previewImageView != null) {
                VideoView.this.previewImageView.setVisibility(toVisible ? 0 : 8);
            }
        }
    }

    protected class AudioFocusHelper
    implements AudioManager.OnAudioFocusChangeListener {
        protected boolean startRequested = false;
        protected boolean pausedForLoss = false;
        protected int currentFocus = 0;

        protected AudioFocusHelper() {
        }

        public void onAudioFocusChange(int focusChange) {
            if (!VideoView.this.handleAudioFocus || this.currentFocus == focusChange) {
                return;
            }
            this.currentFocus = focusChange;
            switch (focusChange) {
                case 1: 
                case 2: {
                    if (!this.startRequested && !this.pausedForLoss) break;
                    VideoView.this.start();
                    this.startRequested = false;
                    this.pausedForLoss = false;
                    break;
                }
                case -1: {
                    if (!VideoView.this.isPlaying()) break;
                    this.pausedForLoss = true;
                    VideoView.this.pause();
                    break;
                }
                case -3: 
                case -2: {
                    if (!VideoView.this.isPlaying()) break;
                    this.pausedForLoss = true;
                    VideoView.this.pause(true);
                }
            }
        }

        public boolean requestFocus() {
            if (!VideoView.this.handleAudioFocus || this.currentFocus == 1) {
                return true;
            }
            if (VideoView.this.audioManager == null) {
                return false;
            }
            int status = VideoView.this.audioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 1);
            if (1 == status) {
                this.currentFocus = 1;
                return true;
            }
            this.startRequested = true;
            return false;
        }

        public boolean abandonFocus() {
            if (!VideoView.this.handleAudioFocus) {
                return true;
            }
            if (VideoView.this.audioManager == null) {
                return false;
            }
            this.startRequested = false;
            int status = VideoView.this.audioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
            return 1 == status;
        }
    }
}

