/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.video.mp;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import com.devbrackets.android.exomedia.ExoMedia;
import com.devbrackets.android.exomedia.core.ListenerMux;
import com.devbrackets.android.exomedia.core.api.VideoViewApi;
import com.devbrackets.android.exomedia.core.exoplayer.WindowInfo;
import com.devbrackets.android.exomedia.core.video.ResizingSurfaceView;
import com.devbrackets.android.exomedia.core.video.mp.NativeVideoDelegate;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import java.util.Map;

public class NativeSurfaceVideoView
extends ResizingSurfaceView
implements NativeVideoDelegate.Callback,
VideoViewApi {
    protected View.OnTouchListener touchListener;
    protected NativeVideoDelegate delegate;

    public NativeSurfaceVideoView(Context context) {
        super(context);
        this.setup(context, null);
    }

    public NativeSurfaceVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup(context, attrs);
    }

    public NativeSurfaceVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup(context, attrs);
    }

    @TargetApi(value=21)
    public NativeSurfaceVideoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setup(context, attrs);
    }

    @Override
    public void setDrmCallback(@Nullable MediaDrmCallback drmCallback) {
    }

    @Override
    public void start() {
        this.delegate.start();
        this.requestFocus();
    }

    @Override
    public void pause() {
        this.delegate.pause();
    }

    @Override
    public long getDuration() {
        return this.delegate.getDuration();
    }

    @Override
    public long getCurrentPosition() {
        return this.delegate.getCurrentPosition();
    }

    @Override
    public void seekTo(long milliseconds) {
        this.delegate.seekTo(milliseconds);
    }

    @Override
    public boolean isPlaying() {
        return this.delegate.isPlaying();
    }

    @Override
    public void videoSizeChanged(int width, int height) {
        if (this.updateVideoSize(width, height)) {
            this.requestLayout();
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        boolean flag = false;
        if (this.touchListener != null) {
            flag = this.touchListener.onTouch((View)this, ev);
        }
        return flag || super.onTouchEvent(ev);
    }

    @Override
    public void setOnTouchListener(View.OnTouchListener listener) {
        this.touchListener = listener;
        super.setOnTouchListener(listener);
    }

    @Override
    public void setVideoUri(@Nullable Uri uri) {
        this.setVideoUri(uri, null);
    }

    @Override
    public void setVideoUri(@Nullable Uri uri, @Nullable MediaSource mediaSource) {
        this.setVideoURI(uri);
    }

    @Override
    public float getVolume() {
        return this.delegate.getVolume();
    }

    @Override
    public boolean setVolume(@FloatRange(from=0.0, to=1.0) float volume) {
        return this.delegate.setVolume(volume);
    }

    @Override
    public int getBufferedPercent() {
        return this.delegate.getBufferPercentage();
    }

    @Override
    @Nullable
    public WindowInfo getWindowInfo() {
        return this.delegate.getWindowInfo();
    }

    @Override
    public boolean restart() {
        return this.delegate.restart();
    }

    @Override
    public void stopPlayback(boolean clearSurface) {
        this.delegate.stopPlayback(clearSurface);
    }

    @Override
    public void release() {
    }

    @Override
    public boolean setPlaybackSpeed(float speed) {
        return this.delegate.setPlaybackSpeed(speed);
    }

    @Override
    public float getPlaybackSpeed() {
        return this.delegate.getPlaybackSpeed();
    }

    @Override
    public boolean trackSelectionAvailable() {
        return false;
    }

    @Override
    public void setTrack(@NonNull ExoMedia.RendererType trackType, int trackIndex) {
    }

    @Override
    public void setTrack(@NonNull ExoMedia.RendererType type, int groupIndex, int trackIndex) {
    }

    @Override
    @Nullable
    public Map<ExoMedia.RendererType, TrackGroupArray> getAvailableTracks() {
        return null;
    }

    @Override
    public void setRendererEnabled(@NonNull ExoMedia.RendererType type, boolean enabled) {
    }

    @Override
    public void setListenerMux(ListenerMux listenerMux) {
        this.delegate.setListenerMux(listenerMux);
    }

    @Override
    public void onVideoSizeChanged(int width, int height, float pixelWidthHeightRatio) {
        if (this.updateVideoSize((int)((float)width * pixelWidthHeightRatio), height)) {
            this.requestLayout();
        }
    }

    @Override
    public void setRepeatMode(int repeatMode) {
    }

    @Override
    public void suspend() {
        this.delegate.suspend();
    }

    public void setVideoURI(Uri uri) {
        this.setVideoURI(uri, null);
    }

    public void setVideoURI(Uri uri, @Nullable Map<String, String> headers) {
        this.delegate.setVideoURI(uri, headers);
        this.requestLayout();
        this.invalidate();
    }

    public void setOnPreparedListener(@Nullable MediaPlayer.OnPreparedListener listener) {
        this.delegate.setOnPreparedListener(listener);
    }

    public void setOnCompletionListener(@Nullable MediaPlayer.OnCompletionListener listener) {
        this.delegate.setOnCompletionListener(listener);
    }

    public void setOnBufferingUpdateListener(@Nullable MediaPlayer.OnBufferingUpdateListener listener) {
        this.delegate.setOnBufferingUpdateListener(listener);
    }

    public void setOnSeekCompleteListener(@Nullable MediaPlayer.OnSeekCompleteListener listener) {
        this.delegate.setOnSeekCompleteListener(listener);
    }

    public void setOnErrorListener(@Nullable MediaPlayer.OnErrorListener listener) {
        this.delegate.setOnErrorListener(listener);
    }

    public void setOnInfoListener(@Nullable MediaPlayer.OnInfoListener listener) {
        this.delegate.setOnInfoListener(listener);
    }

    protected void setup(@NonNull Context context, @Nullable AttributeSet attrs) {
        this.delegate = new NativeVideoDelegate(context, this, this);
        this.getHolder().addCallback((SurfaceHolder.Callback)new HolderCallback());
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.updateVideoSize(0, 0);
    }

    protected class HolderCallback
    implements SurfaceHolder.Callback {
        protected HolderCallback() {
        }

        public void surfaceCreated(SurfaceHolder holder) {
            NativeSurfaceVideoView.this.delegate.onSurfaceReady(holder.getSurface());
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            NativeSurfaceVideoView.this.delegate.onSurfaceSizeChanged(width, height);
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            holder.getSurface().release();
            NativeSurfaceVideoView.this.suspend();
        }
    }
}

