/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.audio;

import android.content.Context;
import android.media.MediaPlayer;
import android.media.PlaybackParams;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.devbrackets.android.exomedia.ExoMedia;
import com.devbrackets.android.exomedia.core.ListenerMux;
import com.devbrackets.android.exomedia.core.api.AudioPlayerApi;
import com.devbrackets.android.exomedia.core.exoplayer.WindowInfo;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import java.util.Map;

public class NativeAudioPlayer
implements AudioPlayerApi {
    private static final String TAG = "NativeMediaPlayer";
    @NonNull
    protected final Context context;
    @NonNull
    protected final MediaPlayer mediaPlayer;
    @NonNull
    protected InternalListeners internalListeners = new InternalListeners();
    protected ListenerMux listenerMux;
    protected long requestedSeek;
    protected int currentBufferPercent = 0;
    @FloatRange(from=0.0, to=1.0)
    protected float volumeLeft = 1.0f;
    @FloatRange(from=0.0, to=1.0)
    protected float volumeRight = 1.0f;

    public NativeAudioPlayer(@NonNull Context context) {
        this.context = context;
        this.mediaPlayer = new MediaPlayer();
        this.mediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this.internalListeners);
    }

    @Override
    public void setDataSource(@Nullable Uri uri) {
        this.setDataSource(uri, null);
    }

    @Override
    public void setDataSource(@Nullable Uri uri, @Nullable MediaSource mediaSource) {
        try {
            this.requestedSeek = 0L;
            this.mediaPlayer.setDataSource(this.context, uri);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"MediaPlayer: error setting data source", (Throwable)e);
        }
    }

    @Override
    public void setDrmCallback(@Nullable MediaDrmCallback drmCallback) {
    }

    @Override
    public void prepareAsync() {
        try {
            this.mediaPlayer.prepareAsync();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void reset() {
        this.mediaPlayer.reset();
    }

    @Override
    public float getVolumeLeft() {
        return this.volumeLeft;
    }

    @Override
    public float getVolumeRight() {
        return this.volumeRight;
    }

    @Override
    public void setVolume(@FloatRange(from=0.0, to=1.0) float left, @FloatRange(from=0.0, to=1.0) float right) {
        this.volumeLeft = left;
        this.volumeRight = right;
        this.mediaPlayer.setVolume(left, right);
    }

    @Override
    public void seekTo(@IntRange(from=0L) long milliseconds) {
        if (this.listenerMux != null && this.listenerMux.isPrepared()) {
            this.mediaPlayer.seekTo((int)milliseconds);
            this.requestedSeek = 0L;
        } else {
            this.requestedSeek = milliseconds;
        }
    }

    @Override
    public boolean isPlaying() {
        return this.mediaPlayer.isPlaying();
    }

    @Override
    public void start() {
        this.mediaPlayer.start();
        if (this.listenerMux != null) {
            this.listenerMux.setNotifiedCompleted(false);
        }
    }

    @Override
    public void pause() {
        this.mediaPlayer.pause();
    }

    @Override
    public void stopPlayback() {
        this.mediaPlayer.stop();
    }

    @Override
    public boolean restart() {
        if (this.listenerMux == null || !this.listenerMux.isPrepared()) {
            return false;
        }
        this.mediaPlayer.seekTo(0);
        this.mediaPlayer.start();
        this.listenerMux.setNotifiedCompleted(false);
        return true;
    }

    @Override
    public long getDuration() {
        if (this.listenerMux == null || !this.listenerMux.isPrepared()) {
            return 0L;
        }
        return this.mediaPlayer.getDuration();
    }

    @Override
    public long getCurrentPosition() {
        if (this.listenerMux == null || !this.listenerMux.isPrepared()) {
            return 0L;
        }
        return this.mediaPlayer.getCurrentPosition();
    }

    @Override
    public int getBufferedPercent() {
        return this.currentBufferPercent;
    }

    @Override
    @Nullable
    public WindowInfo getWindowInfo() {
        return null;
    }

    @Override
    public void release() {
        this.mediaPlayer.release();
    }

    @Override
    public int getAudioSessionId() {
        return this.mediaPlayer.getAudioSessionId();
    }

    @Override
    public boolean setPlaybackSpeed(float speed) {
        if (Build.VERSION.SDK_INT >= 23) {
            PlaybackParams params = new PlaybackParams();
            params.setSpeed(speed);
            this.mediaPlayer.setPlaybackParams(params);
            return true;
        }
        return false;
    }

    @Override
    public float getPlaybackSpeed() {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.mediaPlayer.getPlaybackParams().getSpeed();
        }
        return 1.0f;
    }

    @Override
    public void setAudioStreamType(int streamType) {
        this.mediaPlayer.setAudioStreamType(streamType);
    }

    @Override
    public void setWakeMode(@NonNull Context context, int mode) {
        this.mediaPlayer.setWakeMode(context, mode);
    }

    @Override
    public boolean trackSelectionAvailable() {
        return false;
    }

    @Override
    public void setTrack(@NonNull ExoMedia.RendererType trackType, int trackIndex) {
    }

    @Override
    @Nullable
    public Map<ExoMedia.RendererType, TrackGroupArray> getAvailableTracks() {
        return null;
    }

    @Override
    public void setListenerMux(ListenerMux listenerMux) {
        this.listenerMux = listenerMux;
        this.mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)listenerMux);
        this.mediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)listenerMux);
        this.mediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)listenerMux);
        this.mediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)listenerMux);
        this.mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)listenerMux);
    }

    @Override
    public void onMediaPrepared() {
        if (this.requestedSeek != 0L) {
            this.seekTo(this.requestedSeek);
        }
    }

    @Override
    public void setRepeatMode(int repeatMode) {
    }

    protected class InternalListeners
    implements MediaPlayer.OnBufferingUpdateListener {
        protected InternalListeners() {
        }

        public void onBufferingUpdate(MediaPlayer mediaPlayer, int percent) {
            NativeAudioPlayer.this.listenerMux.onBufferingUpdate(percent);
            NativeAudioPlayer.this.currentBufferPercent = percent;
        }
    }
}

