/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.Nullable;

public class StopWatch {
    protected static final String HANDLER_THREAD_NAME = "ExoMedia_StopWatch_HandlerThread";
    protected static final int DEFAULT_TICK_DELAY = 33;
    protected volatile boolean isRunning = false;
    protected int tickDelay = 33;
    protected Handler delayedHandler;
    protected HandlerThread handlerThread;
    protected boolean useHandlerThread = false;
    protected TickListener listener;
    protected TickRunnable tickRunnable = new TickRunnable();
    protected long startTime = 0L;
    protected long currentTime = 0L;
    protected long storedTime = 0L;

    public StopWatch() {
        this(true);
    }

    public StopWatch(boolean processOnStartingThread) {
        if (processOnStartingThread) {
            this.delayedHandler = new Handler();
            return;
        }
        this.useHandlerThread = true;
    }

    public StopWatch(Handler handler) {
        this.delayedHandler = handler;
    }

    public void setTickDelay(int milliSeconds) {
        this.tickDelay = milliSeconds;
    }

    public int getTickDelay() {
        return this.tickDelay;
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.isRunning = true;
        this.startTime = System.currentTimeMillis();
        if (this.useHandlerThread) {
            this.handlerThread = new HandlerThread(HANDLER_THREAD_NAME);
            this.handlerThread.start();
            this.delayedHandler = new Handler(this.handlerThread.getLooper());
        }
        this.tickRunnable.performTick();
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.delayedHandler.removeCallbacksAndMessages(null);
        if (this.handlerThread != null) {
            this.handlerThread.quit();
        }
        this.isRunning = false;
        this.currentTime = 0L;
        this.storedTime += System.currentTimeMillis() - this.startTime;
    }

    public void reset() {
        this.currentTime = 0L;
        this.storedTime = 0L;
        this.startTime = System.currentTimeMillis();
    }

    public void overrideCurrentTime(long time) {
        this.startTime = System.currentTimeMillis();
        this.currentTime = 0L;
        this.storedTime = time;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public long getTime() {
        return this.currentTime + this.storedTime;
    }

    public int getTimeInt() {
        long time = this.currentTime + this.storedTime;
        return time < Integer.MAX_VALUE ? (int)time : Integer.MAX_VALUE;
    }

    public void setTickListener(@Nullable TickListener listener) {
        this.listener = listener;
    }

    protected class TickRunnable
    implements Runnable {
        protected TickRunnable() {
        }

        @Override
        public void run() {
            StopWatch.this.currentTime = System.currentTimeMillis() - StopWatch.this.startTime;
            if (StopWatch.this.isRunning) {
                this.performTick();
            }
            if (StopWatch.this.listener != null) {
                StopWatch.this.listener.onStopWatchTick(StopWatch.this.currentTime + StopWatch.this.storedTime);
            }
        }

        public void performTick() {
            StopWatch.this.delayedHandler.postDelayed((Runnable)StopWatch.this.tickRunnable, (long)StopWatch.this.tickDelay);
        }
    }

    public static interface TickListener {
        public void onStopWatchTick(long var1);
    }
}

