/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.devbrackets.android.exomedia.core.source.MediaSourceProvider;
import com.devbrackets.android.exomedia.core.source.builder.DashMediaSourceBuilder;
import com.devbrackets.android.exomedia.core.source.builder.HlsMediaSourceBuilder;
import com.devbrackets.android.exomedia.core.source.builder.SsMediaSourceBuilder;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.TransferListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ExoMedia {
    public static void registerRenderer(@NonNull RendererType type, @NonNull Class<? extends Renderer> clazz) {
        Data.registeredRendererClasses.get((Object)type).add(clazz.getName());
    }

    public static void registerMediaSourceBuilder(@NonNull MediaSourceProvider.SourceTypeBuilder builder) {
        Data.sourceTypeBuilders.add(0, builder);
    }

    @Deprecated
    public static void setHttpDataSourceFactoryProvider(@Nullable HttpDataSourceFactoryProvider provider) {
        Data.httpDataSourceFactoryProvider = provider;
    }

    public static void setDataSourceFactoryProvider(@Nullable DataSourceFactoryProvider provider) {
        Data.dataSourceFactoryProvider = provider;
    }

    public static void setLoadControl(@Nullable LoadControl loadControl) {
        Data.loadControl = loadControl;
    }

    public static class Data {
        @NonNull
        public static final Map<RendererType, List<String>> registeredRendererClasses = new HashMap<RendererType, List<String>>();
        @NonNull
        public static final List<MediaSourceProvider.SourceTypeBuilder> sourceTypeBuilders = new ArrayList<MediaSourceProvider.SourceTypeBuilder>();
        @Deprecated
        @Nullable
        public static volatile HttpDataSourceFactoryProvider httpDataSourceFactoryProvider;
        @Nullable
        public static volatile DataSourceFactoryProvider dataSourceFactoryProvider;
        @Nullable
        public static volatile LoadControl loadControl;

        private static void instantiateRendererClasses() {
            registeredRendererClasses.put(RendererType.AUDIO, new LinkedList());
            registeredRendererClasses.put(RendererType.VIDEO, new LinkedList());
            registeredRendererClasses.put(RendererType.CLOSED_CAPTION, new LinkedList());
            registeredRendererClasses.put(RendererType.METADATA, new LinkedList());
            List<String> audioClasses = registeredRendererClasses.get((Object)RendererType.AUDIO);
            audioClasses.add("com.google.android.exoplayer2.ext.opus.LibopusAudioRenderer");
            audioClasses.add("com.google.android.exoplayer2.ext.flac.LibflacAudioRenderer");
            audioClasses.add("com.google.android.exoplayer2.ext.ffmpeg.FfmpegAudioRenderer");
            List<String> videoClasses = registeredRendererClasses.get((Object)RendererType.VIDEO);
            videoClasses.add("com.google.android.exoplayer2.ext.vp9.LibvpxVideoRenderer");
        }

        private static void instantiateSourceProviders() {
            sourceTypeBuilders.add(new MediaSourceProvider.SourceTypeBuilder(new HlsMediaSourceBuilder(), ".m3u8", ".*m3u8.*"));
            sourceTypeBuilders.add(new MediaSourceProvider.SourceTypeBuilder(new DashMediaSourceBuilder(), ".mpd", ".*mpd.*"));
            sourceTypeBuilders.add(new MediaSourceProvider.SourceTypeBuilder(new SsMediaSourceBuilder(), ".ism", ".*ism.*"));
        }

        static {
            Data.instantiateRendererClasses();
            Data.instantiateSourceProviders();
        }
    }

    public static enum RendererType {
        AUDIO,
        VIDEO,
        CLOSED_CAPTION,
        METADATA;

    }

    public static interface DataSourceFactoryProvider {
        @NonNull
        public DataSource.Factory provide(@NonNull String var1, @Nullable TransferListener<? super DataSource> var2);
    }

    @Deprecated
    public static interface HttpDataSourceFactoryProvider {
        @NonNull
        public HttpDataSource.BaseFactory provide(@NonNull String var1, @Nullable TransferListener<? super DataSource> var2);
    }
}

