/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.ui.animation;

import android.support.v4.view.animation.FastOutLinearInInterpolator;
import android.support.v4.view.animation.LinearOutSlowInInterpolator;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;

public class BottomViewHideShowAnimation
extends AnimationSet {
    private View animationView;
    private boolean toVisible;

    public BottomViewHideShowAnimation(View view, boolean toVisible, long duration) {
        super(false);
        this.toVisible = toVisible;
        this.animationView = view;
        float startAlpha = toVisible ? 0.0f : 1.0f;
        float endAlpha = toVisible ? 1.0f : 0.0f;
        AlphaAnimation alphaAnimation = new AlphaAnimation(startAlpha, endAlpha);
        alphaAnimation.setDuration(duration);
        int startY = toVisible ? this.getHideShowDelta(view) : 0;
        int endY = toVisible ? 0 : this.getHideShowDelta(view);
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 0.0f, (float)startY, (float)endY);
        translateAnimation.setInterpolator((Interpolator)(toVisible ? new LinearOutSlowInInterpolator() : new FastOutLinearInInterpolator()));
        translateAnimation.setDuration(duration);
        this.addAnimation((Animation)alphaAnimation);
        this.addAnimation((Animation)translateAnimation);
        this.setAnimationListener(new Listener());
    }

    private int getHideShowDelta(View view) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Display display = ((WindowManager)view.getContext().getSystemService("window")).getDefaultDisplay();
        display.getMetrics(displayMetrics);
        int screenHeight = displayMetrics.heightPixels;
        return screenHeight - view.getTop();
    }

    private class Listener
    implements Animation.AnimationListener {
        private Listener() {
        }

        public void onAnimationStart(Animation animation) {
            BottomViewHideShowAnimation.this.animationView.setVisibility(0);
        }

        public void onAnimationEnd(Animation animation) {
            BottomViewHideShowAnimation.this.animationView.setVisibility(BottomViewHideShowAnimation.this.toVisible ? 0 : 8);
        }

        public void onAnimationRepeat(Animation animation) {
        }
    }
}

