/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.builder;

import android.annotation.TargetApi;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.devbrackets.android.exomedia.core.builder.RenderBuilder;
import com.devbrackets.android.exomedia.core.exoplayer.EMExoPlayer;
import com.devbrackets.android.exomedia.core.renderer.EMMediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.DefaultLoadControl;
import com.google.android.exoplayer.LoadControl;
import com.google.android.exoplayer.MediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.MediaCodecSelector;
import com.google.android.exoplayer.MediaCodecVideoTrackRenderer;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.drm.MediaDrmCallback;
import com.google.android.exoplayer.hls.DefaultHlsTrackSelector;
import com.google.android.exoplayer.hls.HlsChunkSource;
import com.google.android.exoplayer.hls.HlsMasterPlaylist;
import com.google.android.exoplayer.hls.HlsPlaylist;
import com.google.android.exoplayer.hls.HlsPlaylistParser;
import com.google.android.exoplayer.hls.HlsSampleSource;
import com.google.android.exoplayer.hls.HlsTrackSelector;
import com.google.android.exoplayer.hls.PtsTimestampAdjusterProvider;
import com.google.android.exoplayer.metadata.MetadataParser;
import com.google.android.exoplayer.metadata.MetadataTrackRenderer;
import com.google.android.exoplayer.metadata.id3.Id3Parser;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.TextRenderer;
import com.google.android.exoplayer.text.TextTrackRenderer;
import com.google.android.exoplayer.text.eia608.Eia608TrackRenderer;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.upstream.BandwidthMeter;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DefaultAllocator;
import com.google.android.exoplayer.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer.upstream.DefaultUriDataSource;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.upstream.UriDataSource;
import com.google.android.exoplayer.upstream.UriLoadable;
import com.google.android.exoplayer.util.ManifestFetcher;
import java.io.IOException;

@TargetApi(value=16)
public class HlsRenderBuilder
extends RenderBuilder {
    public HlsRenderBuilder(@NonNull Context context, @NonNull String userAgent, @NonNull String uri) {
        super(context, userAgent, uri);
    }

    public HlsRenderBuilder(@NonNull Context context, @NonNull String userAgent, @NonNull String uri, int streamType) {
        super(context, userAgent, uri, streamType);
    }

    public HlsRenderBuilder(@NonNull Context context, @NonNull String userAgent, @NonNull String uri, @Nullable MediaDrmCallback drmCallback, int streamType) {
        super(context, userAgent, uri, drmCallback, streamType);
    }

    @Override
    protected RenderBuilder.AsyncBuilder createAsyncBuilder(EMExoPlayer player) {
        return new AsyncHlsBuilder(this.context, this.userAgent, this.uri, this.drmCallback, player, this.streamType);
    }

    protected UriDataSource createManifestDataSource(Context context, String userAgent) {
        return new DefaultUriDataSource(context, userAgent);
    }

    protected class AsyncHlsBuilder
    extends RenderBuilder.AsyncBuilder
    implements ManifestFetcher.ManifestCallback<HlsPlaylist> {
        protected final ManifestFetcher<HlsPlaylist> playlistFetcher;

        public AsyncHlsBuilder(Context context, String userAgent, @Nullable String url, MediaDrmCallback drmCallback, EMExoPlayer player, int streamType) {
            super(context, userAgent, url, drmCallback, player, streamType);
            HlsPlaylistParser parser = new HlsPlaylistParser();
            this.playlistFetcher = new ManifestFetcher(url, HlsRenderBuilder.this.createManifestDataSource(context, userAgent), (UriLoadable.Parser)parser);
        }

        @Override
        public void init() {
            this.playlistFetcher.singleLoad(this.player.getMainHandler().getLooper(), (ManifestFetcher.ManifestCallback)this);
        }

        public void onSingleManifestError(IOException e) {
            if (this.canceled) {
                return;
            }
            this.player.onRenderersError(e);
        }

        public void onSingleManifest(HlsPlaylist playlist) {
            if (this.canceled) {
                return;
            }
            this.buildRenderers(playlist);
        }

        protected void buildRenderers(HlsPlaylist playlist) {
            if (this.canceled) {
                return;
            }
            boolean hasClosedCaptions = false;
            boolean hasMultipleAudioTracks = false;
            if (playlist instanceof HlsMasterPlaylist) {
                HlsMasterPlaylist masterPlaylist = (HlsMasterPlaylist)playlist;
                hasClosedCaptions = !masterPlaylist.subtitles.isEmpty();
                hasMultipleAudioTracks = !masterPlaylist.audios.isEmpty();
            }
            this.buildTrackRenderers(playlist, hasClosedCaptions, hasMultipleAudioTracks);
        }

        protected void buildTrackRenderers(HlsPlaylist playlist, boolean hasClosedCaptions, boolean hasMultipleAudioTracks) {
            SampleSource[] sampleSourceArray;
            DefaultLoadControl loadControl = new DefaultLoadControl((Allocator)new DefaultAllocator(65536));
            DefaultBandwidthMeter bandwidthMeter = new DefaultBandwidthMeter(this.player.getMainHandler(), (BandwidthMeter.EventListener)this.player);
            PtsTimestampAdjusterProvider timestampAdjusterProvider = new PtsTimestampAdjusterProvider();
            DataSource dataSourceVideo = HlsRenderBuilder.this.createDataSource(this.context, (TransferListener)bandwidthMeter, this.userAgent);
            HlsChunkSource chunkSourceVideo = new HlsChunkSource(true, dataSourceVideo, playlist, (HlsTrackSelector)DefaultHlsTrackSelector.newDefaultInstance((Context)this.context), (BandwidthMeter)bandwidthMeter, timestampAdjusterProvider);
            HlsSampleSource sampleSourceVideo = new HlsSampleSource(chunkSourceVideo, (LoadControl)loadControl, 0x1000000, this.player.getMainHandler(), (HlsSampleSource.EventListener)this.player, 0);
            DefaultUriDataSource dataSourceAudio = new DefaultUriDataSource(this.context, (TransferListener)bandwidthMeter, this.userAgent);
            HlsChunkSource chunkSourceAudio = new HlsChunkSource(false, (DataSource)dataSourceAudio, playlist, (HlsTrackSelector)DefaultHlsTrackSelector.newAudioInstance(), (BandwidthMeter)bandwidthMeter, timestampAdjusterProvider);
            HlsSampleSource sampleSourceAudio = new HlsSampleSource(chunkSourceAudio, (LoadControl)loadControl, 0x360000, this.player.getMainHandler(), (HlsSampleSource.EventListener)this.player, 1);
            if (hasMultipleAudioTracks) {
                SampleSource[] sampleSourceArray2 = new SampleSource[2];
                sampleSourceArray2[0] = sampleSourceVideo;
                sampleSourceArray = sampleSourceArray2;
                sampleSourceArray2[1] = sampleSourceAudio;
            } else {
                SampleSource[] sampleSourceArray3 = new SampleSource[1];
                sampleSourceArray = sampleSourceArray3;
                sampleSourceArray3[0] = sampleSourceVideo;
            }
            SampleSource[] sampleSourcesAudio = sampleSourceArray;
            DataSource dataSourceCC = HlsRenderBuilder.this.createDataSource(this.context, (TransferListener)bandwidthMeter, this.userAgent);
            HlsChunkSource chunkSourceCC = new HlsChunkSource(false, dataSourceCC, playlist, (HlsTrackSelector)DefaultHlsTrackSelector.newSubtitleInstance(), (BandwidthMeter)bandwidthMeter, timestampAdjusterProvider);
            HlsSampleSource sampleSourceCC = new HlsSampleSource(chunkSourceCC, (LoadControl)loadControl, 131072, this.player.getMainHandler(), (HlsSampleSource.EventListener)this.player, 2);
            MediaCodecVideoTrackRenderer videoRenderer = new MediaCodecVideoTrackRenderer(this.context, (SampleSource)sampleSourceVideo, MediaCodecSelector.DEFAULT, 1, 5000L, this.player.getMainHandler(), (MediaCodecVideoTrackRenderer.EventListener)this.player, 50);
            EMMediaCodecAudioTrackRenderer audioRenderer = new EMMediaCodecAudioTrackRenderer(sampleSourcesAudio, MediaCodecSelector.DEFAULT, null, true, this.player.getMainHandler(), (MediaCodecAudioTrackRenderer.EventListener)this.player, AudioCapabilities.getCapabilities((Context)this.context), this.streamType);
            TextTrackRenderer captionsRenderer = hasClosedCaptions ? new TextTrackRenderer((SampleSource)sampleSourceCC, (TextRenderer)this.player, this.player.getMainHandler().getLooper(), new SubtitleParser[0]) : new Eia608TrackRenderer((SampleSource)sampleSourceVideo, (TextRenderer)this.player, this.player.getMainHandler().getLooper());
            MetadataTrackRenderer id3Renderer = new MetadataTrackRenderer((SampleSource)sampleSourceVideo, (MetadataParser)new Id3Parser(), (MetadataTrackRenderer.MetadataRenderer)this.player, this.player.getMainHandler().getLooper());
            TrackRenderer[] renderers = new TrackRenderer[]{videoRenderer, audioRenderer, captionsRenderer, id3Renderer};
            this.player.onRenderers(renderers, (BandwidthMeter)bandwidthMeter);
        }
    }
}

