/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.AnyRes;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.AppCompatDrawableManager;
import android.util.TypedValue;

public class ResourceUtil {
    public static Drawable tint(Context context, @DrawableRes int drawableRes, @ColorRes int colorRes) {
        Drawable drawable2 = ResourceUtil.getDrawable(context, drawableRes);
        drawable2 = drawable2.mutate();
        return ResourceUtil.tint(context, drawable2, colorRes);
    }

    public static Drawable tint(Context context, Drawable drawable2, @ColorRes int colorRes) {
        drawable2 = DrawableCompat.wrap((Drawable)drawable2);
        DrawableCompat.setTint((Drawable)drawable2, (int)ResourceUtil.getColor(context, colorRes));
        return drawable2;
    }

    public static Drawable tintList(Context context, @DrawableRes int drawableRes, @ColorRes int tintListRes) {
        Drawable drawable2 = ResourceUtil.getDrawable(context, drawableRes);
        drawable2 = drawable2.mutate();
        return ResourceUtil.tintList(context, drawable2, tintListRes);
    }

    public static Drawable tintList(Context context, Drawable drawable2, @ColorRes int tintListRes) {
        drawable2 = DrawableCompat.wrap((Drawable)drawable2);
        DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)ResourceUtil.getColorStateList(context, tintListRes));
        return drawable2;
    }

    public static Drawable getDrawable(Context context, @DrawableRes int drawableResourceId) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getResources().getDrawable(drawableResourceId, context.getTheme());
        }
        return AppCompatDrawableManager.get().getDrawable(context, drawableResourceId);
    }

    @AnyRes
    public static int getResolvedResourceId(Context context, @AttrRes int attr) {
        TypedValue typedValue = new TypedValue();
        Resources.Theme theme = context.getTheme();
        theme.resolveAttribute(attr, typedValue, true);
        if (typedValue.type == 1) {
            return typedValue.data;
        }
        return typedValue.resourceId;
    }

    @ColorInt
    public static int getColor(Context context, @ColorRes int colorRes) {
        if (Build.VERSION.SDK_INT >= 23) {
            return context.getResources().getColor(colorRes, context.getTheme());
        }
        return context.getResources().getColor(colorRes);
    }

    public static ColorStateList getColorStateList(Context context, @ColorRes int colorRes) {
        if (Build.VERSION.SDK_INT >= 23) {
            return context.getResources().getColorStateList(colorRes, context.getTheme());
        }
        return context.getResources().getColorStateList(colorRes);
    }
}

