/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.video.exo;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.Surface;
import com.devbrackets.android.exomedia.core.EMListenerMux;
import com.devbrackets.android.exomedia.core.builder.DashRenderBuilder;
import com.devbrackets.android.exomedia.core.builder.HlsRenderBuilder;
import com.devbrackets.android.exomedia.core.builder.RenderBuilder;
import com.devbrackets.android.exomedia.core.builder.SmoothStreamRenderBuilder;
import com.devbrackets.android.exomedia.core.exoplayer.EMExoPlayer;
import com.devbrackets.android.exomedia.core.listener.Id3MetadataListener;
import com.devbrackets.android.exomedia.core.video.ClearableSurface;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.devbrackets.android.exomedia.type.MediaSourceType;
import com.devbrackets.android.exomedia.util.DrmProvider;
import com.devbrackets.android.exomedia.util.MediaSourceUtil;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.audio.AudioCapabilitiesReceiver;
import com.google.android.exoplayer.metadata.id3.Id3Frame;
import java.util.List;
import java.util.Map;

public class ExoVideoDelegate
implements AudioCapabilitiesReceiver.Listener {
    protected static final String USER_AGENT_FORMAT = "EMVideoView %s / Android %s / %s";
    protected EMExoPlayer emExoPlayer;
    protected AudioCapabilities audioCapabilities;
    protected AudioCapabilitiesReceiver audioCapabilitiesReceiver;
    protected EMListenerMux listenerMux;
    protected boolean playRequested = false;
    protected Context context;
    protected ClearableSurface clearableSurface;
    @Nullable
    protected DrmProvider drmProvider;
    @NonNull
    protected InternalListeners internalListeners = new InternalListeners();

    public ExoVideoDelegate(@NonNull Context context, @NonNull ClearableSurface clearableSurface) {
        this.context = context.getApplicationContext();
        this.clearableSurface = clearableSurface;
        this.setup();
    }

    public void onAudioCapabilitiesChanged(AudioCapabilities audioCapabilities) {
        if (!audioCapabilities.equals((Object)this.audioCapabilities)) {
            this.audioCapabilities = audioCapabilities;
        }
    }

    public void setVideoUri(@Nullable Uri uri) {
        RenderBuilder builder = uri == null ? null : this.getRendererBuilder(MediaSourceUtil.getType(uri), uri);
        this.setVideoUri(uri, builder);
    }

    public void setVideoUri(@Nullable Uri uri, @Nullable RenderBuilder renderBuilder) {
        this.playRequested = false;
        if (uri == null) {
            this.emExoPlayer.replaceRenderBuilder(null);
        } else {
            this.emExoPlayer.replaceRenderBuilder(renderBuilder);
            this.listenerMux.setNotifiedCompleted(false);
        }
        this.listenerMux.setNotifiedPrepared(false);
        this.emExoPlayer.seekTo(0L);
    }

    public void setDrmProvider(@Nullable DrmProvider drmProvider) {
        this.drmProvider = drmProvider;
    }

    public boolean restart() {
        if (!this.emExoPlayer.restart()) {
            return false;
        }
        this.listenerMux.setNotifiedPrepared(false);
        this.listenerMux.setNotifiedCompleted(false);
        return true;
    }

    public boolean setVolume(@FloatRange(from=0.0, to=1.0) float volume) {
        this.emExoPlayer.setVolume(volume);
        return true;
    }

    public void seekTo(@IntRange(from=0L) int milliseconds) {
        this.emExoPlayer.seekTo(milliseconds);
    }

    public boolean isPlaying() {
        return this.emExoPlayer.getPlayWhenReady();
    }

    public void start() {
        this.emExoPlayer.setPlayWhenReady(true);
        this.listenerMux.setNotifiedCompleted(false);
        this.playRequested = true;
    }

    public void pause() {
        this.emExoPlayer.setPlayWhenReady(false);
        this.playRequested = false;
    }

    public void stopPlayback() {
        this.emExoPlayer.stop();
        this.playRequested = false;
        this.listenerMux.clearSurfaceWhenReady(this.clearableSurface);
    }

    public void suspend() {
        this.emExoPlayer.release();
        this.playRequested = false;
    }

    public int getDuration() {
        if (!this.listenerMux.isPrepared()) {
            return 0;
        }
        return (int)this.emExoPlayer.getDuration();
    }

    public int getCurrentPosition() {
        if (!this.listenerMux.isPrepared()) {
            return 0;
        }
        return (int)this.emExoPlayer.getCurrentPosition();
    }

    public int getBufferedPercent() {
        return this.emExoPlayer.getBufferedPercentage();
    }

    public boolean trackSelectionAvailable() {
        return true;
    }

    public void setTrack(int trackType, int trackIndex) {
        this.emExoPlayer.setSelectedTrack(trackType, trackIndex);
    }

    @Nullable
    public Map<Integer, List<MediaFormat>> getAvailableTracks() {
        return this.emExoPlayer.getAvailableTracks();
    }

    public void release() {
        this.emExoPlayer.release();
        if (this.audioCapabilitiesReceiver != null) {
            this.audioCapabilitiesReceiver.unregister();
            this.audioCapabilitiesReceiver = null;
        }
    }

    public void setListenerMux(EMListenerMux listenerMux) {
        this.listenerMux = listenerMux;
        this.emExoPlayer.addListener(listenerMux);
    }

    public void onSurfaceReady(Surface surface) {
        this.emExoPlayer.setSurface(surface);
        if (this.playRequested) {
            this.emExoPlayer.setPlayWhenReady(true);
        }
    }

    public void onSurfaceDestroyed() {
        this.emExoPlayer.blockingClearSurface();
    }

    @NonNull
    public String getUserAgent() {
        return String.format(USER_AGENT_FORMAT, "3.1.1 (31100)", Build.VERSION.RELEASE, Build.MODEL);
    }

    protected void setup() {
        this.initExoPlayer();
        this.audioCapabilitiesReceiver = new AudioCapabilitiesReceiver(this.context, (AudioCapabilitiesReceiver.Listener)this);
        this.audioCapabilitiesReceiver.register();
    }

    protected void initExoPlayer() {
        this.emExoPlayer = new EMExoPlayer(null);
        this.emExoPlayer.setMetadataListener(this.internalListeners);
        this.emExoPlayer.setBufferUpdateListener(this.internalListeners);
    }

    protected RenderBuilder getRendererBuilder(@NonNull MediaSourceType renderType, @NonNull Uri uri) {
        switch (renderType) {
            case HLS: {
                return new HlsRenderBuilder(this.context, this.getUserAgent(), uri.toString(), this.drmProvider == null ? null : this.drmProvider.getHlsCallback(), 3);
            }
            case DASH: {
                return new DashRenderBuilder(this.context, this.getUserAgent(), uri.toString(), this.drmProvider == null ? null : this.drmProvider.getDashCallback(), 3);
            }
            case SMOOTH_STREAM: {
                return new SmoothStreamRenderBuilder(this.context, this.getUserAgent(), uri.toString(), this.drmProvider == null ? null : this.drmProvider.getSmoothStreamCallback(), 3);
            }
        }
        return new RenderBuilder(this.context, this.getUserAgent(), uri.toString(), this.drmProvider == null ? null : this.drmProvider.getDefaultCallback(), 3);
    }

    protected class InternalListeners
    implements Id3MetadataListener,
    OnBufferUpdateListener {
        protected InternalListeners() {
        }

        @Override
        public void onId3Metadata(List<Id3Frame> metadata) {
            ExoVideoDelegate.this.listenerMux.onId3Metadata(metadata);
        }

        @Override
        public void onBufferingUpdate(@IntRange(from=0L, to=100L) int percent) {
            ExoVideoDelegate.this.listenerMux.onBufferingUpdate(percent);
        }
    }
}

