/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.builder;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.devbrackets.android.exomedia.core.builder.RenderBuilder;
import com.devbrackets.android.exomedia.core.exoplayer.EMExoPlayer;
import com.devbrackets.android.exomedia.core.renderer.EMMediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.DefaultLoadControl;
import com.google.android.exoplayer.LoadControl;
import com.google.android.exoplayer.MediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.MediaCodecSelector;
import com.google.android.exoplayer.MediaCodecVideoTrackRenderer;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.chunk.ChunkSampleSource;
import com.google.android.exoplayer.chunk.ChunkSource;
import com.google.android.exoplayer.chunk.FormatEvaluator;
import com.google.android.exoplayer.drm.DrmSessionManager;
import com.google.android.exoplayer.drm.MediaDrmCallback;
import com.google.android.exoplayer.drm.StreamingDrmSessionManager;
import com.google.android.exoplayer.drm.UnsupportedDrmException;
import com.google.android.exoplayer.smoothstreaming.DefaultSmoothStreamingTrackSelector;
import com.google.android.exoplayer.smoothstreaming.SmoothStreamingChunkSource;
import com.google.android.exoplayer.smoothstreaming.SmoothStreamingManifest;
import com.google.android.exoplayer.smoothstreaming.SmoothStreamingManifestParser;
import com.google.android.exoplayer.smoothstreaming.SmoothStreamingTrackSelector;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.TextRenderer;
import com.google.android.exoplayer.text.TextTrackRenderer;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.upstream.BandwidthMeter;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DefaultAllocator;
import com.google.android.exoplayer.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer.upstream.DefaultHttpDataSource;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.upstream.UriDataSource;
import com.google.android.exoplayer.upstream.UriLoadable;
import com.google.android.exoplayer.util.ManifestFetcher;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.util.UUID;

@TargetApi(value=16)
public class SmoothStreamRenderBuilder
extends RenderBuilder {
    protected static final int LIVE_EDGE_LATENCY_MS = 30000;

    public SmoothStreamRenderBuilder(@NonNull Context context, @NonNull String userAgent, @NonNull String uri) {
        super(context, userAgent, uri);
    }

    public SmoothStreamRenderBuilder(@NonNull Context context, @NonNull String userAgent, @NonNull String uri, int streamType) {
        super(context, userAgent, uri, streamType);
    }

    public SmoothStreamRenderBuilder(@NonNull Context context, @NonNull String userAgent, @NonNull String uri, @Nullable MediaDrmCallback drmCallback, int streamType) {
        super(context, userAgent, uri, drmCallback, streamType);
    }

    @Override
    protected RenderBuilder.AsyncBuilder createAsyncBuilder(EMExoPlayer player) {
        return new AsyncSmoothStreamBuilder(this.context, this.userAgent, this.uri, this.drmCallback, player, this.streamType);
    }

    protected UriDataSource createManifestDataSource(Context context, String userAgent) {
        return new DefaultHttpDataSource(userAgent, null);
    }

    protected static String getManifestUri(String url) {
        return Util.toLowerInvariant((String)url).endsWith("/manifest") ? url : url + "/Manifest";
    }

    protected class AsyncSmoothStreamBuilder
    extends RenderBuilder.AsyncBuilder
    implements ManifestFetcher.ManifestCallback<SmoothStreamingManifest> {
        protected final ManifestFetcher<SmoothStreamingManifest> manifestFetcher;

        public AsyncSmoothStreamBuilder(Context context, String userAgent, @Nullable String url, MediaDrmCallback drmCallback, EMExoPlayer player, int streamType) {
            super(context, userAgent, url, drmCallback, player, streamType);
            SmoothStreamingManifestParser parser = new SmoothStreamingManifestParser();
            this.manifestFetcher = new ManifestFetcher(url, SmoothStreamRenderBuilder.this.createManifestDataSource(null, userAgent), (UriLoadable.Parser)parser);
        }

        @Override
        public void init() {
            this.manifestFetcher.singleLoad(this.player.getMainHandler().getLooper(), (ManifestFetcher.ManifestCallback)this);
        }

        public void onSingleManifestError(IOException exception) {
            if (this.canceled) {
                return;
            }
            this.player.onRenderersError(exception);
        }

        public void onSingleManifest(SmoothStreamingManifest manifest) {
            this.buildRenderers(manifest);
        }

        protected void buildRenderers(SmoothStreamingManifest manifest) {
            if (this.canceled) {
                return;
            }
            StreamingDrmSessionManager drmSessionManager = null;
            if (manifest.protectionElement != null) {
                if (Build.VERSION.SDK_INT < 18) {
                    this.player.onRenderersError((Exception)((Object)new UnsupportedDrmException(1)));
                    return;
                }
                try {
                    drmSessionManager = StreamingDrmSessionManager.newFrameworkInstance((UUID)manifest.protectionElement.uuid, (Looper)this.player.getPlaybackLooper(), (MediaDrmCallback)this.drmCallback, null, (Handler)this.player.getMainHandler(), (StreamingDrmSessionManager.EventListener)this.player);
                }
                catch (UnsupportedDrmException e) {
                    this.player.onRenderersError((Exception)((Object)e));
                    return;
                }
            }
            this.buildTrackRenderers((DrmSessionManager)drmSessionManager);
        }

        protected void buildTrackRenderers(DrmSessionManager drmSessionManager) {
            Handler mainHandler = this.player.getMainHandler();
            DefaultLoadControl loadControl = new DefaultLoadControl((Allocator)new DefaultAllocator(65536));
            DefaultBandwidthMeter bandwidthMeter = new DefaultBandwidthMeter(mainHandler, (BandwidthMeter.EventListener)this.player);
            DataSource dataSourceVideo = SmoothStreamRenderBuilder.this.createDataSource(this.context, (TransferListener)bandwidthMeter, this.userAgent);
            DefaultSmoothStreamingTrackSelector trackSelectorVideo = DefaultSmoothStreamingTrackSelector.newVideoInstance((Context)this.context, (boolean)true, (boolean)false);
            SmoothStreamingChunkSource chunkSourceVideo = new SmoothStreamingChunkSource(this.manifestFetcher, (SmoothStreamingTrackSelector)trackSelectorVideo, dataSourceVideo, (FormatEvaluator)new FormatEvaluator.AdaptiveEvaluator((BandwidthMeter)bandwidthMeter), 30000L);
            ChunkSampleSource sampleSourceVideo = new ChunkSampleSource((ChunkSource)chunkSourceVideo, (LoadControl)loadControl, 0xC80000, mainHandler, (ChunkSampleSource.EventListener)this.player, 0);
            DataSource dataSourceAudio = SmoothStreamRenderBuilder.this.createDataSource(this.context, (TransferListener)bandwidthMeter, this.userAgent);
            DefaultSmoothStreamingTrackSelector trackSelectorAudio = DefaultSmoothStreamingTrackSelector.newAudioInstance();
            SmoothStreamingChunkSource chunkSourceAudio = new SmoothStreamingChunkSource(this.manifestFetcher, (SmoothStreamingTrackSelector)trackSelectorAudio, dataSourceAudio, null, 30000L);
            ChunkSampleSource sampleSourceAudio = new ChunkSampleSource((ChunkSource)chunkSourceAudio, (LoadControl)loadControl, 0x360000, mainHandler, (ChunkSampleSource.EventListener)this.player, 1);
            DataSource dataSourceCC = SmoothStreamRenderBuilder.this.createDataSource(this.context, (TransferListener)bandwidthMeter, this.userAgent);
            DefaultSmoothStreamingTrackSelector trackSelectorCC = DefaultSmoothStreamingTrackSelector.newTextInstance();
            SmoothStreamingChunkSource chunkSourceCC = new SmoothStreamingChunkSource(this.manifestFetcher, (SmoothStreamingTrackSelector)trackSelectorCC, dataSourceCC, null, 30000L);
            ChunkSampleSource sampleSourceCC = new ChunkSampleSource((ChunkSource)chunkSourceCC, (LoadControl)loadControl, 131072, mainHandler, (ChunkSampleSource.EventListener)this.player, 2);
            MediaCodecVideoTrackRenderer videoRenderer = new MediaCodecVideoTrackRenderer(this.context, (SampleSource)sampleSourceVideo, MediaCodecSelector.DEFAULT, 1, 5000L, drmSessionManager, true, mainHandler, (MediaCodecVideoTrackRenderer.EventListener)this.player, 50);
            EMMediaCodecAudioTrackRenderer audioRenderer = new EMMediaCodecAudioTrackRenderer((SampleSource)sampleSourceAudio, MediaCodecSelector.DEFAULT, drmSessionManager, true, mainHandler, (MediaCodecAudioTrackRenderer.EventListener)this.player, AudioCapabilities.getCapabilities((Context)this.context), this.streamType);
            TextTrackRenderer captionsRenderer = new TextTrackRenderer((SampleSource)sampleSourceCC, (TextRenderer)this.player, mainHandler.getLooper(), new SubtitleParser[0]);
            TrackRenderer[] renderers = new TrackRenderer[4];
            renderers[0] = videoRenderer;
            renderers[1] = audioRenderer;
            renderers[2] = captionsRenderer;
            this.player.onRenderers(renderers, (BandwidthMeter)bandwidthMeter);
        }
    }
}

