/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.os.Build;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewTreeObserver;
import com.devbrackets.android.exomedia.core.video.ClearableSurface;
import com.devbrackets.android.exomedia.core.video.scale.MatrixManager;
import com.devbrackets.android.exomedia.core.video.scale.ScaleType;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class ResizingSurfaceView
extends SurfaceView
implements ClearableSurface {
    private static final String TAG = "ResizingSurfaceView";
    protected static final int MAX_DEGREES = 360;
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static final int[] GL_CLEAR_CONFIG_ATTRIBUTES = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, 4, 12344, 0, 12344};
    private static final int[] GL_CLEAR_CONTEXT_ATTRIBUTES = new int[]{12440, 2, 12344};
    @Nullable
    protected OnSizeChangeListener onSizeChangeListener;
    @NonNull
    protected Point lastNotifiedSize = new Point(0, 0);
    @NonNull
    protected Point videoSize = new Point(0, 0);
    @NonNull
    protected MatrixManager matrixManager = new MatrixManager();
    @NonNull
    protected AttachedListener attachedListener = new AttachedListener();
    @NonNull
    protected GlobalLayoutMatrixListener globalLayoutMatrixListener = new GlobalLayoutMatrixListener();
    @NonNull
    protected final ReentrantLock globalLayoutMatrixListenerLock = new ReentrantLock(true);
    @IntRange(from=0L, to=359L)
    protected int requestedUserRotation = 0;
    @IntRange(from=0L, to=359L)
    protected int requestedConfigurationRotation = 0;
    protected boolean measureBasedOnAspectRatio = true;

    public ResizingSurfaceView(Context context) {
        super(context);
    }

    public ResizingSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ResizingSurfaceView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public ResizingSurfaceView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (!this.measureBasedOnAspectRatio) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            this.notifyOnSizeChangeListener(this.getMeasuredWidth(), this.getMeasuredHeight());
            return;
        }
        int width = ResizingSurfaceView.getDefaultSize((int)this.videoSize.x, (int)widthMeasureSpec);
        int height = ResizingSurfaceView.getDefaultSize((int)this.videoSize.y, (int)heightMeasureSpec);
        if (this.videoSize.x <= 0 || this.videoSize.y <= 0) {
            this.setMeasuredDimension(width, height);
            this.notifyOnSizeChangeListener(width, height);
            return;
        }
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
            height = heightSpecSize;
            width = widthSpecSize;
            if (this.videoSize.x * height < width * this.videoSize.y) {
                width = height * this.videoSize.x / this.videoSize.y;
            } else if (this.videoSize.x * height > width * this.videoSize.y) {
                height = width * this.videoSize.y / this.videoSize.x;
            }
        } else if (widthSpecMode == 0x40000000) {
            width = widthSpecSize;
            height = width * this.videoSize.y / this.videoSize.x;
            if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                height = heightSpecSize;
            }
        } else if (heightSpecMode == 0x40000000) {
            height = heightSpecSize;
            width = height * this.videoSize.x / this.videoSize.y;
            if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                width = widthSpecSize;
            }
        } else {
            width = this.videoSize.x;
            height = this.videoSize.y;
            if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                height = heightSpecSize;
                width = height * this.videoSize.x / this.videoSize.y;
            }
            if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                width = widthSpecSize;
                height = width * this.videoSize.y / this.videoSize.x;
            }
        }
        this.setMeasuredDimension(width, height);
        this.notifyOnSizeChangeListener(width, height);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        this.updateMatrixOnLayout();
        super.onConfigurationChanged(newConfig);
    }

    public void setOnSizeChangeListener(@Nullable OnSizeChangeListener listener) {
        this.onSizeChangeListener = listener;
    }

    @Override
    public void clearSurface() {
        try {
            EGL10 gl10 = (EGL10)EGLContext.getEGL();
            EGLDisplay display = gl10.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            gl10.eglInitialize(display, null);
            EGLConfig[] configs = new EGLConfig[1];
            gl10.eglChooseConfig(display, GL_CLEAR_CONFIG_ATTRIBUTES, configs, configs.length, new int[1]);
            EGLContext context = gl10.eglCreateContext(display, configs[0], EGL10.EGL_NO_CONTEXT, GL_CLEAR_CONTEXT_ATTRIBUTES);
            EGLSurface eglSurface = gl10.eglCreateWindowSurface(display, configs[0], (Object)this, new int[]{12344});
            gl10.eglMakeCurrent(display, eglSurface, eglSurface, context);
            gl10.eglSwapBuffers(display, eglSurface);
            gl10.eglDestroySurface(display, eglSurface);
            gl10.eglMakeCurrent(display, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            gl10.eglDestroyContext(display, context);
            gl10.eglTerminate(display);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error clearing surface", (Throwable)e);
        }
    }

    protected boolean updateVideoSize(int width, int height) {
        this.matrixManager.setIntrinsicVideoSize(width, height);
        this.updateMatrixOnLayout();
        this.videoSize.x = width;
        this.videoSize.y = height;
        if (width == 0 || height == 0) {
            return false;
        }
        SurfaceHolder holder = this.getHolder();
        if (holder != null) {
            holder.setFixedSize(width, height);
        }
        return true;
    }

    public void setScaleType(@NonNull ScaleType scaleType) {
        this.matrixManager.scale((View)this, scaleType);
    }

    @NonNull
    public ScaleType getScaleType() {
        return this.matrixManager.getCurrentScaleType();
    }

    public void setMeasureBasedOnAspectRatioEnabled(boolean enabled) {
        this.measureBasedOnAspectRatio = enabled;
        this.requestLayout();
    }

    public void setVideoRotation(@IntRange(from=0L, to=359L) int rotation, boolean fromUser) {
        this.setVideoRotation(fromUser ? rotation : this.requestedUserRotation, !fromUser ? rotation : this.requestedConfigurationRotation);
    }

    public void setVideoRotation(@IntRange(from=0L, to=359L) int userRotation, @IntRange(from=0L, to=359L) int configurationRotation) {
        this.requestedUserRotation = userRotation;
        this.requestedConfigurationRotation = configurationRotation;
        this.matrixManager.rotate((View)this, (userRotation + configurationRotation) % 360);
    }

    protected void updateMatrixOnLayout() {
        this.globalLayoutMatrixListenerLock.lock();
        if (this.getWindowToken() == null) {
            this.addOnAttachStateChangeListener(this.attachedListener);
        } else {
            this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.globalLayoutMatrixListener);
        }
        this.globalLayoutMatrixListenerLock.unlock();
    }

    protected void notifyOnSizeChangeListener(int width, int height) {
        if (this.lastNotifiedSize.x == width && this.lastNotifiedSize.y == height) {
            return;
        }
        this.lastNotifiedSize.x = width;
        this.lastNotifiedSize.y = height;
        if (this.onSizeChangeListener != null) {
            this.onSizeChangeListener.onVideoSurfaceSizeChange(width, height);
        }
    }

    private class GlobalLayoutMatrixListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private GlobalLayoutMatrixListener() {
        }

        public void onGlobalLayout() {
            ResizingSurfaceView.this.setScaleType(ResizingSurfaceView.this.matrixManager.getCurrentScaleType());
            if (Build.VERSION.SDK_INT >= 16) {
                ResizingSurfaceView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                ResizingSurfaceView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
    }

    private class AttachedListener
    implements View.OnAttachStateChangeListener {
        private AttachedListener() {
        }

        public void onViewAttachedToWindow(View view) {
            ResizingSurfaceView.this.globalLayoutMatrixListenerLock.lock();
            ResizingSurfaceView.this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)ResizingSurfaceView.this.globalLayoutMatrixListener);
            ResizingSurfaceView.this.removeOnAttachStateChangeListener(this);
            ResizingSurfaceView.this.globalLayoutMatrixListenerLock.unlock();
        }

        public void onViewDetachedFromWindow(View view) {
        }
    }

    public static interface OnSizeChangeListener {
        public void onVideoSurfaceSizeChange(int var1, int var2);
    }
}

