/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntRange;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.devbrackets.android.exomedia.R;
import com.devbrackets.android.exomedia.listener.VideoControlsButtonListener;
import com.devbrackets.android.exomedia.listener.VideoControlsSeekListener;
import com.devbrackets.android.exomedia.listener.VideoControlsVisibilityListener;
import com.devbrackets.android.exomedia.ui.widget.EMVideoView;
import com.devbrackets.android.exomedia.util.EMResourceUtil;
import com.devbrackets.android.exomedia.util.Repeater;
import java.util.LinkedList;
import java.util.List;

public abstract class VideoControls
extends RelativeLayout {
    public static final int DEFAULT_CONTROL_HIDE_DELAY = 2000;
    protected static final long CONTROL_VISIBILITY_ANIMATION_LENGTH = 300L;
    protected static final int INVALID_RESOURCE_ID = 0;
    protected TextView currentTime;
    protected TextView endTime;
    protected TextView titleView;
    protected TextView subTitleView;
    protected TextView descriptionView;
    protected ImageButton playPauseButton;
    protected ImageButton previousButton;
    protected ImageButton nextButton;
    protected ProgressBar loadingProgress;
    protected ViewGroup controlsContainer;
    protected ViewGroup textContainer;
    protected Drawable defaultPlayDrawable;
    protected Drawable defaultPauseDrawable;
    protected Drawable defaultPreviousDrawable;
    protected Drawable defaultNextDrawable;
    @NonNull
    protected Handler visibilityHandler = new Handler();
    @NonNull
    protected Repeater progressPollRepeater = new Repeater();
    @Nullable
    protected EMVideoView videoView;
    @Nullable
    protected VideoControlsSeekListener seekListener;
    @Nullable
    protected VideoControlsButtonListener buttonsListener;
    @Nullable
    protected VideoControlsVisibilityListener visibilityListener;
    @NonNull
    protected InternalListener internalListener = new InternalListener();
    protected int playResourceId = 0;
    protected int pauseResourceId = 0;
    protected long hideDelay = -1L;
    protected boolean isLoading = false;
    protected boolean isVisible = true;
    protected boolean canViewHide = true;
    protected boolean hideEmptyTextContainer = true;

    public abstract void setPosition(@IntRange(from=0L) long var1);

    public abstract void setDuration(@IntRange(from=0L) long var1);

    public abstract void updateProgress(@IntRange(from=0L) long var1, @IntRange(from=0L) long var3, @IntRange(from=0L, to=100L) int var5);

    @LayoutRes
    protected abstract int getLayoutResource();

    protected abstract void animateVisibility(boolean var1);

    protected abstract void updateTextContainerVisibility();

    public abstract void showLoading(boolean var1);

    public abstract void finishLoading();

    public VideoControls(Context context) {
        super(context);
        this.setup(context);
    }

    public VideoControls(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup(context);
    }

    public VideoControls(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup(context);
    }

    @TargetApi(value=21)
    public VideoControls(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setup(context);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.progressPollRepeater.stop();
        this.progressPollRepeater.setRepeatListener(null);
    }

    public void setVideoView(@Nullable EMVideoView EMVideoView2) {
        this.videoView = EMVideoView2;
    }

    public void setSeekListener(@Nullable VideoControlsSeekListener callbacks) {
        this.seekListener = callbacks;
    }

    public void setButtonListener(@Nullable VideoControlsButtonListener callback) {
        this.buttonsListener = callback;
    }

    public void setVisibilityListener(@Nullable VideoControlsVisibilityListener callbacks) {
        this.visibilityListener = callbacks;
    }

    public void updatePlaybackState(boolean isPlaying) {
        this.updatePlayPauseImage(isPlaying);
        this.progressPollRepeater.start();
        if (isPlaying) {
            this.hideDelayed(2000L);
        } else {
            this.show();
        }
    }

    public void setTitle(@Nullable CharSequence title) {
        this.titleView.setText(title);
        this.updateTextContainerVisibility();
    }

    public void setSubTitle(@Nullable CharSequence subTitle) {
        this.subTitleView.setText(subTitle);
        this.updateTextContainerVisibility();
    }

    public void setDescription(@Nullable CharSequence description) {
        this.descriptionView.setText(description);
        this.updateTextContainerVisibility();
    }

    public void setPlayPauseImages(@DrawableRes int playResourceId, @DrawableRes int pauseResourceId) {
        this.playResourceId = playResourceId;
        this.pauseResourceId = pauseResourceId;
        this.updatePlayPauseImage(this.videoView != null && this.videoView.isPlaying());
    }

    public void setPreviousImageResource(@DrawableRes int resourceId) {
        if (resourceId != 0) {
            this.previousButton.setImageResource(resourceId);
        } else {
            this.previousButton.setImageDrawable(this.defaultPreviousDrawable);
        }
    }

    public void setNextImageResource(@DrawableRes int resourceId) {
        if (resourceId != 0) {
            this.nextButton.setImageResource(resourceId);
        } else {
            this.nextButton.setImageDrawable(this.defaultNextDrawable);
        }
    }

    public void setRewindImageResource(@DrawableRes int resourceId) {
    }

    public void setFastForwardImageResource(@DrawableRes int resourceId) {
    }

    public void updatePlayPauseImage(boolean isPlaying) {
        if (isPlaying) {
            if (this.pauseResourceId != 0) {
                this.playPauseButton.setImageResource(this.pauseResourceId);
            } else {
                this.playPauseButton.setImageDrawable(this.defaultPauseDrawable);
            }
        } else if (this.playResourceId != 0) {
            this.playPauseButton.setImageResource(this.playResourceId);
        } else {
            this.playPauseButton.setImageDrawable(this.defaultPlayDrawable);
        }
    }

    public void setPreviousButtonEnabled(boolean enabled) {
        this.previousButton.setEnabled(enabled);
    }

    public void setNextButtonEnabled(boolean enabled) {
        this.nextButton.setEnabled(enabled);
    }

    public void setRewindButtonEnabled(boolean enabled) {
    }

    public void setFastForwardButtonEnabled(boolean enabled) {
    }

    public void setPreviousButtonRemoved(boolean removed) {
        this.previousButton.setVisibility(removed ? 8 : 0);
    }

    public void setNextButtonRemoved(boolean removed) {
        this.nextButton.setVisibility(removed ? 8 : 0);
    }

    public void setRewindButtonRemoved(boolean removed) {
    }

    public void setFastForwardButtonRemoved(boolean removed) {
    }

    public void addExtraView(@NonNull View view) {
    }

    public void removeExtraView(@NonNull View view) {
    }

    @NonNull
    public List<View> getExtraViews() {
        return new LinkedList<View>();
    }

    public void show() {
        this.visibilityHandler.removeCallbacksAndMessages(null);
        this.clearAnimation();
        this.animateVisibility(true);
    }

    public void hideDelayed(long delay) {
        this.hideDelay = delay;
        if (delay < 0L || !this.canViewHide || this.isLoading) {
            return;
        }
        this.visibilityHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                VideoControls.this.animateVisibility(false);
            }
        }, delay);
    }

    public void setCanHide(boolean canHide) {
        this.canViewHide = canHide;
    }

    public void setHideEmptyTextContainer(boolean hide) {
        this.hideEmptyTextContainer = hide;
        this.updateTextContainerVisibility();
    }

    protected void retrieveViews() {
        this.currentTime = (TextView)this.findViewById(R.id.exomedia_controls_current_time);
        this.endTime = (TextView)this.findViewById(R.id.exomedia_controls_end_time);
        this.titleView = (TextView)this.findViewById(R.id.exomedia_controls_title);
        this.subTitleView = (TextView)this.findViewById(R.id.exomedia_controls_sub_title);
        this.descriptionView = (TextView)this.findViewById(R.id.exomedia_controls_description);
        this.playPauseButton = (ImageButton)this.findViewById(R.id.exomedia_controls_play_pause_btn);
        this.previousButton = (ImageButton)this.findViewById(R.id.exomedia_controls_previous_btn);
        this.nextButton = (ImageButton)this.findViewById(R.id.exomedia_controls_next_btn);
        this.loadingProgress = (ProgressBar)this.findViewById(R.id.exomedia_controls_video_loading);
        this.controlsContainer = (ViewGroup)this.findViewById(R.id.exomedia_controls_interactive_container);
        this.textContainer = (ViewGroup)this.findViewById(R.id.exomedia_controls_text_container);
    }

    protected void registerListeners() {
        this.playPauseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoControls.this.onPlayPauseClick();
            }
        });
        this.previousButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoControls.this.onPreviousClick();
            }
        });
        this.nextButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoControls.this.onNextClick();
            }
        });
    }

    protected void updateButtonDrawables() {
        this.defaultPlayDrawable = EMResourceUtil.tintList(this.getContext(), R.drawable.exomedia_ic_play_arrow_white, R.color.exomedia_default_controls_button_selector);
        this.defaultPauseDrawable = EMResourceUtil.tintList(this.getContext(), R.drawable.exomedia_ic_pause_white, R.color.exomedia_default_controls_button_selector);
        this.playPauseButton.setImageDrawable(this.defaultPlayDrawable);
        this.defaultPreviousDrawable = EMResourceUtil.tintList(this.getContext(), R.drawable.exomedia_ic_skip_previous_white, R.color.exomedia_default_controls_button_selector);
        this.previousButton.setImageDrawable(this.defaultPreviousDrawable);
        this.defaultNextDrawable = EMResourceUtil.tintList(this.getContext(), R.drawable.exomedia_ic_skip_next_white, R.color.exomedia_default_controls_button_selector);
        this.nextButton.setImageDrawable(this.defaultNextDrawable);
    }

    protected void onPlayPauseClick() {
        if (this.buttonsListener == null || !this.buttonsListener.onPlayPauseClicked()) {
            this.internalListener.onPlayPauseClicked();
        }
    }

    protected void onPreviousClick() {
        if (this.buttonsListener == null || !this.buttonsListener.onPreviousClicked()) {
            this.internalListener.onPreviousClicked();
        }
    }

    protected void onNextClick() {
        if (this.buttonsListener == null || !this.buttonsListener.onNextClicked()) {
            this.internalListener.onNextClicked();
        }
    }

    protected void setup(Context context) {
        View.inflate((Context)context, (int)this.getLayoutResource(), (ViewGroup)this);
        this.retrieveViews();
        this.registerListeners();
        this.updateButtonDrawables();
        this.progressPollRepeater.setRepeatListener(new Repeater.RepeatListener(){

            @Override
            public void onRepeat() {
                VideoControls.this.updateProgress();
            }
        });
    }

    protected boolean isTextContainerEmpty() {
        if (this.titleView.getText() != null && this.titleView.getText().length() > 0) {
            return false;
        }
        if (this.subTitleView.getText() != null && this.subTitleView.getText().length() > 0) {
            return false;
        }
        return this.descriptionView.getText() == null || this.descriptionView.getText().length() <= 0;
    }

    protected void onVisibilityChanged() {
        if (this.visibilityListener == null) {
            return;
        }
        if (this.isVisible) {
            this.visibilityListener.onControlsShown();
        } else {
            this.visibilityListener.onControlsHidden();
        }
    }

    protected void updateProgress() {
        if (this.videoView != null) {
            this.updateProgress(this.videoView.getCurrentPosition(), this.videoView.getDuration(), this.videoView.getBufferPercentage());
        }
    }

    protected class InternalListener
    implements VideoControlsSeekListener,
    VideoControlsButtonListener {
        protected boolean pausedForSeek = false;

        protected InternalListener() {
        }

        @Override
        public boolean onPlayPauseClicked() {
            if (VideoControls.this.videoView == null) {
                return false;
            }
            if (VideoControls.this.videoView.isPlaying()) {
                VideoControls.this.videoView.pause();
            } else {
                VideoControls.this.videoView.start();
            }
            return true;
        }

        @Override
        public boolean onPreviousClicked() {
            return false;
        }

        @Override
        public boolean onNextClicked() {
            return false;
        }

        @Override
        public boolean onRewindClicked() {
            return false;
        }

        @Override
        public boolean onFastForwardClicked() {
            return false;
        }

        @Override
        public boolean onSeekStarted() {
            if (VideoControls.this.videoView == null) {
                return false;
            }
            if (VideoControls.this.videoView.isPlaying()) {
                this.pausedForSeek = true;
                VideoControls.this.videoView.pause();
            }
            VideoControls.this.show();
            return true;
        }

        @Override
        public boolean onSeekEnded(int seekTime) {
            if (VideoControls.this.videoView == null) {
                return false;
            }
            VideoControls.this.videoView.seekTo(seekTime);
            if (this.pausedForSeek) {
                this.pausedForSeek = false;
                VideoControls.this.videoView.start();
                VideoControls.this.hideDelayed(VideoControls.this.hideDelay);
            }
            return true;
        }
    }
}

