/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.exoplayer;

import android.content.Context;
import android.media.MediaCodec;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import android.view.Surface;
import com.devbrackets.android.exomedia.core.builder.RenderBuilder;
import com.devbrackets.android.exomedia.core.listener.CaptionListener;
import com.devbrackets.android.exomedia.core.listener.ExoPlayerListener;
import com.devbrackets.android.exomedia.core.listener.Id3MetadataListener;
import com.devbrackets.android.exomedia.core.listener.InfoListener;
import com.devbrackets.android.exomedia.core.listener.InternalErrorListener;
import com.devbrackets.android.exomedia.core.renderer.EMMediaCodecAudioTrackRenderer;
import com.devbrackets.android.exomedia.listener.OnBufferUpdateListener;
import com.devbrackets.android.exomedia.util.Repeater;
import com.google.android.exoplayer.DummyTrackRenderer;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.ExoPlayer;
import com.google.android.exoplayer.MediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.MediaCodecTrackRenderer;
import com.google.android.exoplayer.MediaCodecVideoTrackRenderer;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.TimeRange;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.audio.AudioCapabilitiesReceiver;
import com.google.android.exoplayer.audio.AudioTrack;
import com.google.android.exoplayer.chunk.ChunkSampleSource;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.dash.DashChunkSource;
import com.google.android.exoplayer.drm.StreamingDrmSessionManager;
import com.google.android.exoplayer.extractor.ExtractorSampleSource;
import com.google.android.exoplayer.hls.HlsSampleSource;
import com.google.android.exoplayer.metadata.MetadataTrackRenderer;
import com.google.android.exoplayer.metadata.id3.Id3Frame;
import com.google.android.exoplayer.text.Cue;
import com.google.android.exoplayer.text.TextRenderer;
import com.google.android.exoplayer.upstream.BandwidthMeter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class EMExoPlayer
implements ExoPlayer.Listener,
AudioCapabilitiesReceiver.Listener,
ExtractorSampleSource.EventListener,
ChunkSampleSource.EventListener,
HlsSampleSource.EventListener,
BandwidthMeter.EventListener,
MediaCodecVideoTrackRenderer.EventListener,
MediaCodecAudioTrackRenderer.EventListener,
StreamingDrmSessionManager.EventListener,
DashChunkSource.EventListener,
MetadataTrackRenderer.MetadataRenderer<List<Id3Frame>>,
TextRenderer {
    private static final String TAG = "EMExoPlayer";
    public static final int DISABLED_TRACK = -1;
    public static final int RENDER_COUNT = 4;
    public static final int RENDER_VIDEO = 0;
    public static final int RENDER_AUDIO = 1;
    public static final int RENDER_CLOSED_CAPTION = 2;
    public static final int RENDER_TIMED_METADATA = 3;
    public static final int BUFFER_LENGTH_MIN = 1000;
    public static final int REBUFFER_LENGTH_MIN = 5000;
    private static final int BUFFER_REPEAT_DELAY = 1000;
    private RenderBuilder rendererBuilder;
    private final ExoPlayer player;
    private final Handler mainHandler;
    private final CopyOnWriteArrayList<ExoPlayerListener> listeners;
    private final AtomicBoolean stopped = new AtomicBoolean();
    private RenderBuildingState rendererBuildingState;
    @NonNull
    private StateStore stateStore = new StateStore();
    @NonNull
    private Repeater bufferRepeater = new Repeater();
    private boolean prepared = false;
    private Surface surface;
    private TrackRenderer videoRenderer;
    private TrackRenderer audioRenderer;
    @Nullable
    private AudioCapabilities audioCapabilities;
    @Nullable
    private AudioCapabilitiesReceiver audioCapabilitiesReceiver;
    @Nullable
    private CaptionListener captionListener;
    @Nullable
    private Id3MetadataListener id3MetadataListener;
    @Nullable
    private InternalErrorListener internalErrorListener;
    @Nullable
    private InfoListener infoListener;
    @Nullable
    private OnBufferUpdateListener bufferUpdateListener;
    @Nullable
    private PowerManager.WakeLock wakeLock = null;

    public EMExoPlayer() {
        this(null);
    }

    public EMExoPlayer(@Nullable RenderBuilder rendererBuilder) {
        this.bufferRepeater.setRepeaterDelay(1000);
        this.bufferRepeater.setRepeatListener(new BufferRepeatListener());
        this.player = ExoPlayer.Factory.newInstance((int)4, (int)1000, (int)5000);
        this.player.addListener((ExoPlayer.Listener)this);
        this.mainHandler = new Handler();
        this.listeners = new CopyOnWriteArrayList();
        this.rendererBuildingState = RenderBuildingState.IDLE;
        this.player.setSelectedTrack(2, -1);
        this.replaceRenderBuilder(rendererBuilder);
    }

    public void replaceRenderBuilder(@Nullable RenderBuilder renderBuilder) {
        this.rendererBuilder = renderBuilder;
        if (this.rendererBuilder != null && this.audioCapabilities == null) {
            this.audioCapabilitiesReceiver = new AudioCapabilitiesReceiver(this.rendererBuilder.getContext(), (AudioCapabilitiesReceiver.Listener)this);
            this.audioCapabilitiesReceiver.register();
        }
        this.prepared = false;
        this.prepare();
    }

    public void addListener(ExoPlayerListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(ExoPlayerListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void setBufferUpdateListener(@Nullable OnBufferUpdateListener listener) {
        this.bufferUpdateListener = listener;
        this.setBufferRepeaterStarted(listener != null);
    }

    public void setInternalErrorListener(@Nullable InternalErrorListener listener) {
        this.internalErrorListener = listener;
    }

    public void setInfoListener(@Nullable InfoListener listener) {
        this.infoListener = listener;
    }

    public void setCaptionListener(@Nullable CaptionListener listener) {
        this.captionListener = listener;
    }

    public void setMetadataListener(@Nullable Id3MetadataListener listener) {
        this.id3MetadataListener = listener;
    }

    public void setSurface(Surface surface) {
        this.surface = surface;
        this.pushSurface(false);
    }

    public Surface getSurface() {
        return this.surface;
    }

    public void blockingClearSurface() {
        if (this.surface != null) {
            this.surface.release();
        }
        this.surface = null;
        this.pushSurface(true);
    }

    @Nullable
    public AudioCapabilities getAudioCapabilities() {
        return this.audioCapabilities;
    }

    @Nullable
    public Map<Integer, List<MediaFormat>> getAvailableTracks() {
        int[] trackTypes;
        if (this.getPlaybackState() == 1) {
            return null;
        }
        ArrayMap trackMap = new ArrayMap();
        for (int type : trackTypes = new int[]{1, 0, 2, 3}) {
            int trackCount = this.getTrackCount(type);
            ArrayList<MediaFormat> tracks = new ArrayList<MediaFormat>(trackCount);
            trackMap.put(type, tracks);
            for (int i = 0; i < trackCount; ++i) {
                tracks.add(this.getTrackFormat(type, i));
            }
        }
        return trackMap;
    }

    public int getTrackCount(int type) {
        return this.player.getTrackCount(type);
    }

    public MediaFormat getTrackFormat(int type, int index) {
        return this.player.getTrackFormat(type, index);
    }

    public int getSelectedTrack(int type) {
        return this.player.getSelectedTrack(type);
    }

    public void setSelectedTrack(int type, int index) {
        this.player.setSelectedTrack(type, index);
        if (type == 2 && index == -1 && this.captionListener != null) {
            this.captionListener.onCues(Collections.emptyList());
        }
    }

    public void setVolume(@FloatRange(from=0.0, to=1.0) float volume) {
        this.player.sendMessage((ExoPlayer.ExoPlayerComponent)this.audioRenderer, 1, (Object)Float.valueOf(volume));
    }

    public void forcePrepare() {
        this.prepared = false;
    }

    public void prepare() {
        if (this.prepared || this.rendererBuilder == null) {
            return;
        }
        if (this.rendererBuildingState == RenderBuildingState.BUILT) {
            this.player.stop();
        }
        this.videoRenderer = null;
        this.rendererBuildingState = RenderBuildingState.BUILDING;
        this.reportPlayerState();
        this.rendererBuilder.buildRenderers(this);
        this.prepared = true;
        this.stopped.set(false);
    }

    public void onRenderers(TrackRenderer[] renderers, @Nullable BandwidthMeter bandwidthMeter) {
        for (int i = 0; i < 4; ++i) {
            if (renderers[i] != null) continue;
            renderers[i] = new DummyTrackRenderer();
        }
        this.videoRenderer = renderers[0];
        this.audioRenderer = renderers[1];
        this.pushSurface(false);
        this.player.prepare(renderers);
        this.rendererBuildingState = RenderBuildingState.BUILT;
    }

    public void onRenderersError(Exception e) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onRendererInitializationError(e);
        }
        for (ExoPlayerListener listener : this.listeners) {
            listener.onError(this, e);
        }
        this.rendererBuildingState = RenderBuildingState.IDLE;
        this.reportPlayerState();
    }

    public void stop() {
        if (!this.stopped.getAndSet(true)) {
            this.player.setPlayWhenReady(false);
            this.player.stop();
        }
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        this.player.setPlayWhenReady(playWhenReady);
        this.stayAwake(playWhenReady);
    }

    public void seekTo(long positionMs) {
        this.player.seekTo(positionMs);
        this.stateStore.setMostRecentState(this.stateStore.isLastReportedPlayWhenReady(), 100);
    }

    public boolean restart() {
        int playbackState = this.getPlaybackState();
        if (playbackState != 1 && playbackState != 5) {
            return false;
        }
        this.seekTo(0L);
        this.setPlayWhenReady(true);
        this.forcePrepare();
        this.prepare();
        return true;
    }

    public void release() {
        if (this.rendererBuilder != null) {
            this.rendererBuilder.cancel();
        }
        if (this.audioCapabilitiesReceiver != null) {
            this.audioCapabilitiesReceiver.unregister();
            this.audioCapabilitiesReceiver = null;
        }
        this.setBufferRepeaterStarted(false);
        this.rendererBuildingState = RenderBuildingState.IDLE;
        this.listeners.clear();
        this.surface = null;
        this.player.release();
        this.stayAwake(false);
    }

    public int getPlaybackState() {
        if (this.rendererBuildingState == RenderBuildingState.BUILDING) {
            return 2;
        }
        return this.player.getPlaybackState();
    }

    public int getAudioSessionId() {
        if (this.audioRenderer != null) {
            return ((EMMediaCodecAudioTrackRenderer)this.audioRenderer).getAudioSessionId();
        }
        return 0;
    }

    public long getCurrentPosition() {
        return this.player.getCurrentPosition();
    }

    public long getDuration() {
        return this.player.getDuration();
    }

    public int getBufferedPercentage() {
        return this.player.getBufferedPercentage();
    }

    public boolean getPlayWhenReady() {
        return this.player.getPlayWhenReady();
    }

    public Looper getPlaybackLooper() {
        return this.player.getPlaybackLooper();
    }

    public Handler getMainHandler() {
        return this.mainHandler;
    }

    public void setWakeMode(Context context, int mode) {
        boolean wasHeld = false;
        if (this.wakeLock != null) {
            if (this.wakeLock.isHeld()) {
                wasHeld = true;
                this.wakeLock.release();
            }
            this.wakeLock = null;
        }
        if (context.getPackageManager().checkPermission("android.permission.WAKE_LOCK", context.getPackageName()) == 0) {
            PowerManager pm = (PowerManager)context.getSystemService("power");
            this.wakeLock = pm.newWakeLock(mode | 0x20000000, EMExoPlayer.class.getName());
            this.wakeLock.setReferenceCounted(false);
        } else {
            Log.w((String)TAG, (String)"Unable to acquire WAKE_LOCK due to missing manifest permission");
        }
        this.stayAwake(wasHeld);
    }

    protected void stayAwake(boolean awake) {
        if (this.wakeLock == null) {
            return;
        }
        if (awake && !this.wakeLock.isHeld()) {
            this.wakeLock.acquire();
        } else if (!awake && this.wakeLock.isHeld()) {
            this.wakeLock.release();
        }
    }

    public void onPlayerStateChanged(boolean playWhenReady, int state) {
        this.reportPlayerState();
    }

    public void onPlayerError(ExoPlaybackException exception) {
        this.rendererBuildingState = RenderBuildingState.IDLE;
        for (ExoPlayerListener listener : this.listeners) {
            listener.onError(this, (Exception)exception);
        }
    }

    public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
        for (ExoPlayerListener listener : this.listeners) {
            listener.onVideoSizeChanged(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
        }
    }

    public void onDroppedFrames(int count, long elapsed) {
        if (this.infoListener != null) {
            this.infoListener.onDroppedFrames(count, elapsed);
        }
    }

    public void onBandwidthSample(int elapsedMs, long bytes, long bitrateEstimate) {
        if (this.infoListener != null) {
            this.infoListener.onBandwidthSample(elapsedMs, bytes, bitrateEstimate);
        }
    }

    public void onDownstreamFormatChanged(int sourceId, Format format, int trigger, long mediaTimeMs) {
        if (this.infoListener == null) {
            return;
        }
        if (sourceId == 0) {
            this.infoListener.onVideoFormatEnabled(format, trigger, mediaTimeMs);
        } else if (sourceId == 1) {
            this.infoListener.onAudioFormatEnabled(format, trigger, mediaTimeMs);
        }
    }

    public void onDrmKeysLoaded() {
    }

    public void onDrmSessionManagerError(Exception e) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onDrmSessionManagerError(e);
        }
    }

    public void onDecoderInitializationError(MediaCodecTrackRenderer.DecoderInitializationException e) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onDecoderInitializationError(e);
        }
    }

    public void onDecoderInitialized(String decoderName, long elapsedRealtimeMs, long initializationDurationMs) {
        if (this.infoListener != null) {
            this.infoListener.onDecoderInitialized(decoderName, elapsedRealtimeMs, initializationDurationMs);
        }
    }

    public void onAudioTrackInitializationError(AudioTrack.InitializationException e) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onAudioTrackInitializationError(e);
        }
    }

    public void onAudioTrackWriteError(AudioTrack.WriteException e) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onAudioTrackWriteError(e);
        }
    }

    public void onAudioTrackUnderrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onAudioTrackUnderrun(bufferSize, bufferSizeMs, elapsedSinceLastFeedMs);
        }
    }

    public void onCryptoError(MediaCodec.CryptoException e) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onCryptoError(e);
        }
    }

    public void onLoadError(int sourceId, IOException e) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onLoadError(sourceId, e);
        }
    }

    public void onCues(List<Cue> cues) {
        if (this.captionListener != null && this.getSelectedTrack(2) != -1) {
            this.captionListener.onCues(cues);
        }
    }

    public void onMetadata(List<Id3Frame> metadata) {
        if (this.id3MetadataListener != null && this.getSelectedTrack(3) != -1) {
            this.id3MetadataListener.onId3Metadata(metadata);
        }
    }

    public void onAvailableRangeChanged(int sourceId, TimeRange availableRange) {
        if (this.infoListener != null) {
            this.infoListener.onAvailableRangeChanged(sourceId, availableRange);
        }
    }

    public void onPlayWhenReadyCommitted() {
    }

    public void onDrawnToSurface(Surface surface) {
    }

    public void onLoadStarted(int sourceId, long length, int type, int trigger, Format format, long mediaStartTimeMs, long mediaEndTimeMs) {
        if (this.infoListener != null) {
            this.infoListener.onLoadStarted(sourceId, length, type, trigger, format, mediaStartTimeMs, mediaEndTimeMs);
        }
    }

    public void onLoadCompleted(int sourceId, long bytesLoaded, int type, int trigger, Format format, long mediaStartTimeMs, long mediaEndTimeMs, long elapsedRealtimeMs, long loadDurationMs) {
        if (this.infoListener != null) {
            this.infoListener.onLoadCompleted(sourceId, bytesLoaded, type, trigger, format, mediaStartTimeMs, mediaEndTimeMs, elapsedRealtimeMs, loadDurationMs);
        }
    }

    public void onLoadCanceled(int sourceId, long bytesLoaded) {
    }

    public void onUpstreamDiscarded(int sourceId, long mediaStartTimeMs, long mediaEndTimeMs) {
    }

    public void onAudioCapabilitiesChanged(AudioCapabilities audioCapabilities) {
        if (audioCapabilities.equals((Object)this.audioCapabilities)) {
            return;
        }
        this.audioCapabilities = audioCapabilities;
        if (this.rendererBuilder == null) {
            return;
        }
        boolean playWhenReady = this.getPlayWhenReady();
        long currentPosition = this.getCurrentPosition();
        this.replaceRenderBuilder(this.rendererBuilder);
        this.player.seekTo(currentPosition);
        this.player.setPlayWhenReady(playWhenReady);
    }

    private void reportPlayerState() {
        int playbackState;
        boolean playWhenReady = this.player.getPlayWhenReady();
        int newState = this.stateStore.getState(playWhenReady, playbackState = this.getPlaybackState());
        if (newState != this.stateStore.getMostRecentState()) {
            this.stateStore.setMostRecentState(playWhenReady, playbackState);
            if (newState == 4) {
                this.setBufferRepeaterStarted(true);
            } else if (newState == 1 || newState == 5 || newState == 2) {
                this.setBufferRepeaterStarted(false);
            }
            boolean informSeekCompletion = this.stateStore.matchesHistory(new int[]{100, 3, 4}, true);
            informSeekCompletion |= this.stateStore.matchesHistory(new int[]{100, 4, 3, 4}, true);
            for (ExoPlayerListener listener : this.listeners) {
                listener.onStateChanged(playWhenReady, playbackState);
                if (!informSeekCompletion) continue;
                listener.onSeekComplete();
            }
        }
    }

    private void pushSurface(boolean blockForSurfacePush) {
        if (this.videoRenderer == null) {
            return;
        }
        if (blockForSurfacePush) {
            this.player.blockingSendMessage((ExoPlayer.ExoPlayerComponent)this.videoRenderer, 1, (Object)this.surface);
        } else {
            this.player.sendMessage((ExoPlayer.ExoPlayerComponent)this.videoRenderer, 1, (Object)this.surface);
        }
    }

    private void setBufferRepeaterStarted(boolean start) {
        if (start && this.bufferUpdateListener != null) {
            this.bufferRepeater.start();
        } else {
            this.bufferRepeater.stop();
        }
    }

    private static class StateStore {
        public static final int FLAG_PLAY_WHEN_READY = -268435456;
        public static final int STATE_SEEKING = 100;
        private int[] prevStates = new int[]{1, 1, 1, 1};

        private StateStore() {
        }

        public void setMostRecentState(boolean playWhenReady, int state) {
            int newState = this.getState(playWhenReady, state);
            if (this.prevStates[3] == newState) {
                return;
            }
            this.prevStates[0] = this.prevStates[1];
            this.prevStates[1] = this.prevStates[2];
            this.prevStates[2] = this.prevStates[3];
            this.prevStates[3] = state;
        }

        public int getState(boolean playWhenReady, int state) {
            return state | (playWhenReady ? -268435456 : 0);
        }

        public int getMostRecentState() {
            return this.prevStates[3];
        }

        public boolean isLastReportedPlayWhenReady() {
            return (this.prevStates[3] & 0xF0000000) != 0;
        }

        public boolean matchesHistory(@Size(min=1L, max=4L) int[] states, boolean ignorePlayWhenReady) {
            int startIndex;
            boolean flag = true;
            int andFlag = ignorePlayWhenReady ? 0xFFFFFFF : -1;
            for (int i = startIndex = this.prevStates.length - states.length; i < this.prevStates.length; ++i) {
                flag &= (this.prevStates[i] & andFlag) == (states[i - startIndex] & andFlag);
            }
            return flag;
        }
    }

    private class BufferRepeatListener
    implements Repeater.RepeatListener {
        private BufferRepeatListener() {
        }

        @Override
        public void onRepeat() {
            if (EMExoPlayer.this.bufferUpdateListener != null) {
                EMExoPlayer.this.bufferUpdateListener.onBufferingUpdate(EMExoPlayer.this.getBufferedPercentage());
            }
        }
    }

    public static enum RenderBuildingState {
        IDLE,
        BUILDING,
        BUILT;

    }
}

