/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.video.scale;

import android.graphics.Point;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.TextureView;
import com.devbrackets.android.exomedia.core.video.scale.ScaleType;
import java.lang.ref.WeakReference;

public class MatrixManager {
    private static final String TAG = "MatrixManager";
    protected static final int QUARTER_ROTATION = 90;
    @NonNull
    protected Point intrinsicVideoSize = new Point(0, 0);
    @IntRange(from=0L, to=359L)
    protected int currentRotation = 0;
    @NonNull
    protected ScaleType currentScaleType = ScaleType.FIT_CENTER;
    @Nullable
    protected Integer requestedRotation = null;
    @Nullable
    protected ScaleType requestedScaleType = null;
    @NonNull
    protected WeakReference<TextureView> requestedModificationView = new WeakReference<Object>(null);

    public void reset() {
        this.setIntrinsicVideoSize(0, 0);
        this.currentRotation = 0;
    }

    public boolean ready() {
        return this.intrinsicVideoSize.x > 0 && this.intrinsicVideoSize.y > 0;
    }

    public void setIntrinsicVideoSize(@IntRange(from=0L) int width, @IntRange(from=0L) int height) {
        boolean currentWidthHeightSwapped = this.currentRotation / 90 % 2 == 1;
        this.intrinsicVideoSize.x = currentWidthHeightSwapped ? height : width;
        int n = this.intrinsicVideoSize.y = currentWidthHeightSwapped ? width : height;
        if (this.ready()) {
            this.applyRequestedModifications();
        }
    }

    public int getCurrentRotation() {
        return this.requestedRotation != null ? this.requestedRotation : this.currentRotation;
    }

    @NonNull
    public ScaleType getCurrentScaleType() {
        return this.requestedScaleType != null ? this.requestedScaleType : this.currentScaleType;
    }

    public void rotate(@NonNull TextureView view, @IntRange(from=0L, to=359L) int rotation) {
        boolean currentWidthHeightSwapped;
        if (!this.ready()) {
            this.requestedRotation = rotation;
            this.requestedModificationView = new WeakReference<TextureView>(view);
            return;
        }
        boolean swapWidthHeight = rotation / 90 % 2 == 1;
        boolean bl = currentWidthHeightSwapped = this.currentRotation / 90 % 2 == 1;
        if (swapWidthHeight != currentWidthHeightSwapped) {
            int tempX = this.intrinsicVideoSize.x;
            this.intrinsicVideoSize.x = this.intrinsicVideoSize.y;
            this.intrinsicVideoSize.y = tempX;
            this.scale(view, this.currentScaleType);
        }
        this.currentRotation = rotation;
        view.setRotation((float)rotation);
    }

    public boolean scale(@NonNull TextureView view, @NonNull ScaleType scaleType) {
        if (!this.ready()) {
            this.requestedScaleType = scaleType;
            this.requestedModificationView = new WeakReference<TextureView>(view);
            return false;
        }
        if (view.getHeight() == 0 || view.getWidth() == 0) {
            Log.d((String)TAG, (String)("Unable to apply scale with a view size of (" + view.getWidth() + ", " + view.getHeight() + ")"));
            return false;
        }
        this.currentScaleType = scaleType;
        switch (scaleType) {
            case CENTER: {
                this.applyCenter(view);
                break;
            }
            case CENTER_CROP: {
                this.applyCenterCrop(view);
                break;
            }
            case CENTER_INSIDE: {
                this.applyCenterInside(view);
                break;
            }
            case FIT_CENTER: {
                this.applyFitCenter(view);
                break;
            }
            case NONE: {
                this.setScale(view, 1.0f, 1.0f);
            }
        }
        return true;
    }

    protected void applyCenter(@NonNull TextureView view) {
        float xScale = (float)this.intrinsicVideoSize.x / (float)view.getWidth();
        float yScale = (float)this.intrinsicVideoSize.y / (float)view.getHeight();
        this.setScale(view, xScale, yScale);
    }

    protected void applyCenterCrop(@NonNull TextureView view) {
        float xScale = (float)view.getWidth() / (float)this.intrinsicVideoSize.x;
        float yScale = (float)view.getHeight() / (float)this.intrinsicVideoSize.y;
        float scale = Math.max(xScale, yScale);
        xScale = scale / xScale;
        yScale = scale / yScale;
        this.setScale(view, xScale, yScale);
    }

    protected void applyCenterInside(@NonNull TextureView view) {
        if (this.intrinsicVideoSize.x <= view.getWidth() && this.intrinsicVideoSize.y <= view.getHeight()) {
            this.applyCenter(view);
        } else {
            this.applyFitCenter(view);
        }
    }

    protected void applyFitCenter(@NonNull TextureView view) {
        float xScale = (float)view.getWidth() / (float)this.intrinsicVideoSize.x;
        float yScale = (float)view.getHeight() / (float)this.intrinsicVideoSize.y;
        float scale = Math.min(xScale, yScale);
        xScale = scale / xScale;
        yScale = scale / yScale;
        this.setScale(view, xScale, yScale);
    }

    protected void setScale(@NonNull TextureView view, float xScale, float yScale) {
        boolean currentWidthHeightSwapped;
        boolean bl = currentWidthHeightSwapped = this.currentRotation / 90 % 2 == 1;
        if (currentWidthHeightSwapped) {
            float scaleTemp = xScale;
            xScale = yScale * (float)view.getHeight() / (float)view.getWidth();
            yScale = scaleTemp * (float)view.getWidth() / (float)view.getHeight();
        }
        view.setScaleX(xScale);
        view.setScaleY(yScale);
    }

    protected void applyRequestedModifications() {
        TextureView view = (TextureView)this.requestedModificationView.get();
        if (view != null) {
            if (this.requestedRotation != null) {
                this.rotate(view, this.requestedRotation);
                this.requestedRotation = null;
            }
            if (this.requestedScaleType != null) {
                this.scale(view, this.requestedScaleType);
                this.requestedScaleType = null;
            }
        }
        this.requestedModificationView = new WeakReference<Object>(null);
    }
}

