/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.devbrackets.android.exomedia.core.EMListenerMux;
import com.devbrackets.android.exomedia.core.api.VideoViewApi;
import com.devbrackets.android.exomedia.core.builder.RenderBuilder;
import com.devbrackets.android.exomedia.core.video.TextureVideoView;
import com.google.android.exoplayer.MediaFormat;
import java.util.List;
import java.util.Map;

public class NativeVideoView
extends TextureVideoView
implements VideoViewApi {
    private View.OnTouchListener touchListener;
    protected EMListenerMux listenerMux;

    public NativeVideoView(Context context) {
        super(context);
        this.setup();
    }

    public NativeVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup();
    }

    public NativeVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup();
    }

    @TargetApi(value=21)
    public NativeVideoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setup();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        boolean flag = false;
        if (this.touchListener != null) {
            flag = this.touchListener.onTouch((View)this, ev);
        }
        return flag || super.onTouchEvent(ev);
    }

    @Override
    public void setOnTouchListener(View.OnTouchListener listener) {
        this.touchListener = listener;
        super.setOnTouchListener(listener);
    }

    @Override
    public void setVideoUri(@Nullable Uri uri) {
        this.setVideoUri(uri, null);
    }

    @Override
    public void setVideoUri(@Nullable Uri uri, @Nullable RenderBuilder renderBuilder) {
        super.setVideoURI(uri);
    }

    @Override
    public boolean setVolume(@FloatRange(from=0.0, to=1.0) float volume) {
        return false;
    }

    @Override
    public int getDuration() {
        if (!this.listenerMux.isPrepared()) {
            return 0;
        }
        return super.getDuration();
    }

    @Override
    public int getCurrentPosition() {
        if (!this.listenerMux.isPrepared()) {
            return 0;
        }
        return super.getCurrentPosition();
    }

    @Override
    public int getBufferedPercent() {
        return this.getBufferPercentage();
    }

    @Override
    public void start() {
        super.start();
        this.listenerMux.setNotifiedCompleted(false);
    }

    @Override
    public boolean restart() {
        if (this.currentState != TextureVideoView.State.COMPLETED) {
            return false;
        }
        this.seekTo(0);
        this.start();
        this.listenerMux.setNotifiedPrepared(false);
        this.listenerMux.setNotifiedCompleted(false);
        return true;
    }

    @Override
    public void stopPlayback() {
        super.stopPlayback();
        this.listenerMux.clearSurfaceWhenReady(this);
    }

    @Override
    public void release() {
    }

    @Override
    public boolean trackSelectionAvailable() {
        return false;
    }

    @Override
    public void setTrack(int trackType, int trackIndex) {
    }

    @Override
    @Nullable
    public Map<Integer, List<MediaFormat>> getAvailableTracks() {
        return null;
    }

    @Override
    public void setListenerMux(EMListenerMux listenerMux) {
        this.listenerMux = listenerMux;
        this.setOnCompletionListener(listenerMux);
        this.setOnPreparedListener(listenerMux);
        this.setOnBufferingUpdateListener(listenerMux);
        this.setOnSeekCompleteListener(listenerMux);
        this.setOnErrorListener(listenerMux);
    }

    @Override
    public void onVideoSizeChanged(int width, int height) {
        if (this.updateVideoSize(width, height)) {
            this.requestLayout();
        }
    }

    protected void setup() {
    }
}

