/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.AnyRes;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.TypedValue;

public class EMResourceUtil {
    public static Drawable tint(Context context, @DrawableRes int drawableRes, @ColorRes int colorRes) {
        Drawable drawable = EMResourceUtil.getDrawable(context, drawableRes);
        drawable = drawable.mutate();
        return EMResourceUtil.tint(context, drawable, colorRes);
    }

    public static Drawable tint(Context context, Drawable drawable, @ColorRes int colorRes) {
        drawable = DrawableCompat.wrap((Drawable)drawable);
        DrawableCompat.setTint((Drawable)drawable, (int)EMResourceUtil.getColor(context, colorRes));
        return drawable;
    }

    public static Drawable tintList(Context context, @DrawableRes int drawableRes, @ColorRes int tintListRes) {
        Drawable drawable = EMResourceUtil.getDrawable(context, drawableRes);
        drawable = drawable.mutate();
        return EMResourceUtil.tintList(context, drawable, tintListRes);
    }

    public static Drawable tintList(Context context, Drawable drawable, @ColorRes int tintListRes) {
        drawable = DrawableCompat.wrap((Drawable)drawable);
        DrawableCompat.setTintList((Drawable)drawable, (ColorStateList)EMResourceUtil.getColorStateList(context, tintListRes));
        return drawable;
    }

    public static Drawable getDrawable(Context context, @DrawableRes int drawableResourceId) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getResources().getDrawable(drawableResourceId, context.getTheme());
        }
        return context.getResources().getDrawable(drawableResourceId);
    }

    @AnyRes
    public static int getResolvedResourceId(Context context, @AttrRes int attr) {
        TypedValue typedValue = new TypedValue();
        Resources.Theme theme = context.getTheme();
        theme.resolveAttribute(attr, typedValue, true);
        if (typedValue.type == 1) {
            return typedValue.data;
        }
        return typedValue.resourceId;
    }

    @ColorInt
    public static int getColor(Context context, @ColorRes int colorRes) {
        if (Build.VERSION.SDK_INT >= 23) {
            return context.getResources().getColor(colorRes, context.getTheme());
        }
        return context.getResources().getColor(colorRes);
    }

    public static ColorStateList getColorStateList(Context context, @ColorRes int colorRes) {
        if (Build.VERSION.SDK_INT >= 23) {
            return context.getResources().getColorStateList(colorRes, context.getTheme());
        }
        return context.getResources().getColorStateList(colorRes);
    }
}

