/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.TextureView;
import android.widget.MediaController;
import com.devbrackets.android.exomedia.core.video.ResizingTextureView;
import java.io.IOException;
import java.util.Map;

public class TextureVideoView
extends ResizingTextureView
implements MediaController.MediaPlayerControl {
    private static final String TAG = "TextureVideoView";
    protected Map<String, String> headers;
    protected State currentState = State.IDLE;
    protected MediaPlayer mediaPlayer;
    protected boolean playRequested = false;
    protected int requestedSeek;
    protected int currentBufferPercent;
    @NonNull
    protected InternalListeners internalListeners = new InternalListeners();
    @Nullable
    protected MediaPlayer.OnCompletionListener onCompletionListener;
    @Nullable
    protected MediaPlayer.OnPreparedListener onPreparedListener;
    @Nullable
    protected MediaPlayer.OnBufferingUpdateListener onBufferingUpdateListener;
    @Nullable
    protected MediaPlayer.OnSeekCompleteListener onSeekCompleteListener;
    @Nullable
    protected MediaPlayer.OnErrorListener onErrorListener;
    @Nullable
    protected MediaPlayer.OnInfoListener onInfoListener;

    public TextureVideoView(Context context) {
        super(context);
        this.setup(context, null);
    }

    public TextureVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup(context, attrs);
    }

    public TextureVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup(context, attrs);
    }

    @TargetApi(value=21)
    public TextureVideoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setup(context, attrs);
    }

    public void start() {
        if (this.isReady()) {
            this.mediaPlayer.start();
            this.requestFocus();
            this.currentState = State.PLAYING;
        }
        this.playRequested = true;
    }

    public void pause() {
        if (this.isReady() && this.mediaPlayer.isPlaying()) {
            this.mediaPlayer.pause();
            this.currentState = State.PAUSED;
        }
        this.playRequested = false;
    }

    public int getDuration() {
        if (this.isReady()) {
            return this.mediaPlayer.getDuration();
        }
        return 0;
    }

    public int getCurrentPosition() {
        if (this.isReady()) {
            return this.mediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    public void seekTo(int msec) {
        if (this.isReady()) {
            this.mediaPlayer.seekTo(msec);
            this.requestedSeek = 0;
        } else {
            this.requestedSeek = msec;
        }
    }

    public boolean isPlaying() {
        return this.isReady() && this.mediaPlayer.isPlaying();
    }

    public int getBufferPercentage() {
        if (this.mediaPlayer != null) {
            return this.currentBufferPercent;
        }
        return 0;
    }

    public boolean canPause() {
        return this.currentState == State.PREPARED || this.currentState == State.PLAYING;
    }

    public boolean canSeekBackward() {
        return this.currentState == State.PREPARED || this.currentState == State.PLAYING || this.currentState == State.PAUSED;
    }

    public boolean canSeekForward() {
        return this.currentState == State.PREPARED || this.currentState == State.PLAYING || this.currentState == State.PAUSED;
    }

    public void stopPlayback() {
        this.currentState = State.IDLE;
        if (this.isReady()) {
            try {
                this.mediaPlayer.stop();
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)"stopPlayback: error calling mediaPlayer.stop()", (Throwable)e);
            }
        }
        this.playRequested = false;
    }

    public void suspend() {
        this.currentState = State.IDLE;
        try {
            this.mediaPlayer.reset();
            this.mediaPlayer.release();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"stopPlayback: error calling mediaPlayer.reset() or mediaPlayer.release()", (Throwable)e);
        }
        this.playRequested = false;
    }

    public void setVideoURI(Uri uri) {
        this.setVideoURI(uri, null);
    }

    public void setVideoURI(Uri uri, @Nullable Map<String, String> headers) {
        this.headers = headers;
        this.requestedSeek = 0;
        this.playRequested = false;
        this.openVideo(uri);
        this.requestLayout();
        this.invalidate();
    }

    public void setOnPreparedListener(@Nullable MediaPlayer.OnPreparedListener listener) {
        this.onPreparedListener = listener;
    }

    public void setOnCompletionListener(@Nullable MediaPlayer.OnCompletionListener listener) {
        this.onCompletionListener = listener;
    }

    public void setOnBufferingUpdateListener(@Nullable MediaPlayer.OnBufferingUpdateListener listener) {
        this.onBufferingUpdateListener = listener;
    }

    public void setOnSeekCompleteListener(@Nullable MediaPlayer.OnSeekCompleteListener listener) {
        this.onSeekCompleteListener = listener;
    }

    public void setOnErrorListener(@Nullable MediaPlayer.OnErrorListener listener) {
        this.onErrorListener = listener;
    }

    public void setOnInfoListener(@Nullable MediaPlayer.OnInfoListener listener) {
        this.onInfoListener = listener;
    }

    public int getAudioSessionId() {
        return this.mediaPlayer.getAudioSessionId();
    }

    protected boolean isReady() {
        return this.currentState != State.ERROR && this.currentState != State.IDLE && this.currentState != State.PREPARING;
    }

    protected void openVideo(@Nullable Uri uri) {
        if (uri == null) {
            return;
        }
        this.currentBufferPercent = 0;
        try {
            this.mediaPlayer.setDataSource(this.getContext().getApplicationContext(), uri, this.headers);
            this.mediaPlayer.prepareAsync();
            this.currentState = State.PREPARING;
        }
        catch (IOException | IllegalArgumentException ex) {
            Log.w((String)TAG, (String)("Unable to open content: " + uri), (Throwable)ex);
            this.currentState = State.ERROR;
            this.internalListeners.onError(this.mediaPlayer, 1, 0);
        }
    }

    protected void setup(Context context, @Nullable AttributeSet attrs) {
        this.initMediaPlayer();
        this.setSurfaceTextureListener(new TextureVideoViewSurfaceListener());
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        this.updateVideoSize(0, 0);
        this.currentState = State.IDLE;
    }

    protected void initMediaPlayer() {
        this.mediaPlayer = new MediaPlayer();
        this.mediaPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)this.internalListeners);
        this.mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this.internalListeners);
        this.mediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this.internalListeners);
        this.mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this.internalListeners);
        this.mediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)this.internalListeners);
        this.mediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this.internalListeners);
        this.mediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this.internalListeners);
        this.mediaPlayer.setAudioStreamType(3);
        this.mediaPlayer.setScreenOnWhilePlaying(true);
    }

    protected class TextureVideoViewSurfaceListener
    implements TextureView.SurfaceTextureListener {
        protected TextureVideoViewSurfaceListener() {
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            TextureVideoView.this.mediaPlayer.setSurface(new Surface(surfaceTexture));
            if (TextureVideoView.this.playRequested) {
                TextureVideoView.this.start();
            }
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            if (TextureVideoView.this.mediaPlayer == null || width <= 0 || height <= 0) {
                return;
            }
            if (TextureVideoView.this.requestedSeek != 0) {
                TextureVideoView.this.seekTo(TextureVideoView.this.requestedSeek);
            }
            if (TextureVideoView.this.playRequested) {
                TextureVideoView.this.start();
            }
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            surface.release();
            TextureVideoView.this.suspend();
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        }
    }

    protected class InternalListeners
    implements MediaPlayer.OnBufferingUpdateListener,
    MediaPlayer.OnErrorListener,
    MediaPlayer.OnPreparedListener,
    MediaPlayer.OnCompletionListener,
    MediaPlayer.OnSeekCompleteListener,
    MediaPlayer.OnInfoListener,
    MediaPlayer.OnVideoSizeChangedListener {
        protected InternalListeners() {
        }

        public void onBufferingUpdate(MediaPlayer mp, int percent) {
            TextureVideoView.this.currentBufferPercent = percent;
            if (TextureVideoView.this.onBufferingUpdateListener != null) {
                TextureVideoView.this.onBufferingUpdateListener.onBufferingUpdate(mp, percent);
            }
        }

        public void onCompletion(MediaPlayer mp) {
            TextureVideoView.this.currentState = State.COMPLETED;
            if (TextureVideoView.this.onCompletionListener != null) {
                TextureVideoView.this.onCompletionListener.onCompletion(TextureVideoView.this.mediaPlayer);
            }
        }

        public void onSeekComplete(MediaPlayer mp) {
            if (TextureVideoView.this.onSeekCompleteListener != null) {
                TextureVideoView.this.onSeekCompleteListener.onSeekComplete(mp);
            }
        }

        public boolean onError(MediaPlayer mp, int what, int extra) {
            Log.d((String)TextureVideoView.TAG, (String)("Error: " + what + "," + extra));
            TextureVideoView.this.currentState = State.ERROR;
            return TextureVideoView.this.onErrorListener == null || TextureVideoView.this.onErrorListener.onError(TextureVideoView.this.mediaPlayer, what, extra);
        }

        public void onPrepared(MediaPlayer mp) {
            TextureVideoView.this.currentState = State.PREPARED;
            if (TextureVideoView.this.onPreparedListener != null) {
                TextureVideoView.this.onPreparedListener.onPrepared(TextureVideoView.this.mediaPlayer);
            }
            TextureVideoView.this.updateVideoSize(mp.getVideoWidth(), mp.getVideoHeight());
            if (TextureVideoView.this.requestedSeek != 0) {
                TextureVideoView.this.seekTo(TextureVideoView.this.requestedSeek);
            }
            if (TextureVideoView.this.playRequested) {
                TextureVideoView.this.start();
            }
        }

        public boolean onInfo(MediaPlayer mp, int what, int extra) {
            return TextureVideoView.this.onInfoListener == null || TextureVideoView.this.onInfoListener.onInfo(mp, what, extra);
        }

        public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
            if (TextureVideoView.this.updateVideoSize(mp.getVideoWidth(), mp.getVideoHeight())) {
                TextureVideoView.this.requestLayout();
            }
        }
    }

    protected static enum State {
        ERROR,
        IDLE,
        PREPARING,
        PREPARED,
        PLAYING,
        PAUSED,
        COMPLETED;

    }
}

