/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.core.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import com.devbrackets.android.exomedia.core.EMListenerMux;
import com.devbrackets.android.exomedia.core.api.VideoViewApi;
import com.devbrackets.android.exomedia.core.builder.DashRenderBuilder;
import com.devbrackets.android.exomedia.core.builder.HlsRenderBuilder;
import com.devbrackets.android.exomedia.core.builder.RenderBuilder;
import com.devbrackets.android.exomedia.core.builder.SmoothStreamRenderBuilder;
import com.devbrackets.android.exomedia.core.exoplayer.EMExoPlayer;
import com.devbrackets.android.exomedia.core.video.ResizingTextureView;
import com.devbrackets.android.exomedia.type.MediaSourceType;
import com.devbrackets.android.exomedia.util.MediaSourceUtil;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.audio.AudioCapabilitiesReceiver;
import java.util.List;
import java.util.Map;

@TargetApi(value=16)
public class ExoVideoView
extends ResizingTextureView
implements VideoViewApi,
AudioCapabilitiesReceiver.Listener {
    protected static final String USER_AGENT_FORMAT = "EMVideoView %s / Android %s / %s";
    protected EMExoPlayer emExoPlayer;
    protected AudioCapabilities audioCapabilities;
    protected AudioCapabilitiesReceiver audioCapabilitiesReceiver;
    protected EMListenerMux listenerMux;
    protected boolean playRequested = false;

    public ExoVideoView(Context context) {
        super(context);
        this.setup();
    }

    public ExoVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup();
    }

    public ExoVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup();
    }

    public ExoVideoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setup();
    }

    @Override
    public void setVideoUri(@Nullable Uri uri) {
        RenderBuilder builder = uri == null ? null : this.getRendererBuilder(MediaSourceUtil.getType(uri), uri);
        this.setVideoUri(uri, builder);
    }

    @Override
    public void setVideoUri(@Nullable Uri uri, @Nullable RenderBuilder renderBuilder) {
        this.playRequested = false;
        if (uri == null) {
            this.emExoPlayer.replaceRenderBuilder(null);
        } else {
            this.emExoPlayer.replaceRenderBuilder(renderBuilder);
            this.listenerMux.setNotifiedCompleted(false);
        }
        this.listenerMux.setNotifiedPrepared(false);
        this.emExoPlayer.seekTo(0L);
    }

    @Override
    public boolean restart() {
        if (!this.emExoPlayer.restart()) {
            return false;
        }
        this.listenerMux.setNotifiedPrepared(false);
        this.listenerMux.setNotifiedCompleted(false);
        return true;
    }

    @Override
    public boolean setVolume(@FloatRange(from=0.0, to=1.0) float volume) {
        this.emExoPlayer.setVolume(volume);
        return true;
    }

    @Override
    public void seekTo(@IntRange(from=0L) int milliseconds) {
        this.emExoPlayer.seekTo(milliseconds);
    }

    @Override
    public boolean isPlaying() {
        return this.emExoPlayer.getPlayWhenReady();
    }

    @Override
    public void start() {
        this.emExoPlayer.setPlayWhenReady(true);
        this.listenerMux.setNotifiedCompleted(false);
        this.playRequested = true;
    }

    @Override
    public void pause() {
        this.emExoPlayer.setPlayWhenReady(false);
        this.playRequested = false;
    }

    @Override
    public void stopPlayback() {
        this.emExoPlayer.stop();
        this.playRequested = false;
        this.listenerMux.clearSurfaceWhenReady(this);
    }

    @Override
    public void suspend() {
        this.emExoPlayer.release();
        this.playRequested = false;
    }

    @Override
    public int getDuration() {
        if (!this.listenerMux.isPrepared()) {
            return 0;
        }
        return (int)this.emExoPlayer.getDuration();
    }

    @Override
    public int getCurrentPosition() {
        if (!this.listenerMux.isPrepared()) {
            return 0;
        }
        return (int)this.emExoPlayer.getCurrentPosition();
    }

    @Override
    public int getBufferedPercent() {
        return this.emExoPlayer.getBufferedPercentage();
    }

    @Override
    public boolean trackSelectionAvailable() {
        return true;
    }

    @Override
    public void setTrack(int trackType, int trackIndex) {
        this.emExoPlayer.setSelectedTrack(trackType, trackIndex);
    }

    @Override
    @Nullable
    public Map<Integer, List<MediaFormat>> getAvailableTracks() {
        return this.emExoPlayer.getAvailableTracks();
    }

    public void onAudioCapabilitiesChanged(AudioCapabilities audioCapabilities) {
        if (!audioCapabilities.equals((Object)this.audioCapabilities)) {
            this.audioCapabilities = audioCapabilities;
        }
    }

    @Override
    public void release() {
        this.emExoPlayer.release();
        if (this.audioCapabilitiesReceiver != null) {
            this.audioCapabilitiesReceiver.unregister();
            this.audioCapabilitiesReceiver = null;
        }
    }

    @Override
    public void setListenerMux(EMListenerMux listenerMux) {
        this.listenerMux = listenerMux;
        this.emExoPlayer.addListener(listenerMux);
    }

    @Override
    public void onVideoSizeChanged(int width, int height) {
        if (this.updateVideoSize(width, height)) {
            this.requestLayout();
        }
    }

    protected void setup() {
        this.audioCapabilitiesReceiver = new AudioCapabilitiesReceiver(this.getContext().getApplicationContext(), (AudioCapabilitiesReceiver.Listener)this);
        this.audioCapabilitiesReceiver.register();
        this.emExoPlayer = new EMExoPlayer(null);
        this.emExoPlayer.setMetadataListener(null);
        this.setSurfaceTextureListener(new EMExoVideoSurfaceTextureListener());
        this.updateVideoSize(0, 0);
    }

    protected RenderBuilder getRendererBuilder(@NonNull MediaSourceType renderType, @NonNull Uri uri) {
        switch (renderType) {
            case HLS: {
                return new HlsRenderBuilder(this.getContext().getApplicationContext(), this.getUserAgent(), uri.toString());
            }
            case DASH: {
                return new DashRenderBuilder(this.getContext().getApplicationContext(), this.getUserAgent(), uri.toString());
            }
            case SMOOTH_STREAM: {
                return new SmoothStreamRenderBuilder(this.getContext().getApplicationContext(), this.getUserAgent(), uri.toString());
            }
        }
        return new RenderBuilder(this.getContext().getApplicationContext(), this.getUserAgent(), uri.toString());
    }

    public String getUserAgent() {
        return String.format(USER_AGENT_FORMAT, "3.0.0 (30000)", Build.VERSION.RELEASE, Build.MODEL);
    }

    protected class EMExoVideoSurfaceTextureListener
    implements TextureView.SurfaceTextureListener {
        protected EMExoVideoSurfaceTextureListener() {
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            ExoVideoView.this.emExoPlayer.setSurface(new Surface(surfaceTexture));
            if (ExoVideoView.this.playRequested) {
                ExoVideoView.this.emExoPlayer.setPlayWhenReady(true);
            }
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            ExoVideoView.this.emExoPlayer.blockingClearSurface();
            surfaceTexture.release();
            return true;
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }
    }
}

