/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.service;

import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.MediaPlayer;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.os.IBinder;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.devbrackets.android.exomedia.EMAudioPlayer;
import com.devbrackets.android.exomedia.EMLockScreen;
import com.devbrackets.android.exomedia.EMNotification;
import com.devbrackets.android.exomedia.EMVideoView;
import com.devbrackets.android.exomedia.R;
import com.devbrackets.android.exomedia.event.EMMediaProgressEvent;
import com.devbrackets.android.exomedia.event.EMMediaStateEvent;
import com.devbrackets.android.exomedia.event.EMPlaylistItemChangedEvent;
import com.devbrackets.android.exomedia.listener.EMAudioFocusCallback;
import com.devbrackets.android.exomedia.listener.EMPlaylistServiceCallback;
import com.devbrackets.android.exomedia.listener.EMProgressCallback;
import com.devbrackets.android.exomedia.manager.EMPlaylistManager;
import com.devbrackets.android.exomedia.util.EMAudioFocusHelper;
import com.devbrackets.android.exomedia.util.EMEventBus;
import java.util.LinkedList;
import java.util.List;

public abstract class EMPlaylistService<I extends EMPlaylistManager.PlaylistItem, M extends EMPlaylistManager<I>>
extends Service
implements EMAudioFocusCallback,
EMProgressCallback {
    private static final String TAG = "EMPlaylistService";
    public static final String START_SERVICE = "EMPlaylistService.start";
    protected WifiManager.WifiLock wifiLock;
    @Nullable
    protected EMAudioFocusHelper audioFocusHelper;
    @Nullable
    protected EMAudioPlayer audioPlayer;
    @Nullable
    protected EMMediaProgressEvent currentMediaProgress;
    @Nullable
    protected EMNotification notificationHelper;
    @Nullable
    protected EMLockScreen lockScreenHelper;
    protected boolean pausedForFocusLoss = false;
    protected MediaState currentState = MediaState.PREPARING;
    @Nullable
    protected I currentPlaylistItem;
    protected int seekToPosition = -1;
    protected boolean immediatelyPause = false;
    @NonNull
    protected AudioListener audioListener = new AudioListener();
    protected boolean pausedForSeek = false;
    protected boolean foregroundSetup;
    protected boolean notificationSetup;
    protected boolean onCreateCalled = false;
    @Nullable
    protected Intent workaroundIntent = null;
    @Nullable
    protected String currentLargeNotificationUrl;
    @Nullable
    protected String currentLockScreenArtworkUrl;
    @NonNull
    protected List<EMPlaylistServiceCallback> callbackList = new LinkedList<EMPlaylistServiceCallback>();

    protected abstract int getNotificationId();

    protected abstract float getAudioDuckVolume();

    protected abstract M getMediaPlaylistManager();

    protected abstract PendingIntent getNotificationClickPendingIntent();

    protected abstract Bitmap getDefaultLargeNotificationImage();

    @DrawableRes
    protected abstract int getNotificationIconRes();

    @DrawableRes
    protected abstract int getLockScreenIconRes();

    @Nullable
    protected EMEventBus getBus() {
        return null;
    }

    public int getServiceFlag() {
        return 2;
    }

    protected boolean isNetworkAvailable() {
        return true;
    }

    protected boolean isDownloaded(I playlistItem) {
        return false;
    }

    protected void onMediaPlayerResetting() {
    }

    protected void onMediaStopped(I playlistItem) {
    }

    protected void onAudioPlaybackEnded(I playlistItem, long currentPosition, long duration) {
    }

    protected void onAudioPlaybackStarted(I playlistItem, long currentPosition, long duration) {
    }

    protected void onNoNonNetworkItemsAvailable() {
    }

    protected void onAudioPlaybackEnded() {
    }

    @Nullable
    protected Bitmap getLargeNotificationImage() {
        return null;
    }

    @Nullable
    protected Bitmap getLargeNotificationSecondaryImage() {
        return null;
    }

    @Nullable
    protected Bitmap getDefaultLargeNotificationSecondaryImage() {
        return null;
    }

    protected void updateLargeNotificationImage(int size, I playlistItem) {
    }

    @Nullable
    protected Bitmap getLockScreenArtwork() {
        return null;
    }

    protected void updateLockScreenArtwork(I playlistItem) {
    }

    protected boolean isPlaying() {
        if (this.currentItemIsAudio()) {
            return this.audioPlayer != null && this.audioPlayer.isPlaying();
        }
        if (this.currentItemIsVideo()) {
            return ((EMPlaylistManager)this.getMediaPlaylistManager()).getVideoView() != null && ((EMPlaylistManager)this.getMediaPlaylistManager()).getVideoView().isPlaying();
        }
        return false;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        if (this.onCreateCalled) {
            return;
        }
        this.onCreateCalled = true;
        super.onCreate();
        Log.d((String)TAG, (String)"Service Created");
        this.onServiceCreate();
    }

    public void onDestroy() {
        super.onDestroy();
        Log.d((String)TAG, (String)"Service Destroyed");
        this.setMediaState(MediaState.STOPPED);
        this.relaxResources(true);
        ((EMPlaylistManager)this.getMediaPlaylistManager()).unRegisterService();
        if (this.audioFocusHelper != null) {
            this.audioFocusHelper.setAudioFocusCallback(null);
            this.audioFocusHelper = null;
        }
        this.notificationHelper = null;
        this.lockScreenHelper = null;
        this.onCreateCalled = false;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null || intent.getAction() == null) {
            return this.getServiceFlag();
        }
        if (!this.onCreateCalled) {
            Log.d((String)TAG, (String)"Starting Samsung workaround");
            this.workaroundIntent = intent;
            this.onCreate();
            return this.getServiceFlag();
        }
        if ("remote_action_start_service".equals(intent.getAction())) {
            this.startItemPlayback();
            this.seekToPosition = intent.getIntExtra("remote_action_seek_position", -1);
            this.immediatelyPause = intent.getBooleanExtra("remote_action_start_paused", false);
        } else {
            this.handleRemoteAction(intent.getAction(), intent.getExtras());
        }
        return this.getServiceFlag();
    }

    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        this.onDestroy();
    }

    @Override
    public boolean onAudioFocusGained() {
        if (!this.currentItemIsAudio() || this.audioPlayer == null) {
            return false;
        }
        if (!this.audioPlayer.isPlaying() && this.pausedForFocusLoss) {
            this.audioPlayer.start();
            this.updateNotification();
        } else {
            this.audioPlayer.setVolume(1.0f, 1.0f);
        }
        return true;
    }

    @Override
    public boolean onAudioFocusLost(boolean canDuckAudio) {
        if (!this.currentItemIsAudio() || this.audioPlayer == null) {
            return false;
        }
        if (!canDuckAudio) {
            if (this.audioPlayer.isPlaying()) {
                this.pausedForFocusLoss = true;
                this.audioPlayer.pause();
                this.updateNotification();
            }
        } else {
            this.audioPlayer.setVolume(this.getAudioDuckVolume(), this.getAudioDuckVolume());
        }
        return true;
    }

    @Override
    public boolean onProgressUpdated(EMMediaProgressEvent progressEvent) {
        this.currentMediaProgress = progressEvent;
        for (EMPlaylistServiceCallback callback : this.callbackList) {
            if (!callback.onProgressUpdated(progressEvent)) continue;
            return true;
        }
        return false;
    }

    public void registerCallback(EMPlaylistServiceCallback callback) {
        if (callback != null) {
            this.callbackList.add(callback);
        }
    }

    public void unRegisterCallback(EMPlaylistServiceCallback callback) {
        if (callback != null) {
            this.callbackList.remove(callback);
        }
    }

    public MediaState getCurrentMediaState() {
        return this.currentState;
    }

    @Nullable
    public EMMediaProgressEvent getCurrentMediaProgress() {
        return this.currentMediaProgress;
    }

    public EMPlaylistItemChangedEvent<I> getCurrentItemChangedEvent() {
        boolean hasNext = ((EMPlaylistManager)this.getMediaPlaylistManager()).isNextAvailable();
        boolean hasPrevious = ((EMPlaylistManager)this.getMediaPlaylistManager()).isPreviousAvailable();
        return new EMPlaylistItemChangedEvent<I>(this.currentPlaylistItem, hasPrevious, hasNext);
    }

    protected void onServiceCreate() {
        this.audioFocusHelper = new EMAudioFocusHelper(this.getApplicationContext());
        this.audioFocusHelper.setAudioFocusCallback(this);
        this.wifiLock = ((WifiManager)this.getSystemService("wifi")).createWifiLock(1, "mcLock");
        this.wifiLock.setReferenceCounted(false);
        this.notificationHelper = new EMNotification(this.getApplicationContext());
        this.lockScreenHelper = new EMLockScreen(this.getApplicationContext(), this.getClass());
        ((EMPlaylistManager)this.getMediaPlaylistManager()).registerService(this);
        if (this.workaroundIntent != null) {
            this.startService(this.workaroundIntent);
            this.workaroundIntent = null;
        }
    }

    protected void performPlayPause() {
        if (this.isPlaying() || this.pausedForFocusLoss) {
            this.pausedForFocusLoss = false;
            this.performPause();
        } else {
            this.performPlay();
        }
        this.updateLockScreen();
        this.updateNotification();
    }

    protected void performPrevious() {
        this.seekToPosition = 0;
        this.immediatelyPause = !this.isPlaying();
        ((EMPlaylistManager)this.getMediaPlaylistManager()).previous();
        this.startItemPlayback();
    }

    protected void performNext() {
        this.seekToPosition = 0;
        this.immediatelyPause = !this.isPlaying();
        ((EMPlaylistManager)this.getMediaPlaylistManager()).next();
        this.startItemPlayback();
    }

    protected void performRepeat() {
    }

    protected void performShuffle() {
    }

    protected void performMediaCompletion() {
    }

    protected void performSeekStarted() {
        boolean isPlaying = false;
        if (this.currentItemIsAudio()) {
            isPlaying = this.audioPlayer != null && this.audioPlayer.isPlaying();
        } else if (this.currentItemIsVideo()) {
            EMVideoView videoView = ((EMPlaylistManager)this.getMediaPlaylistManager()).getVideoView();
            boolean bl = isPlaying = videoView != null && videoView.isPlaying();
        }
        if (isPlaying) {
            this.pausedForSeek = true;
            this.performPause();
        }
    }

    protected void performSeekEnded(int newPosition) {
        this.performSeek(newPosition);
        if (this.pausedForSeek) {
            this.performPlay();
            this.pausedForSeek = false;
        }
    }

    protected void updateAllowedMediaType(EMPlaylistManager.MediaType newType) {
        if (newType != EMPlaylistManager.MediaType.AUDIO_AND_VIDEO && this.currentPlaylistItem != null && newType != this.currentPlaylistItem.getMediaType()) {
            this.performNext();
        }
    }

    protected void postPlaylistItemChanged() {
        boolean hasNext = ((EMPlaylistManager)this.getMediaPlaylistManager()).isNextAvailable();
        boolean hasPrevious = ((EMPlaylistManager)this.getMediaPlaylistManager()).isPreviousAvailable();
        for (EMPlaylistServiceCallback callback : this.callbackList) {
            if (!callback.onPlaylistItemChanged((EMPlaylistManager.PlaylistItem)this.currentPlaylistItem, hasNext, hasPrevious)) continue;
            return;
        }
        EMEventBus bus = this.getBus();
        if (bus != null) {
            bus.post(new EMPlaylistItemChangedEvent<I>(this.currentPlaylistItem, hasPrevious, hasNext));
        }
    }

    protected void postMediaStateChanged() {
        for (EMPlaylistServiceCallback callback : this.callbackList) {
            if (!callback.onMediaStateChanged(this.currentState)) continue;
            return;
        }
        EMEventBus bus = this.getBus();
        if (bus != null) {
            bus.post(new EMMediaStateEvent(this.currentState));
        }
    }

    protected void performStop() {
        this.setMediaState(MediaState.STOPPED);
        if (this.currentPlaylistItem != null) {
            this.onMediaStopped(this.currentPlaylistItem);
        }
        this.relaxResources(true);
        ((EMPlaylistManager)this.getMediaPlaylistManager()).setParameters(null, 0);
        ((EMPlaylistManager)this.getMediaPlaylistManager()).setPlaylistId(-1L);
        this.stopSelf();
    }

    protected void performSeek(int position) {
        EMVideoView videoView;
        if (this.currentItemIsAudio() && this.audioPlayer != null) {
            this.audioPlayer.seekTo(position);
        } else if (this.currentItemIsVideo() && (videoView = ((EMPlaylistManager)this.getMediaPlaylistManager()).getVideoView()) != null) {
            videoView.seekTo(position);
        }
    }

    protected void performPause() {
        EMVideoView videoView;
        if (this.currentItemIsAudio()) {
            if (this.audioPlayer != null) {
                this.audioPlayer.pause();
            }
        } else if (this.currentItemIsVideo() && (videoView = ((EMPlaylistManager)this.getMediaPlaylistManager()).getVideoView()) != null) {
            videoView.pause();
        }
        this.setMediaState(MediaState.PAUSED);
        this.stopForeground();
    }

    protected void performPlay() {
        EMVideoView videoView;
        if (this.currentItemIsAudio()) {
            if (this.audioPlayer != null) {
                this.audioPlayer.start();
            }
        } else if (this.currentItemIsVideo() && (videoView = ((EMPlaylistManager)this.getMediaPlaylistManager()).getVideoView()) != null) {
            videoView.start();
        }
        this.setMediaState(MediaState.PLAYING);
        this.setupForeground();
    }

    protected boolean currentItemIsAudio() {
        return this.currentPlaylistItem != null && this.currentPlaylistItem.getMediaType() == EMPlaylistManager.MediaType.AUDIO;
    }

    protected boolean currentItemIsVideo() {
        return this.currentPlaylistItem != null && this.currentPlaylistItem.getMediaType() == EMPlaylistManager.MediaType.VIDEO;
    }

    protected boolean currentItemIsOther() {
        return this.currentPlaylistItem != null && this.currentPlaylistItem.getMediaType() == EMPlaylistManager.MediaType.OTHER;
    }

    protected void onLargeNotificationImageUpdated() {
        this.updateNotification();
    }

    protected void onLockScreenArtworkUpdated() {
        this.updateLockScreen();
    }

    protected void setupForeground() {
        if (!this.foregroundSetup && this.notificationSetup && this.notificationHelper != null) {
            this.foregroundSetup = true;
            this.startForeground(this.getNotificationId(), this.notificationHelper.getNotification(this.getNotificationClickPendingIntent(), this.getClass()));
        }
    }

    protected void stopForeground() {
        if (this.foregroundSetup) {
            this.foregroundSetup = false;
            this.stopForeground(false);
        }
    }

    protected void startItemPlayback() {
        if (this.currentItemIsAudio()) {
            this.onAudioPlaybackEnded();
        }
        this.seekToNextPlayableItem();
        this.mediaItemChanged();
        if (this.currentItemIsAudio()) {
            this.audioListener.resetRetryCount();
            this.playAudioItem();
        } else if (this.currentItemIsVideo()) {
            this.playVideoItem();
        } else if (this.currentItemIsOther()) {
            this.playOtherItem();
        } else if (((EMPlaylistManager)this.getMediaPlaylistManager()).isNextAvailable()) {
            this.performNext();
        } else {
            this.performStop();
        }
    }

    protected void playAudioItem() {
        this.stopVideoPlayback();
        this.initializeAudioPlayer();
        if (this.audioFocusHelper != null) {
            this.audioFocusHelper.requestFocus();
        }
        this.audioPlayer.setAudioStreamType(3);
        boolean isItemDownloaded = this.isDownloaded(this.currentPlaylistItem);
        this.audioPlayer.setDataSource((Context)this, Uri.parse((String)(isItemDownloaded ? this.currentPlaylistItem.getDownloadedMediaUri() : this.currentPlaylistItem.getMediaUrl())));
        this.setMediaState(MediaState.PREPARING);
        this.setupAsForeground();
        this.audioPlayer.prepareAsync();
        if (!isItemDownloaded) {
            this.wifiLock.acquire();
        } else if (this.wifiLock.isHeld()) {
            this.wifiLock.release();
        }
    }

    protected void playVideoItem() {
        this.stopAudioPlayback();
        this.setupAsForeground();
        EMVideoView videoView = ((EMPlaylistManager)this.getMediaPlaylistManager()).getVideoView();
        if (videoView != null) {
            videoView.stopPlayback();
            boolean isItemDownloaded = this.isDownloaded(this.currentPlaylistItem);
            videoView.setVideoURI(Uri.parse((String)(isItemDownloaded ? this.currentPlaylistItem.getDownloadedMediaUri() : this.currentPlaylistItem.getMediaUrl())));
        }
    }

    protected void playOtherItem() {
    }

    protected void stopAudioPlayback() {
        if (this.audioFocusHelper != null) {
            this.audioFocusHelper.abandonFocus();
        }
        if (this.audioPlayer != null) {
            this.audioPlayer.stopPlayback();
            this.audioPlayer.reset();
        }
    }

    protected void stopVideoPlayback() {
        EMVideoView videoView = ((EMPlaylistManager)this.getMediaPlaylistManager()).getVideoView();
        if (videoView != null) {
            videoView.stopPlayback();
            videoView.reset();
        }
    }

    protected void startAudioPlayer() {
        if (this.audioPlayer == null) {
            return;
        }
        if (this.audioFocusHelper == null || this.audioFocusHelper.getCurrentAudioFocus() == EMAudioFocusHelper.Focus.NO_FOCUS_NO_DUCK) {
            if (this.audioPlayer.isPlaying()) {
                this.audioPlayer.pause();
                this.onAudioPlaybackEnded(this.currentPlaylistItem, this.audioPlayer.getCurrentPosition(), this.audioPlayer.getDuration());
            }
            return;
        }
        if (this.audioFocusHelper.getCurrentAudioFocus() == EMAudioFocusHelper.Focus.NO_FOCUS_CAN_DUCK) {
            this.audioPlayer.setVolume(this.getAudioDuckVolume(), this.getAudioDuckVolume());
        } else {
            this.audioPlayer.setVolume(1.0f, 1.0f);
        }
        if (!this.audioPlayer.isPlaying()) {
            this.audioPlayer.start();
            this.onAudioPlaybackStarted(this.currentPlaylistItem, this.audioPlayer.getCurrentPosition(), this.audioPlayer.getDuration());
        }
    }

    protected void relaxResources(boolean releaseAudioPlayer) {
        this.stopForeground(true);
        this.foregroundSetup = false;
        if (this.notificationHelper != null) {
            this.notificationHelper.release();
        }
        if (this.lockScreenHelper != null) {
            this.lockScreenHelper.release();
        }
        this.notificationSetup = false;
        if (releaseAudioPlayer) {
            if (this.audioPlayer != null) {
                this.audioPlayer.reset();
                this.audioPlayer.release();
                this.audioPlayer = null;
            }
            ((EMPlaylistManager)this.getMediaPlaylistManager()).setCurrentIndex(Integer.MAX_VALUE);
        }
        if (this.wifiLock.isHeld()) {
            this.wifiLock.release();
        }
        if (this.audioFocusHelper != null) {
            this.audioFocusHelper.abandonFocus();
        }
    }

    protected void setMediaState(MediaState state) {
        this.currentState = state;
        this.postMediaStateChanged();
    }

    protected void seekToNextPlayableItem() {
        Object currentItem = ((EMPlaylistManager)this.getMediaPlaylistManager()).getCurrentItem();
        if (currentItem == null) {
            this.currentPlaylistItem = null;
            return;
        }
        if (!this.isNetworkAvailable()) {
            while (currentItem != null && !this.isDownloaded(currentItem)) {
                currentItem = ((EMPlaylistManager)this.getMediaPlaylistManager()).next();
            }
        }
        if (currentItem == null) {
            this.onNoNonNetworkItemsAvailable();
        }
        this.currentPlaylistItem = ((EMPlaylistManager)this.getMediaPlaylistManager()).getCurrentItem();
    }

    protected void setupAsForeground() {
        if (this.lockScreenHelper != null) {
            this.lockScreenHelper.setLockScreenEnabled(true);
            this.lockScreenHelper.setLockScreenBaseInformation(this.getLockScreenIconRes());
        }
        if (this.notificationHelper != null) {
            this.notificationHelper.setNotificationsEnabled(true);
            this.notificationHelper.setNotificationBaseInformation(this.getNotificationId(), this.getNotificationIconRes(), this.getClass());
        }
        this.notificationSetup = true;
        this.setupForeground();
        this.updateLockScreen();
        this.updateNotification();
    }

    protected void updateNotification() {
        Bitmap secondaryImage;
        if (this.currentPlaylistItem == null || !this.notificationSetup || this.notificationHelper == null) {
            return;
        }
        EMNotification.NotificationMediaState mediaState = new EMNotification.NotificationMediaState();
        mediaState.setNextEnabled(((EMPlaylistManager)this.getMediaPlaylistManager()).isNextAvailable());
        mediaState.setPreviousEnabled(((EMPlaylistManager)this.getMediaPlaylistManager()).isPreviousAvailable());
        mediaState.setPlaying(this.isPlaying());
        Bitmap bitmap = this.getLargeNotificationImage();
        if (bitmap == null) {
            bitmap = this.getDefaultLargeNotificationImage();
        }
        if ((secondaryImage = this.getLargeNotificationSecondaryImage()) == null) {
            secondaryImage = this.getDefaultLargeNotificationSecondaryImage();
        }
        String title = this.currentPlaylistItem.getTitle();
        String album = this.currentPlaylistItem.getAlbum();
        String artist = this.currentPlaylistItem.getArtist();
        this.notificationHelper.setClickPendingIntent(this.getNotificationClickPendingIntent());
        this.notificationHelper.updateNotificationInformation(title, album, artist, bitmap, secondaryImage, mediaState);
    }

    protected void updateLockScreen() {
        if (this.currentPlaylistItem == null || !this.notificationSetup || this.lockScreenHelper == null) {
            return;
        }
        EMNotification.NotificationMediaState mediaState = new EMNotification.NotificationMediaState();
        mediaState.setNextEnabled(((EMPlaylistManager)this.getMediaPlaylistManager()).isNextAvailable());
        mediaState.setPreviousEnabled(((EMPlaylistManager)this.getMediaPlaylistManager()).isPreviousAvailable());
        mediaState.setPlaying(this.isPlaying());
        String title = this.currentPlaylistItem.getTitle();
        String album = this.currentPlaylistItem.getAlbum();
        String artist = this.currentPlaylistItem.getArtist();
        this.lockScreenHelper.updateLockScreenInformation(title, album, artist, this.getLockScreenArtwork(), mediaState);
    }

    protected void mediaItemChanged() {
        if (!((EMPlaylistManager)this.getMediaPlaylistManager()).isPlayingItem(this.currentPlaylistItem)) {
            Log.d((String)TAG, (String)"forcing currentPlaylistItem update");
            this.currentPlaylistItem = ((EMPlaylistManager)this.getMediaPlaylistManager()).getCurrentItem();
        }
        if (!(this.currentPlaylistItem == null || this.currentLargeNotificationUrl != null && this.currentLargeNotificationUrl.equals(this.currentPlaylistItem.getThumbnailUrl()))) {
            int size = this.getResources().getDimensionPixelSize(R.dimen.exomedia_big_notification_height);
            this.updateLargeNotificationImage(size, this.currentPlaylistItem);
            this.currentLargeNotificationUrl = this.currentPlaylistItem.getThumbnailUrl();
        }
        if (!(this.currentPlaylistItem == null || this.currentLockScreenArtworkUrl != null && this.currentLockScreenArtworkUrl.equalsIgnoreCase(this.currentPlaylistItem.getArtworkUrl()))) {
            this.updateLockScreenArtwork(this.currentPlaylistItem);
            this.currentLockScreenArtworkUrl = this.currentPlaylistItem.getArtworkUrl();
        }
        this.postPlaylistItemChanged();
    }

    protected void handleRemoteAction(String action, Bundle extras) {
        if (action == null || action.isEmpty()) {
            return;
        }
        switch (action) {
            case "remote_action_play_pause": {
                this.performPlayPause();
                break;
            }
            case "remote_action_next": {
                this.performNext();
                break;
            }
            case "remote_action_previous": {
                this.performPrevious();
                break;
            }
            case "remote_action_repeat": {
                this.performRepeat();
                break;
            }
            case "remote_action_shuffle": {
                this.performShuffle();
                break;
            }
            case "remote_action_stop": {
                this.performStop();
                break;
            }
            case "remote_action_seek_started": {
                this.performSeekStarted();
                break;
            }
            case "remote_action_seek_ended": {
                this.performSeekEnded(extras.getInt("remote_action_seek_position", 0));
                break;
            }
            case "remote_action_allowed_type_changed": {
                this.updateAllowedMediaType((EMPlaylistManager.MediaType)((Object)extras.getSerializable("remote_action_allowed_type")));
                break;
            }
        }
    }

    protected void initializeAudioPlayer() {
        if (this.audioPlayer != null) {
            this.audioPlayer.reset();
            return;
        }
        this.audioPlayer = new EMAudioPlayer(this.getApplicationContext());
        this.audioPlayer.setBus(this.getBus());
        this.audioPlayer.startProgressPoll(this);
        this.audioPlayer.setWakeMode(this.getApplicationContext(), 1);
        this.audioPlayer.setOnPreparedListener(this.audioListener);
        this.audioPlayer.setOnCompletionListener(this.audioListener);
        this.audioPlayer.setOnErrorListener(this.audioListener);
    }

    private class AudioListener
    implements MediaPlayer.OnPreparedListener,
    MediaPlayer.OnCompletionListener,
    MediaPlayer.OnErrorListener {
        private static final int MAX_RETRY_COUNT = 1;
        private int retryCount = 0;

        private AudioListener() {
        }

        public void onCompletion(MediaPlayer mp) {
            if (EMPlaylistService.this.currentItemIsAudio()) {
                EMPlaylistService.this.performMediaCompletion();
            }
        }

        public boolean onError(MediaPlayer mp, int what, int extra) {
            if (!EMPlaylistService.this.currentItemIsAudio()) {
                return false;
            }
            if (++this.retryCount <= 1) {
                Log.d((String)EMPlaylistService.TAG, (String)("Retrying audio playback.  Retry count: " + this.retryCount));
                EMPlaylistService.this.playAudioItem();
                return false;
            }
            EMPlaylistService.this.onMediaPlayerResetting();
            Log.e((String)EMPlaylistService.TAG, (String)("MediaPlayer Error: what=" + what + ", extra=" + extra));
            EMPlaylistService.this.setMediaState(MediaState.ERROR);
            EMPlaylistService.this.relaxResources(true);
            return false;
        }

        public void onPrepared(MediaPlayer mp) {
            if (!EMPlaylistService.this.currentItemIsAudio()) {
                return;
            }
            this.retryCount = 0;
            EMPlaylistService.this.setMediaState(MediaState.PLAYING);
            EMPlaylistService.this.startAudioPlayer();
            if (EMPlaylistService.this.immediatelyPause) {
                EMPlaylistService.this.immediatelyPause = false;
                if (EMPlaylistService.this.audioPlayer != null && EMPlaylistService.this.audioPlayer.isPlaying()) {
                    EMPlaylistService.this.performPause();
                }
            }
            if (EMPlaylistService.this.seekToPosition > 0) {
                EMPlaylistService.this.performSeek(EMPlaylistService.this.seekToPosition);
                EMPlaylistService.this.seekToPosition = -1;
            }
            EMPlaylistService.this.updateLockScreen();
            EMPlaylistService.this.updateNotification();
        }

        public void resetRetryCount() {
            this.retryCount = 0;
        }
    }

    public static enum MediaState {
        RETRIEVING,
        STOPPED,
        PREPARING,
        PLAYING,
        PAUSED,
        ERROR;

    }
}

