/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.exoplayer;

import android.content.Context;
import android.media.MediaCodec;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.view.Surface;
import com.devbrackets.android.exomedia.builder.RenderBuilder;
import com.devbrackets.android.exomedia.listener.CaptionListener;
import com.devbrackets.android.exomedia.listener.ExoPlayerListener;
import com.devbrackets.android.exomedia.listener.Id3MetadataListener;
import com.devbrackets.android.exomedia.listener.InfoListener;
import com.devbrackets.android.exomedia.listener.InternalErrorListener;
import com.devbrackets.android.exomedia.renderer.EMMediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.DummyTrackRenderer;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.ExoPlayer;
import com.google.android.exoplayer.MediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.MediaCodecTrackRenderer;
import com.google.android.exoplayer.MediaCodecVideoTrackRenderer;
import com.google.android.exoplayer.TimeRange;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.audio.AudioTrack;
import com.google.android.exoplayer.chunk.ChunkSampleSource;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.dash.DashChunkSource;
import com.google.android.exoplayer.drm.StreamingDrmSessionManager;
import com.google.android.exoplayer.hls.HlsSampleSource;
import com.google.android.exoplayer.metadata.MetadataTrackRenderer;
import com.google.android.exoplayer.text.Cue;
import com.google.android.exoplayer.text.TextRenderer;
import com.google.android.exoplayer.upstream.BandwidthMeter;
import com.google.android.exoplayer.util.PlayerControl;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class EMExoPlayer
implements ExoPlayer.Listener,
ChunkSampleSource.EventListener,
HlsSampleSource.EventListener,
BandwidthMeter.EventListener,
MediaCodecVideoTrackRenderer.EventListener,
MediaCodecAudioTrackRenderer.EventListener,
StreamingDrmSessionManager.EventListener,
DashChunkSource.EventListener,
MetadataTrackRenderer.MetadataRenderer<Map<String, Object>>,
TextRenderer {
    public static final int DISABLED_TRACK = -1;
    public static final int RENDER_COUNT = 4;
    public static final int RENDER_VIDEO = 0;
    public static final int RENDER_AUDIO = 1;
    public static final int RENDER_CLOSED_CAPTION = 2;
    public static final int RENDER_TIMED_METADATA = 3;
    public static final int BUFFER_LENGTH_MIN = 1000;
    public static final int REBUFFER_LENGTH_MIN = 5000;
    private RenderBuilder rendererBuilder;
    private final ExoPlayer player;
    private final PlayerControl playerControl;
    private final Handler mainHandler;
    private final CopyOnWriteArrayList<ExoPlayerListener> listeners;
    private RenderBuildingState rendererBuildingState;
    private int lastReportedPlaybackState;
    private boolean lastReportedPlayWhenReady;
    private boolean prepared = false;
    private Surface surface;
    private TrackRenderer videoRenderer;
    private TrackRenderer audioRenderer;
    private CaptionListener captionListener;
    private Id3MetadataListener id3MetadataListener;
    private InternalErrorListener internalErrorListener;
    private InfoListener infoListener;
    private PowerManager.WakeLock wakeLock = null;

    public EMExoPlayer() {
        this(null);
    }

    public EMExoPlayer(RenderBuilder rendererBuilder) {
        this.rendererBuilder = rendererBuilder;
        this.player = ExoPlayer.Factory.newInstance((int)4, (int)1000, (int)5000);
        this.player.addListener((ExoPlayer.Listener)this);
        this.playerControl = new PlayerControl(this.player);
        this.mainHandler = new Handler();
        this.listeners = new CopyOnWriteArrayList();
        this.lastReportedPlaybackState = 1;
        this.rendererBuildingState = RenderBuildingState.IDLE;
        this.player.setSelectedTrack(2, -1);
    }

    public void replaceRenderBuilder(RenderBuilder renderBuilder) {
        this.rendererBuilder = renderBuilder;
        this.prepared = false;
        this.prepare();
    }

    public PlayerControl getPlayerControl() {
        return this.playerControl;
    }

    public void addListener(ExoPlayerListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(ExoPlayerListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void setInternalErrorListener(InternalErrorListener listener) {
        this.internalErrorListener = listener;
    }

    public void setInfoListener(InfoListener listener) {
        this.infoListener = listener;
    }

    public void setCaptionListener(CaptionListener listener) {
        this.captionListener = listener;
    }

    public void setMetadataListener(Id3MetadataListener listener) {
        this.id3MetadataListener = listener;
    }

    public void setSurface(Surface surface) {
        this.surface = surface;
        this.pushSurface(false);
    }

    public Surface getSurface() {
        return this.surface;
    }

    public void blockingClearSurface() {
        this.surface = null;
        this.pushSurface(true);
    }

    public int getTrackCount(int type) {
        return this.player.getTrackCount(type);
    }

    public int getSelectedTrack(int type) {
        return this.player.getSelectedTrack(type);
    }

    public void setSelectedTrack(int type, int index) {
        this.player.setSelectedTrack(type, index);
        if (type == 2 && index == -1 && this.captionListener != null) {
            this.captionListener.onCues(Collections.emptyList());
        }
    }

    public void setVolume(float volume) {
        this.player.sendMessage((ExoPlayer.ExoPlayerComponent)this.audioRenderer, 1, (Object)Float.valueOf(volume));
    }

    public void forcePrepare() {
        this.prepared = false;
    }

    public void prepare() {
        if (this.prepared || this.rendererBuilder == null) {
            return;
        }
        if (this.rendererBuildingState == RenderBuildingState.BUILT) {
            this.player.stop();
        }
        this.videoRenderer = null;
        this.rendererBuildingState = RenderBuildingState.BUILDING;
        this.reportPlayerState();
        this.rendererBuilder.buildRenderers(this);
        this.prepared = true;
    }

    public void onRenderers(TrackRenderer[] renderers, @Nullable BandwidthMeter bandwidthMeter) {
        for (int i = 0; i < 4; ++i) {
            if (renderers[i] != null) continue;
            renderers[i] = new DummyTrackRenderer();
        }
        this.videoRenderer = renderers[0];
        this.audioRenderer = renderers[1];
        this.pushSurface(false);
        this.player.prepare(renderers);
        this.rendererBuildingState = RenderBuildingState.BUILT;
    }

    public void onRenderersError(Exception e) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onRendererInitializationError(e);
        }
        for (ExoPlayerListener listener : this.listeners) {
            listener.onError(e);
        }
        this.rendererBuildingState = RenderBuildingState.IDLE;
        this.reportPlayerState();
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        this.player.setPlayWhenReady(playWhenReady);
        this.stayAwake(playWhenReady);
    }

    public void seekTo(long positionMs) {
        this.player.seekTo(positionMs);
    }

    public void stop() {
        this.player.setPlayWhenReady(false);
        this.player.stop();
    }

    public void release() {
        if (this.rendererBuilder != null) {
            this.rendererBuilder.cancel();
        }
        this.rendererBuildingState = RenderBuildingState.IDLE;
        this.surface = null;
        this.player.release();
        this.stayAwake(false);
    }

    public int getPlaybackState() {
        if (this.rendererBuildingState == RenderBuildingState.BUILDING) {
            return 2;
        }
        return this.player.getPlaybackState();
    }

    public int getAudioSessionId() {
        if (this.audioRenderer != null) {
            return ((EMMediaCodecAudioTrackRenderer)this.audioRenderer).getAudioSessionId();
        }
        return 0;
    }

    public long getCurrentPosition() {
        return this.player.getCurrentPosition();
    }

    public long getDuration() {
        return this.player.getDuration();
    }

    public int getBufferedPercentage() {
        return this.player.getBufferedPercentage();
    }

    public boolean getPlayWhenReady() {
        return this.player.getPlayWhenReady();
    }

    public Looper getPlaybackLooper() {
        return this.player.getPlaybackLooper();
    }

    public Handler getMainHandler() {
        return this.mainHandler;
    }

    public void setWakeMode(Context context, int mode) {
        boolean wasHeld = false;
        if (this.wakeLock != null) {
            if (this.wakeLock.isHeld()) {
                wasHeld = true;
                this.wakeLock.release();
            }
            this.wakeLock = null;
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.wakeLock = pm.newWakeLock(mode | 0x20000000, EMExoPlayer.class.getName());
        this.wakeLock.setReferenceCounted(false);
        if (wasHeld) {
            this.wakeLock.acquire();
        }
    }

    protected void stayAwake(boolean awake) {
        if (this.wakeLock != null) {
            if (awake && !this.wakeLock.isHeld()) {
                this.wakeLock.acquire();
            } else if (!awake && this.wakeLock.isHeld()) {
                this.wakeLock.release();
            }
        }
    }

    public void onPlayerStateChanged(boolean playWhenReady, int state) {
        this.reportPlayerState();
    }

    public void onPlayerError(ExoPlaybackException exception) {
        this.rendererBuildingState = RenderBuildingState.IDLE;
        for (ExoPlayerListener listener : this.listeners) {
            listener.onError((Exception)exception);
        }
    }

    public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
        for (ExoPlayerListener listener : this.listeners) {
            listener.onVideoSizeChanged(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
        }
    }

    public void onDroppedFrames(int count, long elapsed) {
        if (this.infoListener != null) {
            this.infoListener.onDroppedFrames(count, elapsed);
        }
    }

    public void onBandwidthSample(int elapsedMs, long bytes, long bitrateEstimate) {
        if (this.infoListener != null) {
            this.infoListener.onBandwidthSample(elapsedMs, bytes, bitrateEstimate);
        }
    }

    public void onDownstreamFormatChanged(int sourceId, Format format, int trigger, long mediaTimeMs) {
        if (this.infoListener == null) {
            return;
        }
        if (sourceId == 0) {
            this.infoListener.onVideoFormatEnabled(format, trigger, mediaTimeMs);
        } else if (sourceId == 1) {
            this.infoListener.onAudioFormatEnabled(format, trigger, mediaTimeMs);
        }
    }

    public void onDrmKeysLoaded() {
    }

    public void onDrmSessionManagerError(Exception e) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onDrmSessionManagerError(e);
        }
    }

    public void onDecoderInitializationError(MediaCodecTrackRenderer.DecoderInitializationException e) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onDecoderInitializationError(e);
        }
    }

    public void onDecoderInitialized(String decoderName, long elapsedRealtimeMs, long initializationDurationMs) {
        if (this.infoListener != null) {
            this.infoListener.onDecoderInitialized(decoderName, elapsedRealtimeMs, initializationDurationMs);
        }
    }

    public void onAudioTrackInitializationError(AudioTrack.InitializationException e) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onAudioTrackInitializationError(e);
        }
    }

    public void onAudioTrackWriteError(AudioTrack.WriteException e) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onAudioTrackWriteError(e);
        }
    }

    public void onAudioTrackUnderrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onAudioTrackUnderrun(bufferSize, bufferSizeMs, elapsedSinceLastFeedMs);
        }
    }

    public void onCryptoError(MediaCodec.CryptoException e) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onCryptoError(e);
        }
    }

    public void onLoadError(int sourceId, IOException e) {
        if (this.internalErrorListener != null) {
            this.internalErrorListener.onLoadError(sourceId, e);
        }
    }

    public void onCues(List<Cue> cues) {
        if (this.captionListener != null && this.getSelectedTrack(2) != -1) {
            this.captionListener.onCues(cues);
        }
    }

    public void onMetadata(Map<String, Object> metadata) {
        if (this.id3MetadataListener != null && this.getSelectedTrack(3) != -1) {
            this.id3MetadataListener.onId3Metadata(metadata);
        }
    }

    public void onAvailableRangeChanged(int sourceId, TimeRange availableRange) {
        if (this.infoListener != null) {
            this.infoListener.onAvailableRangeChanged(sourceId, availableRange);
        }
    }

    public void onPlayWhenReadyCommitted() {
    }

    public void onDrawnToSurface(Surface surface) {
    }

    public void onLoadStarted(int sourceId, long length, int type, int trigger, Format format, long mediaStartTimeMs, long mediaEndTimeMs) {
        if (this.infoListener != null) {
            this.infoListener.onLoadStarted(sourceId, length, type, trigger, format, mediaStartTimeMs, mediaEndTimeMs);
        }
    }

    public void onLoadCompleted(int sourceId, long bytesLoaded, int type, int trigger, Format format, long mediaStartTimeMs, long mediaEndTimeMs, long elapsedRealtimeMs, long loadDurationMs) {
        if (this.infoListener != null) {
            this.infoListener.onLoadCompleted(sourceId, bytesLoaded, type, trigger, format, mediaStartTimeMs, mediaEndTimeMs, elapsedRealtimeMs, loadDurationMs);
        }
    }

    public void onLoadCanceled(int sourceId, long bytesLoaded) {
    }

    public void onUpstreamDiscarded(int sourceId, long mediaStartTimeMs, long mediaEndTimeMs) {
    }

    private void reportPlayerState() {
        boolean playWhenReady = this.player.getPlayWhenReady();
        int playbackState = this.getPlaybackState();
        if (this.lastReportedPlayWhenReady != playWhenReady || this.lastReportedPlaybackState != playbackState) {
            for (ExoPlayerListener listener : this.listeners) {
                listener.onStateChanged(playWhenReady, playbackState);
            }
            this.lastReportedPlayWhenReady = playWhenReady;
            this.lastReportedPlaybackState = playbackState;
        }
    }

    private void pushSurface(boolean blockForSurfacePush) {
        if (this.videoRenderer == null) {
            return;
        }
        if (blockForSurfacePush) {
            this.player.blockingSendMessage((ExoPlayer.ExoPlayerComponent)this.videoRenderer, 1, (Object)this.surface);
        } else {
            this.player.sendMessage((ExoPlayer.ExoPlayerComponent)this.videoRenderer, 1, (Object)this.surface);
        }
    }

    public static enum RenderBuildingState {
        IDLE,
        BUILDING,
        BUILT;

    }
}

