/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.builder;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Handler;
import com.devbrackets.android.exomedia.builder.RenderBuilder;
import com.devbrackets.android.exomedia.exoplayer.EMExoPlayer;
import com.devbrackets.android.exomedia.renderer.EMMediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.DefaultLoadControl;
import com.google.android.exoplayer.LoadControl;
import com.google.android.exoplayer.MediaCodecSelector;
import com.google.android.exoplayer.MediaCodecUtil;
import com.google.android.exoplayer.MediaCodecVideoTrackRenderer;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.chunk.VideoFormatSelectorUtil;
import com.google.android.exoplayer.hls.DefaultHlsTrackSelector;
import com.google.android.exoplayer.hls.HlsChunkSource;
import com.google.android.exoplayer.hls.HlsMasterPlaylist;
import com.google.android.exoplayer.hls.HlsPlaylist;
import com.google.android.exoplayer.hls.HlsPlaylistParser;
import com.google.android.exoplayer.hls.HlsSampleSource;
import com.google.android.exoplayer.hls.HlsTrackSelector;
import com.google.android.exoplayer.hls.PtsTimestampAdjusterProvider;
import com.google.android.exoplayer.metadata.Id3Parser;
import com.google.android.exoplayer.metadata.MetadataParser;
import com.google.android.exoplayer.metadata.MetadataTrackRenderer;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.TextRenderer;
import com.google.android.exoplayer.text.TextTrackRenderer;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.upstream.BandwidthMeter;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DefaultAllocator;
import com.google.android.exoplayer.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer.upstream.DefaultUriDataSource;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.upstream.UriDataSource;
import com.google.android.exoplayer.upstream.UriLoadable;
import com.google.android.exoplayer.util.ManifestFetcher;
import java.io.IOException;
import java.util.List;

@TargetApi(value=16)
public class HlsRenderBuilder
extends RenderBuilder {
    private final Context context;
    private final String userAgent;
    private final String url;
    private final int streamType;
    private AsyncRendererBuilder currentAsyncBuilder;

    public HlsRenderBuilder(Context context, String userAgent, String url) {
        this(context, userAgent, url, 3);
    }

    public HlsRenderBuilder(Context context, String userAgent, String url, int streamType) {
        super(context, userAgent, url);
        this.context = context;
        this.userAgent = userAgent;
        this.url = url;
        this.streamType = streamType;
    }

    @Override
    public void buildRenderers(EMExoPlayer player) {
        this.currentAsyncBuilder = new AsyncRendererBuilder(this.context, this.userAgent, this.url, player, this.streamType);
        this.currentAsyncBuilder.init();
    }

    @Override
    public void cancel() {
        if (this.currentAsyncBuilder != null) {
            this.currentAsyncBuilder.cancel();
            this.currentAsyncBuilder = null;
        }
    }

    private static final class AsyncRendererBuilder
    implements ManifestFetcher.ManifestCallback<HlsPlaylist> {
        private final Context context;
        private final String userAgent;
        private final String url;
        private final int streamType;
        private final EMExoPlayer player;
        private final ManifestFetcher<HlsPlaylist> playlistFetcher;
        private boolean canceled;

        public AsyncRendererBuilder(Context context, String userAgent, String url, EMExoPlayer player, int streamType) {
            this.context = context;
            this.userAgent = userAgent;
            this.url = url;
            this.streamType = streamType;
            this.player = player;
            HlsPlaylistParser parser = new HlsPlaylistParser();
            this.playlistFetcher = new ManifestFetcher(url, (UriDataSource)new DefaultUriDataSource(context, userAgent), (UriLoadable.Parser)parser);
        }

        public void init() {
            this.playlistFetcher.singleLoad(this.player.getMainHandler().getLooper(), (ManifestFetcher.ManifestCallback)this);
        }

        public void cancel() {
            this.canceled = true;
        }

        public void onSingleManifestError(IOException e) {
            if (this.canceled) {
                return;
            }
            this.player.onRenderersError(e);
        }

        public void onSingleManifest(HlsPlaylist playlist) {
            if (this.canceled) {
                return;
            }
            this.buildRenderers(playlist);
        }

        private void buildRenderers(HlsPlaylist playlist) {
            Handler mainHandler = this.player.getMainHandler();
            DefaultLoadControl loadControl = new DefaultLoadControl((Allocator)new DefaultAllocator(65536));
            DefaultBandwidthMeter bandwidthMeter = new DefaultBandwidthMeter(mainHandler, (BandwidthMeter.EventListener)this.player);
            PtsTimestampAdjusterProvider timestampAdjusterProvider = new PtsTimestampAdjusterProvider();
            if (playlist instanceof HlsMasterPlaylist) {
                int[] variantIndices;
                HlsMasterPlaylist masterPlaylist = (HlsMasterPlaylist)playlist;
                try {
                    variantIndices = VideoFormatSelectorUtil.selectVideoFormatsForDefaultDisplay((Context)this.context, (List)masterPlaylist.variants, null, (boolean)false);
                }
                catch (MediaCodecUtil.DecoderQueryException e) {
                    this.player.onRenderersError((Exception)((Object)e));
                    return;
                }
                if (variantIndices.length == 0) {
                    this.player.onRenderersError(new IllegalStateException("No variants selected."));
                    return;
                }
            }
            DefaultUriDataSource dataSource = new DefaultUriDataSource(this.context, (TransferListener)bandwidthMeter, this.userAgent, true);
            HlsChunkSource chunkSource = new HlsChunkSource(true, (DataSource)dataSource, this.url, playlist, (HlsTrackSelector)DefaultHlsTrackSelector.newDefaultInstance((Context)this.context), (BandwidthMeter)bandwidthMeter, timestampAdjusterProvider, 1);
            HlsSampleSource sampleSource = new HlsSampleSource(chunkSource, (LoadControl)loadControl, 0x1000000, mainHandler, (HlsSampleSource.EventListener)this.player, 0);
            MediaCodecVideoTrackRenderer videoRenderer = new MediaCodecVideoTrackRenderer(this.context, (SampleSource)sampleSource, MediaCodecSelector.DEFAULT, 1, 5000L, mainHandler, (MediaCodecVideoTrackRenderer.EventListener)this.player, 50);
            EMMediaCodecAudioTrackRenderer audioRenderer = new EMMediaCodecAudioTrackRenderer((SampleSource)sampleSource, MediaCodecSelector.DEFAULT, null, true, this.player.getMainHandler(), this.player, AudioCapabilities.getCapabilities((Context)this.context), this.streamType);
            TextTrackRenderer captionsRenderer = new TextTrackRenderer((SampleSource)sampleSource, (TextRenderer)this.player, mainHandler.getLooper(), new SubtitleParser[0]);
            MetadataTrackRenderer id3Renderer = new MetadataTrackRenderer((SampleSource)sampleSource, (MetadataParser)new Id3Parser(), (MetadataTrackRenderer.MetadataRenderer)this.player, mainHandler.getLooper());
            TrackRenderer[] renderers = new TrackRenderer[]{videoRenderer, audioRenderer, captionsRenderer, id3Renderer};
            this.player.onRenderers(renderers, (BandwidthMeter)bandwidthMeter);
        }
    }
}

