/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.widget.RemoteViews;
import com.devbrackets.android.exomedia.NotificationInfo;
import com.devbrackets.android.exomedia.R;

public class EMNotification {
    @NonNull
    private Context context;
    @NonNull
    private NotificationInfo notificationInfo = new NotificationInfo();
    @Nullable
    private NotificationManager notificationManager;
    @Nullable
    private Class<? extends Service> mediaServiceClass;

    public EMNotification(@NonNull Context context) {
        this.context = context;
        this.notificationManager = (NotificationManager)context.getSystemService("notification");
    }

    public void release() {
        this.dismiss();
        this.mediaServiceClass = null;
        this.notificationInfo.clean();
    }

    public void dismiss() {
        if (this.notificationManager != null) {
            this.notificationManager.cancel(this.notificationInfo.getNotificationId());
        }
    }

    public void setNotificationsEnabled(boolean enabled) {
        if (enabled == this.notificationInfo.getShowNotifications()) {
            return;
        }
        this.notificationInfo.setShowNotifications(enabled);
        if (!enabled && this.notificationManager != null) {
            this.notificationManager.cancel(this.notificationInfo.getNotificationId());
        }
    }

    public void setNotificationBaseInformation(int notificationId, @DrawableRes int appIcon) {
        this.setNotificationBaseInformation(notificationId, appIcon, null);
    }

    public void setNotificationBaseInformation(int notificationId, @DrawableRes int appIcon, @Nullable Class<? extends Service> mediaServiceClass) {
        this.notificationInfo.setNotificationId(notificationId);
        this.notificationInfo.setAppIcon(appIcon);
        this.mediaServiceClass = mediaServiceClass;
    }

    public void updateNotificationInformation(@Nullable String title, @Nullable String album, @Nullable String artist, @Nullable Bitmap notificationImage, @Nullable Bitmap secondaryNotificationImage) {
        this.updateNotificationInformation(title, album, artist, notificationImage, secondaryNotificationImage, null);
    }

    public void setClickPendingIntent(@Nullable PendingIntent pendingIntent) {
        this.notificationInfo.setPendingIntent(pendingIntent);
    }

    public void updateNotificationInformation(@Nullable String title, @Nullable String album, @Nullable String artist, @Nullable Bitmap notificationImage, @Nullable Bitmap secondaryNotificationImage, @Nullable NotificationMediaState notificationMediaState) {
        this.notificationInfo.setTitle(title);
        this.notificationInfo.setAlbum(album);
        this.notificationInfo.setArtist(artist);
        this.notificationInfo.setLargeImage(notificationImage);
        this.notificationInfo.setSecondaryImage(secondaryNotificationImage);
        this.notificationInfo.setMediaState(notificationMediaState);
        if (this.notificationInfo.getShowNotifications() && this.notificationManager != null && this.mediaServiceClass != null) {
            this.notificationManager.notify(this.notificationInfo.getNotificationId(), this.getNotification(this.notificationInfo.getPendingIntent(), this.mediaServiceClass));
        }
    }

    @TargetApi(value=16)
    public Notification getNotification(@Nullable PendingIntent pendingIntent, @NonNull Class<? extends Service> serviceClass) {
        this.setClickPendingIntent(pendingIntent);
        RemoteViews customNotificationViews = this.getCustomNotification(serviceClass);
        boolean allowSwipe = this.notificationInfo.getMediaState() == null || !this.notificationInfo.getMediaState().isPlaying();
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context);
        builder.setContent(customNotificationViews);
        builder.setContentIntent(pendingIntent);
        builder.setDeleteIntent(this.createPendingIntent("remote_action_stop", serviceClass));
        builder.setSmallIcon(this.notificationInfo.getAppIcon());
        builder.setAutoCancel(allowSwipe);
        builder.setOngoing(!allowSwipe);
        if (pendingIntent != null) {
            customNotificationViews.setOnClickPendingIntent(R.id.exomedia_notification_touch_area, pendingIntent);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            builder.setCategory("status");
            builder.setVisibility(1);
        }
        Notification notification = builder.build();
        if (Build.VERSION.SDK_INT >= 16 && this.mediaServiceClass != null) {
            notification.bigContentView = this.getBigNotification(serviceClass);
            notification.bigContentView.setOnClickPendingIntent(R.id.exomedia_big_notification_touch_area, pendingIntent);
        }
        return notification;
    }

    private RemoteViews getCustomNotification(@NonNull Class<? extends Service> serviceClass) {
        RemoteViews customNotification = new RemoteViews(this.context.getPackageName(), R.layout.exomedia_notification_content);
        customNotification.setOnClickPendingIntent(R.id.exomedia_notification_playpause, this.createPendingIntent("remote_action_play_pause", serviceClass));
        customNotification.setOnClickPendingIntent(R.id.exomedia_notification_next, this.createPendingIntent("remote_action_next", serviceClass));
        customNotification.setOnClickPendingIntent(R.id.exomedia_notification_prev, this.createPendingIntent("remote_action_previous", serviceClass));
        customNotification.setTextViewText(R.id.exomedia_notification_title, (CharSequence)this.notificationInfo.getTitle());
        customNotification.setTextViewText(R.id.exomedia_notification_album, (CharSequence)this.notificationInfo.getAlbum());
        customNotification.setTextViewText(R.id.exomedia_notification_artist, (CharSequence)this.notificationInfo.getArtist());
        if (this.notificationInfo.getLargeImage() != null) {
            customNotification.setBitmap(R.id.exomedia_notification_large_image, "setImageBitmap", this.notificationInfo.getLargeImage());
        }
        if (this.notificationInfo.getMediaState() != null) {
            this.updateCustomNotificationMediaState(customNotification);
        }
        return customNotification;
    }

    private RemoteViews getBigNotification(@NonNull Class<? extends Service> serviceClass) {
        RemoteViews bigContent = new RemoteViews(this.context.getPackageName(), R.layout.exomedia_big_notification_content);
        bigContent.setOnClickPendingIntent(R.id.exomedia_big_notification_close, this.createPendingIntent("remote_action_stop", serviceClass));
        bigContent.setOnClickPendingIntent(R.id.exomedia_big_notification_playpause, this.createPendingIntent("remote_action_play_pause", serviceClass));
        bigContent.setOnClickPendingIntent(R.id.exomedia_big_notification_next, this.createPendingIntent("remote_action_next", serviceClass));
        bigContent.setOnClickPendingIntent(R.id.exomedia_big_notification_prev, this.createPendingIntent("remote_action_previous", serviceClass));
        bigContent.setTextViewText(R.id.exomedia_big_notification_title, (CharSequence)this.notificationInfo.getTitle());
        bigContent.setTextViewText(R.id.exomedia_big_notification_album, (CharSequence)this.notificationInfo.getAlbum());
        bigContent.setTextViewText(R.id.exomedia_big_notification_artist, (CharSequence)this.notificationInfo.getArtist());
        bigContent.setBitmap(R.id.exomedia_big_notification_large_image, "setImageBitmap", this.notificationInfo.getLargeImage());
        bigContent.setBitmap(R.id.exomedia_big_notification_secondary_image, "setImageBitmap", this.notificationInfo.getSecondaryImage());
        if (this.notificationInfo.getMediaState() != null) {
            this.updateBigNotificationMediaState(bigContent);
        }
        return bigContent;
    }

    private void updateCustomNotificationMediaState(RemoteViews customNotification) {
        NotificationMediaState state = this.notificationInfo.getMediaState();
        if (customNotification == null || state == null) {
            return;
        }
        customNotification.setImageViewResource(R.id.exomedia_notification_playpause, state.isPlaying() ? R.drawable.exomedia_notification_pause : R.drawable.exomedia_notification_play);
        customNotification.setInt(R.id.exomedia_notification_prev, "setVisibility", state.isPreviousEnabled() ? 0 : 8);
        customNotification.setInt(R.id.exomedia_notification_next, "setVisibility", state.isNextEnabled() ? 0 : 8);
    }

    private void updateBigNotificationMediaState(RemoteViews bigContent) {
        NotificationMediaState state = this.notificationInfo.getMediaState();
        if (bigContent == null || state == null) {
            return;
        }
        bigContent.setImageViewResource(R.id.exomedia_big_notification_playpause, state.isPlaying() ? R.drawable.exomedia_notification_pause : R.drawable.exomedia_notification_play);
        bigContent.setInt(R.id.exomedia_big_notification_prev, "setVisibility", state.isPreviousEnabled() ? 0 : 4);
        bigContent.setInt(R.id.exomedia_big_notification_next, "setVisibility", state.isNextEnabled() ? 0 : 4);
    }

    private PendingIntent createPendingIntent(String action, @NonNull Class<? extends Service> serviceClass) {
        Intent intent = new Intent(this.context, serviceClass);
        intent.setAction(action);
        return PendingIntent.getService((Context)this.context, (int)0, (Intent)intent, (int)0x8000000);
    }

    public static class NotificationMediaState {
        private boolean isPlaying;
        private boolean isPreviousEnabled;
        private boolean isNextEnabled;

        public boolean isPlaying() {
            return this.isPlaying;
        }

        public boolean isPreviousEnabled() {
            return this.isPreviousEnabled;
        }

        public boolean isNextEnabled() {
            return this.isNextEnabled;
        }

        public void setPlaying(boolean isPlaying) {
            this.isPlaying = isPlaying;
        }

        public void setPreviousEnabled(boolean isPreviousEnabled) {
            this.isPreviousEnabled = isPreviousEnabled;
        }

        public void setNextEnabled(boolean isNextEnabled) {
            this.isNextEnabled = isNextEnabled;
        }
    }
}

