/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.devbrackets.android.exomedia.EMVideoView;
import com.devbrackets.android.exomedia.R;
import com.devbrackets.android.exomedia.event.EMMediaNextEvent;
import com.devbrackets.android.exomedia.event.EMMediaPlayPauseEvent;
import com.devbrackets.android.exomedia.event.EMMediaPreviousEvent;
import com.devbrackets.android.exomedia.event.EMMediaProgressEvent;
import com.devbrackets.android.exomedia.event.EMVideoViewControlVisibilityEvent;
import com.devbrackets.android.exomedia.listener.EMVideoViewControlsCallback;
import com.devbrackets.android.exomedia.util.EMEventBus;
import com.devbrackets.android.exomedia.util.EMResourceUtil;

public abstract class DefaultControls
extends RelativeLayout {
    public static final int DEFAULT_CONTROL_HIDE_DELAY = 2000;
    protected static final long CONTROL_VISIBILITY_ANIMATION_LENGTH = 300L;
    protected static final int INVALID_RESOURCE_ID = 0;
    protected TextView currentTime;
    protected TextView endTime;
    protected ImageButton playPauseButton;
    protected ImageButton previousButton;
    protected ImageButton nextButton;
    protected ViewGroup controlsContainer;
    protected ProgressBar loadingProgress;
    protected Drawable defaultPlayDrawable;
    protected Drawable defaultPauseDrawable;
    protected Drawable defaultPreviousDrawable;
    protected Drawable defaultNextDrawable;
    protected int playResourceId = 0;
    protected int pauseResourceId = 0;
    protected long hideDelay = -1L;
    protected boolean isVisible = true;
    protected boolean canViewHide = true;
    protected Handler visibilityHandler = new Handler();
    protected boolean busPostHandlesEvent = false;
    @Nullable
    protected EMEventBus bus;
    protected EMVideoView videoView;
    protected SeekCallbacks seekCallbacks;
    protected EMVideoViewControlsCallback callback;

    public DefaultControls(Context context) {
        super(context);
        this.setup(context);
    }

    public DefaultControls(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup(context);
    }

    @TargetApi(value=11)
    public DefaultControls(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup(context);
    }

    @TargetApi(value=21)
    public DefaultControls(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setup(context);
    }

    public void setBus(@Nullable EMEventBus bus) {
        this.bus = bus;
    }

    public void setVideoView(EMVideoView EMVideoView2) {
        this.videoView = EMVideoView2;
    }

    public void setVideoViewControlsCallback(EMVideoViewControlsCallback callback) {
        this.callback = callback;
    }

    public void setLoading(boolean isLoading) {
        this.loadingProgress.setVisibility(isLoading ? 0 : 4);
        this.controlsContainer.setVisibility(isLoading ? 8 : 0);
    }

    public void loadCompleted() {
        this.setLoading(false);
        this.updatePlayPauseImage(this.videoView.isPlaying());
    }

    public void restartLoading() {
        this.setLoading(true);
    }

    public void setSeekCallbacks(@Nullable SeekCallbacks callbacks) {
        this.seekCallbacks = callbacks;
    }

    public abstract void setPosition(long var1);

    public abstract void setDuration(long var1);

    public abstract void setProgressEvent(EMMediaProgressEvent var1);

    public void setPlayPauseImages(@DrawableRes int playResourceId, @DrawableRes int pauseResourceId) {
        this.playResourceId = playResourceId;
        this.pauseResourceId = pauseResourceId;
        this.updatePlayPauseImage(this.videoView != null && this.videoView.isPlaying());
    }

    public void setPreviousImageResource(@DrawableRes int resourceId) {
        if (resourceId != 0) {
            this.previousButton.setImageResource(resourceId);
        } else {
            this.previousButton.setImageDrawable(this.defaultPreviousDrawable);
        }
    }

    public void setNextImageResource(@DrawableRes int resourceId) {
        if (resourceId != 0) {
            this.nextButton.setImageResource(resourceId);
        } else {
            this.nextButton.setImageDrawable(this.defaultNextDrawable);
        }
    }

    public void setRewindImageResource(@DrawableRes int resourceId) {
    }

    public void setFastForwardImageResource(@DrawableRes int resourceId) {
    }

    public void updatePlayPauseImage(boolean isPlaying) {
        if (isPlaying) {
            if (this.pauseResourceId != 0) {
                this.playPauseButton.setImageResource(this.pauseResourceId);
            } else {
                this.playPauseButton.setImageDrawable(this.defaultPauseDrawable);
            }
        } else if (this.playResourceId != 0) {
            this.playPauseButton.setImageResource(this.playResourceId);
        } else {
            this.playPauseButton.setImageDrawable(this.defaultPlayDrawable);
        }
    }

    public void setPreviousButtonEnabled(boolean enabled) {
        this.previousButton.setEnabled(enabled);
    }

    public void setNextButtonEnabled(boolean enabled) {
        this.nextButton.setEnabled(enabled);
    }

    public void setRewindButtonEnabled(boolean enabled) {
    }

    public void setFastForwardButtonEnabled(boolean enabled) {
    }

    public void setPreviousButtonRemoved(boolean removed) {
        this.previousButton.setVisibility(removed ? 8 : 0);
    }

    public void setNextButtonRemoved(boolean removed) {
        this.nextButton.setVisibility(removed ? 8 : 0);
    }

    public void setRewindButtonRemoved(boolean removed) {
    }

    public void setFastForwardButtonRemoved(boolean removed) {
    }

    public void show() {
        this.visibilityHandler.removeCallbacksAndMessages(null);
        this.clearAnimation();
        this.animateVisibility(true);
    }

    public void hideDelayed(long delay) {
        this.hideDelay = delay;
        if (delay < 0L || !this.canViewHide) {
            return;
        }
        this.visibilityHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                DefaultControls.this.animateVisibility(false);
            }
        }, delay);
    }

    public void setCanHide(boolean canHide) {
        this.canViewHide = canHide;
    }

    public void setFinishOnBusEvents(boolean finish) {
        this.busPostHandlesEvent = finish;
    }

    protected void retrieveViews() {
        this.currentTime = (TextView)this.findViewById(R.id.exomedia_controls_current_time);
        this.endTime = (TextView)this.findViewById(R.id.exomedia_controls_end_time);
        this.playPauseButton = (ImageButton)this.findViewById(R.id.exomedia_controls_play_pause_btn);
        this.previousButton = (ImageButton)this.findViewById(R.id.exomedia_controls_previous_btn);
        this.nextButton = (ImageButton)this.findViewById(R.id.exomedia_controls_next_btn);
        this.loadingProgress = (ProgressBar)this.findViewById(R.id.exomedia_controls_video_loading);
        this.controlsContainer = (ViewGroup)this.findViewById(R.id.exomedia_controls_interactive_container);
    }

    protected void registerListeners() {
        this.playPauseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DefaultControls.this.onPlayPauseClick();
            }
        });
        this.previousButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DefaultControls.this.onPreviousClick();
            }
        });
        this.nextButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DefaultControls.this.onNextClick();
            }
        });
    }

    protected void updateButtonDrawables() {
        this.defaultPlayDrawable = EMResourceUtil.tintList(this.getContext(), R.drawable.exomedia_ic_play_arrow_white, R.color.exomedia_default_controls_button_selector);
        this.defaultPauseDrawable = EMResourceUtil.tintList(this.getContext(), R.drawable.exomedia_ic_pause_white, R.color.exomedia_default_controls_button_selector);
        this.playPauseButton.setImageDrawable(this.defaultPlayDrawable);
        this.defaultPreviousDrawable = EMResourceUtil.tintList(this.getContext(), R.drawable.exomedia_ic_skip_previous_white, R.color.exomedia_default_controls_button_selector);
        this.previousButton.setImageDrawable(this.defaultPreviousDrawable);
        this.defaultNextDrawable = EMResourceUtil.tintList(this.getContext(), R.drawable.exomedia_ic_skip_next_white, R.color.exomedia_default_controls_button_selector);
        this.nextButton.setImageDrawable(this.defaultNextDrawable);
    }

    protected void onPlayPauseClick() {
        boolean playing;
        if (this.callback != null && this.callback.onPlayPauseClicked()) {
            return;
        }
        if (this.bus != null) {
            this.bus.post(new EMMediaPlayPauseEvent());
            if (this.busPostHandlesEvent) {
                return;
            }
        }
        if (playing = this.videoView.isPlaying()) {
            this.videoView.pause();
        } else {
            this.videoView.start();
        }
    }

    protected void onPreviousClick() {
        if (this.callback != null && this.callback.onPreviousClicked()) {
            return;
        }
        if (this.bus != null) {
            this.bus.post(new EMMediaPreviousEvent());
        }
    }

    protected void onNextClick() {
        if (this.callback != null && this.callback.onNextClicked()) {
            return;
        }
        if (this.bus != null) {
            this.bus.post(new EMMediaNextEvent());
        }
    }

    @LayoutRes
    protected abstract int getLayoutResource();

    protected void setup(Context context) {
        View.inflate((Context)context, (int)this.getLayoutResource(), (ViewGroup)this);
        this.retrieveViews();
        this.registerListeners();
        this.updateButtonDrawables();
    }

    protected void onVisibilityChanged() {
        boolean handled = false;
        if (this.callback != null) {
            handled = this.isVisible ? this.callback.onControlsShown() : this.callback.onControlsHidden();
        }
        if (!handled && this.bus != null) {
            this.bus.post(new EMVideoViewControlVisibilityEvent(this.isVisible));
        }
    }

    protected void animateVisibility(boolean toVisible) {
        if (this.isVisible == toVisible) {
            return;
        }
        float startAlpha = toVisible ? 0.0f : 1.0f;
        float endAlpha = toVisible ? 1.0f : 0.0f;
        AlphaAnimation animation = new AlphaAnimation(startAlpha, endAlpha);
        animation.setDuration(300L);
        animation.setFillAfter(true);
        this.startAnimation((Animation)animation);
        this.isVisible = toVisible;
        this.onVisibilityChanged();
    }

    public static interface SeekCallbacks {
        public boolean onSeekStarted();

        public boolean onSeekEnded(int var1);
    }
}

