/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.Nullable;

public class StopWatch {
    private static final String HANDLER_THREAD_NAME = "ExoMedia_StopWatch_HandlerThread";
    private static final int DEFAULT_TICK_DELAY = 33;
    private volatile boolean isRunning = false;
    private int tickDelay = 33;
    private Handler delayedHandler;
    private HandlerThread handlerThread;
    private boolean useHandlerThread = false;
    private TickListener listener;
    private TickRunnable tickRunnable = new TickRunnable();
    private long startTime = 0L;
    private long currentTime = 0L;
    private long storedTime = 0L;

    public StopWatch() {
        this(true);
    }

    public StopWatch(boolean processOnStartingThread) {
        if (processOnStartingThread) {
            this.delayedHandler = new Handler();
            return;
        }
        this.useHandlerThread = true;
    }

    public StopWatch(Handler handler) {
        this.delayedHandler = handler;
    }

    public void setTickDelay(int milliSeconds) {
        this.tickDelay = milliSeconds;
    }

    public int getTickDelay() {
        return this.tickDelay;
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.isRunning = true;
        this.startTime = System.currentTimeMillis();
        if (this.useHandlerThread) {
            this.handlerThread = new HandlerThread(HANDLER_THREAD_NAME);
            this.handlerThread.start();
            this.delayedHandler = new Handler(this.handlerThread.getLooper());
        }
        this.tickRunnable.performTick();
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.delayedHandler.removeCallbacksAndMessages(null);
        if (this.handlerThread != null) {
            this.handlerThread.quit();
        }
        this.isRunning = false;
        this.currentTime = 0L;
        this.storedTime += System.currentTimeMillis() - this.startTime;
    }

    public void reset() {
        this.currentTime = 0L;
        this.storedTime = 0L;
        this.startTime = System.currentTimeMillis();
    }

    public void overrideCurrentTime(long time) {
        this.startTime = System.currentTimeMillis();
        this.currentTime = 0L;
        this.storedTime = time;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public long getTime() {
        return this.currentTime + this.storedTime;
    }

    public void setTickListener(@Nullable TickListener listener) {
        this.listener = listener;
    }

    private class TickRunnable
    implements Runnable {
        private TickRunnable() {
        }

        @Override
        public void run() {
            StopWatch.this.currentTime = System.currentTimeMillis() - StopWatch.this.startTime;
            if (StopWatch.this.isRunning) {
                this.performTick();
            }
            if (StopWatch.this.listener != null) {
                StopWatch.this.listener.onStopWatchTick(StopWatch.this.currentTime + StopWatch.this.storedTime);
            }
        }

        public void performTick() {
            StopWatch.this.delayedHandler.postDelayed((Runnable)StopWatch.this.tickRunnable, (long)StopWatch.this.tickDelay);
        }
    }

    public static interface TickListener {
        public void onStopWatchTick(long var1);
    }
}

