/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.builder;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import com.devbrackets.android.exomedia.builder.RenderBuilder;
import com.devbrackets.android.exomedia.exoplayer.EMExoPlayer;
import com.devbrackets.android.exomedia.renderer.EMMediaCodecAudioTrackRenderer;
import com.google.android.exoplayer.DefaultLoadControl;
import com.google.android.exoplayer.LoadControl;
import com.google.android.exoplayer.MediaCodecVideoTrackRenderer;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.chunk.ChunkSampleSource;
import com.google.android.exoplayer.chunk.ChunkSource;
import com.google.android.exoplayer.chunk.FormatEvaluator;
import com.google.android.exoplayer.drm.DrmSessionManager;
import com.google.android.exoplayer.drm.StreamingDrmSessionManager;
import com.google.android.exoplayer.drm.UnsupportedDrmException;
import com.google.android.exoplayer.smoothstreaming.DefaultSmoothStreamingTrackSelector;
import com.google.android.exoplayer.smoothstreaming.SmoothStreamingChunkSource;
import com.google.android.exoplayer.smoothstreaming.SmoothStreamingManifest;
import com.google.android.exoplayer.smoothstreaming.SmoothStreamingManifestParser;
import com.google.android.exoplayer.smoothstreaming.SmoothStreamingTrackSelector;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.text.TextRenderer;
import com.google.android.exoplayer.text.TextTrackRenderer;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.upstream.BandwidthMeter;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DefaultAllocator;
import com.google.android.exoplayer.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer.upstream.DefaultHttpDataSource;
import com.google.android.exoplayer.upstream.DefaultUriDataSource;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.upstream.UriDataSource;
import com.google.android.exoplayer.upstream.UriLoadable;
import com.google.android.exoplayer.util.ManifestFetcher;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;

@TargetApi(value=16)
public class SmoothStreamRenderBuilder
extends RenderBuilder {
    private static final int LIVE_EDGE_LATENCY_MS = 30000;
    private final Context context;
    private final String userAgent;
    private final String url;
    private AsyncRendererBuilder currentAsyncBuilder;

    public SmoothStreamRenderBuilder(Context context, String userAgent, String url) {
        super(context, userAgent, url);
        this.context = context;
        this.userAgent = userAgent;
        this.url = Util.toLowerInvariant((String)url).endsWith("/manifest") ? url : url + "/Manifest";
    }

    @Override
    public void buildRenderers(EMExoPlayer player) {
        this.currentAsyncBuilder = new AsyncRendererBuilder(this.context, this.userAgent, this.url, player);
        this.currentAsyncBuilder.init();
    }

    @Override
    public void cancel() {
        if (this.currentAsyncBuilder != null) {
            this.currentAsyncBuilder.cancel();
            this.currentAsyncBuilder = null;
        }
    }

    private static final class AsyncRendererBuilder
    implements ManifestFetcher.ManifestCallback<SmoothStreamingManifest> {
        private final Context context;
        private final String userAgent;
        private final EMExoPlayer player;
        private final ManifestFetcher<SmoothStreamingManifest> manifestFetcher;
        private boolean canceled;

        public AsyncRendererBuilder(Context context, String userAgent, String url, EMExoPlayer player) {
            this.context = context;
            this.userAgent = userAgent;
            this.player = player;
            SmoothStreamingManifestParser parser = new SmoothStreamingManifestParser();
            this.manifestFetcher = new ManifestFetcher(url, (UriDataSource)new DefaultHttpDataSource(userAgent, null), (UriLoadable.Parser)parser);
        }

        public void init() {
            this.manifestFetcher.singleLoad(this.player.getMainHandler().getLooper(), (ManifestFetcher.ManifestCallback)this);
        }

        public void cancel() {
            this.canceled = true;
        }

        public void onSingleManifestError(IOException exception) {
            if (this.canceled) {
                return;
            }
            this.player.onRenderersError(exception);
        }

        public void onSingleManifest(SmoothStreamingManifest manifest) {
            if (this.canceled) {
                return;
            }
            StreamingDrmSessionManager drmSessionManager = null;
            if (manifest.protectionElement != null) {
                if (Build.VERSION.SDK_INT < 18) {
                    this.player.onRenderersError((Exception)((Object)new UnsupportedDrmException(1)));
                    return;
                }
                try {
                    drmSessionManager = new StreamingDrmSessionManager(manifest.protectionElement.uuid, this.player.getPlaybackLooper(), null, null, this.player.getMainHandler(), (StreamingDrmSessionManager.EventListener)this.player);
                }
                catch (UnsupportedDrmException e) {
                    this.player.onRenderersError((Exception)((Object)e));
                    return;
                }
            }
            this.buildRenderers((DrmSessionManager)drmSessionManager);
        }

        private void buildRenderers(DrmSessionManager drmSessionManager) {
            Handler mainHandler = this.player.getMainHandler();
            DefaultLoadControl loadControl = new DefaultLoadControl((Allocator)new DefaultAllocator(65536));
            DefaultBandwidthMeter bandwidthMeter = new DefaultBandwidthMeter(mainHandler, (BandwidthMeter.EventListener)this.player);
            DefaultUriDataSource dataSourceVideo = new DefaultUriDataSource(this.context, (TransferListener)bandwidthMeter, this.userAgent);
            DefaultSmoothStreamingTrackSelector trackSelectorVideo = new DefaultSmoothStreamingTrackSelector(this.context, 1);
            SmoothStreamingChunkSource chunkSourceVideo = new SmoothStreamingChunkSource(this.manifestFetcher, (SmoothStreamingTrackSelector)trackSelectorVideo, (DataSource)dataSourceVideo, (FormatEvaluator)new FormatEvaluator.AdaptiveEvaluator((BandwidthMeter)bandwidthMeter), 30000L);
            ChunkSampleSource sampleSourceVideo = new ChunkSampleSource((ChunkSource)chunkSourceVideo, (LoadControl)loadControl, 0xC80000, mainHandler, (ChunkSampleSource.EventListener)this.player, 0);
            DefaultUriDataSource dataSourceAudio = new DefaultUriDataSource(this.context, (TransferListener)bandwidthMeter, this.userAgent);
            DefaultSmoothStreamingTrackSelector trackSelectorAudio = new DefaultSmoothStreamingTrackSelector(this.context, 0);
            SmoothStreamingChunkSource chunkSourceAudio = new SmoothStreamingChunkSource(this.manifestFetcher, (SmoothStreamingTrackSelector)trackSelectorAudio, (DataSource)dataSourceAudio, null, 30000L);
            ChunkSampleSource sampleSourceAudio = new ChunkSampleSource((ChunkSource)chunkSourceAudio, (LoadControl)loadControl, 0x360000, mainHandler, (ChunkSampleSource.EventListener)this.player, 1);
            DefaultUriDataSource dataSourceCC = new DefaultUriDataSource(this.context, (TransferListener)bandwidthMeter, this.userAgent);
            DefaultSmoothStreamingTrackSelector trackSelectorCC = new DefaultSmoothStreamingTrackSelector(this.context, 2);
            SmoothStreamingChunkSource chunkSourceCC = new SmoothStreamingChunkSource(this.manifestFetcher, (SmoothStreamingTrackSelector)trackSelectorCC, (DataSource)dataSourceCC, null, 30000L);
            ChunkSampleSource sampleSourceCC = new ChunkSampleSource((ChunkSource)chunkSourceCC, (LoadControl)loadControl, 131072, mainHandler, (ChunkSampleSource.EventListener)this.player, 2);
            MediaCodecVideoTrackRenderer videoRenderer = new MediaCodecVideoTrackRenderer(this.context, (SampleSource)sampleSourceVideo, 1, 5000L, drmSessionManager, true, mainHandler, (MediaCodecVideoTrackRenderer.EventListener)this.player, 50);
            EMMediaCodecAudioTrackRenderer audioRenderer = new EMMediaCodecAudioTrackRenderer((SampleSource)sampleSourceAudio, drmSessionManager, true, mainHandler, this.player, AudioCapabilities.getCapabilities((Context)this.context));
            TextTrackRenderer captionsRenderer = new TextTrackRenderer((SampleSource)sampleSourceCC, (TextRenderer)this.player, mainHandler.getLooper(), new SubtitleParser[0]);
            TrackRenderer[] renderers = new TrackRenderer[4];
            renderers[0] = videoRenderer;
            renderers[1] = audioRenderer;
            renderers[2] = captionsRenderer;
            this.player.onRenderers(renderers, (BandwidthMeter)bandwidthMeter);
        }
    }
}

