/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.VideoView;
import com.devbrackets.android.exomedia.EMListenerMux;
import com.devbrackets.android.exomedia.R;
import com.devbrackets.android.exomedia.builder.DashRenderBuilder;
import com.devbrackets.android.exomedia.builder.HlsRenderBuilder;
import com.devbrackets.android.exomedia.builder.RenderBuilder;
import com.devbrackets.android.exomedia.builder.SmoothStreamRenderBuilder;
import com.devbrackets.android.exomedia.event.EMMediaProgressEvent;
import com.devbrackets.android.exomedia.event.EMVideoViewClickedEvent;
import com.devbrackets.android.exomedia.exoplayer.EMExoPlayer;
import com.devbrackets.android.exomedia.listener.EMProgressCallback;
import com.devbrackets.android.exomedia.listener.EMVideoViewControlsCallback;
import com.devbrackets.android.exomedia.listener.ExoPlayerListener;
import com.devbrackets.android.exomedia.type.MediaSourceType;
import com.devbrackets.android.exomedia.util.EMDeviceUtil;
import com.devbrackets.android.exomedia.util.EMEventBus;
import com.devbrackets.android.exomedia.util.MediaUtil;
import com.devbrackets.android.exomedia.util.Repeater;
import com.devbrackets.android.exomedia.util.StopWatch;
import com.devbrackets.android.exomedia.widget.DefaultControls;
import com.devbrackets.android.exomedia.widget.DefaultControlsLeanback;
import com.devbrackets.android.exomedia.widget.DefaultControlsMobile;
import com.devbrackets.android.exomedia.widget.VideoSurfaceView;
import com.google.android.exoplayer.audio.AudioCapabilities;
import com.google.android.exoplayer.audio.AudioCapabilitiesReceiver;

public class EMVideoView
extends RelativeLayout
implements AudioCapabilitiesReceiver.Listener,
VideoSurfaceView.OnSizeChangeListener {
    private static final String TAG = EMVideoView.class.getSimpleName();
    private static final String USER_AGENT_FORMAT = "EMVideoView %s / Android %s / %s";
    private View shutterTop;
    private View shutterBottom;
    private View shutterRight;
    private View shutterLeft;
    private ImageView previewImageView;
    private TouchVideoView videoView;
    private VideoSurfaceView exoVideoSurfaceView;
    private EMExoPlayer emExoPlayer;
    protected DefaultControls defaultControls;
    protected Repeater pollRepeater = new Repeater();
    private EMProgressCallback progressCallback;
    private StopWatch overriddenPositionStopWatch = new StopWatch();
    private AudioCapabilities audioCapabilities;
    private AudioCapabilitiesReceiver audioCapabilitiesReceiver;
    private boolean useExo = false;
    private int overriddenDuration = -1;
    private int positionOffset = 0;
    private boolean overridePosition = false;
    protected MuxNotifier muxNotifier = new MuxNotifier();
    private EMListenerMux listenerMux;
    private boolean playRequested = false;
    private boolean releaseOnDetachFromWindow = true;
    @Nullable
    private EMEventBus bus;
    private Uri videoUri;
    private EMMediaProgressEvent currentMediaProgressEvent = new EMMediaProgressEvent(0L, 0, 0L);

    public EMVideoView(Context context) {
        super(context);
        this.setup(context, null);
    }

    public EMVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup(context, attrs);
    }

    @TargetApi(value=11)
    public EMVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup(context, attrs);
    }

    @TargetApi(value=21)
    public EMVideoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setup(context, attrs);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.pause();
        if (this.releaseOnDetachFromWindow) {
            this.release();
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            @TargetApi(value=16)
            public void onGlobalLayout() {
                if (EMVideoView.this.useExo) {
                    EMVideoView.this.muxNotifier.updateVideoShutters(EMVideoView.this.getWidth(), EMVideoView.this.getHeight(), EMVideoView.this.exoVideoSurfaceView.getWidth(), EMVideoView.this.exoVideoSurfaceView.getHeight());
                    EMVideoView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    EMVideoView.this.muxNotifier.updateVideoShutters(EMVideoView.this.getWidth(), EMVideoView.this.getHeight(), EMVideoView.this.videoView.getWidth(), EMVideoView.this.videoView.getHeight());
                    EMVideoView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
        this.forceLayout();
        this.invalidate();
    }

    @Override
    public void onVideoSurfaceSizeChange(int width, int height) {
        this.muxNotifier.updateVideoShutters(this.getWidth(), this.getHeight(), width, height);
    }

    public void setOnTouchListener(View.OnTouchListener listener) {
        if (this.exoVideoSurfaceView != null) {
            this.exoVideoSurfaceView.setOnTouchListener(listener);
        }
        if (this.videoView != null) {
            this.videoView.setOnTouchListener(listener);
        }
        this.shutterLeft.setOnTouchListener(listener);
        this.shutterRight.setOnTouchListener(listener);
        this.shutterTop.setOnTouchListener(listener);
        this.shutterBottom.setOnTouchListener(listener);
        super.setOnTouchListener(listener);
    }

    public void onAudioCapabilitiesChanged(AudioCapabilities audioCapabilities) {
        if (!audioCapabilities.equals((Object)this.audioCapabilities)) {
            this.audioCapabilities = audioCapabilities;
        }
    }

    private void setup(Context context, @Nullable AttributeSet attrs) {
        this.useExo = Build.VERSION.SDK_INT >= 16 && EMDeviceUtil.isDeviceCTSCompliant();
        this.pollRepeater.setRepeatListener(new Repeater.RepeatListener(){

            @Override
            public void onRepeat() {
                EMVideoView.this.currentMediaProgressEvent.update(EMVideoView.this.getCurrentPosition(), EMVideoView.this.getBufferPercentage(), EMVideoView.this.getDuration());
                if (EMVideoView.this.defaultControls != null) {
                    EMVideoView.this.defaultControls.setProgressEvent(EMVideoView.this.currentMediaProgressEvent);
                }
                if (EMVideoView.this.progressCallback != null && EMVideoView.this.progressCallback.onProgressUpdated(EMVideoView.this.currentMediaProgressEvent)) {
                    return;
                }
                if (EMVideoView.this.bus != null) {
                    EMVideoView.this.bus.post(EMVideoView.this.currentMediaProgressEvent);
                }
            }
        });
        this.initView(context);
        this.readAttributes(context, attrs);
    }

    private void readAttributes(Context context, @Nullable AttributeSet attrs) {
        if (attrs == null || this.isInEditMode()) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.EMVideoView);
        if (typedArray == null) {
            return;
        }
        boolean enableDefaultControls = typedArray.getBoolean(R.styleable.EMVideoView_defaultControlsEnabled, false);
        this.setDefaultControlsEnabled(enableDefaultControls);
        typedArray.recycle();
    }

    private void initView(Context context) {
        if (this.useExo) {
            View.inflate((Context)context, (int)R.layout.exomedia_exo_view_layout, (ViewGroup)this);
        } else {
            View.inflate((Context)context, (int)R.layout.exomedia_video_view_layout, (ViewGroup)this);
        }
        this.shutterBottom = this.findViewById(R.id.exomedia_video_shutter_bottom);
        this.shutterTop = this.findViewById(R.id.exomedia_video_shutter_top);
        this.shutterLeft = this.findViewById(R.id.exomedia_video_shutter_left);
        this.shutterRight = this.findViewById(R.id.exomedia_video_shutter_right);
        this.previewImageView = (ImageView)this.findViewById(R.id.exomedia_video_preview_image);
        this.exoVideoSurfaceView = (VideoSurfaceView)this.findViewById(R.id.exomedia_exo_video_surface);
        this.videoView = (TouchVideoView)this.findViewById(R.id.exomedia_android_video_view);
        if (this.exoVideoSurfaceView != null) {
            this.setupExoPlayer();
        } else {
            this.setupVideoView();
        }
    }

    private void setupExoPlayer() {
        this.audioCapabilitiesReceiver = new AudioCapabilitiesReceiver(this.getContext().getApplicationContext(), (AudioCapabilitiesReceiver.Listener)this);
        this.audioCapabilitiesReceiver.register();
        this.emExoPlayer = new EMExoPlayer(null);
        this.listenerMux = new EMListenerMux(this.muxNotifier);
        this.emExoPlayer.addListener(this.listenerMux);
        this.emExoPlayer.setMetadataListener(null);
        this.emExoPlayer.setSurface(this.exoVideoSurfaceView.getHolder().getSurface());
        this.exoVideoSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)new EMExoVideoSurfaceCallback());
        this.exoVideoSurfaceView.setOnSizeChangeListener(this);
    }

    private void setupVideoView() {
        this.listenerMux = new EMListenerMux(this.muxNotifier);
        this.videoView.setOnCompletionListener(this.listenerMux);
        this.videoView.setOnPreparedListener(this.listenerMux);
        this.videoView.setOnErrorListener(this.listenerMux);
        if (Build.VERSION.SDK_INT >= 17) {
            this.videoView.setOnInfoListener(this.listenerMux);
        }
    }

    private RenderBuilder getRendererBuilder(MediaSourceType renderType, Uri uri, MediaUtil.MediaType defaultMediaType) {
        switch (renderType) {
            case HLS: {
                return new HlsRenderBuilder(this.getContext().getApplicationContext(), this.getUserAgent(), uri.toString());
            }
            case DASH: {
                return new DashRenderBuilder(this.getContext().getApplicationContext(), this.getUserAgent(), uri.toString());
            }
            case SMOOTH_STREAM: {
                return new SmoothStreamRenderBuilder(this.getContext().getApplicationContext(), this.getUserAgent(), uri.toString());
            }
        }
        return new RenderBuilder(this.getContext().getApplicationContext(), this.getUserAgent(), uri.toString());
    }

    public void setReleaseOnDetachFromWindow(boolean releaseOnDetach) {
        this.releaseOnDetachFromWindow = releaseOnDetach;
    }

    public void release() {
        this.defaultControls = null;
        this.stopPlayback();
        this.overriddenPositionStopWatch.stop();
        if (this.emExoPlayer != null) {
            this.emExoPlayer.release();
        }
        if (this.audioCapabilitiesReceiver != null) {
            this.audioCapabilitiesReceiver.unregister();
            this.audioCapabilitiesReceiver = null;
        }
    }

    public String getUserAgent() {
        return String.format(USER_AGENT_FORMAT, "2.5.2 (25200)", Build.VERSION.RELEASE, Build.MODEL);
    }

    public void setPreviewImage(@Nullable Drawable drawable2) {
        if (this.previewImageView != null) {
            this.previewImageView.setImageDrawable(drawable2);
        }
    }

    public void setPreviewImage(@DrawableRes int resourceId) {
        if (this.previewImageView != null) {
            this.previewImageView.setImageResource(resourceId);
        }
    }

    public void setPreviewImage(@Nullable Bitmap bitmap) {
        if (this.previewImageView != null) {
            this.previewImageView.setImageBitmap(bitmap);
        }
    }

    public void setPreviewImage(@Nullable Uri uri) {
        if (this.previewImageView != null) {
            this.previewImageView.setImageURI(uri);
        }
    }

    public ImageView getPreviewImageView() {
        return this.previewImageView;
    }

    public void setShutterColor(int color2) {
        if (this.shutterTop != null) {
            this.shutterTop.setBackgroundColor(color2);
        }
        if (this.shutterBottom != null) {
            this.shutterBottom.setBackgroundColor(color2);
        }
        if (this.shutterLeft != null) {
            this.shutterLeft.setBackgroundColor(color2);
        }
        if (this.shutterRight != null) {
            this.shutterRight.setBackgroundColor(color2);
        }
    }

    public void setProgressPollDelay(int milliSeconds) {
        this.pollRepeater.setRepeaterDelay(milliSeconds);
    }

    public void setBus(@Nullable EMEventBus bus) {
        this.bus = bus;
        this.listenerMux.setBus(bus);
        if (this.defaultControls != null) {
            this.defaultControls.setBus(bus);
        }
    }

    public void startProgressPoll(@Nullable EMEventBus bus) {
        this.setBus(bus);
        this.startProgressPoll();
    }

    public void startProgressPoll(EMProgressCallback callback) {
        this.progressCallback = callback;
        this.startProgressPoll();
    }

    public void startProgressPoll() {
        if (this.bus != null || this.defaultControls != null || this.progressCallback != null) {
            this.pollRepeater.start();
        }
    }

    public void stopProgressPoll() {
        if (this.defaultControls == null) {
            this.pollRepeater.stop();
        }
    }

    public void setDefaultControlsEnabled(boolean enabled) {
        if (this.defaultControls == null && enabled) {
            this.defaultControls = EMDeviceUtil.isDeviceTV(this.getContext()) ? new DefaultControlsLeanback(this.getContext()) : new DefaultControlsMobile(this.getContext());
            this.defaultControls.setVideoView(this);
            this.defaultControls.setBus(this.bus);
            this.addView((View)this.defaultControls);
            this.startProgressPoll();
        } else if (this.defaultControls != null && !enabled) {
            this.removeView((View)this.defaultControls);
            this.defaultControls = null;
            if (this.bus == null) {
                this.stopProgressPoll();
            }
        }
        TouchListener listener = new TouchListener(this.getContext());
        this.setOnTouchListener(enabled ? listener : null);
    }

    public void showDefaultControls() {
        if (this.defaultControls != null) {
            this.defaultControls.show();
            if (this.isPlaying()) {
                this.defaultControls.hideDelayed(2000L);
            }
        }
    }

    public void setPreviousButtonEnabled(boolean enabled) {
        if (this.defaultControls != null) {
            this.defaultControls.setPreviousButtonEnabled(enabled);
        }
    }

    public void setNextButtonEnabled(boolean enabled) {
        if (this.defaultControls != null) {
            this.defaultControls.setNextButtonEnabled(enabled);
        }
    }

    public void setRewindButtonEnabled(boolean enabled) {
        if (this.defaultControls != null) {
            this.defaultControls.setRewindButtonEnabled(enabled);
        }
    }

    public void setFastForwardButtonEnabled(boolean enabled) {
        if (this.defaultControls != null) {
            this.defaultControls.setFastForwardButtonEnabled(enabled);
        }
    }

    public void setVideoViewControlsCallback(EMVideoViewControlsCallback callback) {
        if (this.defaultControls != null) {
            this.defaultControls.setVideoViewControlsCallback(callback);
        }
    }

    public void setPlayPauseImages(@DrawableRes int playResourceId, @DrawableRes int pauseResourceId) {
        if (this.defaultControls != null) {
            this.defaultControls.setPlayPauseImages(playResourceId, pauseResourceId);
        }
    }

    public void setPreviousImageResource(@DrawableRes int resourceId) {
        if (this.defaultControls != null) {
            this.defaultControls.setPreviousImageResource(resourceId);
        }
    }

    public void setNextImageResource(@DrawableRes int resourceId) {
        if (this.defaultControls != null) {
            this.defaultControls.setNextImageResource(resourceId);
        }
    }

    public void setRewindImageResource(@DrawableRes int resourceId) {
        if (this.defaultControls != null) {
            this.defaultControls.setRewindImageResource(resourceId);
        }
    }

    public void setFastForwardImageResource(@DrawableRes int resourceId) {
        if (this.defaultControls != null) {
            this.defaultControls.setFastForwardImageResource(resourceId);
        }
    }

    public void setPreviousButtonRemoved(boolean removed) {
        if (this.defaultControls != null) {
            this.defaultControls.setPreviousButtonRemoved(removed);
        }
    }

    public void setNextButtonRemoved(boolean removed) {
        if (this.defaultControls != null) {
            this.defaultControls.setNextButtonRemoved(removed);
        }
    }

    public void setRewindButtonRemoved(boolean removed) {
        if (this.defaultControls != null) {
            this.defaultControls.setRewindButtonRemoved(removed);
        }
    }

    public void setFastForwardButtonRemoved(boolean removed) {
        if (this.defaultControls != null) {
            this.defaultControls.setFastForwardButtonRemoved(removed);
        }
    }

    public void setVideoURI(Uri uri) {
        this.setVideoURI(uri, MediaUtil.MediaType.MP4);
    }

    public void setVideoURI(Uri uri, MediaUtil.MediaType defaultMediaType) {
        RenderBuilder builder = null;
        if (uri != null) {
            builder = this.getRendererBuilder(MediaSourceType.get(uri), uri, defaultMediaType);
        }
        this.setVideoURI(uri, builder);
    }

    public void setVideoURI(Uri uri, RenderBuilder renderBuilder) {
        this.videoUri = uri;
        if (!this.useExo) {
            this.videoView.setVideoURI(uri);
        } else {
            if (uri == null) {
                this.emExoPlayer.replaceRenderBuilder(null);
            } else {
                this.emExoPlayer.replaceRenderBuilder(renderBuilder);
                this.listenerMux.setNotifiedCompleted(false);
            }
            this.listenerMux.setNotifiedPrepared(false);
            this.emExoPlayer.seekTo(0L);
        }
        if (this.defaultControls != null) {
            this.defaultControls.restartLoading();
        }
    }

    public void setVideoPath(String path) {
        this.setVideoURI(Uri.parse((String)path));
    }

    @Nullable
    public Uri getVideoUri() {
        return this.videoUri;
    }

    public boolean setVolume(float volume) {
        if (this.useExo) {
            this.emExoPlayer.setVolume(volume);
            return true;
        }
        return false;
    }

    public void reset() {
        this.stopPlayback();
        this.setVideoURI(null);
    }

    public void seekTo(int milliSeconds) {
        if (!this.useExo) {
            this.videoView.seekTo(milliSeconds);
        } else {
            this.emExoPlayer.seekTo(milliSeconds);
        }
    }

    public boolean isPlaying() {
        if (!this.useExo) {
            return this.videoView.isPlaying();
        }
        return this.emExoPlayer.getPlayWhenReady();
    }

    public void start() {
        if (!this.useExo) {
            this.videoView.start();
        } else {
            this.emExoPlayer.setPlayWhenReady(true);
        }
        if (this.defaultControls != null) {
            this.defaultControls.updatePlayPauseImage(true);
            this.defaultControls.hideDelayed(2000L);
        }
        this.playRequested = true;
        this.startProgressPoll();
        this.listenerMux.setNotifiedCompleted(false);
    }

    public void pause() {
        if (!this.useExo) {
            this.videoView.pause();
        } else {
            this.emExoPlayer.setPlayWhenReady(false);
        }
        if (this.defaultControls != null) {
            this.defaultControls.updatePlayPauseImage(false);
            this.defaultControls.show();
        }
        this.playRequested = false;
        this.stopProgressPoll();
    }

    public void stopPlayback() {
        if (!this.useExo) {
            this.videoView.stopPlayback();
        } else {
            this.emExoPlayer.setPlayWhenReady(false);
        }
        if (this.defaultControls != null) {
            this.defaultControls.updatePlayPauseImage(false);
            this.defaultControls.show();
        }
        this.playRequested = false;
        this.stopProgressPoll();
    }

    public void suspend() {
        if (!this.useExo) {
            this.videoView.suspend();
        } else {
            this.emExoPlayer.release();
        }
        if (this.defaultControls != null) {
            this.defaultControls.updatePlayPauseImage(false);
            this.defaultControls.show();
        }
        this.playRequested = false;
        this.stopProgressPoll();
    }

    public long getDuration() {
        if (this.overriddenDuration >= 0) {
            return this.overriddenDuration;
        }
        if (!this.listenerMux.isPrepared()) {
            return 0L;
        }
        if (!this.useExo) {
            return this.videoView.getDuration();
        }
        return this.emExoPlayer.getDuration();
    }

    public void overrideDuration(int duration) {
        this.overriddenDuration = duration;
    }

    public long getCurrentPosition() {
        if (this.overridePosition) {
            return (long)this.positionOffset + this.overriddenPositionStopWatch.getTime();
        }
        if (!this.listenerMux.isPrepared()) {
            return 0L;
        }
        if (!this.useExo) {
            return this.positionOffset + this.videoView.getCurrentPosition();
        }
        return (long)this.positionOffset + this.emExoPlayer.getCurrentPosition();
    }

    public void setPositionOffset(int offset) {
        this.positionOffset = offset;
    }

    public void restartOverridePosition() {
        this.overriddenPositionStopWatch.reset();
    }

    public void overridePosition(boolean override) {
        if (override) {
            this.overriddenPositionStopWatch.start();
        } else {
            this.overriddenPositionStopWatch.stop();
        }
        this.overridePosition = override;
    }

    public int getBufferPercentage() {
        if (!this.useExo) {
            return this.videoView.getBufferPercentage();
        }
        return this.emExoPlayer.getBufferedPercentage();
    }

    public void addExoPlayerListener(ExoPlayerListener listener) {
        this.listenerMux.addExoPlayerListener(listener);
    }

    public void removeExoPlayerListener(ExoPlayerListener listener) {
        this.listenerMux.removeExoPlayerListener(listener);
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener listener) {
        this.listenerMux.setOnPreparedListener(listener);
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener listener) {
        this.listenerMux.setOnCompletionListener(listener);
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener listener) {
        this.listenerMux.setOnErrorListener(listener);
    }

    public void setOnInfoListener(MediaPlayer.OnInfoListener listener) {
        this.listenerMux.setOnInfoListener(listener);
    }

    private void onPlaybackEnded() {
        this.stopPlayback();
        this.pollRepeater.stop();
    }

    public static class TouchVideoView
    extends VideoView {
        private View.OnTouchListener touchListener;

        public TouchVideoView(Context context) {
            super(context);
        }

        public TouchVideoView(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public TouchVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
            super(context, attrs, defStyleAttr);
        }

        @TargetApi(value=21)
        public TouchVideoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            super(context, attrs, defStyleAttr, defStyleRes);
        }

        public boolean onTouchEvent(MotionEvent ev) {
            boolean flag = false;
            if (this.touchListener != null) {
                flag = this.touchListener.onTouch((View)this, ev);
            }
            return flag || super.onTouchEvent(ev);
        }

        public void setOnTouchListener(View.OnTouchListener listener) {
            this.touchListener = listener;
            super.setOnTouchListener(listener);
        }
    }

    private class TouchListener
    extends GestureDetector.SimpleOnGestureListener
    implements View.OnTouchListener {
        private GestureDetector gestureDetector;

        public TouchListener(Context context) {
            this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
        }

        public boolean onTouch(View v, MotionEvent event) {
            this.gestureDetector.onTouchEvent(event);
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (EMVideoView.this.defaultControls != null) {
                EMVideoView.this.defaultControls.show();
                if (EMVideoView.this.isPlaying()) {
                    EMVideoView.this.defaultControls.hideDelayed(2000L);
                }
            }
            if (EMVideoView.this.bus != null) {
                EMVideoView.this.bus.post(new EMVideoViewClickedEvent());
            }
            return true;
        }
    }

    private class EMExoVideoSurfaceCallback
    implements SurfaceHolder.Callback {
        private EMExoVideoSurfaceCallback() {
        }

        public void surfaceCreated(SurfaceHolder holder) {
            if (EMVideoView.this.emExoPlayer != null) {
                EMVideoView.this.emExoPlayer.setSurface(holder.getSurface());
                if (EMVideoView.this.playRequested) {
                    EMVideoView.this.emExoPlayer.setPlayWhenReady(true);
                }
            }
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            if (EMVideoView.this.emExoPlayer != null) {
                EMVideoView.this.emExoPlayer.blockingClearSurface();
            }
        }
    }

    private class MuxNotifier
    extends EMListenerMux.EMListenerMuxNotifier {
        private MuxNotifier() {
        }

        @Override
        public boolean shouldNotifyCompletion(long endLeeway) {
            return EMVideoView.this.getCurrentPosition() + endLeeway >= EMVideoView.this.getDuration();
        }

        @Override
        public void onExoPlayerError(Exception e) {
            if (EMVideoView.this.emExoPlayer != null) {
                EMVideoView.this.emExoPlayer.forcePrepare();
            }
        }

        @Override
        public void onMediaPlaybackEnded() {
            EMVideoView.this.onPlaybackEnded();
        }

        @Override
        public void onVideoSizeChanged(int width, int height, float pixelWidthHeightRatio) {
            float videoAspectRatio = height == 0 ? 1.0f : (float)width * pixelWidthHeightRatio / (float)height;
            EMVideoView.this.exoVideoSurfaceView.setAspectRatio(videoAspectRatio);
            if (width < EMVideoView.this.getWidth() && height < EMVideoView.this.getHeight() && (height = (int)((float)(width = EMVideoView.this.getWidth()) / videoAspectRatio)) > EMVideoView.this.getHeight()) {
                height = EMVideoView.this.getHeight();
                width = (int)((float)height * videoAspectRatio);
            }
            this.updateVideoShutters(EMVideoView.this.getWidth(), EMVideoView.this.getHeight(), width, height);
        }

        @Override
        public void onPrepared() {
            if (EMVideoView.this.defaultControls != null) {
                EMVideoView.this.defaultControls.setDuration(EMVideoView.this.getDuration());
                EMVideoView.this.defaultControls.loadCompleted();
            }
        }

        @Override
        public void onPreviewImageStateChanged(boolean toVisible) {
            if (EMVideoView.this.previewImageView != null) {
                EMVideoView.this.previewImageView.setVisibility(toVisible ? 0 : 8);
            }
        }

        public void updateVideoShutters(int viewWidth, int viewHeight, int videoWidth, int videoHeight) {
            int shutterHeight = this.calculateVerticalShutterSize(viewHeight, videoHeight);
            if (EMVideoView.this.shutterTop != null) {
                ((EMVideoView)EMVideoView.this).shutterTop.getLayoutParams().height = shutterHeight;
                EMVideoView.this.shutterTop.requestLayout();
            }
            if (EMVideoView.this.shutterBottom != null) {
                ((EMVideoView)EMVideoView.this).shutterBottom.getLayoutParams().height = shutterHeight;
                EMVideoView.this.shutterBottom.requestLayout();
            }
            int shutterWidth = this.calculateSideShutterSize(viewWidth, videoWidth);
            if (EMVideoView.this.shutterLeft != null) {
                ((EMVideoView)EMVideoView.this).shutterLeft.getLayoutParams().width = shutterWidth;
                EMVideoView.this.shutterLeft.requestLayout();
            }
            if (EMVideoView.this.shutterRight != null) {
                ((EMVideoView)EMVideoView.this).shutterRight.getLayoutParams().width = shutterWidth;
                EMVideoView.this.shutterRight.requestLayout();
            }
        }

        private int calculateVerticalShutterSize(int viewHeight, int videoHeight) {
            int shutterSize = (viewHeight - videoHeight) / 2;
            return (viewHeight - videoHeight) % 2 == 0 ? shutterSize : shutterSize + 1;
        }

        private int calculateSideShutterSize(int viewWidth, int videoWidth) {
            int shutterSize = (viewWidth - videoWidth) / 2;
            return (viewWidth - videoWidth) % 2 == 0 ? shutterSize : shutterSize + 1;
        }
    }
}

