/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.widget.SeekBar;
import com.devbrackets.android.exomedia.R;
import com.devbrackets.android.exomedia.event.EMMediaProgressEvent;
import com.devbrackets.android.exomedia.util.TimeFormatUtil;
import com.devbrackets.android.exomedia.widget.DefaultControls;

public class DefaultControlsMobile
extends DefaultControls {
    private SeekBar seekBar;
    private boolean pausedForSeek = false;
    private boolean userInteracting = false;

    public DefaultControlsMobile(Context context) {
        super(context);
    }

    public DefaultControlsMobile(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @TargetApi(value=11)
    public DefaultControlsMobile(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public DefaultControlsMobile(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.exomedia_video_controls_overlay;
    }

    @Override
    public void setPosition(long position) {
        this.currentTime.setText((CharSequence)TimeFormatUtil.formatMs(position));
        this.seekBar.setProgress((int)position);
    }

    @Override
    public void setDuration(long duration) {
        if (duration != (long)this.seekBar.getMax()) {
            this.endTime.setText((CharSequence)TimeFormatUtil.formatMs(duration));
            this.seekBar.setMax((int)duration);
        }
    }

    @Override
    public void setProgressEvent(EMMediaProgressEvent event) {
        if (!this.userInteracting) {
            this.seekBar.setSecondaryProgress((int)((float)this.seekBar.getMax() * event.getBufferPercentFloat()));
            this.seekBar.setProgress((int)event.getPosition());
            this.currentTime.setText((CharSequence)TimeFormatUtil.formatMs(event.getPosition()));
        }
    }

    @Override
    protected void retrieveViews() {
        super.retrieveViews();
        this.seekBar = (SeekBar)this.findViewById(R.id.exomedia_controls_video_seek);
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.seekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)new SeekBarChanged());
    }

    @Override
    public void hideDelayed(long delay) {
        this.hideDelay = delay;
        if (delay < 0L || !this.canViewHide) {
            return;
        }
        if (this.userInteracting) {
            return;
        }
        this.visibilityHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                DefaultControlsMobile.this.animateVisibility(false);
            }
        }, delay);
    }

    private class SeekBarChanged
    implements SeekBar.OnSeekBarChangeListener {
        private int seekToTime;

        private SeekBarChanged() {
        }

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            if (!fromUser) {
                return;
            }
            this.seekToTime = progress;
            if (DefaultControlsMobile.this.seekCallbacks != null && DefaultControlsMobile.this.seekCallbacks.onSeekStarted()) {
                return;
            }
            if (DefaultControlsMobile.this.currentTime != null) {
                DefaultControlsMobile.this.currentTime.setText((CharSequence)TimeFormatUtil.formatMs(progress));
            }
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
            DefaultControlsMobile.this.userInteracting = true;
            if (DefaultControlsMobile.this.videoView.isPlaying()) {
                DefaultControlsMobile.this.pausedForSeek = true;
                DefaultControlsMobile.this.videoView.pause();
            }
            DefaultControlsMobile.this.show();
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
            DefaultControlsMobile.this.userInteracting = false;
            if (DefaultControlsMobile.this.seekCallbacks != null && DefaultControlsMobile.this.seekCallbacks.onSeekEnded(this.seekToTime)) {
                return;
            }
            DefaultControlsMobile.this.videoView.seekTo(this.seekToTime);
            if (DefaultControlsMobile.this.pausedForSeek) {
                DefaultControlsMobile.this.pausedForSeek = false;
                DefaultControlsMobile.this.videoView.start();
                DefaultControlsMobile.this.hideDelayed(DefaultControlsMobile.this.hideDelay);
            }
        }
    }
}

