/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.util;

import android.net.Uri;
import android.support.annotation.Nullable;

public class MediaUtil {
    private MediaUtil() {
    }

    public static boolean isLocalFile(String url) {
        return url != null && !url.isEmpty() && (url.startsWith("file") || url.startsWith("/"));
    }

    public static String getUriWithProtocol(String uri) {
        if (uri == null) {
            return "";
        }
        Uri tempUri = Uri.parse((String)uri);
        String protocol = tempUri.getScheme();
        if (protocol == null) {
            return "file://" + uri;
        }
        return uri;
    }

    public static MediaType getMediaType(String mediaUri) {
        String extension = MediaUtil.getExtension(mediaUri);
        if (extension == null) {
            return MediaType.UNKNOWN;
        }
        for (MediaType type : MediaType.values()) {
            if (!type.getExtension().equals(extension)) continue;
            return type;
        }
        return MediaType.UNKNOWN;
    }

    @Nullable
    private static String getExtension(String mediaUri) {
        if (mediaUri == null || mediaUri.trim().isEmpty()) {
            return null;
        }
        int periodIndex = mediaUri.lastIndexOf(46);
        if (periodIndex == -1 || periodIndex >= mediaUri.length()) {
            return null;
        }
        String rawExtension = mediaUri.substring(periodIndex);
        return rawExtension.toLowerCase();
    }

    public static enum MediaType {
        SMOOTH_STREAM(".ism", "application/vnd.ms-sstr+xml"),
        DASH(".mpd", "application/dash+xml"),
        HLS(".m3u8", "application/x-mpegurl"),
        MP4(".mp4", "video/mp4"),
        FMP4(".fmp4", "video/fmp4"),
        M4A(".m4a", "video/m4a"),
        MP3(".mp3", "audio/mp3"),
        TS(".ts", "video/mp2t"),
        AAC(".aac", "audio/aac"),
        WEBM(".webm", "video/webm"),
        MKV(".mkv", "video/mkv"),
        UNKNOWN("", "");

        private String extension;
        private String mimeType;

        private MediaType(String extension, String mimeType) {
            this.extension = extension;
            this.mimeType = mimeType;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getMimeType() {
            return this.mimeType;
        }
    }
}

