/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia.manager;

import android.app.Application;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;
import android.util.Log;
import com.devbrackets.android.exomedia.EMVideoView;
import com.devbrackets.android.exomedia.event.EMMediaProgressEvent;
import com.devbrackets.android.exomedia.event.EMPlaylistItemChangedEvent;
import com.devbrackets.android.exomedia.listener.EMPlaylistServiceCallback;
import com.devbrackets.android.exomedia.service.EMPlaylistService;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class EMPlaylistManager<I extends PlaylistItem>
implements EMPlaylistServiceCallback {
    private static final String TAG = "EMPlaylistManager";
    public static final int INVALID_PLAYLIST_ID = -1;
    public static final int INVALID_PLAYLIST_INDEX = -1;
    protected List<I> playList;
    protected int currentPosition = 0;
    protected long playListId = -1L;
    protected MediaType allowedType = MediaType.AUDIO;
    protected WeakReference<EMVideoView> videoPlayer = new WeakReference<Object>(null);
    @Nullable
    protected EMPlaylistService service;
    protected List<EMPlaylistServiceCallback> callbackList = new ArrayList<EMPlaylistServiceCallback>();
    @Nullable
    protected PendingIntent playPausePendingIntent;
    @Nullable
    protected PendingIntent nextPendingIntent;
    @Nullable
    protected PendingIntent previousPendingIntent;
    @Nullable
    protected PendingIntent stopPendingIntent;
    @Nullable
    protected PendingIntent repeatPendingIntent;
    @Nullable
    protected PendingIntent shufflePendingIntent;
    @Nullable
    protected PendingIntent seekStartedPendingIntent;
    @Nullable
    protected Intent seekEndedIntent;
    @Nullable
    protected Intent allowedTypeChangedIntent;

    protected abstract Application getApplication();

    protected abstract Class<? extends Service> getMediaServiceClass();

    public EMPlaylistManager() {
        this.constructControlIntents(this.getMediaServiceClass(), this.getApplication());
    }

    public EMPlaylistManager(Application application) {
        this.constructControlIntents(this.getMediaServiceClass(), application);
    }

    @Override
    public boolean onPlaylistItemChanged(PlaylistItem currentItem, boolean hasNext, boolean hasPrevious) {
        for (EMPlaylistServiceCallback callback : this.callbackList) {
            if (!callback.onPlaylistItemChanged(currentItem, hasNext, hasPrevious)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onMediaStateChanged(EMPlaylistService.MediaState mediaState) {
        for (EMPlaylistServiceCallback callback : this.callbackList) {
            if (!callback.onMediaStateChanged(mediaState)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onProgressUpdated(EMMediaProgressEvent event) {
        for (EMPlaylistServiceCallback callback : this.callbackList) {
            if (!callback.onProgressUpdated(event)) continue;
            return true;
        }
        return false;
    }

    public EMPlaylistService.MediaState getCurrentMediaState() {
        if (this.service != null) {
            return this.service.getCurrentMediaState();
        }
        return EMPlaylistService.MediaState.STOPPED;
    }

    @Nullable
    public EMMediaProgressEvent getCurrentProgress() {
        return this.service != null ? this.service.getCurrentMediaProgress() : null;
    }

    @Nullable
    public EMPlaylistItemChangedEvent getCurrentItemChangedEvent() {
        return this.service != null ? this.service.getCurrentItemChangedEvent() : null;
    }

    public void registerService(EMPlaylistService service) {
        this.service = service;
        service.registerCallback(this);
    }

    public void unRegisterService() {
        if (this.service != null) {
            this.service.unRegisterCallback(this);
            this.service = null;
        }
    }

    public void registerServiceCallbacks(EMPlaylistServiceCallback callback) {
        if (callback != null) {
            this.callbackList.add(callback);
        }
    }

    public void unRegisterServiceCallbacks(EMPlaylistServiceCallback callback) {
        if (callback != null) {
            this.callbackList.remove(callback);
        }
    }

    public void play(List<I> playListItems, int startIndex, int seekPosition, boolean startPaused) {
        this.setParameters(playListItems, startIndex);
        this.play(seekPosition, startPaused);
    }

    public void play(int seekPosition, boolean startPaused) {
        I currentItem = this.getCurrentItem();
        if (currentItem == null) {
            return;
        }
        Intent intent = new Intent((Context)this.getApplication(), this.getMediaServiceClass());
        intent.setAction("remote_action_start_service");
        intent.putExtra("remote_action_seek_position", seekPosition);
        intent.putExtra("remote_action_start_paused", startPaused);
        this.getApplication().startService(intent);
    }

    public void setParameters(List<I> playListItems, int startIndex) {
        this.playList = playListItems;
        this.setCurrentIndex(startIndex);
        this.setPlaylistId(-1L);
    }

    public void setPlaylistId(long playListId) {
        this.playListId = playListId;
    }

    public void setAllowedMediaType(MediaType allowedType) {
        this.allowedType = allowedType;
        if (this.allowedTypeChangedIntent != null) {
            this.allowedTypeChangedIntent.putExtra("remote_action_allowed_type", (Serializable)((Object)allowedType));
            this.getApplication().startService(this.allowedTypeChangedIntent);
        }
    }

    public void setCurrentIndex(int index) {
        if (index >= this.getPlayListSize()) {
            index = this.getPlayListSize() - 1;
        }
        this.currentPosition = this.findNextAllowedIndex(index);
    }

    public int getCurrentIndex() {
        return this.currentPosition;
    }

    public void setCurrentItem(long itemId) {
        if (this.playList == null) {
            return;
        }
        int index = this.getIndexForItem(itemId);
        if (index != -1) {
            this.setCurrentIndex(index);
        }
    }

    public int getIndexForItem(long itemId) {
        if (this.playList == null) {
            return -1;
        }
        int index = 0;
        for (PlaylistItem item : this.playList) {
            if (item.getId() == itemId) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public boolean isPlayingItem(I item) {
        I currentItem = this.getCurrentItem();
        if (item == null || currentItem == null) {
            return false;
        }
        return item.getId() == currentItem.getId() && item.getPlaylistId() == this.playListId;
    }

    public boolean isNextAvailable() {
        return this.getPlayListSize() > this.findNextAllowedIndex(this.currentPosition + 1);
    }

    public boolean isPreviousAvailable() {
        return this.findPreviousAllowedIndex(this.currentPosition - 1) != this.getPlayListSize();
    }

    public long getPlayListId() {
        return this.playListId;
    }

    public MediaType getCurrentItemType() {
        I item = this.getCurrentItem();
        return item != null ? item.getMediaType() : MediaType.NONE;
    }

    public int getPlayListSize() {
        return this.playList == null ? 0 : this.playList.size();
    }

    @Nullable
    public I getItem(int index) {
        if (this.playList == null || index < 0 || index >= this.playList.size()) {
            return null;
        }
        return (I)((PlaylistItem)this.playList.get(index));
    }

    @Nullable
    public I getCurrentItem() {
        if (this.currentPosition < this.getPlayListSize()) {
            return this.getItem(this.currentPosition);
        }
        return null;
    }

    @Nullable
    public I next() {
        this.currentPosition = this.findNextAllowedIndex(this.currentPosition + 1);
        return this.getCurrentItem();
    }

    @Nullable
    public I previous() {
        this.currentPosition = this.findPreviousAllowedIndex(this.currentPosition - 1);
        return this.getCurrentItem();
    }

    public void setVideoView(@Nullable EMVideoView videoView) {
        this.videoPlayer = new WeakReference<EMVideoView>(videoView);
    }

    @Nullable
    public EMVideoView getVideoView() {
        return (EMVideoView)this.videoPlayer.get();
    }

    public void invokePausePlay() {
        this.sendPendingIntent(this.playPausePendingIntent);
    }

    public void invokeNext() {
        this.sendPendingIntent(this.nextPendingIntent);
    }

    public void invokePrevious() {
        this.sendPendingIntent(this.previousPendingIntent);
    }

    public void invokeStop() {
        this.sendPendingIntent(this.stopPendingIntent);
    }

    public void invokeRepeat() {
        this.sendPendingIntent(this.repeatPendingIntent);
    }

    public void invokeShuffle() {
        this.sendPendingIntent(this.shufflePendingIntent);
    }

    public void invokeSeekStarted() {
        this.sendPendingIntent(this.seekStartedPendingIntent);
    }

    public void invokeSeekEnded(int seekPosition) {
        if (this.seekEndedIntent != null) {
            this.seekEndedIntent.putExtra("remote_action_seek_position", seekPosition);
            this.getApplication().startService(this.seekEndedIntent);
        }
    }

    protected void constructControlIntents(Class<? extends Service> mediaServiceClass, Application application) {
        this.previousPendingIntent = this.createPendingIntent(application, mediaServiceClass, "remote_action_previous");
        this.nextPendingIntent = this.createPendingIntent(application, mediaServiceClass, "remote_action_next");
        this.playPausePendingIntent = this.createPendingIntent(application, mediaServiceClass, "remote_action_play_pause");
        this.repeatPendingIntent = this.createPendingIntent(application, mediaServiceClass, "remote_action_repeat");
        this.shufflePendingIntent = this.createPendingIntent(application, mediaServiceClass, "remote_action_shuffle");
        this.stopPendingIntent = this.createPendingIntent(application, mediaServiceClass, "remote_action_stop");
        this.seekStartedPendingIntent = this.createPendingIntent(application, mediaServiceClass, "remote_action_seek_started");
        this.seekEndedIntent = new Intent((Context)application, mediaServiceClass);
        this.seekEndedIntent.setAction("remote_action_seek_ended");
        this.allowedTypeChangedIntent = new Intent((Context)application, mediaServiceClass);
        this.allowedTypeChangedIntent.setAction("remote_action_allowed_type_changed");
    }

    protected int findNextAllowedIndex(int index) {
        if (index >= this.getPlayListSize()) {
            return this.getPlayListSize();
        }
        if (index < 0) {
            index = 0;
        }
        while (index < this.getPlayListSize() && !this.isAllowedType((PlaylistItem)this.playList.get(index))) {
            ++index;
        }
        return index < this.getPlayListSize() ? index : this.getPlayListSize();
    }

    protected int findPreviousAllowedIndex(int index) {
        if (index >= this.getPlayListSize() || index < 0) {
            return this.getPlayListSize();
        }
        while (index >= 0 && !this.isAllowedType((PlaylistItem)this.playList.get(index))) {
            --index;
        }
        return index >= 0 ? index : this.getPlayListSize();
    }

    protected boolean isAllowedType(@Nullable I item) {
        if (item == null || item.getMediaType() == MediaType.NONE) {
            return false;
        }
        if (this.allowedType == MediaType.AUDIO_AND_VIDEO) {
            return item.getMediaType() == MediaType.AUDIO || item.getMediaType() == MediaType.VIDEO;
        }
        return this.allowedType == item.getMediaType();
    }

    protected PendingIntent createPendingIntent(Application application, Class<? extends Service> serviceClass, String action) {
        Intent intent = new Intent((Context)application, serviceClass);
        intent.setAction(action);
        return PendingIntent.getService((Context)application, (int)0, (Intent)intent, (int)0x8000000);
    }

    protected void sendPendingIntent(PendingIntent pi) {
        if (pi == null) {
            return;
        }
        try {
            pi.send();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)("Error sending pending intent " + pi.toString()), (Throwable)e);
        }
    }

    public static interface PlaylistItem {
        public long getId();

        public long getPlaylistId();

        public MediaType getMediaType();

        public String getMediaUrl();

        public String getDownloadedMediaUri();

        public String getThumbnailUrl();

        public String getArtworkUrl();

        public String getTitle();

        public String getAlbum();

        public String getArtist();
    }

    public static enum MediaType {
        AUDIO,
        VIDEO,
        AUDIO_AND_VIDEO,
        OTHER,
        NONE;

    }
}

