/*
 * Decompiled with CFR 0.152.
 */
package com.devbrackets.android.exomedia;

import android.media.MediaPlayer;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.devbrackets.android.exomedia.event.EMMediaCompletionEvent;
import com.devbrackets.android.exomedia.event.EMMediaErrorEvent;
import com.devbrackets.android.exomedia.event.EMMediaPreparedEvent;
import com.devbrackets.android.exomedia.listener.ExoPlayerListener;
import com.devbrackets.android.exomedia.util.EMEventBus;
import java.util.LinkedList;
import java.util.List;

class EMListenerMux
implements ExoPlayerListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnBufferingUpdateListener {
    private static final long COMPLETED_DURATION_LEEWAY = 1000L;
    private boolean notifiedPrepared = false;
    private boolean notifiedCompleted = false;
    private Handler delayedHandler = new Handler();
    private EMListenerMuxNotifier muxNotifier;
    @Nullable
    private EMEventBus bus;
    private List<ExoPlayerListener> exoPlayerListeners = new LinkedList<ExoPlayerListener>();
    private MediaPlayer.OnBufferingUpdateListener bufferingUpdateListener;
    private MediaPlayer.OnCompletionListener completionListener;
    private MediaPlayer.OnPreparedListener preparedListener;
    private MediaPlayer.OnErrorListener errorListener;
    private MediaPlayer.OnInfoListener infoListener;

    EMListenerMux(@NonNull EMListenerMuxNotifier notifier) {
        this.muxNotifier = notifier;
    }

    public void onBufferingUpdate(MediaPlayer mp, int percent) {
        this.muxNotifier.onBufferUpdated(percent);
        if (this.bufferingUpdateListener != null) {
            this.bufferingUpdateListener.onBufferingUpdate(mp, percent);
        }
    }

    public void onCompletion(MediaPlayer mp) {
        if (this.completionListener != null) {
            this.completionListener.onCompletion(null);
        }
        if (this.bus != null) {
            this.bus.post(new EMMediaCompletionEvent());
        }
    }

    public boolean onError(MediaPlayer mp, int what, int extra) {
        if (this.errorListener != null && this.errorListener.onError(mp, what, extra)) {
            return true;
        }
        if (this.bus != null) {
            this.bus.post(new EMMediaErrorEvent(mp, what, extra));
            return true;
        }
        return false;
    }

    public boolean onInfo(MediaPlayer mp, int what, int extra) {
        return this.infoListener != null && this.infoListener.onInfo(mp, what, extra);
    }

    public void onPrepared(final MediaPlayer mp) {
        this.notifiedPrepared = true;
        this.delayedHandler.post(new Runnable(){

            @Override
            public void run() {
                EMListenerMux.this.performPreparedHandlerNotification(mp);
            }
        });
    }

    @Override
    public void onError(Exception e) {
        this.muxNotifier.onExoPlayerError(e);
        this.muxNotifier.onMediaPlaybackEnded();
        if (this.errorListener != null && this.errorListener.onError(null, 0, 0)) {
            return;
        }
        for (ExoPlayerListener listener : this.exoPlayerListeners) {
            listener.onError(e);
        }
        if (this.bus != null) {
            this.bus.post(new EMMediaErrorEvent(null, 0, 0));
        }
    }

    @Override
    public void onStateChanged(boolean playWhenReady, int playbackState) {
        if (playbackState == 5) {
            this.muxNotifier.onMediaPlaybackEnded();
            if (!this.notifiedCompleted) {
                this.notifyCompletionListener();
            }
        } else if (playbackState == 4 && !this.notifiedPrepared) {
            this.notifyPreparedListener(null);
        }
        for (ExoPlayerListener listener : this.exoPlayerListeners) {
            listener.onStateChanged(playWhenReady, playbackState);
        }
        if (playbackState == 4 && playWhenReady) {
            this.muxNotifier.onPreviewImageStateChanged(false);
        }
    }

    @Override
    public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
        this.muxNotifier.onVideoSizeChanged(width, height, pixelWidthHeightRatio);
        for (ExoPlayerListener listener : this.exoPlayerListeners) {
            listener.onVideoSizeChanged(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
        }
    }

    public void setBus(@Nullable EMEventBus bus) {
        this.bus = bus;
    }

    public void addExoPlayerListener(ExoPlayerListener listener) {
        if (listener != null) {
            this.exoPlayerListeners.add(listener);
        }
    }

    public void removeExoPlayerListener(ExoPlayerListener listener) {
        if (listener != null && this.exoPlayerListeners.contains(listener)) {
            this.exoPlayerListeners.remove(listener);
        }
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener listener) {
        this.preparedListener = listener;
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener listener) {
        this.completionListener = listener;
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener listener) {
        this.errorListener = listener;
    }

    public void setOnInfoListener(MediaPlayer.OnInfoListener listener) {
        this.infoListener = listener;
    }

    public void setOnBufferingUpdateListener(MediaPlayer.OnBufferingUpdateListener listener) {
        this.bufferingUpdateListener = listener;
    }

    public void setNotifiedPrepared(boolean wasNotified) {
        this.notifiedPrepared = wasNotified;
        this.muxNotifier.onPreviewImageStateChanged(true);
    }

    public boolean isPrepared() {
        return this.notifiedPrepared;
    }

    public void setNotifiedCompleted(boolean wasNotified) {
        this.notifiedCompleted = wasNotified;
    }

    private void notifyPreparedListener(final MediaPlayer mediaPlayer) {
        this.notifiedPrepared = true;
        this.delayedHandler.post(new Runnable(){

            @Override
            public void run() {
                EMListenerMux.this.performPreparedHandlerNotification(mediaPlayer);
            }
        });
    }

    private void performPreparedHandlerNotification(MediaPlayer mediaPlayer) {
        this.muxNotifier.onPrepared();
        if (this.preparedListener != null) {
            this.preparedListener.onPrepared(mediaPlayer);
        }
        if (this.bus != null) {
            this.bus.post(new EMMediaPreparedEvent());
        }
    }

    private void notifyCompletionListener() {
        if (!this.muxNotifier.shouldNotifyCompletion(1000L)) {
            return;
        }
        this.notifiedCompleted = true;
        this.delayedHandler.post(new Runnable(){

            @Override
            public void run() {
                if (EMListenerMux.this.completionListener != null) {
                    EMListenerMux.this.completionListener.onCompletion(null);
                }
                if (EMListenerMux.this.bus != null) {
                    EMListenerMux.this.bus.post(new EMMediaCompletionEvent());
                }
            }
        });
    }

    public static abstract class EMListenerMuxNotifier {
        public void onBufferUpdated(int percent) {
        }

        public void onVideoSizeChanged(int width, int height, float pixelWidthHeightRatio) {
        }

        public void onPrepared() {
        }

        public void onPreviewImageStateChanged(boolean toVisible) {
        }

        public abstract boolean shouldNotifyCompletion(long var1);

        public abstract void onExoPlayerError(Exception var1);

        public abstract void onMediaPlaybackEnded();
    }
}

