/*
 * Decompiled with CFR 0.152.
 */
package com.desmond.squarecamera;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.desmond.squarecamera.CameraActivity;
import com.desmond.squarecamera.ImageParameters;
import com.desmond.squarecamera.ImageUtility;
import com.desmond.squarecamera.R;
import com.desmond.squarecamera.RuntimePermissionActivity;

public class EditSavePhotoFragment
extends Fragment {
    public static final String TAG = EditSavePhotoFragment.class.getSimpleName();
    public static final String BITMAP_KEY = "bitmap_byte_array";
    public static final String ROTATION_KEY = "rotation";
    public static final String IMAGE_INFO = "image_info";
    private static final int REQUEST_STORAGE = 1;

    public static Fragment newInstance(byte[] bitmapByteArray, int rotation, @NonNull ImageParameters parameters) {
        EditSavePhotoFragment fragment = new EditSavePhotoFragment();
        Bundle args = new Bundle();
        args.putByteArray(BITMAP_KEY, bitmapByteArray);
        args.putInt(ROTATION_KEY, rotation);
        args.putParcelable(IMAGE_INFO, (Parcelable)parameters);
        fragment.setArguments(args);
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.squarecamera__fragment_edit_save_photo, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        int rotation = this.getArguments().getInt(ROTATION_KEY);
        byte[] data = this.getArguments().getByteArray(BITMAP_KEY);
        ImageParameters imageParameters = (ImageParameters)this.getArguments().getParcelable(IMAGE_INFO);
        if (imageParameters == null) {
            return;
        }
        ImageView photoImageView = (ImageView)view.findViewById(R.id.photo);
        imageParameters.mIsPortrait = this.getResources().getConfiguration().orientation == 1;
        View topView = view.findViewById(R.id.topView);
        if (imageParameters.mIsPortrait) {
            topView.getLayoutParams().height = imageParameters.mCoverHeight;
        } else {
            topView.getLayoutParams().width = imageParameters.mCoverWidth;
        }
        this.rotatePicture(rotation, data, photoImageView);
        view.findViewById(R.id.save_photo).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EditSavePhotoFragment.this.savePicture();
            }
        });
    }

    private void rotatePicture(int rotation, byte[] data, ImageView photoImageView) {
        Bitmap bitmap = ImageUtility.decodeSampledBitmapFromByte((Context)this.getActivity(), data);
        if (rotation != 0) {
            Bitmap oldBitmap = bitmap;
            Matrix matrix = new Matrix();
            matrix.postRotate((float)rotation);
            bitmap = Bitmap.createBitmap((Bitmap)oldBitmap, (int)0, (int)0, (int)oldBitmap.getWidth(), (int)oldBitmap.getHeight(), (Matrix)matrix, (boolean)false);
            oldBitmap.recycle();
        }
        photoImageView.setImageBitmap(bitmap);
    }

    private void savePicture() {
        this.requestForPermission();
    }

    private void requestForPermission() {
        RuntimePermissionActivity.startActivity(this, 1, "android.permission.WRITE_EXTERNAL_STORAGE", new String[0]);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (-1 != resultCode) {
            return;
        }
        if (1 == requestCode && data != null) {
            boolean isGranted = data.getBooleanExtra("requested_permission", false);
            View view = this.getView();
            if (isGranted && view != null) {
                ImageView photoImageView = (ImageView)view.findViewById(R.id.photo);
                Bitmap bitmap = ((BitmapDrawable)photoImageView.getDrawable()).getBitmap();
                Uri photoUri = ImageUtility.savePicture((Context)this.getActivity(), bitmap);
                ((CameraActivity)this.getActivity()).returnPhotoUri(photoUri);
            }
        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }
}

