/*
 * Decompiled with CFR 0.152.
 */
package com.bosphere.filelogger;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.bosphere.filelogger.FL;
import com.bosphere.filelogger.FLUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

public class FileLoggerService
extends IntentService {
    private static final String EXTRA_FILE_NAME = "EXTRA_FILE_NAME";
    private static final String EXTRA_DIR_PATH = "EXTRA_DIR_PATH";
    private static final String EXTRA_LINE = "EXTRA_LINE";
    private static final String EXTRA_RETENTION_POLICY = "EXTRA_RETENTION_POLICY";
    private static final String EXTRA_MAX_FILE_COUNT = "EXTRA_MAX_FILE_COUNT";
    private static final String EXTRA_MAX_SIZE = "EXTRA_MAX_SIZE";
    private static final Comparator<File> FILE_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            long lm2;
            long lm1 = o1.lastModified();
            return lm1 < (lm2 = o2.lastModified()) ? -1 : (lm1 == lm2 ? 0 : 1);
        }
    };
    private int mRetentionPolicy;
    private int mMaxFileCount;
    private long mMaxSize;
    private BufferedWriter mWriter;
    private String mPath;

    static void logFile(Context context, String fileName, String dirPath, String line, int retentionPolicy, int maxFileCount, long maxTotalSize) {
        Intent intent = new Intent(context, FileLoggerService.class);
        intent.putExtra(EXTRA_FILE_NAME, fileName);
        intent.putExtra(EXTRA_DIR_PATH, dirPath);
        intent.putExtra(EXTRA_LINE, line);
        intent.putExtra(EXTRA_RETENTION_POLICY, retentionPolicy);
        intent.putExtra(EXTRA_MAX_FILE_COUNT, maxFileCount);
        intent.putExtra(EXTRA_MAX_SIZE, maxTotalSize);
        context.startService(intent);
    }

    public FileLoggerService() {
        super("file-logger");
    }

    protected void onHandleIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        String fileName = intent.getStringExtra(EXTRA_FILE_NAME);
        String dirPath = intent.getStringExtra(EXTRA_DIR_PATH);
        String line = intent.getStringExtra(EXTRA_LINE);
        this.mRetentionPolicy = intent.getIntExtra(EXTRA_RETENTION_POLICY, 0);
        this.mMaxFileCount = intent.getIntExtra(EXTRA_MAX_FILE_COUNT, 0);
        this.mMaxSize = intent.getLongExtra(EXTRA_MAX_SIZE, 0L);
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            throw new IllegalStateException("invalid file name: [" + fileName + "]");
        }
        if (TextUtils.isEmpty((CharSequence)dirPath)) {
            throw new IllegalStateException("invalid directory path: [" + dirPath + "]");
        }
        if (TextUtils.isEmpty((CharSequence)line)) {
            return;
        }
        File dir = new File(dirPath);
        FLUtil.ensureDir(dir);
        this.logLine(dir, fileName, line);
    }

    private void logLine(File dir, String fileName, String line) {
        File f = new File(dir, fileName);
        String path = f.getAbsolutePath();
        if (this.mWriter != null && path.equals(this.mPath)) {
            try {
                this.mWriter.write(line);
                this.mWriter.write("\n");
            }
            catch (IOException e) {
                FL.e("FileLogger", e);
            }
        } else {
            this.closeWriter();
            FLUtil.ensureFile(f);
            try {
                this.mWriter = this.createWriter(f);
                this.mPath = f.getAbsolutePath();
                this.mWriter.write(line);
                this.mWriter.write("\n");
            }
            catch (IOException e) {
                FL.e("FileLogger", e);
            }
        }
    }

    private BufferedWriter createWriter(File file) throws IOException {
        return new BufferedWriter(new FileWriter(file, true));
    }

    public void onDestroy() {
        super.onDestroy();
        this.closeWriter();
        this.startHouseKeeping();
    }

    private void startHouseKeeping() {
        if (TextUtils.isEmpty((CharSequence)this.mPath)) {
            return;
        }
        if (this.mRetentionPolicy == 1) {
            this.houseKeepByCount(this.mMaxFileCount);
        } else if (this.mRetentionPolicy == 2) {
            this.houseKeepBySize(this.mMaxSize);
        }
    }

    private void houseKeepByCount(int maxCount) {
        if (maxCount <= 0) {
            throw new IllegalStateException("invalid max file count: " + maxCount);
        }
        File file = new File(this.mPath);
        File dir = file.getParentFile();
        if (dir == null) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null || files.length <= maxCount) {
            return;
        }
        Arrays.sort(files, FILE_COMPARATOR);
        int deleteCount = files.length - maxCount;
        int successCount = 0;
        for (int i = 0; i < deleteCount; ++i) {
            if (!files[i].delete()) continue;
            ++successCount;
        }
        FL.d("FileLogger", "house keeping complete: file count [%d -> %d]", files.length, files.length - successCount);
    }

    private void houseKeepBySize(long maxSize) {
        if (maxSize <= 0L) {
            throw new IllegalStateException("invalid max total size: " + maxSize);
        }
        File file = new File(this.mPath);
        File dir = file.getParentFile();
        if (dir == null) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        long totalSize = 0L;
        for (File f : files) {
            totalSize += f.length();
        }
        if (totalSize <= maxSize) {
            return;
        }
        Arrays.sort(files, FILE_COMPARATOR);
        long newSize = totalSize;
        for (File f : files) {
            long size = f.length();
            if (f.delete() && (newSize -= size) <= maxSize) break;
        }
        FL.d("FileLogger", "house keeping complete: total size [%d -> %d]", totalSize, newSize);
    }

    private void closeWriter() {
        if (this.mWriter != null) {
            try {
                this.mWriter.close();
            }
            catch (IOException e) {
                FL.e("FileLogger", e);
            }
        }
    }
}

