/*
 * Decompiled with CFR 0.152.
 */
package com.bosphere.filelogger;

import android.content.Context;
import android.text.TextUtils;
import com.bosphere.filelogger.FLConfig;
import com.bosphere.filelogger.FLConst;
import com.bosphere.filelogger.FLUtil;
import com.bosphere.filelogger.FileLoggerService;
import com.bosphere.filelogger.Loggable;

public class FL {
    private static volatile boolean sEnabled;
    private static volatile FLConfig sConfig;

    public static void setEnabled(boolean enabled) {
        sEnabled = enabled;
    }

    public static void init(Context context) {
        FL.init(new FLConfig.Builder(context).build());
    }

    public static void init(FLConfig config) {
        sConfig = config;
    }

    public static void v(String fmt, Object ... args) {
        FL.v(null, fmt, args);
    }

    public static void v(String tag, String fmt, Object ... args) {
        FL.log(FLConst.Level.V, tag, FLUtil.format(fmt, args));
    }

    public static void d(String fmt, Object ... args) {
        FL.d(null, fmt, args);
    }

    public static void d(String tag, String fmt, Object ... args) {
        FL.log(FLConst.Level.D, tag, FLUtil.format(fmt, args));
    }

    public static void i(String fmt, Object ... args) {
        FL.log(FLConst.Level.I, null, FLUtil.format(fmt, args));
    }

    public static void i(String tag, String fmt, Object ... args) {
        FL.log(FLConst.Level.I, tag, FLUtil.format(fmt, args));
    }

    public static void w(String fmt, Object ... args) {
        FL.w(null, fmt, args);
    }

    public static void w(String tag, String fmt, Object ... args) {
        FL.log(FLConst.Level.W, tag, FLUtil.format(fmt, args));
    }

    public static void e(String fmt, Object ... args) {
        FL.e((String)null, fmt, args);
    }

    public static void e(String tag, String fmt, Object ... args) {
        FL.log(FLConst.Level.E, tag, FLUtil.format(fmt, args));
    }

    public static void e(Throwable tr) {
        FL.e(null, tr);
    }

    public static void e(String tag, Throwable tr) {
        FL.e(tag, tr, null, new Object[0]);
    }

    public static void e(Throwable tr, String fmt, Object ... args) {
        FL.e(null, tr, fmt, args);
    }

    public static void e(String tag, Throwable tr, String fmt, Object ... args) {
        StringBuilder sb = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)fmt)) {
            sb.append(FLUtil.format(fmt, args));
        }
        if (tr != null) {
            sb.append(FLUtil.formatThrowable(tr));
        }
        FL.log(FLConst.Level.E, tag, sb.toString());
    }

    private static void log(FLConst.Level level, String tag, String log) {
        Loggable logger;
        if (!sEnabled) {
            return;
        }
        FL.ensureStatus();
        FLConfig config = sConfig;
        if (TextUtils.isEmpty((CharSequence)tag)) {
            tag = config.b.defaultTag;
        }
        if ((logger = config.b.logger) != null) {
            switch (level) {
                case V: {
                    logger.v(tag, log);
                    break;
                }
                case D: {
                    logger.d(tag, log);
                    break;
                }
                case I: {
                    logger.i(tag, log);
                    break;
                }
                case W: {
                    logger.w(tag, log);
                    break;
                }
                case E: {
                    logger.e(tag, log);
                }
            }
        }
        if (config.b.logToFile && !TextUtils.isEmpty((CharSequence)config.b.dirPath)) {
            long timeMs = System.currentTimeMillis();
            String fileName = config.b.formatter.formatFileName(timeMs);
            String line = config.b.formatter.formatLine(timeMs, level.name(), tag, log);
            FileLoggerService.logFile(config.b.context, fileName, config.b.dirPath, line, config.b.retentionPolicy, config.b.maxFileCount, config.b.maxSize);
        }
    }

    private static void ensureStatus() {
        if (sConfig == null) {
            throw new IllegalStateException("FileLogger is not initialized. Forgot to call FL.init()?");
        }
    }
}

