/*
 * Decompiled with CFR 0.152.
 */
package com.innovatrics.mrz.records;

import com.innovatrics.mrz.MrzParseException;
import com.innovatrics.mrz.MrzParser;
import com.innovatrics.mrz.MrzRange;
import com.innovatrics.mrz.MrzRecordOptional;
import com.innovatrics.mrz.types.MrzDocumentCode;
import com.innovatrics.mrz.types.MrzFormat;

public class MrvA
extends MrzRecordOptional {
    private static final long serialVersionUID = 1L;

    public MrvA() {
        super(MrzFormat.MRV_VISA_A, "MRV-A");
        this.setCode(MrzDocumentCode.TYPE_V);
        this.setCode1('V');
        this.setCode2('<');
    }

    @Override
    public void fromMrz(String mrz) throws MrzParseException {
        super.fromMrz(mrz);
        MrzParser parser = new MrzParser(mrz);
        this.setName(parser.parseName(new MrzRange(5, 44, 0)));
        this.setDocumentNumber(parser.parseString(new MrzRange(0, 9, 1)));
        this.setValidDocumentNumber(parser.checkDigit(9, 1, new MrzRange(0, 9, 1), "passport number"));
        this.setNationality(parser.parseString(new MrzRange(10, 13, 1)));
        this.setDateOfBirth(parser.parseDate(new MrzRange(13, 19, 1)));
        this.setValidDateOfBirth(parser.checkDigit(19, 1, new MrzRange(13, 19, 1), "date of birth") && this.getDateOfBirth().isDateValid());
        this.setSex(parser.parseSex(20, 1));
        this.setExpirationDate(parser.parseDate(new MrzRange(21, 27, 1)));
        this.setValidExpirationDate(parser.checkDigit(27, 1, new MrzRange(21, 27, 1), "expiration date") && this.getExpirationDate().isDateValid());
        this.setOptional(parser.parseString(new MrzRange(28, 44, 1)));
    }

    @Override
    public String toMrz() {
        StringBuilder sb = new StringBuilder("V<");
        sb.append(MrzParser.toMrz(this.getIssuingCountry(), 3));
        sb.append(MrzParser.nameToMrz(this.getSurname(), this.getGivenNames(), 39));
        sb.append('\n');
        sb.append(MrzParser.toMrz(this.getDocumentNumber(), 9));
        sb.append(MrzParser.computeCheckDigitChar(MrzParser.toMrz(this.getDocumentNumber(), 9)));
        sb.append(MrzParser.toMrz(this.getNationality(), 3));
        sb.append(this.getDateOfBirth().toMrz());
        sb.append(MrzParser.computeCheckDigitChar(this.getDateOfBirth().toMrz()));
        sb.append(this.getSex().getMrz());
        sb.append(this.getExpirationDate().toMrz());
        sb.append(MrzParser.computeCheckDigitChar(this.getExpirationDate().toMrz()));
        sb.append(MrzParser.toMrz(this.getOptional(), 16));
        sb.append('\n');
        return sb.toString();
    }
}

