/*
 * Decompiled with CFR 0.152.
 */
package com.innovatrics.mrz.records;

import com.innovatrics.mrz.MrzParseException;
import com.innovatrics.mrz.MrzParser;
import com.innovatrics.mrz.MrzRange;
import com.innovatrics.mrz.MrzRecordOptional;
import com.innovatrics.mrz.types.MrzFormat;

public class MrtdTd2
extends MrzRecordOptional {
    private static final long serialVersionUID = 1L;

    public MrtdTd2() {
        super(MrzFormat.MRTD_TD2, "MRTD-TD2");
    }

    @Override
    public void fromMrz(String mrz) throws MrzParseException {
        super.fromMrz(mrz);
        MrzParser parser = new MrzParser(mrz);
        this.setName(parser.parseName(new MrzRange(5, 36, 0)));
        this.setDocumentNumber(parser.parseString(new MrzRange(0, 9, 1)));
        this.setValidDocumentNumber(parser.checkDigit(9, 1, new MrzRange(0, 9, 1), "document number"));
        this.setNationality(parser.parseString(new MrzRange(10, 13, 1)));
        this.setDateOfBirth(parser.parseDate(new MrzRange(13, 19, 1)));
        this.setValidDateOfBirth(parser.checkDigit(19, 1, new MrzRange(13, 19, 1), "date of birth") && this.getDateOfBirth().isDateValid());
        this.setSex(parser.parseSex(20, 1));
        this.setExpirationDate(parser.parseDate(new MrzRange(21, 27, 1)));
        this.setValidExpirationDate(parser.checkDigit(27, 1, new MrzRange(21, 27, 1), "expiration date") && this.getExpirationDate().isDateValid());
        this.setOptional(parser.parseString(new MrzRange(28, 35, 1)));
        this.setValidComposite(parser.checkDigit(35, 1, parser.rawValue(new MrzRange(0, 10, 1), new MrzRange(13, 20, 1), new MrzRange(21, 35, 1)), "mrz"));
    }

    @Override
    public String toMrz() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCode1());
        sb.append(this.getCode2());
        sb.append(MrzParser.toMrz(this.getIssuingCountry(), 3));
        sb.append(MrzParser.nameToMrz(this.getSurname(), this.getGivenNames(), 31));
        sb.append('\n');
        String dn = MrzParser.toMrz(this.getDocumentNumber(), 9) + MrzParser.computeCheckDigitChar(MrzParser.toMrz(this.getDocumentNumber(), 9));
        sb.append(dn);
        sb.append(MrzParser.toMrz(this.getNationality(), 3));
        String dob = this.getDateOfBirth().toMrz() + MrzParser.computeCheckDigitChar(this.getDateOfBirth().toMrz());
        sb.append(dob);
        sb.append(this.getSex().getMrz());
        String ed = this.getExpirationDate().toMrz() + MrzParser.computeCheckDigitChar(this.getExpirationDate().toMrz());
        sb.append(ed);
        sb.append(MrzParser.toMrz(this.getOptional(), 7));
        sb.append(MrzParser.computeCheckDigitChar(dn + dob + ed + MrzParser.toMrz(this.getOptional(), 7)));
        sb.append('\n');
        return sb.toString();
    }
}

