/*
 * Decompiled with CFR 0.152.
 */
package com.innovatrics.mrz.records;

import com.innovatrics.mrz.MrzParseException;
import com.innovatrics.mrz.MrzParser;
import com.innovatrics.mrz.MrzRange;
import com.innovatrics.mrz.MrzRecordOptional;
import com.innovatrics.mrz.types.MrzDocumentCode;
import com.innovatrics.mrz.types.MrzFormat;

public class FrenchIdCard
extends MrzRecordOptional {
    private static final long serialVersionUID = 1L;

    public FrenchIdCard() {
        super(MrzFormat.FRENCH_ID, "FrenchIdCard");
        this.setCode(MrzDocumentCode.TYPE_I);
        this.setCode1('I');
        this.setCode2('D');
    }

    @Override
    public void fromMrz(String mrz) throws MrzParseException {
        super.fromMrz(mrz);
        MrzParser parser = new MrzParser(mrz);
        String[] name = new String[]{"", ""};
        name[0] = parser.parseString(new MrzRange(5, 30, 0));
        name[1] = parser.parseString(new MrzRange(13, 27, 1));
        this.setName(name);
        this.setNationality(parser.parseString(new MrzRange(2, 5, 0)));
        this.setOptional(parser.parseString(new MrzRange(30, 36, 0)));
        this.setDocumentNumber(parser.parseString(new MrzRange(0, 12, 1)));
        this.setValidDocumentNumber(parser.checkDigit(12, 1, new MrzRange(0, 12, 1), "document number"));
        this.setDateOfBirth(parser.parseDate(new MrzRange(27, 33, 1)));
        this.setValidDateOfBirth(parser.checkDigit(33, 1, new MrzRange(27, 33, 1), "date of birth") && this.getDateOfBirth().isDateValid());
        this.setSex(parser.parseSex(34, 1));
        String finalChecksum = mrz.replace("\n", "").substring(0, 71);
        this.setValidComposite(parser.checkDigit(35, 1, finalChecksum, "final checksum"));
    }

    @Override
    public String toMrz() {
        StringBuilder sb = new StringBuilder("IDFRA");
        sb.append(MrzParser.toMrz(this.getSurname(), 25));
        sb.append(MrzParser.toMrz(this.getOptional(), 6));
        sb.append('\n');
        sb.append(MrzParser.toMrz(this.getDocumentNumber(), 12));
        sb.append(MrzParser.computeCheckDigitChar(MrzParser.toMrz(this.getDocumentNumber(), 12)));
        sb.append(MrzParser.toMrz(this.getGivenNames(), 14));
        sb.append(this.getDateOfBirth().toMrz());
        sb.append(MrzParser.computeCheckDigitChar(this.getDateOfBirth().toMrz()));
        sb.append(this.getSex().getMrz());
        sb.append(MrzParser.computeCheckDigitChar(sb.toString().replace("\n", "")));
        sb.append('\n');
        return sb.toString();
    }
}

