/*
 * Decompiled with CFR 0.152.
 */
package me.bogerchan.niervisualizer.renderer.circle;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.bogerchan.niervisualizer.renderer.IRenderer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lme/bogerchan/niervisualizer/renderer/circle/CircleSolidRenderer;", "Lme/bogerchan/niervisualizer/renderer/IRenderer;", "paint", "Landroid/graphics/Paint;", "amplification", "", "(Landroid/graphics/Paint;F)V", "mComputedRadius", "mLastDrawArea", "Landroid/graphics/Rect;", "calculate", "", "drawArea", "data", "", "getInputDataType", "Lme/bogerchan/niervisualizer/renderer/IRenderer$DataType;", "onStart", "captureSize", "", "onStop", "render", "canvas", "Landroid/graphics/Canvas;", "Companion", "core_release"})
public final class CircleSolidRenderer
implements IRenderer {
    private final Rect mLastDrawArea;
    private float mComputedRadius;
    private final Paint paint;
    private final float amplification;
    public static final Companion Companion = new Companion(null);

    @Override
    public void onStart(int captureSize) {
    }

    @Override
    public void onStop() {
    }

    @Override
    public void calculate(@NotNull Rect drawArea, @NotNull byte[] data) {
        float f;
        float it;
        Intrinsics.checkParameterIsNotNull((Object)drawArea, (String)"drawArea");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (Intrinsics.areEqual((Object)this.mLastDrawArea, (Object)drawArea) ^ true) {
            this.mLastDrawArea.set(drawArea);
        }
        float magnitude = (it = (f = (float)(data[0] * data[0] + data[1] * data[1]))) < 20.0f ? 20.0f : it;
        float dbValue = (float)75 * (float)Math.log10(magnitude);
        this.mComputedRadius = (float)Math.min(this.mLastDrawArea.width(), this.mLastDrawArea.height()) * (1.0f + dbValue / (float)383 * 0.25f) * this.amplification * 0.375f;
    }

    @Override
    public void render(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.save();
        canvas.drawCircle((float)(this.mLastDrawArea.left + this.mLastDrawArea.right) / 2.0f, (float)(this.mLastDrawArea.top + this.mLastDrawArea.bottom) / 2.0f, this.mComputedRadius, this.paint);
        canvas.restore();
    }

    @Override
    @NotNull
    public IRenderer.DataType getInputDataType() {
        return IRenderer.DataType.FFT;
    }

    public CircleSolidRenderer(@NotNull Paint paint, float amplification) {
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        this.paint = paint;
        this.amplification = amplification;
        this.mLastDrawArea = new Rect();
    }

    public /* synthetic */ CircleSolidRenderer(Paint paint, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            paint = CircleSolidRenderer.Companion.getDefaultPaint();
        }
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        this(paint, f);
    }

    public CircleSolidRenderer() {
        this(null, 0.0f, 3, null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lme/bogerchan/niervisualizer/renderer/circle/CircleSolidRenderer$Companion;", "", "()V", "getDefaultPaint", "Landroid/graphics/Paint;", "core_release"})
    public static final class Companion {
        private final Paint getDefaultPaint() {
            Paint paint;
            Paint $receiver = paint = new Paint(1);
            $receiver.setColor(-16711681);
            return paint;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

