/*
 * Decompiled with CFR 0.152.
 */
package me.bogerchan.niervisualizer.util;

import android.animation.TimeInterpolator;
import android.os.SystemClock;
import android.view.animation.LinearInterpolator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001c\u001a\u00020\u0012J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eJ\u0006\u0010 \u001a\u00020\u001eR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\""}, d2={"Lme/bogerchan/niervisualizer/util/NierAnimator;", "", "()V", "duration", "", "getDuration", "()I", "setDuration", "(I)V", "interpolator", "Landroid/animation/TimeInterpolator;", "getInterpolator", "()Landroid/animation/TimeInterpolator;", "setInterpolator", "(Landroid/animation/TimeInterpolator;)V", "isRunning", "", "mFraction", "", "mFractionDuration", "mLastRecordTime", "", "values", "", "getValues", "()[F", "setValues", "([F)V", "computeCurrentValue", "pause", "", "start", "stop", "Companion", "core_release"})
public final class NierAnimator {
    @NotNull
    private TimeInterpolator interpolator = (TimeInterpolator)Companion.getDEFAULT_INTERPOLATOR();
    private int duration = Companion.getDEFAULT_DURATION();
    @NotNull
    private float[] values = Companion.getDEFAULT_VALUES();
    private float mFraction;
    private long mLastRecordTime;
    private boolean isRunning;
    private float mFractionDuration;
    @NotNull
    private static final LinearInterpolator DEFAULT_INTERPOLATOR;
    private static final int DEFAULT_DURATION = 2000;
    @NotNull
    private static final float[] DEFAULT_VALUES;
    public static final Companion Companion;

    @NotNull
    public final TimeInterpolator getInterpolator() {
        return this.interpolator;
    }

    public final void setInterpolator(@NotNull TimeInterpolator timeInterpolator) {
        Intrinsics.checkParameterIsNotNull((Object)timeInterpolator, (String)"<set-?>");
        this.interpolator = timeInterpolator;
    }

    public final int getDuration() {
        return this.duration;
    }

    public final void setDuration(int n) {
        this.duration = n;
    }

    @NotNull
    public final float[] getValues() {
        return this.values;
    }

    public final void setValues(@NotNull float[] fArray) {
        Intrinsics.checkParameterIsNotNull((Object)fArray, (String)"<set-?>");
        this.values = fArray;
    }

    public final void start() {
        this.mLastRecordTime = SystemClock.elapsedRealtime();
        this.isRunning = true;
        this.mFractionDuration = (float)this.duration / (float)(this.values.length - 1);
    }

    public final void stop() {
        this.mFraction = 0.0f;
        this.isRunning = false;
    }

    public final void pause() {
        this.isRunning = false;
    }

    public final float computeCurrentValue() {
        if (!this.isRunning) {
            return this.mFraction;
        }
        long curTime = SystemClock.elapsedRealtime();
        long interval = curTime - this.mLastRecordTime;
        int curIdx = (int)((float)(interval % (long)this.duration) / this.mFractionDuration);
        this.mFraction = (float)interval % this.mFractionDuration / this.mFractionDuration;
        this.mFraction = this.interpolator.getInterpolation(this.mFraction);
        this.mFraction = this.values[curIdx] + (this.values[curIdx + 1] - this.values[curIdx]) * this.mFraction;
        return this.mFraction;
    }

    static {
        Companion = new Companion(null);
        DEFAULT_INTERPOLATOR = new LinearInterpolator();
        DEFAULT_DURATION = 2000;
        DEFAULT_VALUES = new float[]{1.0f, 1.2f, 1.1f, 1.0f};
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lme/bogerchan/niervisualizer/util/NierAnimator$Companion;", "", "()V", "DEFAULT_DURATION", "", "getDEFAULT_DURATION", "()I", "DEFAULT_INTERPOLATOR", "Landroid/view/animation/LinearInterpolator;", "getDEFAULT_INTERPOLATOR", "()Landroid/view/animation/LinearInterpolator;", "DEFAULT_VALUES", "", "getDEFAULT_VALUES", "()[F", "core_release"})
    public static final class Companion {
        @NotNull
        public final LinearInterpolator getDEFAULT_INTERPOLATOR() {
            return DEFAULT_INTERPOLATOR;
        }

        public final int getDEFAULT_DURATION() {
            return DEFAULT_DURATION;
        }

        @NotNull
        public final float[] getDEFAULT_VALUES() {
            return DEFAULT_VALUES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

