/*
 * Decompiled with CFR 0.152.
 */
package com.github.bogdanlivadariu.reporting.cucumber.json.models;

import com.github.bogdanlivadariu.reporting.cucumber.json.models.Embedding;
import com.github.bogdanlivadariu.reporting.cucumber.json.models.Step;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class Element {
    private String name;
    private String id;
    private int line;
    private String keyword;
    private String description;
    private String type;
    private Step[] steps;
    private long total_duration;
    private String overallStatus = "passed";
    private int stepsPassedCount;
    private int stepsFailedCount;
    private int stepsSkippedCount;
    private String uniqueID;
    private List<Embedding> embeddings;

    public void postProcess() {
        this.uniqueID = UUID.randomUUID().toString();
        ArrayList<String> stepStatuses = new ArrayList<String>();
        for (Step step : this.steps) {
            this.total_duration += step.getResult().getDuration();
            String actualResultStatus = step.getResult().getStatus();
            stepStatuses.add(step.getResult().getStatus());
            if (actualResultStatus.equals("passed")) {
                ++this.stepsPassedCount;
                continue;
            }
            if (actualResultStatus.equals("failed")) {
                ++this.stepsFailedCount;
                continue;
            }
            if (!actualResultStatus.equals("skipped")) continue;
            ++this.stepsSkippedCount;
        }
        if (stepStatuses.contains("failed") || stepStatuses.contains("skipped")) {
            this.overallStatus = "failed";
        }
    }

    public String getOverallStatus() {
        return this.overallStatus;
    }

    public long getTotal_duration() {
        return this.total_duration;
    }

    public void appendEmbedding(Embedding embedding) {
        if (this.embeddings == null) {
            this.embeddings = new ArrayList<Embedding>();
        }
        this.embeddings.add(embedding);
    }

    public List<Embedding> getEmbeddings() {
        return this.embeddings;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public int getLine() {
        return this.line;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public Step[] getSteps() {
        return this.steps;
    }

    public int getStepsSkippedCount() {
        return this.stepsSkippedCount;
    }

    public int getStepsFailedCount() {
        return this.stepsFailedCount;
    }

    public int getStepsPassedCount() {
        return this.stepsPassedCount;
    }

    public int getStepsTotalCount() {
        return this.steps.length;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }
}

