/*
 * Decompiled with CFR 0.152.
 */
package com.github.bogdanlivadariu.reporting.cucumber.builder;

import com.github.bogdanlivadariu.reporting.cucumber.builder.AllFeatureReports;
import com.github.bogdanlivadariu.reporting.cucumber.helpers.Helpers;
import com.github.bogdanlivadariu.reporting.cucumber.json.models.Feature;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ReportBuilder {
    private final String FEATURE_SUMMARY_REPORT = "cucumber-reporting/featureSummaryReport";
    private final String FEATURE_OVERVIEW_REPORT = "cucumber-reporting/featureOverviewReport";
    private final String REPORTS_SUMMARY_PATH;
    private final String REPORTS_OVERVIEW_PATH;
    private Gson gs = new Gson();
    private Handlebars bars = new Helpers(new Handlebars()).registerHelpers();
    private List<Feature> processedFeatures = null;

    public ReportBuilder(List<String> jsonReports, String targetBuildPath) throws FileNotFoundException, IOException {
        this.REPORTS_SUMMARY_PATH = targetBuildPath + "/feature-reports/";
        this.REPORTS_OVERVIEW_PATH = targetBuildPath + "/";
        this.processedFeatures = this.prepareData(jsonReports);
    }

    private void writeFeatureSummaryReports() throws IOException {
        Template template = this.bars.compile("cucumber-reporting/featureSummaryReport");
        for (Feature feature : this.processedFeatures) {
            String generatedFeatureHtmlContent = template.apply((Object)feature);
            FileUtils.writeStringToFile((File)new File(this.REPORTS_SUMMARY_PATH + feature.getUniqueID() + ".html"), (String)generatedFeatureHtmlContent);
        }
    }

    private void writeFeatureOverviewReport() throws IOException {
        Template template = this.bars.compile("cucumber-reporting/featureOverviewReport");
        AllFeatureReports allFeatures = new AllFeatureReports("Features Overview Report", this.processedFeatures);
        FileUtils.writeStringToFile((File)new File(this.REPORTS_OVERVIEW_PATH + "featuresOverview.html"), (String)template.apply((Object)allFeatures));
    }

    private void writeFeaturePassedReport() throws IOException {
        Template template = this.bars.compile("cucumber-reporting/featureOverviewReport");
        Predicate<Feature> p = new Predicate<Feature>(){

            @Override
            public boolean test(Feature t) {
                return t.getOverall_status().equalsIgnoreCase("passed");
            }
        };
        Object onlyPassed = ReportBuilder.cast(this.processedFeatures.stream().filter(p).collect(Collectors.toList()));
        AllFeatureReports allFeatures = new AllFeatureReports("Passed Features Overview Report", (List<Feature>)onlyPassed);
        FileUtils.writeStringToFile((File)new File(this.REPORTS_OVERVIEW_PATH + "featuresPassed.html"), (String)template.apply((Object)allFeatures));
    }

    private void writeFeatureFailedReport() throws IOException {
        Template template = this.bars.compile("cucumber-reporting/featureOverviewReport");
        Predicate<Feature> p = new Predicate<Feature>(){

            @Override
            public boolean test(Feature t) {
                return t.getOverall_status().equalsIgnoreCase("failed");
            }
        };
        Object onlyFailed = ReportBuilder.cast(this.processedFeatures.stream().filter(p).collect(Collectors.toList()));
        AllFeatureReports allFeatures = new AllFeatureReports("Failed Features Overview Report", (List<Feature>)onlyFailed);
        FileUtils.writeStringToFile((File)new File(this.REPORTS_OVERVIEW_PATH + "featuresFailed.html"), (String)template.apply((Object)allFeatures));
    }

    private List<Feature> prepareData(List<String> jsonReports) throws FileNotFoundException, IOException {
        ArrayList<Feature> processedFeatures = new ArrayList<Feature>();
        for (String jsonReport : jsonReports) {
            Feature[] features;
            File jsonFileReport = new File(jsonReport);
            String gson = IOUtils.toString((InputStream)new FileInputStream(jsonFileReport));
            for (Feature feature : features = (Feature[])this.gs.fromJson(gson, Feature[].class)) {
                processedFeatures.add(feature.postProcess());
            }
        }
        return processedFeatures;
    }

    public boolean writeReportsOnDisk() throws IOException {
        this.writeFeatureSummaryReports();
        this.writeFeatureOverviewReport();
        this.writeFeaturePassedReport();
        this.writeFeatureFailedReport();
        for (Feature feature : this.processedFeatures) {
            if (!feature.getOverall_status().equals("failed")) continue;
            return false;
        }
        return true;
    }

    public static <T extends List<?>> T cast(Object obj) {
        return (T)((List)obj);
    }
}

