/*
 * Decompiled with CFR 0.152.
 */
package com.github.bogdanlivadariu.reporting.cucumber.json.models;

import com.github.bogdanlivadariu.reporting.cucumber.json.models.Element;
import com.github.bogdanlivadariu.reporting.cucumber.json.models.Embedding;
import com.github.bogdanlivadariu.reporting.cucumber.json.models.Step;
import com.github.bogdanlivadariu.reporting.cucumber.json.models.Tag;
import java.util.ArrayList;
import java.util.UUID;

public class Feature {
    private String pageTitle;
    private String uniqueID;
    private String id;
    private String name;
    private String description;
    private int line;
    private String keyword;
    private Tag[] tags;
    private String uri;
    private Element[] elements;
    private int zbang;
    private long total_duration;
    private String overall_status = "passed";
    private int scenariosPassedCount;
    private int scenariosFailedCount;
    private int stepsTotalCount;
    private int stepsPassedCount;
    private int stepsFailedCount;
    private int stepsSkippedCount;

    public Feature postProcess() {
        this.pageTitle = "Feature Summary Report";
        this.uniqueID = UUID.randomUUID().toString();
        ArrayList<String> stepResultStatuses = new ArrayList<String>();
        for (Element el : this.elements) {
            el.postProcess();
            this.total_duration += el.getTotal_duration();
            this.stepsTotalCount += el.getStepsTotalCount();
            this.stepsPassedCount += el.getStepsPassedCount();
            this.stepsFailedCount += el.getStepsFailedCount();
            this.stepsSkippedCount += el.getStepsSkippedCount();
            if (el.getOverallStatus().equals("passed")) {
                ++this.scenariosPassedCount;
            } else {
                ++this.scenariosFailedCount;
            }
            for (Step step : el.getSteps()) {
                stepResultStatuses.add(step.getResult().getStatus());
                try {
                    for (Embedding emb : step.getEmbeddings()) {
                        if (emb == null) continue;
                        el.appendEmbedding(emb);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (stepResultStatuses.contains("failed") || stepResultStatuses.contains("skipped")) {
            this.overall_status = "failed";
        }
        return this;
    }

    public int getScenariosCount() {
        return this.elements.length;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getLine() {
        return this.line;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public Tag[] getTags() {
        return this.tags;
    }

    public String getUri() {
        return this.uri;
    }

    public Element[] getElements() {
        return this.elements;
    }

    public int getZbang() {
        return this.zbang;
    }

    public int getStepsSkippedCount() {
        return this.stepsSkippedCount;
    }

    public int getStepsFailedCount() {
        return this.stepsFailedCount;
    }

    public int getStepsPassedCount() {
        return this.stepsPassedCount;
    }

    public int getScenariosFailedCount() {
        return this.scenariosFailedCount;
    }

    public int getStepsTotalCount() {
        return this.stepsTotalCount;
    }

    public long getTotal_duration() {
        return this.total_duration;
    }

    public int getScenariosPassedCount() {
        return this.scenariosPassedCount;
    }

    public String getOverall_status() {
        return this.overall_status;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }
}

