/* This file was generated by SableCC (http://www.sablecc.org/). */

package net.sf.cb2xml.sablecc.lexer;

import java.io.*;
import net.sf.cb2xml.sablecc.node.*;

@SuppressWarnings("nls")
public class Lexer
{
    protected Token token;
    protected State state = State.INITIAL;

    private IPushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();

    @SuppressWarnings("unused")
    protected void filter() throws LexerException, IOException
    {
        // Do nothing
    }

    public Lexer(@SuppressWarnings("hiding") final PushbackReader in)
    {
        this.in = new IPushbackReader() {

            private PushbackReader pushbackReader = in;
            
            @Override
            public void unread(int c) throws IOException {
                pushbackReader.unread(c);
            }
            
            @Override
            public int read() throws IOException {
                return pushbackReader.read();
            }
        };
    }
 
    public Lexer(@SuppressWarnings("hiding") IPushbackReader in)
    {
        this.in = in;
    }
 
    public Token peek() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.token = getToken();
            filter();
        }

        return this.token;
    }

    public Token next() throws LexerException, IOException
    {
        while(this.token == null)
        {
            this.token = getToken();
            filter();
        }

        Token result = this.token;
        this.token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = this.pos;
        int start_line = this.line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

        @SuppressWarnings("hiding") int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
        @SuppressWarnings("hiding") int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(this.cr)
                    {
                        this.cr = false;
                    }
                    else
                    {
                        this.line++;
                        this.pos = 0;
                    }
                    break;
                case 13:
                    this.line++;
                    this.pos = 0;
                    this.cr = true;
                    break;
                default:
                    this.pos++;
                    this.cr = false;
                    break;
                }

                this.text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        // int middle = (low + high) / 2;
                        int middle = (low + high) >>> 1;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = this.text.length();
                    accept_pos = this.pos;
                    accept_line = this.line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                            @SuppressWarnings("hiding") Token token = new0(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 1:
                        {
                            @SuppressWarnings("hiding") Token token = new1(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 2:
                        {
                            @SuppressWarnings("hiding") Token token = new2(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 3:
                        {
                            @SuppressWarnings("hiding") Token token = new3(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 4:
                        {
                            @SuppressWarnings("hiding") Token token = new4(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 5:
                        {
                            @SuppressWarnings("hiding") Token token = new5(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 6:
                        {
                            @SuppressWarnings("hiding") Token token = new6(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 7:
                        {
                            @SuppressWarnings("hiding") Token token = new7(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 8:
                        {
                            @SuppressWarnings("hiding") Token token = new8(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 9:
                        {
                            @SuppressWarnings("hiding") Token token = new9(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 10:
                        {
                            @SuppressWarnings("hiding") Token token = new10(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 11:
                        {
                            @SuppressWarnings("hiding") Token token = new11(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 12:
                        {
                            @SuppressWarnings("hiding") Token token = new12(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 13:
                        {
                            @SuppressWarnings("hiding") Token token = new13(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 14:
                        {
                            @SuppressWarnings("hiding") Token token = new14(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 15:
                        {
                            @SuppressWarnings("hiding") Token token = new15(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 16:
                        {
                            @SuppressWarnings("hiding") Token token = new16(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 17:
                        {
                            @SuppressWarnings("hiding") Token token = new17(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 18:
                        {
                            @SuppressWarnings("hiding") Token token = new18(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 19:
                        {
                            @SuppressWarnings("hiding") Token token = new19(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 20:
                        {
                            @SuppressWarnings("hiding") Token token = new20(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 21:
                        {
                            @SuppressWarnings("hiding") Token token = new21(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 22:
                        {
                            @SuppressWarnings("hiding") Token token = new22(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 23:
                        {
                            @SuppressWarnings("hiding") Token token = new23(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 24:
                        {
                            @SuppressWarnings("hiding") Token token = new24(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 25:
                        {
                            @SuppressWarnings("hiding") Token token = new25(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 26:
                        {
                            @SuppressWarnings("hiding") Token token = new26(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 27:
                        {
                            @SuppressWarnings("hiding") Token token = new27(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 28:
                        {
                            @SuppressWarnings("hiding") Token token = new28(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 29:
                        {
                            @SuppressWarnings("hiding") Token token = new29(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 30:
                        {
                            @SuppressWarnings("hiding") Token token = new30(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 31:
                        {
                            @SuppressWarnings("hiding") Token token = new31(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 32:
                        {
                            @SuppressWarnings("hiding") Token token = new32(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 33:
                        {
                            @SuppressWarnings("hiding") Token token = new33(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 34:
                        {
                            @SuppressWarnings("hiding") Token token = new34(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 35:
                        {
                            @SuppressWarnings("hiding") Token token = new35(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 36:
                        {
                            @SuppressWarnings("hiding") Token token = new36(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 37:
                        {
                            @SuppressWarnings("hiding") Token token = new37(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 38:
                        {
                            @SuppressWarnings("hiding") Token token = new38(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 39:
                        {
                            @SuppressWarnings("hiding") Token token = new39(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 40:
                        {
                            @SuppressWarnings("hiding") Token token = new40(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 41:
                        {
                            @SuppressWarnings("hiding") Token token = new41(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 42:
                        {
                            @SuppressWarnings("hiding") Token token = new42(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 43:
                        {
                            @SuppressWarnings("hiding") Token token = new43(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 44:
                        {
                            @SuppressWarnings("hiding") Token token = new44(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 45:
                        {
                            @SuppressWarnings("hiding") Token token = new45(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 46:
                        {
                            @SuppressWarnings("hiding") Token token = new46(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 47:
                        {
                            @SuppressWarnings("hiding") Token token = new47(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 48:
                        {
                            @SuppressWarnings("hiding") Token token = new48(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 49:
                        {
                            @SuppressWarnings("hiding") Token token = new49(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 50:
                        {
                            @SuppressWarnings("hiding") Token token = new50(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 51:
                        {
                            @SuppressWarnings("hiding") Token token = new51(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 52:
                        {
                            @SuppressWarnings("hiding") Token token = new52(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 53:
                        {
                            @SuppressWarnings("hiding") Token token = new53(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 54:
                        {
                            @SuppressWarnings("hiding") Token token = new54(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 55:
                        {
                            @SuppressWarnings("hiding") Token token = new55(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 56:
                        {
                            @SuppressWarnings("hiding") Token token = new56(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 57:
                        {
                            @SuppressWarnings("hiding") Token token = new57(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 58:
                        {
                            @SuppressWarnings("hiding") Token token = new58(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 59:
                        {
                            @SuppressWarnings("hiding") Token token = new59(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 60:
                        {
                            @SuppressWarnings("hiding") Token token = new60(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 61:
                        {
                            @SuppressWarnings("hiding") Token token = new61(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 62:
                        {
                            @SuppressWarnings("hiding") Token token = new62(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 63:
                        {
                            @SuppressWarnings("hiding") Token token = new63(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 64:
                        {
                            @SuppressWarnings("hiding") Token token = new64(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 65:
                        {
                            @SuppressWarnings("hiding") Token token = new65(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 66:
                        {
                            @SuppressWarnings("hiding") Token token = new66(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 67:
                        {
                            @SuppressWarnings("hiding") Token token = new67(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 68:
                        {
                            @SuppressWarnings("hiding") Token token = new68(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 69:
                        {
                            @SuppressWarnings("hiding") Token token = new69(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 70:
                        {
                            @SuppressWarnings("hiding") Token token = new70(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 71:
                        {
                            @SuppressWarnings("hiding") Token token = new71(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 72:
                        {
                            @SuppressWarnings("hiding") Token token = new72(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 73:
                        {
                            @SuppressWarnings("hiding") Token token = new73(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 74:
                        {
                            @SuppressWarnings("hiding") Token token = new74(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 75:
                        {
                            @SuppressWarnings("hiding") Token token = new75(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 76:
                        {
                            @SuppressWarnings("hiding") Token token = new76(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 77:
                        {
                            @SuppressWarnings("hiding") Token token = new77(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 78:
                        {
                            @SuppressWarnings("hiding") Token token = new78(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 79:
                        {
                            @SuppressWarnings("hiding") Token token = new79(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    case 80:
                        {
                            @SuppressWarnings("hiding") Token token = new80(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            this.pos = accept_pos;
                            this.line = accept_line;
                            return token;
                        }
                    }
                }
                else
                {
                    if(this.text.length() > 0)
                    {
                        throw new LexerException(
                            new InvalidToken(this.text.substring(0, 1), start_line + 1, start_pos + 1),
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + this.text);
                    }

                    @SuppressWarnings("hiding") EOF token = new EOF(
                        start_line + 1,
                        start_pos + 1);
                    return token;
                }
            }
        }
    }

    Token new0(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TWhiteSpaces(text, line, pos); }
    Token new1(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TComment(text, line, pos); }
    Token new2(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDot(line, pos); }
    Token new3(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TComma(line, pos); }
    Token new4(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TSlash(line, pos); }
    Token new5(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TPlus(line, pos); }
    Token new6(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TMinus(line, pos); }
    Token new7(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TStar(line, pos); }
    Token new8(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDollar(line, pos); }
    Token new9(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLparen(line, pos); }
    Token new10(@SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TRparen(line, pos); }
    Token new11(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNumber88(text, line, pos); }
    Token new12(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNumberNot88(text, line, pos); }
    Token new13(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TAlphanumericLiteral(text, line, pos); }
    Token new14(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNumericLiteral(text, line, pos); }
    Token new15(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDotZee(text, line, pos); }
    Token new16(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDotMinus(text, line, pos); }
    Token new17(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDotPlus(text, line, pos); }
    Token new18(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TAll(text, line, pos); }
    Token new19(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TAre(text, line, pos); }
    Token new20(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TAscending(text, line, pos); }
    Token new21(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TBinary(text, line, pos); }
    Token new22(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TBlank(text, line, pos); }
    Token new23(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TBy(text, line, pos); }
    Token new24(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TCharacter(text, line, pos); }
    Token new25(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TComp(text, line, pos); }
    Token new26(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TComp1(text, line, pos); }
    Token new27(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TComp2(text, line, pos); }
    Token new28(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TComp3(text, line, pos); }
    Token new29(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TComp4(text, line, pos); }
    Token new30(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TComp5(text, line, pos); }
    Token new31(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TComp6(text, line, pos); }
    Token new32(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDate(text, line, pos); }
    Token new33(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDepending(text, line, pos); }
    Token new34(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDescending(text, line, pos); }
    Token new35(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDisplay(text, line, pos); }
    Token new36(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDisplay1(text, line, pos); }
    Token new37(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TExternal(text, line, pos); }
    Token new38(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TFiller(text, line, pos); }
    Token new39(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TFormat(text, line, pos); }
    Token new40(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TFunctionPointer(text, line, pos); }
    Token new41(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TGlobal(text, line, pos); }
    Token new42(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new THighValues(text, line, pos); }
    Token new43(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TIndex(text, line, pos); }
    Token new44(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TIndexed(text, line, pos); }
    Token new45(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TIs(text, line, pos); }
    Token new46(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TJustified(text, line, pos); }
    Token new47(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TKey(text, line, pos); }
    Token new48(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLeading(text, line, pos); }
    Token new49(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLeft(text, line, pos); }
    Token new50(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TLowValues(text, line, pos); }
    Token new51(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNational(text, line, pos); }
    Token new52(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNative(text, line, pos); }
    Token new53(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TNulls(text, line, pos); }
    Token new54(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TObject(text, line, pos); }
    Token new55(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TOccurs(text, line, pos); }
    Token new56(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TOn(text, line, pos); }
    Token new57(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TPackedDecimal(text, line, pos); }
    Token new58(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TPicture(text, line, pos); }
    Token new59(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TPointer(text, line, pos); }
    Token new60(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TProcedurePointer(text, line, pos); }
    Token new61(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TQuotes(text, line, pos); }
    Token new62(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TRedefines(text, line, pos); }
    Token new63(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TReference(text, line, pos); }
    Token new64(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TRenames(text, line, pos); }
    Token new65(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TRight(text, line, pos); }
    Token new66(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TSeparate(text, line, pos); }
    Token new67(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TSign(text, line, pos); }
    Token new68(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TSpaces(text, line, pos); }
    Token new69(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TSynchronized(text, line, pos); }
    Token new70(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TThrough(text, line, pos); }
    Token new71(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTimes(text, line, pos); }
    Token new72(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTo(text, line, pos); }
    Token new73(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TTrailing(text, line, pos); }
    Token new74(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TUsage(text, line, pos); }
    Token new75(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TValue(text, line, pos); }
    Token new76(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TValues(text, line, pos); }
    Token new77(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TWhen(text, line, pos); }
    Token new78(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TZeros(text, line, pos); }
    Token new79(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TDataName(text, line, pos); }
    Token new80(@SuppressWarnings("hiding") String text, @SuppressWarnings("hiding") int line, @SuppressWarnings("hiding") int pos) { return new TUnknown(text, line, pos); }

    private int getChar() throws IOException
    {
        if(this.eof)
        {
            return -1;
        }

        int result = this.in.read();

        if(result == -1)
        {
            this.eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = this.text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            this.eof = false;

            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(@SuppressWarnings("hiding") Token token) throws IOException
    {
        @SuppressWarnings("hiding") String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            this.eof = false;

            this.in.unread(text.charAt(i));
        }

        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(this.text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // INITIAL
            {{0, 8, 1}, {9, 9, 2}, {10, 10, 3}, {11, 12, 1}, {13, 13, 4}, {14, 31, 1}, {32, 32, 5}, {33, 33, 1}, {34, 34, 6}, {35, 35, 1}, {36, 36, 7}, {37, 38, 1}, {39, 39, 8}, {40, 40, 9}, {41, 41, 10}, {42, 42, 11}, {43, 43, 12}, {44, 44, 13}, {45, 45, 14}, {46, 46, 15}, {47, 47, 16}, {48, 55, 17}, {56, 56, 18}, {57, 57, 17}, {58, 64, 1}, {65, 65, 19}, {66, 66, 20}, {67, 67, 21}, {68, 68, 22}, {69, 69, 23}, {70, 70, 24}, {71, 71, 25}, {72, 72, 26}, {73, 73, 27}, {74, 74, 28}, {75, 75, 29}, {76, 76, 30}, {77, 77, 31}, {78, 78, 32}, {79, 79, 33}, {80, 80, 34}, {81, 81, 35}, {82, 82, 36}, {83, 83, 37}, {84, 84, 38}, {85, 85, 39}, {86, 86, 40}, {87, 87, 41}, {88, 88, 42}, {89, 89, 31}, {90, 90, 43}, {91, 94, 1}, {95, 95, 44}, {96, 96, 1}, {97, 97, 45}, {98, 98, 46}, {99, 99, 47}, {100, 100, 48}, {101, 101, 49}, {102, 102, 50}, {103, 103, 51}, {104, 104, 52}, {105, 105, 53}, {106, 106, 54}, {107, 107, 55}, {108, 108, 56}, {109, 109, 57}, {110, 110, 58}, {111, 111, 59}, {112, 112, 60}, {113, 113, 61}, {114, 114, 62}, {115, 115, 63}, {116, 116, 64}, {117, 117, 65}, {118, 118, 66}, {119, 119, 67}, {120, 121, 57}, {122, 122, 68}, {123, 65535, 1}, },
            {},
            {{9, 9, 69}, {10, 10, 70}, {13, 13, 71}, {32, 32, 72}, },
            {{9, 32, -4}, },
            {{9, 9, 69}, {10, 10, 73}, {13, 32, -4}, },
            {{9, 32, -4}, },
            {{0, 9, 74}, {10, 10, 75}, {11, 12, 74}, {13, 13, 76}, {14, 33, 74}, {34, 34, 77}, {35, 65535, 74}, },
            {},
            {{0, 9, 78}, {10, 10, 79}, {11, 12, 78}, {13, 13, 80}, {14, 38, 78}, {39, 39, 81}, {40, 65535, 78}, },
            {},
            {},
            {{0, 9, 82}, {10, 10, 83}, {11, 12, 82}, {13, 13, 84}, {14, 65535, 82}, },
            {{46, 46, 85}, {48, 57, 86}, },
            {},
            {{45, 45, 87}, {46, 46, 85}, {48, 57, 88}, {65, 90, 89}, {95, 95, 90}, {97, 122, 91}, },
            {{45, 45, 92}, {48, 57, 93}, {90, 90, 94}, },
            {},
            {{45, 46, -16}, {48, 57, 95}, {65, 122, -16}, },
            {{45, 46, -16}, {48, 55, 95}, {56, 56, 96}, {57, 57, 95}, {65, 122, -16}, },
            {{45, 45, 87}, {48, 57, 97}, {65, 75, 89}, {76, 76, 98}, {77, 81, 89}, {82, 82, 99}, {83, 83, 100}, {84, 90, 89}, {95, 95, 90}, {97, 107, 91}, {108, 108, 101}, {109, 113, 91}, {114, 114, 102}, {115, 115, 103}, {116, 122, 91}, },
            {{45, 57, -21}, {65, 72, 89}, {73, 73, 104}, {74, 75, 89}, {76, 76, 105}, {77, 88, 89}, {89, 89, 106}, {90, 90, 89}, {95, 95, 90}, {97, 104, 91}, {105, 105, 107}, {106, 107, 91}, {108, 108, 108}, {109, 120, 91}, {121, 121, 109}, {122, 122, 91}, },
            {{45, 57, -21}, {65, 71, 89}, {72, 72, 110}, {73, 78, 89}, {79, 79, 111}, {80, 90, 89}, {95, 95, 90}, {97, 103, 91}, {104, 104, 112}, {105, 110, 91}, {111, 111, 113}, {112, 122, 91}, },
            {{45, 57, -21}, {65, 65, 114}, {66, 68, 89}, {69, 69, 115}, {70, 72, 89}, {73, 73, 116}, {74, 90, 89}, {95, 95, 90}, {97, 97, 117}, {98, 100, 91}, {101, 101, 118}, {102, 104, 91}, {105, 105, 119}, {106, 122, 91}, },
            {{45, 57, -21}, {65, 87, 89}, {88, 88, 120}, {89, 90, 89}, {95, 95, 90}, {97, 119, 91}, {120, 120, 121}, {121, 122, 91}, },
            {{45, 72, -22}, {73, 73, 122}, {74, 78, 89}, {79, 79, 123}, {80, 84, 89}, {85, 85, 124}, {86, 90, 89}, {95, 104, -22}, {105, 105, 125}, {106, 110, 91}, {111, 111, 126}, {112, 116, 91}, {117, 117, 127}, {118, 122, 91}, },
            {{45, 75, -21}, {76, 76, 128}, {77, 90, 89}, {95, 107, -21}, {108, 108, 129}, {109, 122, 91}, },
            {{45, 72, -22}, {73, 73, 130}, {74, 95, -24}, {97, 104, 91}, {105, 105, 131}, {106, 122, 91}, },
            {{45, 57, -21}, {65, 77, 89}, {78, 78, 132}, {79, 82, 89}, {83, 83, 133}, {84, 95, -21}, {97, 109, 91}, {110, 110, 134}, {111, 114, 91}, {115, 115, 135}, {116, 122, 91}, },
            {{45, 57, -21}, {65, 84, 89}, {85, 85, 136}, {86, 95, -26}, {97, 116, 91}, {117, 117, 137}, {118, 122, 91}, },
            {{45, 57, -21}, {65, 68, 89}, {69, 69, 138}, {70, 90, 89}, {95, 95, 90}, {97, 100, 91}, {101, 101, 139}, {102, 122, 91}, },
            {{45, 68, -31}, {69, 69, 140}, {70, 78, 89}, {79, 79, 141}, {80, 95, -23}, {97, 100, 91}, {101, 101, 142}, {102, 110, 91}, {111, 111, 143}, {112, 122, 91}, },
            {{45, 57, -21}, {65, 122, -16}, },
            {{45, 57, -21}, {65, 65, 144}, {66, 84, 89}, {85, 85, 145}, {86, 95, -26}, {97, 97, 146}, {98, 116, 91}, {117, 117, 147}, {118, 122, 91}, },
            {{45, 57, -21}, {65, 65, 89}, {66, 66, 148}, {67, 67, 149}, {68, 77, 89}, {78, 78, 150}, {79, 90, 89}, {95, 95, 90}, {97, 97, 91}, {98, 98, 151}, {99, 99, 152}, {100, 109, 91}, {110, 110, 153}, {111, 122, 91}, },
            {{45, 57, -21}, {65, 65, 154}, {66, 72, 89}, {73, 73, 155}, {74, 78, 89}, {79, 79, 156}, {80, 81, 89}, {82, 82, 157}, {83, 90, 89}, {95, 95, 90}, {97, 97, 158}, {98, 104, 91}, {105, 105, 159}, {106, 110, 91}, {111, 111, 160}, {112, 113, 91}, {114, 114, 161}, {115, 122, 91}, },
            {{45, 84, -30}, {85, 85, 162}, {86, 116, -30}, {117, 117, 163}, {118, 122, 91}, },
            {{45, 68, -31}, {69, 69, 164}, {70, 72, 89}, {73, 73, 165}, {74, 95, -24}, {97, 100, 91}, {101, 101, 166}, {102, 104, 91}, {105, 105, 167}, {106, 122, 91}, },
            {{45, 68, -31}, {69, 69, 168}, {70, 72, 89}, {73, 73, 169}, {74, 79, 89}, {80, 80, 170}, {81, 88, 89}, {89, 89, 171}, {90, 95, -22}, {97, 100, 91}, {101, 101, 172}, {102, 104, 91}, {105, 105, 173}, {106, 111, 91}, {112, 112, 174}, {113, 120, 91}, {121, 121, 175}, {122, 122, 91}, },
            {{45, 71, -23}, {72, 72, 176}, {73, 73, 177}, {74, 78, 89}, {79, 79, 178}, {80, 81, 89}, {82, 82, 179}, {83, 95, -36}, {97, 103, 91}, {104, 104, 180}, {105, 105, 181}, {106, 110, 91}, {111, 111, 182}, {112, 113, 91}, {114, 114, 183}, {115, 122, 91}, },
            {{45, 57, -21}, {65, 82, 89}, {83, 83, 184}, {84, 95, -21}, {97, 114, 91}, {115, 115, 185}, {116, 122, 91}, },
            {{45, 57, -21}, {65, 65, 186}, {66, 90, 89}, {95, 95, 90}, {97, 97, 187}, {98, 122, 91}, },
            {{45, 71, -23}, {72, 72, 188}, {73, 90, 89}, {95, 103, -23}, {104, 104, 189}, {105, 122, 91}, },
            {{34, 34, 190}, {39, 39, 191}, {45, 122, -33}, },
            {{45, 68, -31}, {69, 69, 192}, {70, 100, -31}, {101, 101, 193}, {102, 122, 91}, },
            {{45, 122, -33}, },
            {{45, 122, -21}, },
            {{45, 122, -22}, },
            {{45, 122, -23}, },
            {{45, 122, -24}, },
            {{45, 122, -25}, },
            {{45, 122, -26}, },
            {{45, 122, -27}, },
            {{45, 122, -28}, },
            {{45, 122, -29}, },
            {{45, 122, -30}, },
            {{45, 122, -31}, },
            {{45, 122, -32}, },
            {{45, 122, -33}, },
            {{45, 122, -34}, },
            {{45, 122, -35}, },
            {{45, 122, -36}, },
            {{45, 122, -37}, },
            {{45, 122, -38}, },
            {{45, 122, -39}, },
            {{45, 122, -40}, },
            {{45, 122, -41}, },
            {{45, 122, -42}, },
            {{45, 122, -43}, },
            {{45, 122, -45}, },
            {{9, 32, -4}, },
            {{9, 32, -4}, },
            {{9, 32, -6}, },
            {{9, 32, -4}, },
            {{9, 32, -4}, },
            {{0, 65535, -8}, },
            {{9, 9, 194}, {10, 10, 195}, {13, 13, 196}, {32, 32, 197}, {45, 45, 198}, },
            {{9, 9, 194}, {10, 10, 199}, {13, 45, -77}, },
            {{34, 34, 200}, },
            {{0, 65535, -10}, },
            {{9, 9, 201}, {10, 10, 202}, {13, 13, 203}, {32, 32, 204}, {45, 45, 205}, },
            {{9, 9, 201}, {10, 10, 206}, {13, 45, -81}, },
            {{39, 39, 207}, },
            {{0, 65535, -13}, },
            {},
            {{10, 10, 208}, },
            {{48, 57, 93}, },
            {{46, 57, -14}, },
            {{45, 122, -33}, },
            {{45, 122, -16}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 45, 92}, },
            {{48, 57, 93}, {69, 69, 209}, },
            {{90, 90, 94}, },
            {{45, 122, -19}, },
            {{45, 122, -19}, },
            {{45, 122, -33}, },
            {{45, 75, -21}, {76, 76, 210}, {77, 107, -27}, {108, 108, 211}, {109, 122, 91}, },
            {{45, 68, -31}, {69, 69, 212}, {70, 100, -31}, {101, 101, 213}, {102, 122, 91}, },
            {{45, 57, -21}, {65, 66, 89}, {67, 67, 214}, {68, 90, 89}, {95, 95, 90}, {97, 98, 91}, {99, 99, 215}, {100, 122, 91}, },
            {{45, 122, -100}, },
            {{45, 122, -101}, },
            {{45, 122, -102}, },
            {{45, 77, -29}, {78, 78, 216}, {79, 95, -35}, {97, 109, 91}, {110, 110, 217}, {111, 122, 91}, },
            {{45, 57, -21}, {65, 65, 218}, {66, 95, -42}, {97, 97, 219}, {98, 122, 91}, },
            {{45, 122, -33}, },
            {{45, 122, -106}, },
            {{45, 122, -107}, },
            {{45, 122, -33}, },
            {{45, 57, -21}, {65, 65, 220}, {66, 95, -42}, {97, 97, 221}, {98, 122, 91}, },
            {{45, 57, -21}, {65, 76, 89}, {77, 77, 222}, {78, 90, 89}, {95, 95, 90}, {97, 108, 91}, {109, 109, 223}, {110, 122, 91}, },
            {{45, 122, -112}, },
            {{45, 122, -113}, },
            {{45, 57, -21}, {65, 83, 89}, {84, 84, 224}, {85, 90, 89}, {95, 95, 90}, {97, 115, 91}, {116, 116, 225}, {117, 122, 91}, },
            {{45, 57, -21}, {65, 79, 89}, {80, 80, 226}, {81, 82, 89}, {83, 83, 227}, {84, 95, -21}, {97, 111, 91}, {112, 112, 228}, {113, 114, 91}, {115, 115, 229}, {116, 122, 91}, },
            {{45, 82, -41}, {83, 83, 230}, {84, 114, -41}, {115, 115, 231}, {116, 122, 91}, },
            {{45, 122, -116}, },
            {{45, 122, -117}, },
            {{45, 122, -118}, },
            {{45, 83, -116}, {84, 84, 232}, {85, 115, -116}, {116, 116, 233}, {117, 122, 91}, },
            {{45, 122, -122}, },
            {{45, 75, -21}, {76, 76, 234}, {77, 107, -27}, {108, 108, 235}, {109, 122, 91}, },
            {{45, 57, -21}, {65, 81, 89}, {82, 82, 236}, {83, 95, -36}, {97, 113, 91}, {114, 114, 237}, {115, 122, 91}, },
            {{45, 77, -29}, {78, 78, 238}, {79, 109, -106}, {110, 110, 239}, {111, 122, 91}, },
            {{45, 122, -124}, },
            {{45, 122, -125}, },
            {{45, 122, -126}, },
            {{45, 57, -21}, {65, 78, 89}, {79, 79, 240}, {80, 95, -23}, {97, 110, 91}, {111, 111, 241}, {112, 122, 91}, },
            {{45, 122, -130}, },
            {{45, 57, -21}, {65, 70, 89}, {71, 71, 242}, {72, 90, 89}, {95, 95, 90}, {97, 102, 91}, {103, 103, 243}, {104, 122, 91}, },
            {{45, 122, -132}, },
            {{45, 57, -21}, {65, 67, 89}, {68, 68, 244}, {69, 90, 89}, {95, 95, 90}, {97, 99, 91}, {100, 100, 245}, {101, 122, 91}, },
            {{45, 122, -33}, },
            {{45, 122, -134}, },
            {{45, 122, -33}, },
            {{45, 82, -41}, {83, 83, 246}, {84, 114, -41}, {115, 115, 247}, {116, 122, 91}, },
            {{45, 122, -138}, },
            {{45, 57, -21}, {65, 88, 89}, {89, 89, 248}, {90, 95, -22}, {97, 120, 91}, {121, 121, 249}, {122, 122, 91}, },
            {{45, 122, -140}, },
            {{45, 57, -21}, {65, 65, 250}, {66, 69, 89}, {70, 70, 251}, {71, 90, 89}, {95, 95, 90}, {97, 97, 252}, {98, 101, 91}, {102, 102, 253}, {103, 122, 91}, },
            {{45, 57, -21}, {65, 86, 89}, {87, 87, 254}, {88, 90, 89}, {95, 95, 90}, {97, 118, 91}, {119, 119, 255}, {120, 122, 91}, },
            {{45, 122, -142}, },
            {{45, 122, -143}, },
            {{45, 83, -116}, {84, 84, 256}, {85, 115, -116}, {116, 116, 257}, {117, 122, 91}, },
            {{45, 75, -21}, {76, 76, 258}, {77, 107, -27}, {108, 108, 259}, {109, 122, 91}, },
            {{45, 122, -146}, },
            {{45, 122, -147}, },
            {{45, 57, -21}, {65, 73, 89}, {74, 74, 260}, {75, 90, 89}, {95, 95, 90}, {97, 105, 91}, {106, 106, 261}, {107, 122, 91}, },
            {{45, 66, -102}, {67, 67, 262}, {68, 98, -102}, {99, 99, 263}, {100, 122, 91}, },
            {{45, 122, -33}, },
            {{45, 122, -150}, },
            {{45, 122, -151}, },
            {{45, 122, -33}, },
            {{45, 66, -102}, {67, 67, 264}, {68, 98, -102}, {99, 99, 265}, {100, 122, 91}, },
            {{45, 66, -102}, {67, 67, 266}, {68, 98, -102}, {99, 99, 267}, {100, 122, 91}, },
            {{45, 72, -22}, {73, 73, 268}, {74, 104, -28}, {105, 105, 269}, {106, 122, 91}, },
            {{45, 78, -130}, {79, 79, 270}, {80, 110, -130}, {111, 111, 271}, {112, 122, 91}, },
            {{45, 122, -156}, },
            {{45, 122, -157}, },
            {{45, 122, -158}, },
            {{45, 122, -159}, },
            {{45, 78, -130}, {79, 79, 272}, {80, 110, -130}, {111, 111, 273}, {112, 122, 91}, },
            {{45, 122, -164}, },
            {{45, 67, -134}, {68, 68, 274}, {69, 69, 89}, {70, 70, 275}, {71, 77, 89}, {78, 78, 276}, {79, 95, -35}, {97, 99, 91}, {100, 100, 277}, {101, 101, 91}, {102, 102, 278}, {103, 109, 91}, {110, 110, 279}, {111, 122, 91}, },
            {{45, 70, -132}, {71, 71, 280}, {72, 102, -132}, {103, 103, 281}, {104, 122, 91}, },
            {{45, 122, -166}, },
            {{45, 122, -167}, },
            {{45, 79, -117}, {80, 80, 282}, {81, 90, 89}, {95, 111, -117}, {112, 112, 283}, {113, 122, 91}, },
            {{45, 70, -132}, {71, 71, 284}, {72, 102, -132}, {103, 103, 285}, {104, 122, 91}, },
            {{45, 57, -21}, {65, 65, 286}, {66, 95, -42}, {97, 97, 287}, {98, 122, 91}, },
            {{45, 77, -29}, {78, 78, 288}, {79, 109, -106}, {110, 110, 289}, {111, 122, 91}, },
            {{45, 122, -170}, },
            {{45, 122, -171}, },
            {{45, 122, -172}, },
            {{45, 122, -173}, },
            {{45, 81, -125}, {82, 82, 290}, {83, 113, -125}, {114, 114, 291}, {115, 122, 91}, },
            {{45, 76, -113}, {77, 77, 292}, {78, 108, -113}, {109, 109, 293}, {110, 122, 91}, },
            {{45, 122, -33}, },
            {{45, 57, -21}, {65, 65, 294}, {66, 95, -42}, {97, 97, 295}, {98, 122, 91}, },
            {{45, 122, -178}, },
            {{45, 122, -179}, },
            {{45, 122, -33}, },
            {{45, 122, -181}, },
            {{45, 57, -21}, {65, 65, 296}, {66, 95, -42}, {97, 97, 297}, {98, 122, 91}, },
            {{45, 122, -186}, },
            {{45, 75, -21}, {76, 76, 298}, {77, 107, -27}, {108, 108, 299}, {109, 122, 91}, },
            {{45, 122, -188}, },
            {{45, 68, -31}, {69, 69, 300}, {70, 100, -31}, {101, 101, 301}, {102, 122, 91}, },
            {{45, 122, -190}, },
            {{48, 57, 302}, {65, 70, 303}, {97, 102, 304}, },
            {{48, 57, 305}, {65, 70, 306}, {97, 102, 307}, },
            {{45, 81, -125}, {82, 82, 308}, {83, 113, -125}, {114, 114, 309}, {115, 122, 91}, },
            {{45, 122, -194}, },
            {{45, 45, 198}, },
            {{45, 45, 198}, },
            {{10, 10, 310}, {45, 45, 198}, },
            {{45, 45, 198}, },
            {{9, 9, 311}, {10, 10, 312}, {13, 13, 313}, {32, 32, 314}, },
            {{9, 45, -77}, },
            {{0, 65535, -8}, },
            {{45, 45, 205}, },
            {{45, 45, 205}, },
            {{10, 10, 315}, {45, 45, 205}, },
            {{45, 45, 205}, },
            {{9, 9, 316}, {10, 10, 317}, {13, 13, 318}, {32, 32, 319}, },
            {{9, 45, -81}, },
            {{0, 65535, -10}, },
            {},
            {{43, 43, 320}, {45, 45, 321}, {48, 57, 322}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 68, -31}, {69, 69, 323}, {70, 100, -31}, {101, 101, 324}, {102, 122, 91}, },
            {{45, 122, -216}, },
            {{45, 57, -21}, {65, 65, 325}, {66, 95, -42}, {97, 97, 326}, {98, 122, 91}, },
            {{45, 122, -218}, },
            {{45, 77, -29}, {78, 78, 327}, {79, 109, -106}, {110, 110, 328}, {111, 122, 91}, },
            {{45, 122, -220}, },
            {{45, 81, -125}, {82, 82, 329}, {83, 113, -125}, {114, 114, 330}, {115, 122, 91}, },
            {{45, 122, -222}, },
            {{45, 79, -117}, {80, 80, 331}, {81, 111, -170}, {112, 112, 332}, {113, 122, 91}, },
            {{45, 122, -224}, },
            {{45, 68, -31}, {69, 69, 333}, {70, 100, -31}, {101, 101, 334}, {102, 122, 91}, },
            {{45, 122, -226}, },
            {{45, 68, -31}, {69, 69, 335}, {70, 100, -31}, {101, 101, 336}, {102, 122, 91}, },
            {{45, 66, -102}, {67, 67, 337}, {68, 98, -102}, {99, 99, 338}, {100, 122, 91}, },
            {{45, 122, -228}, },
            {{45, 122, -229}, },
            {{45, 79, -117}, {80, 80, 339}, {81, 111, -170}, {112, 112, 340}, {113, 122, 91}, },
            {{45, 122, -232}, },
            {{45, 68, -31}, {69, 69, 341}, {70, 100, -31}, {101, 101, 342}, {102, 122, 91}, },
            {{45, 122, -234}, },
            {{45, 75, -21}, {76, 76, 343}, {77, 107, -27}, {108, 108, 344}, {109, 122, 91}, },
            {{45, 122, -236}, },
            {{45, 76, -113}, {77, 77, 345}, {78, 108, -113}, {109, 109, 346}, {110, 122, 91}, },
            {{45, 122, -238}, },
            {{45, 66, -102}, {67, 67, 347}, {68, 98, -102}, {99, 99, 348}, {100, 122, 91}, },
            {{45, 122, -240}, },
            {{45, 65, -35}, {66, 66, 349}, {67, 90, 89}, {95, 97, -35}, {98, 98, 350}, {99, 122, 91}, },
            {{45, 122, -242}, },
            {{45, 71, -23}, {72, 72, 351}, {73, 103, -43}, {104, 104, 352}, {105, 122, 91}, },
            {{45, 122, -244}, },
            {{45, 68, -31}, {69, 69, 353}, {70, 100, -31}, {101, 101, 354}, {102, 122, 91}, },
            {{45, 122, -246}, },
            {{45, 83, -116}, {84, 84, 355}, {85, 115, -116}, {116, 116, 356}, {117, 122, 91}, },
            {{45, 122, -248}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 67, -134}, {68, 68, 357}, {69, 99, -134}, {100, 100, 358}, {101, 122, 91}, },
            {{45, 83, -116}, {84, 84, 359}, {85, 115, -116}, {116, 116, 360}, {117, 122, 91}, },
            {{45, 122, -252}, },
            {{45, 122, -253}, },
            {{45, 45, 361}, {48, 122, -33}, },
            {{45, 122, -256}, },
            {{45, 72, -22}, {73, 73, 362}, {74, 104, -28}, {105, 105, 363}, {106, 122, 91}, },
            {{45, 122, -258}, },
            {{45, 75, -21}, {76, 76, 364}, {77, 107, -27}, {108, 108, 365}, {109, 122, 91}, },
            {{45, 122, -260}, },
            {{45, 68, -31}, {69, 69, 366}, {70, 100, -31}, {101, 101, 367}, {102, 122, 91}, },
            {{45, 122, -262}, },
            {{45, 84, -30}, {85, 85, 368}, {86, 116, -30}, {117, 117, 369}, {118, 122, 91}, },
            {{45, 122, -264}, },
            {{45, 57, -21}, {65, 74, 89}, {75, 75, 370}, {76, 90, 89}, {95, 95, 90}, {97, 106, 91}, {107, 107, 371}, {108, 122, 91}, },
            {{45, 122, -266}, },
            {{45, 83, -116}, {84, 84, 372}, {85, 115, -116}, {116, 116, 373}, {117, 122, 91}, },
            {{45, 122, -268}, },
            {{45, 77, -29}, {78, 78, 374}, {79, 109, -106}, {110, 110, 375}, {111, 122, 91}, },
            {{45, 122, -270}, },
            {{45, 66, -102}, {67, 67, 376}, {68, 98, -102}, {99, 99, 377}, {100, 122, 91}, },
            {{45, 122, -272}, },
            {{45, 83, -116}, {84, 84, 378}, {85, 115, -116}, {116, 116, 379}, {117, 122, 91}, },
            {{45, 122, -274}, },
            {{45, 68, -31}, {69, 69, 380}, {70, 100, -31}, {101, 101, 381}, {102, 122, 91}, },
            {{45, 68, -31}, {69, 69, 382}, {70, 100, -31}, {101, 101, 383}, {102, 122, 91}, },
            {{45, 57, -21}, {65, 65, 384}, {66, 95, -42}, {97, 97, 385}, {98, 122, 91}, },
            {{45, 122, -276}, },
            {{45, 122, -277}, },
            {{45, 122, -278}, },
            {{45, 71, -23}, {72, 72, 386}, {73, 103, -43}, {104, 104, 387}, {105, 122, 91}, },
            {{45, 122, -282}, },
            {{45, 57, -21}, {65, 65, 388}, {66, 95, -42}, {97, 97, 389}, {98, 122, 91}, },
            {{45, 122, -284}, },
            {{45, 77, -29}, {78, 78, 390}, {79, 109, -106}, {110, 110, 391}, {111, 122, 91}, },
            {{45, 122, -286}, },
            {{45, 66, -102}, {67, 67, 392}, {68, 98, -102}, {99, 99, 393}, {100, 122, 91}, },
            {{45, 122, -288}, },
            {{45, 66, -102}, {67, 67, 394}, {68, 98, -102}, {99, 99, 395}, {100, 122, 91}, },
            {{45, 122, -290}, },
            {{45, 78, -130}, {79, 79, 396}, {80, 84, 89}, {85, 85, 397}, {86, 95, -26}, {97, 110, 91}, {111, 111, 398}, {112, 116, 91}, {117, 117, 399}, {118, 122, 91}, },
            {{45, 122, -292}, },
            {{45, 68, -31}, {69, 69, 400}, {70, 100, -31}, {101, 101, 401}, {102, 122, 91}, },
            {{45, 122, -294}, },
            {{45, 72, -22}, {73, 73, 402}, {74, 104, -28}, {105, 105, 403}, {106, 122, 91}, },
            {{45, 122, -296}, },
            {{45, 70, -132}, {71, 71, 404}, {72, 102, -132}, {103, 103, 405}, {104, 122, 91}, },
            {{45, 122, -298}, },
            {{45, 84, -30}, {85, 85, 406}, {86, 116, -30}, {117, 117, 407}, {118, 122, 91}, },
            {{45, 122, -300}, },
            {{45, 77, -29}, {78, 78, 408}, {79, 109, -106}, {110, 110, 409}, {111, 122, 91}, },
            {{45, 122, -302}, },
            {{48, 57, 410}, {65, 70, 411}, {97, 102, 412}, },
            {{48, 102, -304}, },
            {{48, 102, -304}, },
            {{48, 57, 413}, {65, 70, 414}, {97, 102, 415}, },
            {{48, 102, -307}, },
            {{48, 102, -307}, },
            {{45, 78, -130}, {79, 79, 416}, {80, 110, -130}, {111, 111, 417}, {112, 122, 91}, },
            {{45, 122, -310}, },
            {{45, 45, 198}, },
            {{9, 32, -200}, {34, 34, 418}, },
            {{9, 34, -313}, },
            {{9, 9, 311}, {10, 10, 419}, {13, 34, -313}, },
            {{9, 34, -313}, },
            {{45, 45, 205}, },
            {{9, 32, -207}, {39, 39, 420}, },
            {{9, 39, -318}, },
            {{9, 9, 316}, {10, 10, 421}, {13, 39, -318}, },
            {{9, 39, -318}, },
            {{48, 57, 322}, },
            {{48, 57, 322}, },
            {{48, 57, 322}, },
            {{45, 77, -29}, {78, 78, 422}, {79, 109, -106}, {110, 110, 423}, {111, 122, 91}, },
            {{45, 122, -325}, },
            {{45, 81, -125}, {82, 82, 424}, {83, 113, -125}, {114, 114, 425}, {115, 122, 91}, },
            {{45, 122, -327}, },
            {{45, 74, -266}, {75, 75, 426}, {76, 106, -266}, {107, 107, 427}, {108, 122, 91}, },
            {{45, 122, -329}, },
            {{45, 57, -21}, {65, 65, 428}, {66, 95, -42}, {97, 97, 429}, {98, 122, 91}, },
            {{45, 122, -331}, },
            {{45, 45, 430}, {48, 84, -30}, {85, 85, 431}, {86, 116, -30}, {117, 117, 432}, {118, 122, 91}, },
            {{45, 122, -333}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 77, -29}, {78, 78, 433}, {79, 109, -106}, {110, 110, 434}, {111, 122, 91}, },
            {{45, 122, -337}, },
            {{45, 68, -31}, {69, 69, 435}, {70, 100, -31}, {101, 101, 436}, {102, 122, 91}, },
            {{45, 122, -339}, },
            {{45, 75, -21}, {76, 76, 437}, {77, 107, -27}, {108, 108, 438}, {109, 122, 91}, },
            {{45, 122, -341}, },
            {{45, 81, -125}, {82, 82, 439}, {83, 113, -125}, {114, 114, 440}, {115, 122, 91}, },
            {{45, 122, -343}, },
            {{45, 68, -31}, {69, 69, 441}, {70, 100, -31}, {101, 101, 442}, {102, 122, 91}, },
            {{45, 122, -345}, },
            {{45, 57, -21}, {65, 65, 443}, {66, 95, -42}, {97, 97, 444}, {98, 122, 91}, },
            {{45, 122, -347}, },
            {{45, 83, -116}, {84, 84, 445}, {85, 115, -116}, {116, 116, 446}, {117, 122, 91}, },
            {{45, 122, -349}, },
            {{45, 57, -21}, {65, 65, 447}, {66, 95, -42}, {97, 97, 448}, {98, 122, 91}, },
            {{45, 122, -351}, },
            {{45, 45, 449}, {48, 122, -33}, },
            {{45, 122, -353}, },
            {{45, 87, -25}, {88, 88, 450}, {89, 119, -25}, {120, 120, 451}, {121, 122, 91}, },
            {{45, 122, -355}, },
            {{45, 72, -22}, {73, 73, 452}, {74, 104, -28}, {105, 105, 453}, {106, 122, 91}, },
            {{45, 122, -357}, },
            {{45, 72, -22}, {73, 73, 454}, {74, 104, -28}, {105, 105, 455}, {106, 122, 91}, },
            {{45, 122, -359}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 57, -21}, {65, 85, 89}, {86, 86, 456}, {87, 90, 89}, {95, 95, 90}, {97, 117, 91}, {118, 118, 457}, {119, 122, 91}, },
            {{45, 78, -130}, {79, 79, 458}, {80, 85, 89}, {86, 86, 459}, {87, 95, -363}, {97, 110, 91}, {111, 111, 460}, {112, 117, 91}, {118, 118, 461}, {119, 122, 91}, },
            {{45, 122, -364}, },
            {{45, 82, -41}, {83, 83, 462}, {84, 114, -41}, {115, 115, 463}, {116, 122, 91}, },
            {{45, 122, -366}, },
            {{45, 66, -102}, {67, 67, 464}, {68, 98, -102}, {99, 99, 465}, {100, 122, 91}, },
            {{45, 122, -368}, },
            {{45, 81, -125}, {82, 82, 466}, {83, 113, -125}, {114, 114, 467}, {115, 122, 91}, },
            {{45, 122, -370}, },
            {{45, 68, -31}, {69, 69, 468}, {70, 100, -31}, {101, 101, 469}, {102, 122, 91}, },
            {{45, 122, -372}, },
            {{45, 84, -30}, {85, 85, 470}, {86, 116, -30}, {117, 117, 471}, {118, 122, 91}, },
            {{45, 122, -374}, },
            {{45, 83, -116}, {84, 84, 472}, {85, 115, -116}, {116, 116, 473}, {117, 122, 91}, },
            {{45, 122, -376}, },
            {{45, 68, -31}, {69, 69, 474}, {70, 100, -31}, {101, 101, 475}, {102, 122, 91}, },
            {{45, 122, -378}, },
            {{45, 68, -31}, {69, 69, 476}, {70, 100, -31}, {101, 101, 477}, {102, 122, 91}, },
            {{45, 122, -380}, },
            {{45, 57, -21}, {65, 69, 89}, {70, 70, 478}, {71, 95, -142}, {97, 101, 91}, {102, 102, 479}, {103, 122, 91}, },
            {{45, 122, -382}, },
            {{45, 81, -125}, {82, 82, 480}, {83, 113, -125}, {114, 114, 481}, {115, 122, 91}, },
            {{45, 122, -384}, },
            {{45, 76, -113}, {77, 77, 482}, {78, 108, -113}, {109, 109, 483}, {110, 122, 91}, },
            {{45, 122, -386}, },
            {{45, 83, -116}, {84, 84, 484}, {85, 115, -116}, {116, 116, 485}, {117, 122, 91}, },
            {{45, 122, -388}, },
            {{45, 81, -125}, {82, 82, 486}, {83, 113, -125}, {114, 114, 487}, {115, 122, 91}, },
            {{45, 122, -390}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 68, -31}, {69, 69, 488}, {70, 100, -31}, {101, 101, 489}, {102, 122, 91}, },
            {{45, 122, -394}, },
            {{45, 71, -23}, {72, 72, 490}, {73, 103, -43}, {104, 104, 491}, {105, 122, 91}, },
            {{45, 122, -396}, },
            {{45, 84, -30}, {85, 85, 492}, {86, 116, -30}, {117, 117, 493}, {118, 122, 91}, },
            {{45, 122, -33}, },
            {{45, 122, -398}, },
            {{45, 122, -33}, },
            {{45, 82, -41}, {83, 83, 494}, {84, 114, -41}, {115, 115, 495}, {116, 122, 91}, },
            {{45, 122, -402}, },
            {{45, 75, -21}, {76, 76, 496}, {77, 107, -27}, {108, 108, 497}, {109, 122, 91}, },
            {{45, 122, -404}, },
            {{45, 68, -31}, {69, 69, 498}, {70, 100, -31}, {101, 101, 499}, {102, 122, 91}, },
            {{45, 122, -406}, },
            {{45, 68, -31}, {69, 69, 500}, {70, 100, -31}, {101, 101, 501}, {102, 122, 91}, },
            {{45, 122, -408}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{34, 34, 502}, {48, 102, -192}, },
            {{34, 102, -412}, },
            {{34, 102, -412}, },
            {{39, 39, 503}, {48, 102, -193}, },
            {{39, 102, -415}, },
            {{39, 102, -415}, },
            {{45, 68, -31}, {69, 69, 504}, {70, 82, 89}, {83, 83, 505}, {84, 95, -21}, {97, 100, 91}, {101, 101, 506}, {102, 114, 91}, {115, 115, 507}, {116, 122, 91}, },
            {{45, 122, -418}, },
            {{0, 65535, -8}, },
            {{9, 34, -313}, },
            {{0, 65535, -10}, },
            {{9, 39, -318}, },
            {{45, 67, -134}, {68, 68, 508}, {69, 99, -134}, {100, 100, 509}, {101, 122, 91}, },
            {{45, 122, -424}, },
            {{45, 88, -140}, {89, 89, 510}, {90, 120, -140}, {121, 121, 511}, {122, 122, 91}, },
            {{45, 122, -426}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 66, -102}, {67, 67, 512}, {68, 98, -102}, {99, 99, 513}, {100, 122, 91}, },
            {{45, 122, -430}, },
            {{45, 45, 87}, {48, 48, 97}, {49, 49, 514}, {50, 50, 515}, {51, 51, 516}, {52, 52, 517}, {53, 53, 518}, {54, 54, 519}, {55, 57, 97}, {65, 122, -16}, },
            {{45, 83, -116}, {84, 84, 520}, {85, 115, -116}, {116, 116, 521}, {117, 122, 91}, },
            {{45, 122, -433}, },
            {{45, 67, -134}, {68, 68, 522}, {69, 99, -134}, {100, 100, 523}, {101, 122, 91}, },
            {{45, 122, -435}, },
            {{45, 77, -29}, {78, 78, 524}, {79, 109, -106}, {110, 110, 525}, {111, 122, 91}, },
            {{45, 122, -437}, },
            {{45, 57, -21}, {65, 65, 526}, {66, 95, -42}, {97, 97, 527}, {98, 122, 91}, },
            {{45, 122, -439}, },
            {{45, 77, -29}, {78, 78, 528}, {79, 109, -106}, {110, 110, 529}, {111, 122, 91}, },
            {{45, 122, -441}, },
            {{45, 81, -125}, {82, 82, 530}, {83, 113, -125}, {114, 114, 531}, {115, 122, 91}, },
            {{45, 122, -443}, },
            {{45, 83, -116}, {84, 84, 532}, {85, 115, -116}, {116, 116, 533}, {117, 122, 91}, },
            {{45, 122, -445}, },
            {{45, 72, -22}, {73, 73, 534}, {74, 104, -28}, {105, 105, 535}, {106, 122, 91}, },
            {{45, 122, -447}, },
            {{45, 75, -21}, {76, 76, 536}, {77, 107, -27}, {108, 108, 537}, {109, 122, 91}, },
            {{45, 122, -449}, },
            {{45, 85, -363}, {86, 86, 538}, {87, 117, -363}, {118, 118, 539}, {119, 122, 91}, },
            {{45, 68, -31}, {69, 69, 540}, {70, 100, -31}, {101, 101, 541}, {102, 122, 91}, },
            {{45, 122, -452}, },
            {{45, 69, -382}, {70, 70, 542}, {71, 101, -382}, {102, 102, 543}, {103, 122, 91}, },
            {{45, 122, -454}, },
            {{45, 77, -29}, {78, 78, 544}, {79, 109, -106}, {110, 110, 545}, {111, 122, 91}, },
            {{45, 122, -456}, },
            {{45, 57, -21}, {65, 65, 546}, {66, 95, -42}, {97, 97, 547}, {98, 122, 91}, },
            {{45, 122, -458}, },
            {{45, 77, -29}, {78, 78, 548}, {79, 109, -106}, {110, 110, 549}, {111, 122, 91}, },
            {{45, 68, -31}, {69, 69, 550}, {70, 100, -31}, {101, 101, 551}, {102, 122, 91}, },
            {{45, 122, -460}, },
            {{45, 122, -461}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 83, -116}, {84, 84, 552}, {85, 115, -116}, {116, 116, 553}, {117, 122, 91}, },
            {{45, 122, -466}, },
            {{45, 82, -41}, {83, 83, 554}, {84, 114, -41}, {115, 115, 555}, {116, 122, 91}, },
            {{45, 122, -468}, },
            {{45, 67, -134}, {68, 68, 556}, {69, 99, -134}, {100, 100, 557}, {101, 122, 91}, },
            {{45, 122, -470}, },
            {{45, 81, -125}, {82, 82, 558}, {83, 113, -125}, {114, 114, 559}, {115, 122, 91}, },
            {{45, 122, -472}, },
            {{45, 68, -31}, {69, 69, 560}, {70, 100, -31}, {101, 101, 561}, {102, 122, 91}, },
            {{45, 122, -474}, },
            {{45, 67, -134}, {68, 68, 562}, {69, 99, -134}, {100, 100, 563}, {101, 122, 91}, },
            {{45, 122, -476}, },
            {{45, 82, -41}, {83, 83, 564}, {84, 114, -41}, {115, 115, 565}, {116, 122, 91}, },
            {{45, 122, -478}, },
            {{45, 72, -22}, {73, 73, 566}, {74, 104, -28}, {105, 105, 567}, {106, 122, 91}, },
            {{45, 122, -480}, },
            {{45, 68, -31}, {69, 69, 568}, {70, 100, -31}, {101, 101, 569}, {102, 122, 91}, },
            {{45, 122, -482}, },
            {{45, 68, -31}, {69, 69, 570}, {70, 100, -31}, {101, 101, 571}, {102, 122, 91}, },
            {{45, 122, -484}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 57, -21}, {65, 65, 572}, {66, 95, -42}, {97, 97, 573}, {98, 122, 91}, },
            {{45, 122, -488}, },
            {{45, 82, -41}, {83, 83, 574}, {84, 114, -41}, {115, 115, 575}, {116, 122, 91}, },
            {{45, 122, -490}, },
            {{45, 81, -125}, {82, 82, 576}, {83, 113, -125}, {114, 114, 577}, {115, 122, 91}, },
            {{45, 122, -492}, },
            {{45, 70, -132}, {71, 71, 578}, {72, 102, -132}, {103, 103, 579}, {104, 122, 91}, },
            {{45, 122, -494}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 72, -22}, {73, 73, 580}, {74, 104, -28}, {105, 105, 581}, {106, 122, 91}, },
            {{45, 122, -498}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 82, -41}, {83, 83, 582}, {84, 114, -41}, {115, 115, 583}, {116, 122, 91}, },
            {{45, 122, -502}, },
            {},
            {},
            {{45, 82, -41}, {83, 83, 584}, {84, 114, -41}, {115, 115, 585}, {116, 122, 91}, },
            {{45, 122, -33}, },
            {{45, 122, -506}, },
            {{45, 122, -33}, },
            {{45, 72, -22}, {73, 73, 586}, {74, 104, -28}, {105, 105, 587}, {106, 122, 91}, },
            {{45, 122, -510}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 83, -116}, {84, 84, 588}, {85, 115, -116}, {116, 116, 589}, {117, 122, 91}, },
            {{45, 122, -514}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 57, -21}, {65, 65, 590}, {66, 95, -42}, {97, 97, 591}, {98, 122, 91}, },
            {{45, 122, -522}, },
            {{45, 72, -22}, {73, 73, 592}, {74, 104, -28}, {105, 105, 593}, {106, 122, 91}, },
            {{45, 122, -524}, },
            {{45, 67, -134}, {68, 68, 594}, {69, 99, -134}, {100, 100, 595}, {101, 122, 91}, },
            {{45, 122, -526}, },
            {{45, 88, -140}, {89, 89, 596}, {90, 120, -140}, {121, 121, 597}, {122, 122, 91}, },
            {{45, 122, -528}, },
            {{45, 57, -21}, {65, 65, 598}, {66, 95, -42}, {97, 97, 599}, {98, 122, 91}, },
            {{45, 122, -530}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 78, -130}, {79, 79, 600}, {80, 110, -130}, {111, 111, 601}, {112, 122, 91}, },
            {{45, 122, -536}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 57, -21}, {65, 65, 602}, {66, 95, -42}, {97, 97, 603}, {98, 122, 91}, },
            {{45, 122, -540}, },
            {{45, 67, -134}, {68, 68, 604}, {69, 99, -134}, {100, 100, 605}, {101, 122, 91}, },
            {{45, 122, -542}, },
            {{45, 72, -22}, {73, 73, 606}, {74, 104, -28}, {105, 105, 607}, {106, 122, 91}, },
            {{45, 122, -544}, },
            {{45, 70, -132}, {71, 71, 608}, {72, 102, -132}, {103, 103, 609}, {104, 122, 91}, },
            {{45, 122, -546}, },
            {{45, 75, -21}, {76, 76, 610}, {77, 107, -27}, {108, 108, 611}, {109, 122, 91}, },
            {{45, 122, -548}, },
            {{45, 57, -21}, {65, 65, 612}, {66, 95, -42}, {97, 97, 613}, {98, 122, 91}, },
            {{45, 122, -550}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 45, 614}, {48, 122, -33}, },
            {{45, 122, -558}, },
            {{45, 68, -31}, {69, 69, 615}, {70, 100, -31}, {101, 101, 616}, {102, 122, 91}, },
            {{45, 122, -560}, },
            {{45, 81, -125}, {82, 82, 617}, {83, 113, -125}, {114, 114, 618}, {115, 122, 91}, },
            {{45, 122, -562}, },
            {{45, 84, -30}, {85, 85, 619}, {86, 116, -30}, {117, 117, 620}, {118, 122, 91}, },
            {{45, 122, -564}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 77, -29}, {78, 78, 621}, {79, 109, -106}, {110, 110, 622}, {111, 122, 91}, },
            {{45, 122, -568}, },
            {{45, 77, -29}, {78, 78, 623}, {79, 109, -106}, {110, 110, 624}, {111, 122, 91}, },
            {{45, 122, -570}, },
            {{45, 82, -41}, {83, 83, 625}, {84, 114, -41}, {115, 115, 626}, {116, 122, 91}, },
            {{45, 122, -572}, },
            {{45, 83, -116}, {84, 84, 627}, {85, 115, -116}, {116, 116, 628}, {117, 122, 91}, },
            {{45, 122, -574}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 78, -130}, {79, 79, 629}, {80, 110, -130}, {111, 111, 630}, {112, 122, 91}, },
            {{45, 122, -578}, },
            {{45, 71, -23}, {72, 72, 631}, {73, 103, -43}, {104, 104, 632}, {105, 122, 91}, },
            {{45, 122, -580}, },
            {{45, 77, -29}, {78, 78, 633}, {79, 109, -106}, {110, 110, 634}, {111, 122, 91}, },
            {{45, 122, -582}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 77, -29}, {78, 78, 635}, {79, 109, -106}, {110, 110, 636}, {111, 122, 91}, },
            {{45, 122, -588}, },
            {{45, 68, -31}, {69, 69, 637}, {70, 100, -31}, {101, 101, 638}, {102, 122, 91}, },
            {{45, 122, -590}, },
            {{45, 83, -116}, {84, 84, 639}, {85, 115, -116}, {116, 116, 640}, {117, 122, 91}, },
            {{45, 122, -592}, },
            {{45, 77, -29}, {78, 78, 641}, {79, 109, -106}, {110, 110, 642}, {111, 122, 91}, },
            {{45, 122, -594}, },
            {{45, 72, -22}, {73, 73, 643}, {74, 104, -28}, {105, 105, 644}, {106, 122, 91}, },
            {{45, 122, -596}, },
            {{45, 45, 645}, {48, 122, -33}, },
            {{45, 122, -598}, },
            {{45, 75, -21}, {76, 76, 646}, {77, 107, -27}, {108, 108, 647}, {109, 122, 91}, },
            {{45, 122, -600}, },
            {{45, 77, -29}, {78, 78, 648}, {79, 109, -106}, {110, 110, 649}, {111, 122, 91}, },
            {{45, 122, -602}, },
            {{45, 75, -21}, {76, 76, 650}, {77, 107, -27}, {108, 108, 651}, {109, 122, 91}, },
            {{45, 122, -604}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 68, -31}, {69, 69, 652}, {70, 100, -31}, {101, 101, 653}, {102, 122, 91}, },
            {{45, 122, -608}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 84, -30}, {85, 85, 654}, {86, 116, -30}, {117, 117, 655}, {118, 122, 91}, },
            {{45, 122, -612}, },
            {{45, 75, -21}, {76, 76, 656}, {77, 107, -27}, {108, 108, 657}, {109, 122, 91}, },
            {{45, 122, -614}, },
            {{45, 67, -134}, {68, 68, 658}, {69, 99, -134}, {100, 100, 659}, {101, 122, 91}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 81, -125}, {82, 82, 660}, {83, 113, -125}, {114, 114, 661}, {115, 122, 91}, },
            {{45, 122, -621}, },
            {{45, 68, -31}, {69, 69, 662}, {70, 100, -31}, {101, 101, 663}, {102, 122, 91}, },
            {{45, 122, -623}, },
            {{45, 66, -102}, {67, 67, 664}, {68, 98, -102}, {99, 99, 665}, {100, 122, 91}, },
            {{45, 122, -625}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 68, -31}, {69, 69, 666}, {70, 100, -31}, {101, 101, 667}, {102, 122, 91}, },
            {{45, 122, -629}, },
            {{45, 77, -29}, {78, 78, 668}, {79, 109, -106}, {110, 110, 669}, {111, 122, 91}, },
            {{45, 122, -631}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 70, -132}, {71, 71, 670}, {72, 102, -132}, {103, 103, 671}, {104, 122, 91}, },
            {{45, 122, -635}, },
            {{45, 70, -132}, {71, 71, 672}, {72, 102, -132}, {103, 103, 673}, {104, 122, 91}, },
            {{45, 122, -637}, },
            {{45, 81, -125}, {82, 82, 674}, {83, 113, -125}, {114, 114, 675}, {115, 122, 91}, },
            {{45, 122, -639}, },
            {{45, 72, -22}, {73, 73, 676}, {74, 104, -28}, {105, 105, 677}, {106, 122, 91}, },
            {{45, 122, -641}, },
            {{45, 70, -132}, {71, 71, 678}, {72, 102, -132}, {103, 103, 679}, {104, 122, 91}, },
            {{45, 122, -643}, },
            {{45, 77, -29}, {78, 78, 680}, {79, 109, -106}, {110, 110, 681}, {111, 122, 91}, },
            {{45, 122, -645}, },
            {{45, 48, -432}, {49, 49, 682}, {50, 57, 97}, {65, 122, -16}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 45, 683}, {48, 122, -33}, },
            {{45, 122, -650}, },
            {{45, 84, -30}, {85, 85, 684}, {86, 116, -30}, {117, 117, 685}, {118, 122, 91}, },
            {{45, 122, -652}, },
            {{45, 67, -134}, {68, 68, 686}, {69, 99, -134}, {100, 100, 687}, {101, 122, 91}, },
            {{45, 122, -654}, },
            {{45, 68, -31}, {69, 69, 688}, {70, 100, -31}, {101, 101, 689}, {102, 122, 91}, },
            {{45, 122, -656}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 68, -31}, {69, 69, 690}, {70, 100, -31}, {101, 101, 691}, {102, 122, 91}, },
            {{45, 122, -660}, },
            {{45, 68, -31}, {69, 69, 692}, {70, 100, -31}, {101, 101, 693}, {102, 122, 91}, },
            {{45, 122, -662}, },
            {{45, 82, -41}, {83, 83, 694}, {84, 114, -41}, {115, 115, 695}, {116, 122, 91}, },
            {{45, 122, -664}, },
            {{45, 68, -31}, {69, 69, 696}, {70, 100, -31}, {101, 101, 697}, {102, 122, 91}, },
            {{45, 122, -666}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 72, -22}, {73, 73, 698}, {74, 104, -28}, {105, 105, 699}, {106, 122, 91}, },
            {{45, 122, -670}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 78, -130}, {79, 79, 700}, {80, 110, -130}, {111, 111, 701}, {112, 122, 91}, },
            {{45, 122, -678}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 70, -132}, {71, 71, 702}, {72, 102, -132}, {103, 103, 703}, {104, 122, 91}, },
            {{45, 122, -682}, },
            {{45, 122, -33}, },
            {{45, 79, -117}, {80, 80, 704}, {81, 111, -170}, {112, 112, 705}, {113, 122, 91}, },
            {{45, 68, -31}, {69, 69, 706}, {70, 100, -31}, {101, 101, 707}, {102, 122, 91}, },
            {{45, 122, -686}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 82, -41}, {83, 83, 708}, {84, 114, -41}, {115, 115, 709}, {116, 122, 91}, },
            {{45, 122, -690}, },
            {{45, 66, -102}, {67, 67, 710}, {68, 98, -102}, {99, 99, 711}, {100, 122, 91}, },
            {{45, 122, -692}, },
            {{45, 45, 712}, {48, 122, -33}, },
            {{45, 122, -694}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 57, -21}, {65, 89, 89}, {90, 90, 713}, {95, 95, 90}, {97, 121, 91}, {122, 122, 714}, },
            {{45, 122, -700}, },
            {{45, 77, -29}, {78, 78, 715}, {79, 109, -106}, {110, 110, 716}, {111, 122, 91}, },
            {{45, 122, -702}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 78, -130}, {79, 79, 717}, {80, 110, -130}, {111, 111, 718}, {112, 122, 91}, },
            {{45, 122, -706}, },
            {{45, 82, -41}, {83, 83, 719}, {84, 114, -41}, {115, 115, 720}, {116, 122, 91}, },
            {{45, 122, -708}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 72, -22}, {73, 73, 721}, {74, 104, -28}, {105, 105, 722}, {106, 122, 91}, },
            {{45, 122, -712}, },
            {{45, 79, -117}, {80, 80, 723}, {81, 111, -170}, {112, 112, 724}, {113, 122, 91}, },
            {{45, 68, -31}, {69, 69, 725}, {70, 100, -31}, {101, 101, 726}, {102, 122, 91}, },
            {{45, 122, -715}, },
            {{45, 57, -21}, {65, 65, 727}, {66, 95, -42}, {97, 97, 728}, {98, 122, 91}, },
            {{45, 122, -717}, },
            {{45, 72, -22}, {73, 73, 729}, {74, 104, -28}, {105, 105, 730}, {106, 122, 91}, },
            {{45, 122, -719}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 76, -113}, {77, 77, 731}, {78, 108, -113}, {109, 109, 732}, {110, 122, 91}, },
            {{45, 122, -723}, },
            {{45, 78, -130}, {79, 79, 733}, {80, 110, -130}, {111, 111, 734}, {112, 122, 91}, },
            {{45, 122, -725}, },
            {{45, 67, -134}, {68, 68, 735}, {69, 99, -134}, {100, 100, 736}, {101, 122, 91}, },
            {{45, 122, -727}, },
            {{45, 75, -21}, {76, 76, 737}, {77, 107, -27}, {108, 108, 738}, {109, 122, 91}, },
            {{45, 122, -729}, },
            {{45, 77, -29}, {78, 78, 739}, {79, 109, -106}, {110, 110, 740}, {111, 122, 91}, },
            {{45, 122, -731}, },
            {{45, 57, -21}, {65, 65, 741}, {66, 95, -42}, {97, 97, 742}, {98, 122, 91}, },
            {{45, 122, -733}, },
            {{45, 72, -22}, {73, 73, 743}, {74, 104, -28}, {105, 105, 744}, {106, 122, 91}, },
            {{45, 122, -735}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 45, 745}, {48, 122, -33}, },
            {{45, 122, -739}, },
            {{45, 83, -116}, {84, 84, 746}, {85, 115, -116}, {116, 116, 747}, {117, 122, 91}, },
            {{45, 122, -741}, },
            {{45, 75, -21}, {76, 76, 748}, {77, 107, -27}, {108, 108, 749}, {109, 122, 91}, },
            {{45, 122, -743}, },
            {{45, 77, -29}, {78, 78, 750}, {79, 109, -106}, {110, 110, 751}, {111, 122, 91}, },
            {{45, 122, -745}, },
            {{45, 48, -432}, {49, 49, 752}, {50, 50, 753}, {51, 51, 754}, {52, 52, 755}, {53, 53, 756}, {54, 54, 757}, {55, 122, -432}, },
            {{45, 68, -31}, {69, 69, 758}, {70, 100, -31}, {101, 101, 759}, {102, 122, 91}, },
            {{45, 122, -748}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 83, -116}, {84, 84, 760}, {85, 115, -116}, {116, 116, 761}, {117, 122, 91}, },
            {{45, 122, -752}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 81, -125}, {82, 82, 762}, {83, 113, -125}, {114, 114, 763}, {115, 122, 91}, },
            {{45, 122, -760}, },
            {{45, 68, -31}, {69, 69, 764}, {70, 100, -31}, {101, 101, 765}, {102, 122, 91}, },
            {{45, 122, -762}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
            {{45, 81, -125}, {82, 82, 766}, {83, 113, -125}, {114, 114, 767}, {115, 122, 91}, },
            {{45, 122, -766}, },
            {{45, 122, -33}, },
            {{45, 122, -33}, },
        }
    };*/

    private static int[][] accept;
/*  {
        // INITIAL
        {14, 80, 0, 0, 0, 0, 80, 8, 80, 9, 10, 7, 5, 3, 6, 2, 4, 12, 12, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 0, 0, 0, 0, 0, -1, -1, -1, 13, -1, -1, -1, 13, -1, 1, 1, -1, 14, 79, 14, 79, 79, 79, 16, 14, 15, 12, 11, 79, 79, 79, 79, 79, 79, 79, 79, 79, 23, 79, 79, 23, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 45, 79, 45, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 56, 79, 79, 56, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 72, 79, 79, 79, 72, 79, 79, 79, 79, 79, 79, 79, -1, -1, 79, 79, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, 18, 18, 19, 19, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 47, 47, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 58, 58, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, -1, -1, -1, -1, -1, -1, 79, 79, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 14, 79, 79, 79, 79, 79, 79, 79, 79, 25, 25, 32, 32, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 46, 46, 79, 79, 49, 49, 79, 79, 79, 53, 53, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 67, 67, 79, 79, 69, 69, 79, 70, 79, 70, 79, 79, 79, 79, 79, 79, 79, 79, 77, 77, -1, -1, -1, -1, -1, -1, 78, 78, -1, -1, -1, -1, 79, 79, 79, 79, 22, 22, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 43, 43, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 53, 53, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 61, 61, 79, 79, 79, 79, 79, 79, 65, 65, 79, 79, 68, 68, 79, 79, 79, 79, 71, 71, 79, 79, 74, 74, 75, 75, 13, 13, 79, 78, 79, 78, 79, 79, 21, 21, 79, 79, 26, 27, 28, 29, 30, 31, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 38, 38, 39, 39, 79, 79, 41, 41, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 52, 52, 54, 54, 55, 55, 79, 79, 79, 79, 79, 79, 79, 79, 61, 61, 79, 79, 79, 79, 79, 79, 79, 79, 68, 68, 79, 79, 79, 79, 79, 79, 76, 76, 78, 78, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 35, 35, 79, 79, 79, 79, 79, 79, 44, 44, 79, 79, 48, 48, 79, 79, 79, 79, 79, 58, 58, 59, 59, 79, 79, 79, 79, 79, 79, 64, 64, 79, 79, 79, 79, 70, 70, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 37, 37, 79, 79, 79, 79, 79, 79, 79, 79, 51, 51, 79, 79, 79, 79, 79, 79, 79, 79, 66, 66, 79, 79, 73, 73, 20, 20, 24, 24, 79, 79, 33, 33, 79, 79, 36, 79, 79, 79, 46, 46, 50, 50, 79, 79, 79, 79, 62, 62, 63, 63, 79, 79, 79, 79, 34, 34, 79, 79, 42, 42, 50, 50, 79, 79, 79, 79, 79, 79, 79, 79, 79, 42, 42, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 69, 69, 25, 25, 79, 79, 79, 79, 79, 79, 79, 79, 79, 57, 57, 79, 79, 26, 27, 28, 29, 30, 31, 79, 79, 79, 79, 40, 40, 79, 79, 60, 60, },

    };*/

    public static class State
    {
        public final static State INITIAL = new State(0);

        private int id;

        private State(@SuppressWarnings("hiding") int id)
        {
            this.id = id;
        }

        public int id()
        {
            return this.id;
        }
    }

    static 
    {
        try
        {
            DataInputStream s = new DataInputStream(
                new BufferedInputStream(
                Lexer.class.getResourceAsStream("lexer.dat")));

            // read gotoTable
            int length = s.readInt();
            gotoTable = new int[length][][][];
            for(int i = 0; i < gotoTable.length; i++)
            {
                length = s.readInt();
                gotoTable[i] = new int[length][][];
                for(int j = 0; j < gotoTable[i].length; j++)
                {
                    length = s.readInt();
                    gotoTable[i][j] = new int[length][3];
                    for(int k = 0; k < gotoTable[i][j].length; k++)
                    {
                        for(int l = 0; l < 3; l++)
                        {
                            gotoTable[i][j][k][l] = s.readInt();
                        }
                    }
                }
            }

            // read accept
            length = s.readInt();
            accept = new int[length][];
            for(int i = 0; i < accept.length; i++)
            {
                length = s.readInt();
                accept[i] = new int[length];
                for(int j = 0; j < accept[i].length; j++)
                {
                    accept[i][j] = s.readInt();
                }
            }

            s.close();
        }
        catch(Exception e)
        {
            throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
        }
    }
}
