/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.maven.plugin.closurecompiler.common;

import java.io.File;

public class ProcessingResult {
    private final boolean wasSkipped;
    private final File output;

    public ProcessingResult(Builder builder) {
        this.wasSkipped = builder.wasSkipped;
        this.output = builder.output;
    }

    public static Builder skipped(File file) {
        Builder builder = new Builder();
        builder.wasSkipped = true;
        builder.output = file;
        return builder;
    }

    public static Builder success(File file) {
        Builder builder = new Builder();
        builder.output = file;
        return builder;
    }

    public boolean isWasSkipped() {
        return this.wasSkipped;
    }

    public File getOutput() {
        return this.output;
    }

    public static final class Builder {
        private boolean wasSkipped;
        private File output;

        public ProcessingResult build() {
            return new ProcessingResult(this);
        }
    }
}

