/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.maven.plugin.closurecompiler.common;

import com.github.blutorange.maven.plugin.closurecompiler.common.ClosureConfig;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileException;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileHelper;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileProcessConfig;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileSpecifier;
import com.github.blutorange.maven.plugin.closurecompiler.common.FilenameInterpolator;
import com.github.blutorange.maven.plugin.closurecompiler.common.ProcessingResult;
import com.github.blutorange.maven.plugin.closurecompiler.common.SourceFilesEnumeration;
import com.github.blutorange.maven.plugin.closurecompiler.plugin.SkipMode;
import com.github.blutorange.maven.plugin.closurecompiler.shared.MojoMetadata;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class ProcessFilesTask
implements Callable<List<ProcessingResult>> {
    private static final String DEFAULT_MERGED_FILENAME = "script.js";
    protected final MojoMetadata mojoMeta;
    protected final ClosureConfig closureConfig;
    protected final List<File> files = new ArrayList<File>();
    protected final boolean includesEmpty;
    protected final FilenameInterpolator outputFilenameInterpolator;
    protected final FileProcessConfig processConfig;
    protected final File sourceDir;
    protected final File targetDir;

    private static void addNewSourceFile(Collection<File> files, File sourceFile, MojoMetadata mojoMeta) throws IOException {
        if (!sourceFile.exists()) {
            throw new FileNotFoundException("The source file [" + sourceFile.getPath() + "] does not exist.");
        }
        mojoMeta.getLog().debug((CharSequence)("Adding source file [" + sourceFile.getPath() + "]."));
        files.add(sourceFile.getCanonicalFile());
    }

    public ProcessFilesTask(MojoMetadata mojoMeta, FileProcessConfig processConfig, FileSpecifier fileSpecifier, ClosureConfig closureConfig) throws IOException {
        this.mojoMeta = mojoMeta;
        this.processConfig = processConfig;
        File projectBasedir = mojoMeta.getProject().getBasedir();
        this.sourceDir = FileHelper.getFile(FileHelper.getAbsoluteFile(projectBasedir, fileSpecifier.getBaseSourceDir()), fileSpecifier.getSourceDir()).getAbsoluteFile().getCanonicalFile();
        this.targetDir = FileHelper.getFile(FileHelper.getAbsoluteFile(projectBasedir, fileSpecifier.getBaseTargetDir()), fileSpecifier.getTargetDir()).getAbsoluteFile().getCanonicalFile();
        this.outputFilenameInterpolator = new FilenameInterpolator(fileSpecifier.getOutputFilename());
        for (File include : FileHelper.getIncludedFiles(this.sourceDir, fileSpecifier.getIncludes(), fileSpecifier.getExcludes())) {
            if (this.files.contains(include)) continue;
            ProcessFilesTask.addNewSourceFile(this.files, include, mojoMeta);
        }
        this.includesEmpty = fileSpecifier.getIncludes().isEmpty();
        this.closureConfig = closureConfig;
    }

    private void assertTarget(File source, File target) throws MojoFailureException {
        if (this.processConfig.isAllowReplacingInputFiles() || !target.getAbsolutePath().equals(source.getAbsolutePath())) {
            return;
        }
        String msg = "The source file [" + source.getName() + "] has the same name as the output file [" + target.getName() + "].";
        this.mojoMeta.getLog().warn((CharSequence)msg);
        this.mojoMeta.getLog().debug((CharSequence)("Full path for source file is [" + source.getPath() + "] and for target file [" + target.getPath() + "]"));
        throw new MojoFailureException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProcessingResult> call() throws IOException, MojoFailureException {
        Log log = this.mojoMeta.getLog();
        synchronized (log) {
            this.mojoMeta.getLog().info((CharSequence)"Starting JavaScript task:");
            if (!this.files.isEmpty()) {
                try {
                    return this.processFiles();
                }
                catch (FileException e) {
                    this.logFailure(e);
                    throw new MojoFailureException("Closure compilation failure", (Throwable)e);
                }
                catch (Exception e) {
                    this.logFailure(e);
                    this.files.forEach(file -> this.mojoMeta.getBuildContext().addMessage(file, 1, 1, e.getMessage(), 2, (Throwable)e));
                    throw e;
                }
            }
            if (!this.includesEmpty) {
                this.mojoMeta.getLog().warn((CharSequence)"No valid JavaScript source files found to process.");
            }
            return List.of();
        }
    }

    private void logFailure(Exception e) {
        if (e instanceof FileException) {
            ((FileException)e).getFileErrors().forEach(fileError -> fileError.addTo(this.mojoMeta.getBuildContext()));
        }
        this.mojoMeta.getLog().error((CharSequence)("Failed to process the source files [" + this.files.stream().map(File::getName).collect(Collectors.joining(", ")) + "]."), (Throwable)e);
        this.mojoMeta.getLog().debug((CharSequence)("Full path is [" + this.files.stream().map(File::getPath).collect(Collectors.joining(", ")) + "]"));
    }

    private List<ProcessingResult> processFiles() throws IOException, MojoFailureException {
        List<ProcessingResult> results;
        boolean merge = !this.processConfig.isSkipMerge();
        boolean minify = !this.processConfig.isSkipMinify();
        boolean gzip = this.processConfig.isGzip();
        List<File> sourceFiles = this.files;
        if (merge) {
            File outputFile = this.outputFilenameInterpolator.interpolate(new File(this.targetDir, DEFAULT_MERGED_FILENAME), this.targetDir, this.targetDir);
            results = List.of(this.processFiles(sourceFiles, outputFile, minify, gzip));
        } else {
            ArrayList<ProcessingResult> list = new ArrayList<ProcessingResult>();
            for (File file : sourceFiles) {
                File outputFile = this.outputFilenameInterpolator.interpolate(file, this.sourceDir, this.targetDir);
                ProcessingResult result = this.processFiles(List.of(file), outputFile, minify, gzip);
                list.add(result);
            }
            results = list;
        }
        this.logResults(results);
        return results;
    }

    private void gzipCompress(File input) throws IOException {
        File output = new File(input.getAbsolutePath() + ".gz");
        try (GZIPOutputStream gos = new GZIPOutputStream(new FileOutputStream(output));
             FileInputStream fis = new FileInputStream(input);){
            fis.transferTo(gos);
        }
    }

    private ProcessingResult processFiles(List<File> inputFiles, File outputFile, boolean minify, boolean gzip) throws MojoFailureException, IOException {
        if (minify || inputFiles.size() == 1) {
            for (File inputFile : inputFiles) {
                this.assertTarget(inputFile, outputFile);
            }
        }
        ProcessingResult result = minify ? this.minify(inputFiles, outputFile) : (inputFiles.size() == 1 ? this.copy(inputFiles.get(0), outputFile) : this.merge(inputFiles, outputFile));
        if (gzip && !result.isWasSkipped()) {
            this.gzipCompress(outputFile);
        }
        return result;
    }

    protected final void removeMessages(Collection<File> files) {
        files.forEach(file -> this.mojoMeta.getBuildContext().removeMessages(file));
    }

    protected final void logCompressionGains(List<File> srcFiles, String minified) {
        if (!this.mojoMeta.getLog().isInfoEnabled() || this.mojoMeta.getBuildContext().isIncremental()) {
            return;
        }
        try {
            long compressedSizeGzip;
            byte[] minifiedData = minified.getBytes(this.mojoMeta.getEncoding());
            int compressedSize = minifiedData.length;
            try (ByteArrayInputStream input = new ByteArrayInputStream(minifiedData);
                 CountingOutputStream countingOutputStream = new CountingOutputStream(OutputStream.nullOutputStream());
                 GZIPOutputStream gzipOutputStream = new GZIPOutputStream((OutputStream)countingOutputStream);){
                IOUtils.copy((InputStream)input, (OutputStream)gzipOutputStream, (int)this.processConfig.getBufferSize());
                gzipOutputStream.finish();
                compressedSizeGzip = countingOutputStream.getByteCount();
            }
            long uncompressedSize = 0L;
            if (srcFiles != null) {
                for (File srcFile : srcFiles) {
                    uncompressedSize += srcFile.length();
                }
            }
            this.mojoMeta.getLog().info((CharSequence)("Uncompressed size: " + uncompressedSize + " bytes."));
            this.mojoMeta.getLog().info((CharSequence)("Compressed size: " + compressedSize + " bytes minified (" + compressedSizeGzip + " bytes gzipped)."));
        }
        catch (IOException e) {
            this.mojoMeta.getLog().debug((CharSequence)"Failed to calculate the gzipped file size.", (Throwable)e);
        }
    }

    protected final void mkDir(File directory) {
        if (directory.exists()) {
            return;
        }
        File firstThatExists = directory;
        while ((firstThatExists = firstThatExists.getParentFile()) != null && !firstThatExists.exists()) {
        }
        try {
            if (!directory.mkdirs()) {
                throw new RuntimeException("Unable to create target directory: " + directory.getPath());
            }
        }
        finally {
            if (firstThatExists != null) {
                this.mojoMeta.getBuildContext().refresh(firstThatExists);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ProcessingResult copy(File sourceFile, File targetFile) throws IOException {
        if (!this.haveFilesChanged(Collections.singleton(sourceFile), Collections.singleton(targetFile))) {
            return ProcessingResult.skipped(targetFile).build();
        }
        this.mkDir(this.targetDir);
        this.mkDir(targetFile.getParentFile());
        Reader inputReader = null;
        Writer outputWriter = null;
        try {
            FileInputStream input = new FileInputStream(sourceFile);
            OutputStream output = this.mojoMeta.getBuildContext().newFileOutputStream(targetFile);
            try {
                inputReader = new InputStreamReader((InputStream)input, this.mojoMeta.getEncoding());
            }
            finally {
                if (inputReader == null && input != null) {
                    ((InputStream)input).close();
                }
            }
            try {
                outputWriter = new OutputStreamWriter(output, this.mojoMeta.getEncoding());
            }
            finally {
                if (outputWriter == null && output != null) {
                    output.close();
                }
            }
            IOUtils.copy((Reader)inputReader, (Writer)outputWriter);
        }
        finally {
            try {
                if (inputReader != null) {
                    inputReader.close();
                }
            }
            finally {
                if (outputWriter != null) {
                    outputWriter.close();
                }
            }
        }
        this.mojoMeta.getLog().info((CharSequence)("Creating the copied file [" + targetFile.getName() + "]."));
        this.mojoMeta.getLog().debug((CharSequence)("Full path is [" + targetFile.getPath() + "]."));
        return ProcessingResult.success(targetFile).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ProcessingResult merge(List<File> sourceFiles, File mergedFile) throws IOException {
        if (!this.haveFilesChanged(sourceFiles, Collections.singleton(mergedFile))) {
            return ProcessingResult.skipped(mergedFile).build();
        }
        this.mkDir(this.targetDir);
        this.mkDir(mergedFile.getParentFile());
        this.mojoMeta.getLog().info((CharSequence)("Creating the merged file [" + mergedFile.getName() + "]."));
        this.mojoMeta.getLog().debug((CharSequence)("Full path is [" + mergedFile.getPath() + "]."));
        InputStreamReader inputStreamReader = null;
        OutputStreamWriter outputWriter = null;
        try {
            SequenceInputStream input = new SequenceInputStream(new SourceFilesEnumeration(this.mojoMeta.getLog(), sourceFiles, this.mojoMeta.getEncoding(), this.processConfig.getLineSeparator()));
            OutputStream output = this.mojoMeta.getBuildContext().newFileOutputStream(mergedFile);
            try {
                inputStreamReader = new InputStreamReader((InputStream)input, this.mojoMeta.getEncoding());
            }
            finally {
                if (inputStreamReader == null && input != null) {
                    ((InputStream)input).close();
                }
            }
            try {
                outputWriter = new OutputStreamWriter(output, this.mojoMeta.getEncoding());
            }
            finally {
                if (outputWriter == null && output != null) {
                    output.close();
                }
            }
            IOUtils.copyLarge((Reader)inputStreamReader, (Writer)outputWriter, (char[])new char[this.processConfig.getBufferSize()]);
            outputWriter.append(this.processConfig.getLineSeparator());
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
            finally {
                if (outputWriter != null) {
                    outputWriter.close();
                }
            }
        }
        return ProcessingResult.success(mergedFile).build();
    }

    protected final boolean haveFilesChanged(Collection<File> sourceFiles, Collection<File> outputFiles) {
        boolean changed;
        if (this.processConfig.isForce() && this.mojoMeta.getBuildContext().isIncremental()) {
            this.mojoMeta.getLog().warn((CharSequence)"Force is enabled, but building incrementally. Using the force option in an m2e incremental build will result in an endless build loop.");
        }
        if (this.processConfig.isForce()) {
            this.mojoMeta.getLog().info((CharSequence)"Force is enabled, skipping check for changed files.");
            changed = true;
        } else {
            changed = this.mojoMeta.getBuildContext().isIncremental() ? sourceFiles.stream().anyMatch(arg_0 -> ((BuildContext)this.mojoMeta.getBuildContext()).hasDelta(arg_0)) : this.checkFilesForChanges(sourceFiles, outputFiles);
        }
        if (changed) {
            this.removeMessages(sourceFiles);
        }
        if (this.mojoMeta.getLog().isDebugEnabled()) {
            String prefix = changed ? "Changes since last build, processing bundle with output files [" : "No changes since last build, skipping bundle with output files [";
            this.mojoMeta.getLog().debug((CharSequence)(prefix + outputFiles.stream().map(File::getPath).collect(Collectors.joining(", ")) + "]."));
        }
        return changed;
    }

    private boolean checkFilesForChanges(Collection<File> sourceFiles, Collection<File> outputFiles) {
        boolean outputFilesExist = outputFiles.stream().allMatch(File::exists);
        switch ((SkipMode)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.processConfig.getSkipMode()), (Object)((Object)SkipMode.NEWER)))) {
            case NEWER: {
                if (outputFilesExist) {
                    Long oldestOutputFile = outputFiles.stream().map(File::lastModified).min(Long::compare).orElse(0L);
                    Long youngestSourceFile = sourceFiles.stream().map(File::lastModified).max(Long::compare).orElse(Long.MAX_VALUE);
                    this.mojoMeta.getLog().debug((CharSequence)("Date of oldest output file is" + String.valueOf(new Date(oldestOutputFile))));
                    this.mojoMeta.getLog().debug((CharSequence)("Date of youngest source file is " + String.valueOf(new Date(youngestSourceFile))));
                    return oldestOutputFile <= youngestSourceFile;
                }
                return true;
            }
            case EXISTS: {
                return !outputFilesExist;
            }
        }
        throw new RuntimeException("Unhandled enum: " + String.valueOf((Object)this.processConfig.getSkipMode()));
    }

    private void logResults(List<ProcessingResult> results) {
        long skippedCount = results.stream().filter(ProcessingResult::isWasSkipped).count();
        long processedCount = (long)results.size() - skippedCount;
        this.mojoMeta.getLog().info((CharSequence)("Processed " + (processedCount + skippedCount) + " output files"));
        if (processedCount > 0L) {
            String message = "Created " + processedCount + " output files";
            if (this.processConfig.isGzip()) {
                message = message + " (and gzipped)";
            }
            this.mojoMeta.getLog().info((CharSequence)message);
        }
        if (skippedCount > 0L) {
            this.mojoMeta.getLog().info((CharSequence)("Skipped " + skippedCount + " output files (" + String.valueOf((Object)this.processConfig.getSkipMode()) + ")"));
        }
    }

    abstract ProcessingResult minify(File var1, File var2) throws IOException, MojoFailureException;

    abstract ProcessingResult minify(List<File> var1, File var2) throws IOException, MojoFailureException;
}

