/*
 * Decompiled with CFR 0.152.
 */
package com.github.blutorange.maven.plugin.closurecompiler.plugin;

import com.github.blutorange.maven.plugin.closurecompiler.common.ClosureCompileFileMessage;
import com.github.blutorange.maven.plugin.closurecompiler.common.ClosureConfig;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileException;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileHelper;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileMessage;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileProcessConfig;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileSpecifier;
import com.github.blutorange.maven.plugin.closurecompiler.common.FileSystemLocationMapping;
import com.github.blutorange.maven.plugin.closurecompiler.common.OutputInterpolator;
import com.github.blutorange.maven.plugin.closurecompiler.common.ProcessingResult;
import com.github.blutorange.maven.plugin.closurecompiler.plugin.MojoMetadata;
import com.github.blutorange.maven.plugin.closurecompiler.plugin.ProcessFilesTask;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import eu.maxschuster.dataurl.DataUrl;
import eu.maxschuster.dataurl.DataUrlBuilder;
import eu.maxschuster.dataurl.DataUrlEncoding;
import eu.maxschuster.dataurl.DataUrlSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.MojoFailureException;

public class ProcessJSFilesTask
extends ProcessFilesTask {
    public ProcessJSFilesTask(MojoMetadata mojoMeta, FileProcessConfig processConfig, FileSpecifier fileSpecifier, ClosureConfig closureConfig) throws IOException {
        super(mojoMeta, processConfig, fileSpecifier, closureConfig);
    }

    @Override
    protected ProcessingResult minify(File mergedFile, File minifiedFile) throws IOException, MojoFailureException {
        ArrayList<File> srcFiles = new ArrayList<File>();
        srcFiles.add(mergedFile);
        return this.minify(srcFiles, minifiedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ProcessingResult minify(List<File> srcFiles, File minifiedFile) throws IOException, MojoFailureException {
        File sourceMapFile = this.closureConfig.getSourceMapInterpolator().interpolate(minifiedFile, minifiedFile.getParentFile(), minifiedFile.getParentFile());
        if (!this.haveFilesChanged(srcFiles, this.closureConfig.isCreateSourceMapFile() ? Arrays.asList(minifiedFile, sourceMapFile) : Collections.singleton(minifiedFile))) {
            return new ProcessingResult().setWasSkipped(true);
        }
        this.mkDir(this.targetDir);
        this.mkDir(minifiedFile.getParentFile());
        if (this.closureConfig.isCreateSourceMapFile()) {
            this.mkDir(sourceMapFile.getParentFile());
        }
        OutputInterpolator outputInterpolator = this.closureConfig.getOutputInterpolator();
        this.mojoMeta.getLog().info((CharSequence)("Creating the minified file [" + minifiedFile.getName() + "]."));
        this.mojoMeta.getLog().debug((CharSequence)("Full path is [" + minifiedFile.getPath() + "]."));
        File baseDirForSourceFiles = this.getBaseDirForSourceFiles(minifiedFile, sourceMapFile);
        this.mojoMeta.getLog().debug((CharSequence)("Setting base dir for closure source files to [" + baseDirForSourceFiles.getAbsolutePath() + "]"));
        ArrayList<SourceFile> sourceFileList = new ArrayList<SourceFile>();
        for (File srcFile : srcFiles) {
            try (FileInputStream in = new FileInputStream(srcFile);){
                SourceFile input = SourceFile.fromInputStream((String)FileHelper.relativizePath(baseDirForSourceFiles, srcFile), (InputStream)in, (Charset)this.mojoMeta.getEncoding());
                sourceFileList.add(input);
            }
        }
        FileSystemLocationMapping fileSystemMapping = new FileSystemLocationMapping(this.mojoMeta.getLog(), baseDirForSourceFiles, minifiedFile, sourceMapFile);
        CompilerOptions options = this.closureConfig.getCompilerOptions(fileSystemMapping, minifiedFile, sourceMapFile, baseDirForSourceFiles, this.sourceDir);
        if (this.mojoMeta.getLog().isDebugEnabled()) {
            this.mojoMeta.getLog().debug((CharSequence)("Transpiling with closure source files: [" + sourceFileList.stream().map(SourceFile::toString).collect(Collectors.joining(", ")) + "]"));
            this.mojoMeta.getLog().debug((CharSequence)("Transpiling from [" + options.getLanguageIn() + "] to [" + this.closureConfig.getLanguageOut() + "], strict=" + options.shouldEmitUseStrict()));
            this.mojoMeta.getLog().debug((CharSequence)("Starting compilations with closure compiler options: " + options.toString()));
        }
        ArrayList<SourceFile> externs = new ArrayList<SourceFile>();
        externs.addAll(CommandLineRunner.getBuiltinExterns((CompilerOptions.Environment)this.closureConfig.getEnvironment()));
        externs.addAll(this.closureConfig.getExterns());
        Compiler compiler = new Compiler();
        compiler.compile(externs, sourceFileList, options);
        this.checkForErrors(compiler, baseDirForSourceFiles);
        String compiled = compiler.toSource();
        OutputStream out = null;
        try (Writer writer = null;){
            out = this.mojoMeta.getBuildContext().newFileOutputStream(minifiedFile);
            try {
                writer = new OutputStreamWriter(out, this.mojoMeta.getEncoding());
            }
            finally {
                if (writer == null && out != null) {
                    out.close();
                }
            }
            writer.append(outputInterpolator.apply(compiled));
            if (this.closureConfig.isCreateSourceMap()) {
                compiler.getSourceMap().setWrapperPrefix(outputInterpolator.getWrapperPrefix());
                fileSystemMapping.setTranspilationDone(true);
                this.createSourceMap(writer, compiler, minifiedFile, sourceMapFile);
            }
            writer.append(this.processConfig.getLineSeparator());
        }
        this.mojoMeta.getBuildContext().refresh(minifiedFile);
        this.logCompressionGains(srcFiles, compiled);
        return new ProcessingResult().setWasSkipped(false);
    }

    private File getBaseDirForSourceFiles(File minifiedFile, File sourceMapFile) throws IOException {
        return this.sourceDir;
    }

    private void checkForErrors(Compiler compiler, File baseDirForSourceFiles) {
        compiler.getWarnings().stream().forEach(warning -> ClosureCompileFileMessage.ofWarning(warning, compiler, baseDirForSourceFiles).addTo(this.mojoMeta.getBuildContext()));
        ArrayList errors = new ArrayList(compiler.getErrors());
        if (!errors.isEmpty()) {
            Iterable<FileMessage> fileErrors = errors.stream().map(error -> ClosureCompileFileMessage.ofError(error, compiler, baseDirForSourceFiles))::iterator;
            throw new FileException(fileErrors);
        }
    }

    private void createSourceMap(Writer writer, Compiler compiler, File minifiedFile, File sourceMapFile) throws IOException {
        String pathToSource = FilenameUtils.separatorsToUnix((String)FileHelper.relativizePath(sourceMapFile.getParentFile(), minifiedFile));
        this.mojoMeta.getLog().debug((CharSequence)("Setting path to source in source map to [" + pathToSource + "]."));
        switch (this.closureConfig.getSourceMapOutputType()) {
            case inline: {
                this.mojoMeta.getLog().info((CharSequence)"Creating the inline source map.");
                StringBuilder sb = new StringBuilder();
                compiler.getSourceMap().appendTo((Appendable)sb, pathToSource);
                DataUrl unserialized = new DataUrlBuilder().setMimeType("application/json").setEncoding(DataUrlEncoding.BASE64).setData(sb.toString().getBytes(StandardCharsets.UTF_8)).setHeader("charset", "utf-8").build();
                DataUrlSerializer serializer = new DataUrlSerializer();
                String dataUrl = serializer.serialize(unserialized);
                writer.append(this.processConfig.getLineSeparator());
                writer.append("//# sourceMappingURL=" + dataUrl);
                break;
            }
            case file: {
                this.flushSourceMap(sourceMapFile, pathToSource, compiler.getSourceMap());
                break;
            }
            case reference: {
                this.mojoMeta.getLog().info((CharSequence)"Creating reference to source map.");
                String pathToMap = FilenameUtils.separatorsToUnix((String)FileHelper.relativizePath(minifiedFile.getParentFile(), sourceMapFile));
                this.flushSourceMap(sourceMapFile, pathToSource, compiler.getSourceMap());
                writer.append(this.processConfig.getLineSeparator());
                writer.append("//# sourceMappingURL=" + pathToMap);
                break;
            }
            default: {
                this.mojoMeta.getLog().warn((CharSequence)("Unknown source map inclusion type [" + (Object)((Object)this.closureConfig.getSourceMapOutputType()) + "]"));
                throw new RuntimeException("unknown source map inclusion type: " + (Object)((Object)this.closureConfig.getSourceMapOutputType()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushSourceMap(File sourceMapFile, String pathToSource, SourceMap sourceMap) throws IOException {
        this.mojoMeta.getLog().info((CharSequence)("Creating the source map [" + sourceMapFile.getName() + "]."));
        this.mojoMeta.getLog().debug((CharSequence)("Full path is [" + sourceMapFile.getPath() + "]."));
        OutputStream out = null;
        try (Writer writer = null;){
            out = this.mojoMeta.getBuildContext().newFileOutputStream(sourceMapFile);
            try {
                writer = new OutputStreamWriter(out, this.mojoMeta.getEncoding());
            }
            finally {
                if (writer == null && out != null) {
                    out.close();
                }
            }
            sourceMap.appendTo((Appendable)writer, pathToSource);
        }
    }
}

