/*
 * Decompiled with CFR 0.152.
 */
package com.blikoon.qrcodescanner.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.blikoon.qrcodescanner.R;
import com.blikoon.qrcodescanner.utils.ScreenUtils;

public final class QrCodeFinderView
extends RelativeLayout {
    private static final int[] SCANNER_ALPHA = new int[]{0, 64, 128, 192, 255, 192, 128, 64};
    private static final long ANIMATION_DELAY = 100L;
    private static final int OPAQUE = 255;
    private Context mContext;
    private Paint mPaint;
    private int mScannerAlpha;
    private int mMaskColor;
    private int mFrameColor;
    private int mLaserColor;
    private int mTextColor;
    private Rect mFrameRect;
    private int mFocusThick;
    private int mAngleThick;
    private int mAngleLength;

    public QrCodeFinderView(Context context) {
        this(context, null);
    }

    public QrCodeFinderView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public QrCodeFinderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.mPaint = new Paint();
        Resources resources = this.getResources();
        this.mMaskColor = resources.getColor(R.color.qr_code_finder_mask);
        this.mFrameColor = resources.getColor(R.color.qr_code_finder_frame);
        this.mLaserColor = resources.getColor(R.color.qr_code_finder_laser);
        this.mTextColor = resources.getColor(R.color.qr_code_white);
        this.mFocusThick = 1;
        this.mAngleThick = 8;
        this.mAngleLength = 40;
        this.mScannerAlpha = 0;
        this.init(context);
    }

    private void init(Context context) {
        if (this.isInEditMode()) {
            return;
        }
        this.setWillNotDraw(false);
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        RelativeLayout relativeLayout = (RelativeLayout)inflater.inflate(R.layout.layout_qr_code_scanner, (ViewGroup)this);
        FrameLayout frameLayout = (FrameLayout)relativeLayout.findViewById(R.id.qr_code_fl_scanner);
        this.mFrameRect = new Rect();
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)frameLayout.getLayoutParams();
        this.mFrameRect.left = (ScreenUtils.getScreenWidth(context) - layoutParams.width) / 2;
        this.mFrameRect.top = layoutParams.topMargin;
        this.mFrameRect.right = this.mFrameRect.left + layoutParams.width;
        this.mFrameRect.bottom = this.mFrameRect.top + layoutParams.height;
    }

    public void onDraw(Canvas canvas) {
        if (this.isInEditMode()) {
            return;
        }
        Rect frame = this.mFrameRect;
        if (frame == null) {
            return;
        }
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        this.mPaint.setColor(this.mMaskColor);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)frame.top, this.mPaint);
        canvas.drawRect(0.0f, (float)frame.top, (float)frame.left, (float)(frame.bottom + 1), this.mPaint);
        canvas.drawRect((float)(frame.right + 1), (float)frame.top, (float)width, (float)(frame.bottom + 1), this.mPaint);
        canvas.drawRect(0.0f, (float)(frame.bottom + 1), (float)width, (float)height, this.mPaint);
        this.drawFocusRect(canvas, frame);
        this.drawAngle(canvas, frame);
        this.drawText(canvas, frame);
        this.drawLaser(canvas, frame);
        this.postInvalidateDelayed(100L, frame.left, frame.top, frame.right, frame.bottom);
    }

    private void drawFocusRect(Canvas canvas, Rect rect) {
        this.mPaint.setColor(this.mFrameColor);
        canvas.drawRect((float)(rect.left + this.mAngleLength), (float)rect.top, (float)(rect.right - this.mAngleLength), (float)(rect.top + this.mFocusThick), this.mPaint);
        canvas.drawRect((float)rect.left, (float)(rect.top + this.mAngleLength), (float)(rect.left + this.mFocusThick), (float)(rect.bottom - this.mAngleLength), this.mPaint);
        canvas.drawRect((float)(rect.right - this.mFocusThick), (float)(rect.top + this.mAngleLength), (float)rect.right, (float)(rect.bottom - this.mAngleLength), this.mPaint);
        canvas.drawRect((float)(rect.left + this.mAngleLength), (float)(rect.bottom - this.mFocusThick), (float)(rect.right - this.mAngleLength), (float)rect.bottom, this.mPaint);
    }

    private void drawAngle(Canvas canvas, Rect rect) {
        this.mPaint.setColor(this.mLaserColor);
        this.mPaint.setAlpha(255);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth((float)this.mAngleThick);
        int left = rect.left;
        int top = rect.top;
        int right = rect.right;
        int bottom = rect.bottom;
        canvas.drawRect((float)left, (float)top, (float)(left + this.mAngleLength), (float)(top + this.mAngleThick), this.mPaint);
        canvas.drawRect((float)left, (float)top, (float)(left + this.mAngleThick), (float)(top + this.mAngleLength), this.mPaint);
        canvas.drawRect((float)(right - this.mAngleLength), (float)top, (float)right, (float)(top + this.mAngleThick), this.mPaint);
        canvas.drawRect((float)(right - this.mAngleThick), (float)top, (float)right, (float)(top + this.mAngleLength), this.mPaint);
        canvas.drawRect((float)left, (float)(bottom - this.mAngleLength), (float)(left + this.mAngleThick), (float)bottom, this.mPaint);
        canvas.drawRect((float)left, (float)(bottom - this.mAngleThick), (float)(left + this.mAngleLength), (float)bottom, this.mPaint);
        canvas.drawRect((float)(right - this.mAngleLength), (float)(bottom - this.mAngleThick), (float)right, (float)bottom, this.mPaint);
        canvas.drawRect((float)(right - this.mAngleThick), (float)(bottom - this.mAngleLength), (float)right, (float)bottom, this.mPaint);
    }

    private void drawText(Canvas canvas, Rect rect) {
        int margin = 40;
        this.mPaint.setColor(this.mTextColor);
        this.mPaint.setTextSize(this.getResources().getDimension(R.dimen.text_size_13sp));
        String text = this.getResources().getString(R.string.qr_code_auto_scan_notification);
        Paint.FontMetrics fontMetrics = this.mPaint.getFontMetrics();
        float fontTotalHeight = fontMetrics.bottom - fontMetrics.top;
        float offY = fontTotalHeight / 2.0f - fontMetrics.bottom;
        float newY = (float)(rect.bottom + margin) + offY;
        float left = ((float)ScreenUtils.getScreenWidth(this.mContext) - this.mPaint.getTextSize() * (float)text.length()) / 2.0f;
        canvas.drawText(text, left, newY, this.mPaint);
    }

    private void drawLaser(Canvas canvas, Rect rect) {
        this.mPaint.setColor(this.mLaserColor);
        this.mPaint.setAlpha(SCANNER_ALPHA[this.mScannerAlpha]);
        this.mScannerAlpha = (this.mScannerAlpha + 1) % SCANNER_ALPHA.length;
        int middle = rect.height() / 2 + rect.top;
        canvas.drawRect((float)(rect.left + 2), (float)(middle - 1), (float)(rect.right - 1), (float)(middle + 2), this.mPaint);
    }
}

