/*
 * Decompiled with CFR 0.152.
 */
package com.blikoon.qrcodescanner.decode;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.blikoon.qrcodescanner.QrCodeActivity;
import com.blikoon.qrcodescanner.R;
import com.blikoon.qrcodescanner.camera.CameraManager;
import com.blikoon.qrcodescanner.decode.DecodeThread;
import com.google.zxing.Result;

public final class CaptureActivityHandler
extends Handler {
    private static final String TAG = CaptureActivityHandler.class.getName();
    private final QrCodeActivity mActivity;
    private final DecodeThread mDecodeThread;
    private State mState;

    public CaptureActivityHandler(QrCodeActivity activity) {
        this.mActivity = activity;
        this.mDecodeThread = new DecodeThread(activity);
        this.mDecodeThread.start();
        this.mState = State.SUCCESS;
        this.restartPreviewAndDecode();
    }

    public void handleMessage(Message message) {
        if (message.what == R.id.auto_focus) {
            Log.d((String)TAG, (String)"Got auto-focus message");
            if (this.mState == State.PREVIEW) {
                CameraManager.get().requestAutoFocus(this, R.id.auto_focus);
            }
        } else if (message.what == R.id.decode_succeeded) {
            Log.e((String)TAG, (String)"Got decode succeeded message");
            this.mState = State.SUCCESS;
            this.mActivity.handleDecode((Result)message.obj);
        } else if (message.what == R.id.decode_failed) {
            this.mState = State.PREVIEW;
            CameraManager.get().requestPreviewFrame(this.mDecodeThread.getHandler(), R.id.decode);
        }
    }

    public void quitSynchronously() {
        this.mState = State.DONE;
        CameraManager.get().stopPreview();
        Message quit = Message.obtain((Handler)this.mDecodeThread.getHandler(), (int)R.id.quit);
        quit.sendToTarget();
        try {
            this.mDecodeThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.removeMessages(R.id.decode_succeeded);
        this.removeMessages(R.id.decode_failed);
    }

    public void restartPreviewAndDecode() {
        if (this.mState != State.PREVIEW) {
            CameraManager.get().startPreview();
            this.mState = State.PREVIEW;
            CameraManager.get().requestPreviewFrame(this.mDecodeThread.getHandler(), R.id.decode);
            CameraManager.get().requestAutoFocus(this, R.id.auto_focus);
        }
    }

    private static enum State {
        PREVIEW,
        SUCCESS,
        DONE;

    }
}

